"""
Binance Derivatives Trading Options REST API

OpenAPI Specification for the Binance Derivatives Trading Options REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import List, Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import AccountTradeListResponse
from ..models import CancelAllOptionOrdersByUnderlyingResponse
from ..models import CancelAllOptionOrdersOnSpecificSymbolResponse
from ..models import CancelMultipleOptionOrdersResponse
from ..models import CancelOptionOrderResponse
from ..models import NewOrderResponse
from ..models import OptionPositionInformationResponse
from ..models import PlaceMultipleOrdersResponse
from ..models import QueryCurrentOpenOptionOrdersResponse
from ..models import QueryOptionOrderHistoryResponse
from ..models import QuerySingleOrderResponse
from ..models import UserExerciseRecordResponse


from ..models import NewOrderSideEnum
from ..models import NewOrderTypeEnum
from ..models import NewOrderTimeInForceEnum
from ..models import NewOrderNewOrderRespTypeEnum


from ..models import PlaceMultipleOrdersOrdersParameterInner


class TradeApi:
    """API Client for TradeApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def account_trade_list(
        self,
        symbol: Optional[str] = None,
        from_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AccountTradeListResponse]:
        """
                Account Trade List (USER_DATA)
                GET /eapi/v1/userTrades
                https://developers.binance.com/docs/derivatives/option/trade/Account-Trade-List

                Get trades for a specific account and symbol.

        Weight: 5

                Args:
                    symbol (Optional[str] = None): Option trading pair, e.g BTC-200730-9000-C
                    from_id (Optional[int] = None): The UniqueId ID from which to return. The latest deal record is returned by default
                    start_time (Optional[int] = None): Start Time, e.g 1593511200000
                    end_time (Optional[int] = None): End Time, e.g 1593512200000
                    limit (Optional[int] = None): Number of result sets returned Default:100 Max:1000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AccountTradeListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "symbol": symbol,
            "from_id": from_id,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/userTrades",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=AccountTradeListResponse,
            is_signed=True,
            signer=self._signer,
        )

    def cancel_all_option_orders_by_underlying(
        self,
        underlying: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelAllOptionOrdersByUnderlyingResponse]:
        """
                Cancel All Option Orders By Underlying (TRADE)
                DELETE /eapi/v1/allOpenOrdersByUnderlying
                https://developers.binance.com/docs/derivatives/option/trade/Cancel-All-Option-Orders-By-Underlying

                Cancel all active orders on specified underlying.

        Weight: 1

                Args:
                    underlying (Union[str, None]): Option underlying, e.g BTCUSDT
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[CancelAllOptionOrdersByUnderlyingResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if underlying is None:
            raise RequiredError(
                field="underlying",
                error_message="Missing required parameter 'underlying'",
            )

        payload = {"underlying": underlying, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="DELETE",
            path="/eapi/v1/allOpenOrdersByUnderlying",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CancelAllOptionOrdersByUnderlyingResponse,
            is_signed=True,
            signer=self._signer,
        )

    def cancel_all_option_orders_on_specific_symbol(
        self,
        symbol: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelAllOptionOrdersOnSpecificSymbolResponse]:
        """
                Cancel all Option orders on specific symbol (TRADE)
                DELETE /eapi/v1/allOpenOrders
                https://developers.binance.com/docs/derivatives/option/trade/Cancel-all-Option-orders-on-specific-symbol

                Cancel all active order on a symbol.

        Weight: 1

                Args:
                    symbol (Union[str, None]): Option trading pair, e.g BTC-200730-9000-C
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[CancelAllOptionOrdersOnSpecificSymbolResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {"symbol": symbol, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="DELETE",
            path="/eapi/v1/allOpenOrders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CancelAllOptionOrdersOnSpecificSymbolResponse,
            is_signed=True,
            signer=self._signer,
        )

    def cancel_multiple_option_orders(
        self,
        symbol: Union[str, None],
        order_ids: Optional[List[int]] = None,
        client_order_ids: Optional[List[str]] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelMultipleOptionOrdersResponse]:
        """
                Cancel Multiple Option Orders (TRADE)
                DELETE /eapi/v1/batchOrders
                https://developers.binance.com/docs/derivatives/option/trade/Cancel-Multiple-Option-Orders

                Cancel multiple orders.

        * At least one instance of `orderId` and `clientOrderId` must be sent.

        Weight: 1

                Args:
                    symbol (Union[str, None]): Option trading pair, e.g BTC-200730-9000-C
                    order_ids (Optional[List[int]] = None): Order ID, e.g [4611875134427365377,4611875134427365378]
                    client_order_ids (Optional[List[str]] = None): User-defined order ID, e.g ["my_id_1","my_id_2"]
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[CancelMultipleOptionOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "order_ids": order_ids,
            "client_order_ids": client_order_ids,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="DELETE",
            path="/eapi/v1/batchOrders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CancelMultipleOptionOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def cancel_option_order(
        self,
        symbol: Union[str, None],
        order_id: Optional[int] = None,
        client_order_id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelOptionOrderResponse]:
        """
                Cancel Option Order (TRADE)
                DELETE /eapi/v1/order
                https://developers.binance.com/docs/derivatives/option/trade/Cancel-Option-Order

                Cancel an active order.

        * At least one instance of `orderId` and `clientOrderId` must be sent.

        Weight: 1

                Args:
                    symbol (Union[str, None]): Option trading pair, e.g BTC-200730-9000-C
                    order_id (Optional[int] = None): Order ID, e.g 4611875134427365377
                    client_order_id (Optional[str] = None): User-defined order ID, e.g 10000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[CancelOptionOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "order_id": order_id,
            "client_order_id": client_order_id,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="DELETE",
            path="/eapi/v1/order",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CancelOptionOrderResponse,
            is_signed=True,
            signer=self._signer,
        )

    def new_order(
        self,
        symbol: Union[str, None],
        side: Union[NewOrderSideEnum, None],
        type: Union[NewOrderTypeEnum, None],
        quantity: Union[float, None],
        price: Optional[float] = None,
        time_in_force: Optional[NewOrderTimeInForceEnum] = None,
        reduce_only: Optional[bool] = None,
        post_only: Optional[bool] = None,
        new_order_resp_type: Optional[NewOrderNewOrderRespTypeEnum] = None,
        client_order_id: Optional[str] = None,
        is_mmp: Optional[bool] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[NewOrderResponse]:
        """
                New Order (TRADE)
                POST /eapi/v1/order
                https://developers.binance.com/docs/derivatives/option/trade/New-Order

                Send a new order.

        Weight: 0

                Args:
                    symbol (Union[str, None]): Option trading pair, e.g BTC-200730-9000-C
                    side (Union[NewOrderSideEnum, None]): BUY or SELL
                    type (Union[NewOrderTypeEnum, None]): Order Type: LIMIT(only support limit)
                    quantity (Union[float, None]): Order Quantity
                    price (Optional[float] = None): Order Price
                    time_in_force (Optional[NewOrderTimeInForceEnum] = None): Time in force method（Default GTC）
                    reduce_only (Optional[bool] = None): Reduce Only（Default false）
                    post_only (Optional[bool] = None): Post Only（Default false）
                    new_order_resp_type (Optional[NewOrderNewOrderRespTypeEnum] = None): "ACK", "RESULT", Default "ACK"
                    client_order_id (Optional[str] = None): User-defined order ID, e.g 10000
                    is_mmp (Optional[bool] = None): is market maker protection order, true/false
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[NewOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if side is None:
            raise RequiredError(
                field="side", error_message="Missing required parameter 'side'"
            )
        if type is None:
            raise RequiredError(
                field="type", error_message="Missing required parameter 'type'"
            )
        if quantity is None:
            raise RequiredError(
                field="quantity", error_message="Missing required parameter 'quantity'"
            )

        payload = {
            "symbol": symbol,
            "side": side,
            "type": type,
            "quantity": quantity,
            "price": price,
            "time_in_force": time_in_force,
            "reduce_only": reduce_only,
            "post_only": post_only,
            "new_order_resp_type": new_order_resp_type,
            "client_order_id": client_order_id,
            "is_mmp": is_mmp,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/eapi/v1/order",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=NewOrderResponse,
            is_signed=True,
            signer=self._signer,
        )

    def option_position_information(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[OptionPositionInformationResponse]:
        """
                Option Position Information (USER_DATA)
                GET /eapi/v1/position
                https://developers.binance.com/docs/derivatives/option/trade/Option-Position-Information

                Get current position information.

        Weight: 5

                Args:
                    symbol (Optional[str] = None): Option trading pair, e.g BTC-200730-9000-C
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[OptionPositionInformationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/position",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=OptionPositionInformationResponse,
            is_signed=True,
            signer=self._signer,
        )

    def place_multiple_orders(
        self,
        orders: Union[List[PlaceMultipleOrdersOrdersParameterInner], None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[PlaceMultipleOrdersResponse]:
        """
                Place Multiple Orders(TRADE)
                POST /eapi/v1/batchOrders
                https://developers.binance.com/docs/derivatives/option/trade/Place-Multiple-Orders

                Send multiple option orders.

        * Parameter rules are same with New Order
        * Batch orders are processed concurrently, and the order of matching is not guaranteed.

        Weight: 5

                Args:
                    orders (Union[List[PlaceMultipleOrdersOrdersParameterInner], None]): order list. Max 5 orders
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[PlaceMultipleOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if orders is None:
            raise RequiredError(
                field="orders", error_message="Missing required parameter 'orders'"
            )

        payload = {"orders": orders, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/eapi/v1/batchOrders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=PlaceMultipleOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_current_open_option_orders(
        self,
        symbol: Optional[str] = None,
        order_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryCurrentOpenOptionOrdersResponse]:
        """
                Query Current Open Option Orders (USER_DATA)
                GET /eapi/v1/openOrders
                https://developers.binance.com/docs/derivatives/option/trade/Query-Current-Open-Option-Orders

                Query current all open orders, status: ACCEPTED PARTIALLY_FILLED

        Weight: 1 for a single symbol; 40 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str] = None): Option trading pair, e.g BTC-200730-9000-C
                    order_id (Optional[int] = None): Order ID, e.g 4611875134427365377
                    start_time (Optional[int] = None): Start Time, e.g 1593511200000
                    end_time (Optional[int] = None): End Time, e.g 1593512200000
                    limit (Optional[int] = None): Number of result sets returned Default:100 Max:1000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryCurrentOpenOptionOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "symbol": symbol,
            "order_id": order_id,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/openOrders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryCurrentOpenOptionOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_option_order_history(
        self,
        symbol: Union[str, None],
        order_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryOptionOrderHistoryResponse]:
        """
                Query Option Order History (TRADE)
                GET /eapi/v1/historyOrders
                https://developers.binance.com/docs/derivatives/option/trade/Query-Option-Order-History

                Query all finished orders within 5 days, finished status: CANCELLED FILLED REJECTED.

        Weight: 3

                Args:
                    symbol (Union[str, None]): Option trading pair, e.g BTC-200730-9000-C
                    order_id (Optional[int] = None): Order ID, e.g 4611875134427365377
                    start_time (Optional[int] = None): Start Time, e.g 1593511200000
                    end_time (Optional[int] = None): End Time, e.g 1593512200000
                    limit (Optional[int] = None): Number of result sets returned Default:100 Max:1000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryOptionOrderHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "order_id": order_id,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/historyOrders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryOptionOrderHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_single_order(
        self,
        symbol: Union[str, None],
        order_id: Optional[int] = None,
        client_order_id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySingleOrderResponse]:
        """
                Query Single Order (TRADE)
                GET /eapi/v1/order
                https://developers.binance.com/docs/derivatives/option/trade/Query-Single-Order

                Check an order status.

        * These orders will not be found:
        * order status is `CANCELED` or `REJECTED`, **AND**
        * order has NO filled trade, **AND**
        * created time + 3 days < current time


        * Either `orderId` or `clientOrderId ` must be sent.

        Weight: 1

                Args:
                    symbol (Union[str, None]): Option trading pair, e.g BTC-200730-9000-C
                    order_id (Optional[int] = None): Order ID, e.g 4611875134427365377
                    client_order_id (Optional[str] = None): User-defined order ID, e.g 10000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySingleOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "order_id": order_id,
            "client_order_id": client_order_id,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/order",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QuerySingleOrderResponse,
            is_signed=True,
            signer=self._signer,
        )

    def user_exercise_record(
        self,
        symbol: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[UserExerciseRecordResponse]:
        """
                User Exercise Record (USER_DATA)
                GET /eapi/v1/exerciseRecord
                https://developers.binance.com/docs/derivatives/option/trade/User-Exercise-Record

                Get account exercise records.

        Weight: 5

                Args:
                    symbol (Optional[str] = None): Option trading pair, e.g BTC-200730-9000-C
                    start_time (Optional[int] = None): Start Time, e.g 1593511200000
                    end_time (Optional[int] = None): End Time, e.g 1593512200000
                    limit (Optional[int] = None): Number of result sets returned Default:100 Max:1000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[UserExerciseRecordResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "symbol": symbol,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/exerciseRecord",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=UserExerciseRecordResponse,
            is_signed=True,
            signer=self._signer,
        )
