"""
Binance Derivatives Trading Options REST API

OpenAPI Specification for the Binance Derivatives Trading Options REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request


from ..models import StartUserDataStreamResponse


class UserDataStreamsApi:
    """API Client for UserDataStreamsApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def close_user_data_stream(
        self,
    ) -> ApiResponse[None]:
        """
                Close User Data Stream (USER_STREAM)
                DELETE /eapi/v1/listenKey
                https://developers.binance.com/docs/derivatives/option/user-data-streams/Close-User-Data-Stream

                Close out a user data stream.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[None]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = None

        return send_request(
            self._session,
            self._configuration,
            method="DELETE",
            path="/eapi/v1/listenKey",
            payload=payload,
            time_unit=self._configuration.time_unit,
        )

    def keepalive_user_data_stream(
        self,
    ) -> ApiResponse[None]:
        """
                Keepalive User Data Stream (USER_STREAM)
                PUT /eapi/v1/listenKey
                https://developers.binance.com/docs/derivatives/option/user-data-streams/Keepalive-User-Data-Stream

                Keepalive a user data stream to prevent a time out. User data streams will close after 60 minutes. It's recommended to send a ping about every 60 minutes.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[None]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = None

        return send_request(
            self._session,
            self._configuration,
            method="PUT",
            path="/eapi/v1/listenKey",
            payload=payload,
            time_unit=self._configuration.time_unit,
        )

    def start_user_data_stream(
        self,
    ) -> ApiResponse[StartUserDataStreamResponse]:
        """
                Start User Data Stream (USER_STREAM)
                POST /eapi/v1/listenKey
                https://developers.binance.com/docs/derivatives/option/user-data-streams/Start-User-Data-Stream

                Start a new user data stream. The stream will close after 60 minutes unless a keepalive is sent. If the account has an active `listenKey`, that `listenKey` will be returned and its validity will be extended for 60 minutes.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[StartUserDataStreamResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = None

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/eapi/v1/listenKey",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=StartUserDataStreamResponse,
        )
