# coding: utf-8

"""
Binance Derivatives Trading Options REST API

OpenAPI Specification for the Binance Derivatives Trading Options REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class AccountTradeListResponseInner(BaseModel):
    """
    AccountTradeListResponseInner
    """  # noqa: E501

    id: Optional[StrictInt] = None
    trade_id: Optional[StrictInt] = Field(default=None, alias="tradeId")
    order_id: Optional[StrictInt] = Field(default=None, alias="orderId")
    symbol: Optional[StrictStr] = None
    price: Optional[StrictStr] = None
    quantity: Optional[StrictStr] = None
    fee: Optional[StrictStr] = None
    realized_profit: Optional[StrictStr] = Field(default=None, alias="realizedProfit")
    side: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    volatility: Optional[StrictStr] = None
    liquidity: Optional[StrictStr] = None
    quote_asset: Optional[StrictStr] = Field(default=None, alias="quoteAsset")
    time: Optional[StrictInt] = None
    price_scale: Optional[StrictInt] = Field(default=None, alias="priceScale")
    quantity_scale: Optional[StrictInt] = Field(default=None, alias="quantityScale")
    option_side: Optional[StrictStr] = Field(default=None, alias="optionSide")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "id",
        "tradeId",
        "orderId",
        "symbol",
        "price",
        "quantity",
        "fee",
        "realizedProfit",
        "side",
        "type",
        "volatility",
        "liquidity",
        "quoteAsset",
        "time",
        "priceScale",
        "quantityScale",
        "optionSide",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccountTradeListResponseInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccountTradeListResponseInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "tradeId": obj.get("tradeId"),
                "orderId": obj.get("orderId"),
                "symbol": obj.get("symbol"),
                "price": obj.get("price"),
                "quantity": obj.get("quantity"),
                "fee": obj.get("fee"),
                "realizedProfit": obj.get("realizedProfit"),
                "side": obj.get("side"),
                "type": obj.get("type"),
                "volatility": obj.get("volatility"),
                "liquidity": obj.get("liquidity"),
                "quoteAsset": obj.get("quoteAsset"),
                "time": obj.get("time"),
                "priceScale": obj.get("priceScale"),
                "quantityScale": obj.get("quantityScale"),
                "optionSide": obj.get("optionSide"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
