"""Alerts Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class AggregateAlertsBySeverityInput_GroupBy(str, Enum):
    """AggregateAlertsBySeverityInput_GroupBy."""

    DOMAIN = "DOMAIN"
    WATCHLIST = "WATCHLIST"
    HOSTNAME = "HOSTNAME"
    DETECTOR = "DETECTOR"
    USER = "USER"


class AlertsSeverity(str, Enum):
    """AlertsSeverity."""

    INFO = "INFO"
    LOW = "LOW"
    MEDIUM = "MEDIUM"
    HIGH = "HIGH"
    CRITICAL = "CRITICAL"


class CallerInformation(str, Enum):
    """CallerInformation."""

    UNKNOWN = "UNKNOWN"
    ALERTS_V1 = "ALERTS_V1"
    ALERTS_V2 = "ALERTS_V2"


class InvestigationOperation(str, Enum):
    """InvestigationOperation."""

    UPDATE = "UPDATE"
    DELETE = "DELETE"


class ResolutionStatus(str, Enum):
    """ResolutionStatus."""

    OPEN = "OPEN"
    TRUE_POSITIVE_BENIGN = "TRUE_POSITIVE_BENIGN"
    TRUE_POSITIVE_MALICIOUS = "TRUE_POSITIVE_MALICIOUS"
    FALSE_POSITIVE = "FALSE_POSITIVE"
    NOT_ACTIONABLE = "NOT_ACTIONABLE"
    OTHER = "OTHER"
    SUPPRESSED = "SUPPRESSED"


class ResponseStatus(str, Enum):
    """ResponseStatus."""

    SUCCESS = "SUCCESS"
    FAILED = "FAILED"


class ImprobableLogonDetail_FeatureName(str, Enum):
    """ImprobableLogonDetail_FeatureName."""

    UNKNOWN = "UNKNOWN"
    COUNTRY = "COUNTRY"
    CITY = "CITY"
    ASN = "ASN"


class Origin(str, Enum):
    """Origin."""

    INTERNAL = "INTERNAL"
    CUSTOMER = "CUSTOMER"
    EXTERNAL = "EXTERNAL"
    PARTNER = "PARTNER"


class RPCResponseStatus(str, Enum):
    """RPCResponseStatus."""

    OK = "OK"
    INVALID_REQUEST = "INVALID_REQUEST"
    TRANSACTION_ERROR = "TRANSACTION_ERROR"


class Visibility(str, Enum):
    """Visibility."""

    DEPLOYED = "DEPLOYED"
    RESEARCH = "RESEARCH"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary_CountryInput:
    """GeoSummary_CountryInput."""

    geoname_id: Optional[int] = field(
        default=None, metadata=config(field_name="geoname_id")
    )
    iso_code: Optional[str] = field(
        default=None, metadata=config(field_name="iso_code")
    )
    code: Optional[str] = field(default=None, metadata=config(field_name="code"))
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class KeyAndValuesInput:
    """KeyAndValuesInput."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    values: Optional[List[str]] = field(
        default=None, metadata=config(field_name="values")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertRuleReferenceInput:
    """AlertRuleReferenceInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkInvestigationsRequestInput:
    """BulkInvestigationsRequestInput."""

    query: Optional[str] = field(default=None, metadata=config(field_name="query"))
    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigation_id")
    )
    genesis_alerts: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "used to flag specific alerts as the genesis of the investigation",
            },
            field_name="genesis_alerts",
        ),
    )
    alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alerts")
    )
    tenant: Optional[str] = field(default=None, metadata=config(field_name="tenant"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityMetadataInput:
    """EntityMetadataInput."""

    entity: Optional[str] = field(default=None, metadata=config(field_name="entity"))
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EvictRequestInput:
    """EvictRequestInput."""

    search_id: Optional[str] = field(
        default=None, metadata=config(field_name="search_id")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GetByIDRequestInput:
    """GetByIDRequestInput."""

    i_ds: Optional[List[str]] = field(default=None, metadata=config(field_name="iDs"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PollRequestInput:
    """PollRequestInput."""

    search_id: Optional[str] = field(
        default=None, metadata=config(field_name="search_id")
    )
    part_id: Optional[int] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "part id is advanced transparently with each new call now",
            },
            field_name="part_id",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SearchRequestInput:
    """SearchRequestInput."""

    cql_query: Optional[str] = field(
        default=None, metadata=config(field_name="cql_query")
    )
    offset: Optional[int] = field(default=None, metadata=config(field_name="offset"))
    limit: Optional[int] = field(default=None, metadata=config(field_name="limit"))
    search_id: Optional[str] = field(
        default=None, metadata=config(field_name="search_id")
    )
    metadata: Optional[dict] = field(
        default=None, metadata=config(field_name="metadata")
    )
    tenant_service_filters: Optional[List[str]] = field(
        default=None, metadata=config(field_name="tenant_service_filters")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TimestampInput:
    """TimestampInput."""

    seconds: Optional[int] = field(default=None, metadata=config(field_name="seconds"))
    nanos: Optional[int] = field(default=None, metadata=config(field_name="nanos"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateThreatScoreEntry:
    """UpdateThreatScoreEntry."""

    alert_id: Optional[str] = field(
        default=None, metadata=config(field_name="alert_id")
    )
    threat_score: Optional[float] = field(
        default=None, metadata=config(field_name="threat_score")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AccountCompromiseDetectorDetailInput:
    """AccountCompromiseDetectorDetailInput."""

    user_name: Optional[str] = field(
        default=None, metadata=config(field_name="user_name")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AuthScanLogonAttemptInput:
    """AuthScanLogonAttemptInput."""

    target_user_name: Optional[str] = field(
        default=None, metadata=config(field_name="target_user_name")
    )
    has_logon_success: Optional[bool] = field(
        default=None, metadata=config(field_name="has_logon_success")
    )
    num_attempts: Optional[int] = field(
        default=None, metadata=config(field_name="num_attempts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BruteForceAuthInput:
    """BruteForceAuthInput."""

    win_event_id: Optional[str] = field(
        default=None, metadata=config(field_name="win_event_id")
    )
    action: Optional[str] = field(default=None, metadata=config(field_name="action"))
    domain: Optional[str] = field(default=None, metadata=config(field_name="domain"))
    target_username: Optional[str] = field(
        default=None, metadata=config(field_name="target_username")
    )
    event_timestamp: Optional[int] = field(
        default=None, metadata=config(field_name="event_timestamp")
    )
    resource_record_identifier: Optional[str] = field(
        default=None, metadata=config(field_name="resource_record_identifier")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class KerberoastingInput:
    """KerberoastingInput."""

    user: Optional[str] = field(default=None, metadata=config(field_name="user"))
    user_baseline: Optional[int] = field(
        default=None, metadata=config(field_name="user_baseline")
    )
    user_avg_requests: Optional[float] = field(
        default=None, metadata=config(field_name="user_avg_requests")
    )
    user_max_requests: Optional[int] = field(
        default=None, metadata=config(field_name="user_max_requests")
    )
    total_spns: Optional[int] = field(
        default=None, metadata=config(field_name="total_spns")
    )
    suspicious_num_requests: Optional[int] = field(
        default=None, metadata=config(field_name="suspicious_num_requests")
    )
    percentage_accessed: Optional[float] = field(
        default=None, metadata=config(field_name="percentage_accessed")
    )
    spns_accessed: Optional[List[str]] = field(
        default=None, metadata=config(field_name="spns_accessed")
    )
    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LogonAnomalyInput:
    """LogonAnomalyInput."""

    feature_value: Optional[str] = field(
        default=None, metadata=config(field_name="feature_value")
    )
    feature_frequency_in_org: Optional[float] = field(
        default=None, metadata=config(field_name="feature_frequency_in_org")
    )
    feature_frequency_in_user: Optional[float] = field(
        default=None, metadata=config(field_name="feature_frequency_in_user")
    )
    approximate_count_in_user: Optional[int] = field(
        default=None, metadata=config(field_name="approximate_count_in_user")
    )
    min_allowed_user_percentage: Optional[float] = field(
        default=None, metadata=config(field_name="min_allowed_user_percentage")
    )
    min_allowed_org_percentage: Optional[float] = field(
        default=None, metadata=config(field_name="min_allowed_org_percentage")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class MatchDetailsInput:
    """MatchDetailsInput."""

    list_name: Optional[str] = field(
        default=None, metadata=config(field_name="list_name")
    )
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    attacks: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attacks")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PasswordSprayAffectedUserInput:
    """PasswordSprayAffectedUserInput."""

    target_user_name: Optional[str] = field(
        default=None, metadata=config(field_name="target_user_name")
    )
    target_domain_name: Optional[str] = field(
        default=None, metadata=config(field_name="target_domain_name")
    )
    user_had_auth_success: Optional[bool] = field(
        default=None, metadata=config(field_name="user_had_auth_success")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UserLogonBaselineInput:
    """UserLogonBaselineInput."""

    feature_value: Optional[str] = field(
        default=None, metadata=config(field_name="feature_value")
    )
    feature_frequency_in_org: Optional[float] = field(
        default=None, metadata=config(field_name="feature_frequency_in_org")
    )
    feature_frequency_in_user: Optional[float] = field(
        default=None, metadata=config(field_name="feature_frequency_in_user")
    )
    approximate_count_in_user: Optional[int] = field(
        default=None, metadata=config(field_name="approximate_count_in_user")
    )
    days_in_baseline: Optional[int] = field(
        default=None, metadata=config(field_name="days_in_baseline")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary_ASN:
    """GeoSummary_ASN."""

    autonomous_system_no: Optional[int] = field(
        default=None, metadata=config(field_name="autonomous_system_no")
    )
    autonomous_system_org: Optional[str] = field(
        default=None, metadata=config(field_name="autonomous_system_org")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary_Continent:
    """GeoSummary_Continent."""

    geoname_id: Optional[int] = field(
        default=None, metadata=config(field_name="geoname_id")
    )
    code: Optional[str] = field(default=None, metadata=config(field_name="code"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary_Country:
    """GeoSummary_Country."""

    geoname_id: Optional[int] = field(
        default=None, metadata=config(field_name="geoname_id")
    )
    iso_code: Optional[str] = field(
        default=None, metadata=config(field_name="iso_code")
    )
    code: Optional[str] = field(default=None, metadata=config(field_name="code"))
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary_Location:
    """GeoSummary_Location."""

    radius: Optional[int] = field(default=None, metadata=config(field_name="radius"))
    latitude: Optional[float] = field(
        default=None, metadata=config(field_name="latitude")
    )
    longitude: Optional[float] = field(
        default=None, metadata=config(field_name="longitude")
    )
    us_metro_code: Optional[int] = field(
        default=None, metadata=config(field_name="us_metro_code")
    )
    timezone: Optional[str] = field(
        default=None, metadata=config(field_name="timezone")
    )
    gmt_offset: Optional[int] = field(
        default=None, metadata=config(field_name="gmt_offset")
    )
    metro_code: Optional[int] = field(
        default=None, metadata=config(field_name="metro_code")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class KeyAndValues:
    """KeyAndValues."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    values: Optional[List[str]] = field(
        default=None, metadata=config(field_name="values")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class KeyValueRecordIndexed:
    """KeyValueRecordIndexed."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AggregationKeys:
    """AggregationKeys."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertRuleReference:
    """AlertRuleReference."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertsAggregateResponse_AlertsAggregation_Severity:
    """AlertsAggregateResponse_AlertsAggregation_Severity."""

    info: Optional[int] = field(default=None, metadata=config(field_name="info"))
    low: Optional[int] = field(default=None, metadata=config(field_name="low"))
    medium: Optional[int] = field(default=None, metadata=config(field_name="medium"))
    high: Optional[int] = field(default=None, metadata=config(field_name="high"))
    critical: Optional[int] = field(
        default=None, metadata=config(field_name="critical")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityMetadata:
    """EntityMetadata."""

    entity: Optional[str] = field(default=None, metadata=config(field_name="entity"))
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Timestamp:
    """Timestamp."""

    seconds: Optional[int] = field(default=None, metadata=config(field_name="seconds"))
    nanos: Optional[int] = field(default=None, metadata=config(field_name="nanos"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AccountCompromiseDetectorDetail:
    """AccountCompromiseDetectorDetail."""

    user_name: Optional[str] = field(
        default=None, metadata=config(field_name="user_name")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AuthScanLogonAttempt:
    """AuthScanLogonAttempt."""

    target_user_name: Optional[str] = field(
        default=None, metadata=config(field_name="target_user_name")
    )
    has_logon_success: Optional[bool] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "see list in successful_logon_attempts",
            },
            field_name="has_logon_success",
        ),
    )
    num_attempts: Optional[int] = field(
        default=None, metadata=config(field_name="num_attempts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BruteForceAuth:
    """BruteForceAuth."""

    win_event_id: Optional[str] = field(
        default=None, metadata=config(field_name="win_event_id")
    )
    action: Optional[str] = field(default=None, metadata=config(field_name="action"))
    domain: Optional[str] = field(default=None, metadata=config(field_name="domain"))
    target_username: Optional[str] = field(
        default=None, metadata=config(field_name="target_username")
    )
    event_timestamp: Optional[int] = field(
        default=None, metadata=config(field_name="event_timestamp")
    )
    resource_record_identifier: Optional[str] = field(
        default=None, metadata=config(field_name="resource_record_identifier")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreationRule:
    """CreationRule."""

    rule_id: Optional[str] = field(default=None, metadata=config(field_name="rule_id"))
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DDosIpAddressOccurrenceCount:
    """DDosIpAddressOccurrenceCount."""

    ip_address: Optional[str] = field(
        default=None, metadata=config(field_name="ip_address")
    )
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Detector:
    """Detector."""

    detector_id: Optional[str] = field(
        default=None, metadata=config(field_name="detector_id")
    )
    detector_name: Optional[str] = field(
        default=None, metadata=config(field_name="detector_name")
    )
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DnsExfilEnrichment:
    """DnsExfilEnrichment."""

    num_queries: Optional[int] = field(
        default=None, metadata=config(field_name="num_queries")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Engine:
    """Engine."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeographicIp:
    """GeographicIp."""

    ip_address: Optional[str] = field(
        default=None, metadata=config(field_name="ip_address")
    )
    latitude: Optional[float] = field(
        default=None, metadata=config(field_name="latitude")
    )
    longitude: Optional[float] = field(
        default=None, metadata=config(field_name="longitude")
    )
    radius: Optional[float] = field(default=None, metadata=config(field_name="radius"))
    geohash: Optional[str] = field(default=None, metadata=config(field_name="geohash"))
    country_code_iso: Optional[str] = field(
        default=None, metadata=config(field_name="country_code_iso")
    )
    asn: Optional[int] = field(default=None, metadata=config(field_name="asn"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class HandsOnKeyboardDetails_Commandline:
    """HandsOnKeyboardDetails_Commandline."""

    commandline: Optional[str] = field(
        default=None, metadata=config(field_name="commandline")
    )
    matched_features: Optional[List[str]] = field(
        default=None, metadata=config(field_name="matched_features")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class HandsOnKeyboardDetails_Image:
    """HandsOnKeyboardDetails_Image."""

    image_path: Optional[str] = field(
        default=None, metadata=config(field_name="image_path")
    )
    matched_features: Optional[List[str]] = field(
        default=None, metadata=config(field_name="matched_features")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Kerberoasting:
    """Kerberoasting."""

    user: Optional[str] = field(default=None, metadata=config(field_name="user"))
    user_baseline: Optional[int] = field(
        default=None, metadata=config(field_name="user_baseline")
    )
    user_avg_requests: Optional[float] = field(
        default=None, metadata=config(field_name="user_avg_requests")
    )
    user_max_requests: Optional[int] = field(
        default=None, metadata=config(field_name="user_max_requests")
    )
    total_spns: Optional[int] = field(
        default=None, metadata=config(field_name="total_spns")
    )
    suspicious_num_requests: Optional[int] = field(
        default=None, metadata=config(field_name="suspicious_num_requests")
    )
    percentage_accessed: Optional[float] = field(
        default=None, metadata=config(field_name="percentage_accessed")
    )
    spns_accessed: Optional[List[str]] = field(
        default=None, metadata=config(field_name="spns_accessed")
    )
    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LoginFailureDetail:
    """LoginFailureDetail."""

    host: Optional[str] = field(default=None, metadata=config(field_name="host"))
    user: Optional[str] = field(default=None, metadata=config(field_name="user"))
    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    target_address: Optional[str] = field(
        default=None, metadata=config(field_name="target_address")
    )
    successful_auth_event: Optional[str] = field(
        default=None, metadata=config(field_name="successful_auth_event")
    )
    failed_auth_event: Optional[str] = field(
        default=None, metadata=config(field_name="failed_auth_event")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LogonAnomaly:
    """LogonAnomaly."""

    feature_value: Optional[str] = field(
        default=None, metadata=config(field_name="feature_value")
    )
    feature_frequency_in_org: Optional[float] = field(
        default=None, metadata=config(field_name="feature_frequency_in_org")
    )
    feature_frequency_in_user: Optional[float] = field(
        default=None, metadata=config(field_name="feature_frequency_in_user")
    )
    approximate_count_in_user: Optional[int] = field(
        default=None, metadata=config(field_name="approximate_count_in_user")
    )
    min_allowed_user_percentage: Optional[float] = field(
        default=None, metadata=config(field_name="min_allowed_user_percentage")
    )
    min_allowed_org_percentage: Optional[float] = field(
        default=None, metadata=config(field_name="min_allowed_org_percentage")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class MatchDetails:
    """MatchDetails."""

    list_name: Optional[str] = field(
        default=None, metadata=config(field_name="list_name")
    )
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    attacks: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attacks")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class MitreAttackDetails:
    """MitreAttackDetails."""

    technique_id: Optional[str] = field(
        default=None, metadata=config(field_name="technique_id")
    )
    technique: Optional[str] = field(
        default=None, metadata=config(field_name="technique")
    )
    tactics: Optional[List[str]] = field(
        default=None, metadata=config(field_name="tactics")
    )
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    platform: Optional[List[str]] = field(
        default=None, metadata=config(field_name="platform")
    )
    system_requirements: Optional[List[str]] = field(
        default=None, metadata=config(field_name="system_requirements")
    )
    url: Optional[str] = field(default=None, metadata=config(field_name="url"))
    data_sources: Optional[List[str]] = field(
        default=None, metadata=config(field_name="data_sources")
    )
    defence_bypassed: Optional[List[str]] = field(
        default=None, metadata=config(field_name="defence_bypassed")
    )
    contributors: Optional[List[str]] = field(
        default=None, metadata=config(field_name="contributors")
    )
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NetworkConnection:
    """NetworkConnection."""

    source_ip: Optional[str] = field(
        default=None, metadata=config(field_name="source_ip")
    )
    destination_ip: Optional[str] = field(
        default=None, metadata=config(field_name="destination_ip")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PasswordSprayAffectedUser:
    """PasswordSprayAffectedUser."""

    target_user_name: Optional[str] = field(
        default=None, metadata=config(field_name="target_user_name")
    )
    target_domain_name: Optional[str] = field(
        default=None, metadata=config(field_name="target_domain_name")
    )
    user_had_auth_success: Optional[bool] = field(
        default=None, metadata=config(field_name="user_had_auth_success")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Reference:
    """Reference."""

    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    url: Optional[str] = field(default=None, metadata=config(field_name="url"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Relationship:
    """Relationship."""

    from_entity: Optional[str] = field(
        default=None, metadata=config(field_name="from_entity")
    )
    to_entity: Optional[str] = field(
        default=None, metadata=config(field_name="to_entity")
    )
    relationship: Optional[str] = field(
        default=None, metadata=config(field_name="relationship")
    )
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UserLogonBaseline:
    """UserLogonBaseline."""

    feature_value: Optional[str] = field(
        default=None, metadata=config(field_name="feature_value")
    )
    feature_frequency_in_org: Optional[float] = field(
        default=None, metadata=config(field_name="feature_frequency_in_org")
    )
    feature_frequency_in_user: Optional[float] = field(
        default=None, metadata=config(field_name="feature_frequency_in_user")
    )
    approximate_count_in_user: Optional[int] = field(
        default=None, metadata=config(field_name="approximate_count_in_user")
    )
    days_in_baseline: Optional[int] = field(
        default=None, metadata=config(field_name="days_in_baseline")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class WhoisSimple:
    """WhoisSimple."""

    domain_name: Optional[str] = field(
        default=None, metadata=config(field_name="domainName")
    )
    registrar_name: Optional[str] = field(
        default=None, metadata=config(field_name="registrarName")
    )
    contact_email: Optional[str] = field(
        default=None, metadata=config(field_name="contactEmail")
    )
    whois_server: Optional[str] = field(
        default=None, metadata=config(field_name="whoisServer")
    )
    name_servers: Optional[str] = field(
        default=None, metadata=config(field_name="nameServers")
    )
    created_date: Optional[str] = field(
        default=None, metadata=config(field_name="createdDate")
    )
    updated_date: Optional[str] = field(
        default=None, metadata=config(field_name="updatedDate")
    )
    expires_date: Optional[str] = field(
        default=None, metadata=config(field_name="expiresDate")
    )
    standard_reg_created_date: Optional[str] = field(
        default=None, metadata=config(field_name="standardRegCreatedDate")
    )
    standard_reg_updated_date: Optional[str] = field(
        default=None, metadata=config(field_name="standardRegUpdatedDate")
    )
    standard_reg_expires_date: Optional[str] = field(
        default=None, metadata=config(field_name="standardRegExpiresDate")
    )
    status: Optional[str] = field(default=None, metadata=config(field_name="status"))
    audit_audit_updated_date: Optional[str] = field(
        default=None, metadata=config(field_name="Audit_auditUpdatedDate")
    )
    registrant_email: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_email")
    )
    registrant_name: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_name")
    )
    registrant_organization: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_organization")
    )
    registrant_street1: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_street1")
    )
    registrant_street2: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_street2")
    )
    registrant_street3: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_street3")
    )
    registrant_street4: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_street4")
    )
    registrant_city: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_city")
    )
    registrant_state: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_state")
    )
    registrant_postal_code: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_postalCode")
    )
    registrant_country: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_country")
    )
    registrant_fax: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_fax")
    )
    registrant_fax_ext: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_faxExt")
    )
    registrant_telephone: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_telephone")
    )
    registrant_telephone_ext: Optional[str] = field(
        default=None, metadata=config(field_name="registrant_telephoneExt")
    )
    administrative_contact_email: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_email")
    )
    administrative_contact_name: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_name")
    )
    administrative_contact_organization: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_organization")
    )
    administrative_contact_street1: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_street1")
    )
    administrative_contact_street2: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_street2")
    )
    administrative_contact_street3: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_street3")
    )
    administrative_contact_street4: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_street4")
    )
    administrative_contact_city: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_city")
    )
    administrative_contact_state: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_state")
    )
    administrative_contact_postal_code: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_postalCode")
    )
    administrative_contact_country: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_country")
    )
    administrative_contact_fax: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_fax")
    )
    administrative_contact_fax_ext: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_faxExt")
    )
    administrative_contact_telephone: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_telephone")
    )
    administrative_contact_telephone_ext: Optional[str] = field(
        default=None, metadata=config(field_name="administrativeContact_telephoneExt")
    )
    reg_created_date_usec: Optional[int] = field(
        default=None, metadata=config(field_name="reg_created_date_usec")
    )
    reg_updated_date_usec: Optional[int] = field(
        default=None, metadata=config(field_name="reg_updated_date_usec")
    )
    reg_expires_date_usec: Optional[int] = field(
        default=None, metadata=config(field_name="reg_expires_date_usec")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AuxiliaryEvent:
    """AuxiliaryEvent."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Investigation:
    """Investigation."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    genesis_alerts_flag: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "not in use anymore"},
            field_name="GenesisAlertsFlag",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Collection:
    """Collection."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Observation:
    """Observation."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertPriorityInput:
    """AlertPriorityInput."""

    value: Optional[float] = field(default=None, metadata=config(field_name="value"))
    prioritizer: Optional[str] = field(
        default=None, metadata=config(field_name="prioritizer")
    )
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))
    model_name: Optional[str] = field(
        default=None, metadata=config(field_name="model_name")
    )
    model_version: Optional[str] = field(
        default=None, metadata=config(field_name="model_version")
    )
    evidence: Optional[List[str]] = field(
        default=None, metadata=config(field_name="evidence")
    )
    applied_time: Optional[TimestampInput] = field(
        default=None, metadata=config(field_name="applied_time")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SeverityUpdateInput:
    """SeverityUpdateInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    severity: Optional[float] = field(
        default=None, metadata=config(field_name="severity")
    )
    changed_at: Optional[TimestampInput] = field(
        default=None, metadata=config(field_name="changed_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateThreatScoreRequestInput:
    """UpdateThreatScoreRequestInput."""

    threat_score: Optional[float] = field(
        default=None, metadata=config(field_name="threat_score")
    )
    alert_ids: Optional[List[UpdateThreatScoreEntry]] = field(
        default=None, metadata=config(field_name="alert_ids")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PasswordSprayDetailInput:
    """PasswordSprayDetailInput."""

    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    num_auth_failures: Optional[int] = field(
        default=None, metadata=config(field_name="num_auth_failures")
    )
    num_auth_successes: Optional[int] = field(
        default=None, metadata=config(field_name="num_auth_successes")
    )
    all_affected_users: Optional[List[PasswordSprayAffectedUserInput]] = field(
        default=None, metadata=config(field_name="all_affected_users")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TacticGraphDetailInput:
    """TacticGraphDetailInput."""

    graph_id: Optional[str] = field(
        default=None, metadata=config(field_name="graph_id")
    )
    events: Optional[List[KeyAndValuesInput]] = field(
        default=None, metadata=config(field_name="events")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class WatchlistMatchesInput:
    """WatchlistMatchesInput."""

    entity: Optional[str] = field(default=None, metadata=config(field_name="entity"))
    details: Optional[List[MatchDetailsInput]] = field(
        default=None, metadata=config(field_name="details")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class KeyValuePairsIndexed:
    """KeyValuePairsIndexed."""

    record: Optional[List[KeyValueRecordIndexed]] = field(
        default=None, metadata=config(field_name="record")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AggregationResponse:
    """AggregationResponse."""

    key: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "use keys instead for the broken out name/value pairs",
            },
            field_name="key",
        ),
    )
    value: Optional[float] = field(default=None, metadata=config(field_name="value"))
    keys: Optional[List[AggregationKeys]] = field(
        default=None, metadata=config(field_name="keys")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertPriority:
    """AlertPriority."""

    value: Optional[float] = field(default=None, metadata=config(field_name="value"))
    prioritizer: Optional[str] = field(
        default=None, metadata=config(field_name="prioritizer")
    )
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))
    model_name: Optional[str] = field(
        default=None, metadata=config(field_name="model_name")
    )
    model_version: Optional[str] = field(
        default=None, metadata=config(field_name="model_version")
    )
    evidence: Optional[List[str]] = field(
        default=None, metadata=config(field_name="evidence")
    )
    applied_time: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="applied_time")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertsAggregateResponse_AlertsAggregation:
    """AlertsAggregateResponse_AlertsAggregation."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    severities: Optional[AlertsAggregateResponse_AlertsAggregation_Severity] = field(
        default=None, metadata=config(field_name="severities")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkResolutionResponse:
    """BulkResolutionResponse."""

    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    total_hits: Optional[int] = field(
        default=None, metadata=config(field_name="total_hits")
    )
    total_done: Optional[int] = field(
        default=None, metadata=config(field_name="total_done")
    )
    total_failed: Optional[int] = field(
        default=None, metadata=config(field_name="total_failed")
    )
    is_complete: Optional[bool] = field(
        default=None, metadata=config(field_name="is_complete")
    )
    resolution_status: Optional[ResponseStatus] = field(
        default=None, metadata=config(field_name="resolution_status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateAlertsResponse:
    """CreateAlertsResponse."""

    i_ds: Optional[List[str]] = field(default=None, metadata=config(field_name="iDs"))
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    status: Optional[RPCResponseStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteAlertsResponse:
    """DeleteAlertsResponse."""

    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    status: Optional[RPCResponseStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EvictResponse:
    """EvictResponse."""

    status: Optional[ResponseStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SeverityUpdate:
    """SeverityUpdate."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    severity: Optional[float] = field(
        default=None, metadata=config(field_name="severity")
    )
    changed_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="changed_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateResolutionResponse:
    """UpdateResolutionResponse."""

    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    resolution_status: Optional[ResponseStatus] = field(
        default=None, metadata=config(field_name="resolution_status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateThreatScoreResponse:
    """UpdateThreatScoreResponse."""

    status: Optional[ResponseStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class MatchedYaraRule:
    """MatchedYaraRule."""

    rule_name: Optional[str] = field(
        default=None, metadata=config(field_name="rule_name")
    )
    rule_description: Optional[str] = field(
        default=None, metadata=config(field_name="rule_description")
    )
    classification: Optional[str] = field(
        default=None, metadata=config(field_name="classification")
    )
    confidence: Optional[float] = field(
        default=None, metadata=config(field_name="confidence")
    )
    severity: Optional[float] = field(
        default=None, metadata=config(field_name="severity")
    )
    attack_technique_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attack_technique_ids")
    )
    vid: Optional[str] = field(default=None, metadata=config(field_name="vid"))
    rule_created_date: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="rule_created_date")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DDosIpCount:
    """DDosIpCount."""

    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    date: Optional[Timestamp] = field(default=None, metadata=config(field_name="date"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityRelationships:
    """EntityRelationships."""

    entities: Optional[List[str]] = field(
        default=None, metadata=config(field_name="entities")
    )
    relationships: Optional[List[Relationship]] = field(
        default=None, metadata=config(field_name="relationships")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GenericDetail:
    """GenericDetail."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    generic: Optional[KeyValuePairsIndexed] = field(
        default=None, metadata=config(field_name="generic")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PasswordSprayDetail:
    """PasswordSprayDetail."""

    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    num_auth_failures: Optional[int] = field(
        default=None, metadata=config(field_name="num_auth_failures")
    )
    num_auth_successes: Optional[int] = field(
        default=None, metadata=config(field_name="num_auth_successes")
    )
    all_affected_users: Optional[List[PasswordSprayAffectedUser]] = field(
        default=None, metadata=config(field_name="all_affected_users")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RareProgramRareIpDetail:
    """RareProgramRareIpDetail."""

    host: Optional[str] = field(default=None, metadata=config(field_name="host"))
    programs: Optional[List[str]] = field(
        default=None, metadata=config(field_name="programs")
    )
    connections: Optional[List[NetworkConnection]] = field(
        default=None, metadata=config(field_name="connections")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ReferenceDetail:
    """ReferenceDetail."""

    reference: Optional[Reference] = field(
        default=None, metadata=config(field_name="reference")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class StolenCredsTrustFeatures:
    """StolenCredsTrustFeatures."""

    network_unknown_asn: Optional[bool] = field(
        default=None, metadata=config(field_name="network_unknown_asn")
    )
    network_unknown_ip: Optional[bool] = field(
        default=None, metadata=config(field_name="network_unknown_ip")
    )
    user_unknown_ip: Optional[bool] = field(
        default=None, metadata=config(field_name="user_unknown_ip")
    )
    user_unknown_asn: Optional[bool] = field(
        default=None, metadata=config(field_name="user_unknown_asn")
    )
    prior_event_time_sec: Optional[int] = field(
        default=None, metadata=config(field_name="prior_event_time_sec")
    )
    current_event_time_sec: Optional[int] = field(
        default=None, metadata=config(field_name="current_event_time_sec")
    )
    prior_event_id: Optional[str] = field(
        default=None, metadata=config(field_name="prior_event_id")
    )
    current_event_id: Optional[str] = field(
        default=None, metadata=config(field_name="current_event_id")
    )
    username: Optional[str] = field(
        default=None, metadata=config(field_name="username")
    )
    location: Optional[GeographicIp] = field(
        default=None, metadata=config(field_name="location")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TacticGraphDetail:
    """TacticGraphDetail."""

    graph_id: Optional[str] = field(
        default=None, metadata=config(field_name="graph_id")
    )
    events: Optional[List[KeyAndValues]] = field(
        default=None, metadata=config(field_name="events")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThirdPartyDetail:
    """ThirdPartyDetail."""

    generic: Optional[GenericDetail] = field(
        default=None, metadata=config(field_name="generic")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class WatchlistMatches:
    """WatchlistMatches."""

    entity: Optional[str] = field(default=None, metadata=config(field_name="entity"))
    details: Optional[List[MatchDetails]] = field(
        default=None, metadata=config(field_name="details")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ResolutionMetadataInput:
    """ResolutionMetadataInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    user_id: Optional[str] = field(default=None, metadata=config(field_name="user_id"))
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    num_alerts_affected: Optional[int] = field(
        default=None, metadata=config(field_name="num_alerts_affected")
    )
    timestamp: Optional[TimestampInput] = field(
        default=None, metadata=config(field_name="timestamp")
    )
    status: Optional[ResolutionStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AuthScanDetailInput:
    """AuthScanDetailInput."""

    total_attempts: Optional[int] = field(
        default=None, metadata=config(field_name="total_attempts")
    )
    successful_logon_attempts: Optional[List[AuthScanLogonAttemptInput]] = field(
        default=None, metadata=config(field_name="successful_logon_attempts")
    )
    failed_logon_attempts: Optional[List[AuthScanLogonAttemptInput]] = field(
        default=None, metadata=config(field_name="failed_logon_attempts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BruteForceDetailsInput:
    """BruteForceDetailsInput."""

    num_auth_failures: Optional[int] = field(
        default=None, metadata=config(field_name="num_auth_failures")
    )
    num_auth_successes: Optional[int] = field(
        default=None, metadata=config(field_name="num_auth_successes")
    )
    last_successful_auth: Optional[BruteForceAuthInput] = field(
        default=None, metadata=config(field_name="last_successful_auth")
    )
    most_recent_auths_failures: Optional[List[BruteForceAuthInput]] = field(
        default=None, metadata=config(field_name="most_recent_auths_failures")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InitialAccessVectorInfo:
    """InitialAccessVectorInfo."""

    investigation_ids: Optional[str] = field(
        default=None, metadata=config(field_name="investigation_ids")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenant_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    created_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="created_at")
    )
    updated_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="updated_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ResolutionMetadata:
    """ResolutionMetadata."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    user_id: Optional[str] = field(default=None, metadata=config(field_name="user_id"))
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    num_alerts_affected: Optional[int] = field(
        default=None, metadata=config(field_name="num_alerts_affected")
    )
    timestamp: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="timestamp")
    )
    status: Optional[ResolutionStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AuthScanDetail:
    """AuthScanDetail."""

    total_attempts: Optional[int] = field(
        default=None, metadata=config(field_name="total_attempts")
    )
    successful_logon_attempts: Optional[List[AuthScanLogonAttempt]] = field(
        default=None, metadata=config(field_name="successful_logon_attempts")
    )
    failed_logon_attempts: Optional[List[AuthScanLogonAttempt]] = field(
        default=None, metadata=config(field_name="failed_logon_attempts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BruteForceDetails:
    """BruteForceDetails."""

    num_auth_failures: Optional[int] = field(
        default=None, metadata=config(field_name="num_auth_failures")
    )
    num_auth_successes: Optional[int] = field(
        default=None, metadata=config(field_name="num_auth_successes")
    )
    last_successful_auth: Optional[BruteForceAuth] = field(
        default=None, metadata=config(field_name="last_successful_auth")
    )
    most_recent_auths_failures: Optional[List[BruteForceAuth]] = field(
        default=None, metadata=config(field_name="most_recent_auths_failures")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Creator:
    """Creator."""

    detector: Optional[Detector] = field(
        default=None, metadata=config(field_name="detector")
    )
    rule: Optional[CreationRule] = field(
        default=None, metadata=config(field_name="rule")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DDosSourceIpCountDetail:
    """DDosSourceIpCountDetail."""

    hour_partition: Optional[str] = field(
        default=None, metadata=config(field_name="hour_partition")
    )
    sensor_id: Optional[str] = field(
        default=None, metadata=config(field_name="sensor_id")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    event_observable_count: Optional[int] = field(
        default=None, metadata=config(field_name="event_observable_count")
    )
    event_observable_count_std_dev: Optional[float] = field(
        default=None, metadata=config(field_name="event_observable_count_std_dev")
    )
    baseline_observable_count_std_dev: Optional[float] = field(
        default=None, metadata=config(field_name="baseline_observable_count_std_dev")
    )
    baseline_observable_count_mean: Optional[float] = field(
        default=None, metadata=config(field_name="baseline_observable_count_mean")
    )
    baseline_observable_count_median: Optional[int] = field(
        default=None, metadata=config(field_name="baseline_observable_count_median")
    )
    baseline_num_days: Optional[int] = field(
        default=None, metadata=config(field_name="baseline_num_days")
    )
    analytic_observable_std_dev_threshold: Optional[float] = field(
        default=None,
        metadata=config(field_name="analytic_observable_std_dev_threshold"),
    )
    analytic_observable_min_count: Optional[int] = field(
        default=None, metadata=config(field_name="analytic_observable_min_count")
    )
    analytic_time_threshold: Optional[int] = field(
        default=None, metadata=config(field_name="analytic_time_threshold")
    )
    historical_ip_counts: Optional[List[DDosIpCount]] = field(
        default=None, metadata=config(field_name="historical_ip_counts")
    )
    top_destination_ips: Optional[List[DDosIpAddressOccurrenceCount]] = field(
        default=None, metadata=config(field_name="top_destination_ips")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class HandsOnKeyboardDetails_MatchedProcess:
    """HandsOnKeyboardDetails_MatchedProcess."""

    process_resource_id: Optional[str] = field(
        default=None, metadata=config(field_name="process_resource_id")
    )
    num_matched_features: Optional[int] = field(
        default=None, metadata=config(field_name="num_matched_features")
    )
    event_time_sec: Optional[int] = field(
        default=None, metadata=config(field_name="event_time_sec")
    )
    score: Optional[float] = field(default=None, metadata=config(field_name="score"))
    severity: Optional[str] = field(
        default=None, metadata=config(field_name="severity")
    )
    image: Optional[HandsOnKeyboardDetails_Image] = field(
        default=None, metadata=config(field_name="image")
    )
    commandline: Optional[HandsOnKeyboardDetails_Commandline] = field(
        default=None, metadata=config(field_name="commandline")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class StolenCredsTravelFeatures:
    """StolenCredsTravelFeatures."""

    accurate_geo: Optional[bool] = field(
        default=None, metadata=config(field_name="accurate_geo")
    )
    foreign_travel: Optional[bool] = field(
        default=None, metadata=config(field_name="foreign_travel")
    )
    long_distance_travel: Optional[bool] = field(
        default=None, metadata=config(field_name="long_distance_travel")
    )
    travel_hours: Optional[float] = field(
        default=None, metadata=config(field_name="travel_hours")
    )
    travel_km_min: Optional[float] = field(
        default=None, metadata=config(field_name="travel_km_min")
    )
    travel_km_h_min: Optional[float] = field(
        default=None, metadata=config(field_name="travel_km_h_min")
    )
    travel_speed_impossible: Optional[bool] = field(
        default=None, metadata=config(field_name="travel_speed_impossible")
    )
    username: Optional[str] = field(
        default=None, metadata=config(field_name="username")
    )
    current_location: Optional[GeographicIp] = field(
        default=None, metadata=config(field_name="current_location")
    )
    prior_location: Optional[GeographicIp] = field(
        default=None, metadata=config(field_name="prior_location")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkResolutionRequestInput:
    """BulkResolutionRequestInput."""

    query: Optional[str] = field(default=None, metadata=config(field_name="query"))
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    user_id: Optional[str] = field(default=None, metadata=config(field_name="user_id"))
    tenant: Optional[str] = field(default=None, metadata=config(field_name="tenant"))
    resolution_status: Optional[ResolutionStatus] = field(
        default=None, metadata=config(field_name="resolution_status")
    )
    caller: Optional[CallerInformation] = field(
        default=None, metadata=config(field_name="caller")
    )
    requested_at: Optional[TimestampInput] = field(
        default=None, metadata=config(field_name="requested_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateInvestigationRequestInput:
    """UpdateInvestigationRequestInput."""

    investigation_id: Optional[str] = field(
        default=None, metadata=config(field_name="investigation_id")
    )
    genesis_alerts: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "was used to flag specific alerts as the genesis of the investigation",
            },
            field_name="genesis_alerts",
        ),
    )
    alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alerts")
    )
    tenant: Optional[str] = field(default=None, metadata=config(field_name="tenant"))
    user_id: Optional[str] = field(default=None, metadata=config(field_name="user_id"))
    operation: Optional[InvestigationOperation] = field(
        default=None, metadata=config(field_name="operation")
    )
    caller: Optional[CallerInformation] = field(
        default=None, metadata=config(field_name="caller")
    )
    requested_at: Optional[TimestampInput] = field(
        default=None, metadata=config(field_name="requested_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateResolutionRequestInput:
    """UpdateResolutionRequestInput."""

    alert_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alert_ids")
    )
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    user_id: Optional[str] = field(default=None, metadata=config(field_name="user_id"))
    tenant: Optional[str] = field(default=None, metadata=config(field_name="tenant"))
    resolution_status: Optional[ResolutionStatus] = field(
        default=None, metadata=config(field_name="resolution_status")
    )
    caller: Optional[CallerInformation] = field(
        default=None, metadata=config(field_name="caller")
    )
    requested_at: Optional[TimestampInput] = field(
        default=None, metadata=config(field_name="requested_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ImprobableLogonDetailInput:
    """ImprobableLogonDetailInput."""

    user: Optional[str] = field(default=None, metadata=config(field_name="user"))
    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    feature_name: Optional[ImprobableLogonDetail_FeatureName] = field(
        default=None, metadata=config(field_name="feature_name")
    )
    logon_anomaly: Optional[LogonAnomalyInput] = field(
        default=None, metadata=config(field_name="logon_anomaly")
    )
    user_logon_baselines: Optional[List[UserLogonBaselineInput]] = field(
        default=None, metadata=config(field_name="user_logon_baselines")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertEventMetadata:
    """AlertEventMetadata."""

    first_event_id: Optional[str] = field(
        default=None, metadata=config(field_name="first_event_id")
    )
    last_event_id: Optional[str] = field(
        default=None, metadata=config(field_name="last_event_id")
    )
    total_events: Optional[int] = field(
        default=None, metadata=config(field_name="total_events")
    )
    updated_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="updated_at")
    )
    began_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="began_at")
    )
    ended_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="ended_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ImprobableLogonDetail:
    """ImprobableLogonDetail."""

    user: Optional[str] = field(default=None, metadata=config(field_name="user"))
    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    feature_name: Optional[ImprobableLogonDetail_FeatureName] = field(
        default=None, metadata=config(field_name="feature_name")
    )
    logon_anomaly: Optional[LogonAnomaly] = field(
        default=None, metadata=config(field_name="logon_anomaly")
    )
    user_logon_baselines: Optional[List[UserLogonBaseline]] = field(
        default=None, metadata=config(field_name="user_logon_baselines")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AggregateAlertsBySeverityInputInput:
    """AggregateAlertsBySeverityInputInput."""

    limit: Optional[int] = field(default=None, metadata=config(field_name="limit"))
    filter_custom_alerts: Optional[bool] = field(
        default=None, metadata=config(field_name="filter_custom_alerts")
    )
    tenant_service_filters: Optional[List[str]] = field(
        default=None, metadata=config(field_name="tenant_service_filters")
    )
    group_by: Optional[AggregateAlertsBySeverityInput_GroupBy] = field(
        default=None, metadata=config(field_name="group_by")
    )
    earliest: Optional[TimestampInput] = field(
        default=None, metadata=config(field_name="earliest")
    )
    latest: Optional[TimestampInput] = field(
        default=None, metadata=config(field_name="latest")
    )
    excluded_severities: Optional[List[AlertsSeverity]] = field(
        default=None, metadata=config(field_name="excluded_severities")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertsMetadata:
    """AlertsMetadata."""

    severity: Optional[float] = field(
        default=None, metadata=config(field_name="severity")
    )
    confidence: Optional[float] = field(
        default=None, metadata=config(field_name="confidence")
    )
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    full_title: Optional[str] = field(
        default=None, metadata=config(field_name="full_title")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    creator: Optional[Creator] = field(
        default=None, metadata=config(field_name="creator")
    )
    engine: Optional[Engine] = field(default=None, metadata=config(field_name="engine"))
    severity_updated_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="severity_updated_at")
    )
    began_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="began_at")
    )
    ended_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="ended_at")
    )
    created_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="created_at")
    )
    inserted_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="inserted_at")
    )
    updated_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="updated_at")
    )
    first_seen_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="first_seen_at")
    )
    first_investigated_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="first_investigated_at")
    )
    first_resolved_at: Optional[Timestamp] = field(
        default=None, metadata=config(field_name="first_resolved_at")
    )
    origin: Optional[Origin] = field(default=None, metadata=config(field_name="origin"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary_City:
    """GeoSummary_City."""

    geoname_id: Optional[int] = field(
        default=None, metadata=config(field_name="geoname_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    locale_names: Optional[KeyValuePairsIndexed] = field(
        default=None, metadata=config(field_name="locale_names")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertsAggregateResponse:
    """AlertsAggregateResponse."""

    aggregation: Optional[List[AlertsAggregateResponse_AlertsAggregation]] = field(
        default=None, metadata=config(field_name="aggregation")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertsInvestigationInfo:
    """AlertsInvestigationInfo."""

    alert_resource_id: Optional[str] = field(
        default=None, metadata=config(field_name="alert_resource_id")
    )
    initial_access_vector_info: Optional[List[InitialAccessVectorInfo]] = field(
        default=None, metadata=config(field_name="initial_access_vector_info")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FileAnalysisDetail:
    """FileAnalysisDetail."""

    matched_yara_rule: Optional[List[MatchedYaraRule]] = field(
        default=None, metadata=config(field_name="matched_yara_rule")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class HandsOnKeyboardDetails:
    """HandsOnKeyboardDetails."""

    total_num_events: Optional[int] = field(
        default=None, metadata=config(field_name="total_num_events")
    )
    matched_num_events: Optional[int] = field(
        default=None, metadata=config(field_name="matched_num_events")
    )
    num_admin_events: Optional[int] = field(
        default=None, metadata=config(field_name="num_admin_events")
    )
    common_parent_image_path: Optional[str] = field(
        default=None, metadata=config(field_name="common_parent_image_path")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="host_id"))
    username: Optional[str] = field(
        default=None, metadata=config(field_name="username")
    )
    matched_process: Optional[List[HandsOnKeyboardDetails_MatchedProcess]] = field(
        default=None, metadata=config(field_name="matched_process")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkInvestigationsResponse:
    """BulkInvestigationsResponse."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="events")
    )
    assets: Optional[List[str]] = field(
        default=None, metadata=config(field_name="assets")
    )
    status: Optional[ResponseStatus] = field(
        default=None, metadata=config(field_name="status")
    )
    access_vector_info: Optional[List[AlertsInvestigationInfo]] = field(
        default=None, metadata=config(field_name="access_vector_info")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateInvestigationResponse:
    """UpdateInvestigationResponse."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="events")
    )
    assets: Optional[List[str]] = field(
        default=None, metadata=config(field_name="assets")
    )
    status: Optional[ResponseStatus] = field(
        default=None, metadata=config(field_name="status")
    )
    access_vector_info: Optional[List[AlertsInvestigationInfo]] = field(
        default=None, metadata=config(field_name="access_vector_info")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GeoSummary:
    """GeoSummary."""

    location: Optional[GeoSummary_Location] = field(
        default=None, metadata=config(field_name="location")
    )
    city: Optional[GeoSummary_City] = field(
        default=None, metadata=config(field_name="city")
    )
    continent: Optional[GeoSummary_Continent] = field(
        default=None, metadata=config(field_name="continent")
    )
    country: Optional[GeoSummary_Country] = field(
        default=None, metadata=config(field_name="country")
    )
    asn: Optional[GeoSummary_ASN] = field(
        default=None, metadata=config(field_name="asn")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BusinessEmailCompromiseDetail:
    """BusinessEmailCompromiseDetail."""

    source_address: Optional[str] = field(
        default=None, metadata=config(field_name="source_address")
    )
    user_name: Optional[str] = field(
        default=None, metadata=config(field_name="user_name")
    )
    source_address_geo_summary: Optional[GeoSummary] = field(
        default=None, metadata=config(field_name="source_address_geo_summary")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EnrichmentDetail:
    """EnrichmentDetail."""

    geo_ip: Optional[GeographicIp] = field(
        default=None, metadata=config(field_name="geo_ip")
    )
    whois: Optional[WhoisSimple] = field(
        default=None, metadata=config(field_name="whois")
    )
    dns_exfil: Optional[DnsExfilEnrichment] = field(
        default=None, metadata=config(field_name="dns_exfil")
    )
    ddos_source_ip: Optional[DDosSourceIpCountDetail] = field(
        default=None, metadata=config(field_name="ddos_source_ip")
    )
    login_failure: Optional[LoginFailureDetail] = field(
        default=None, metadata=config(field_name="login_failure")
    )
    rare_program_rare_ip: Optional[RareProgramRareIpDetail] = field(
        default=None, metadata=config(field_name="rare_program_rare_ip")
    )
    travel_features: Optional[StolenCredsTravelFeatures] = field(
        default=None, metadata=config(field_name="travel_features")
    )
    trust_features: Optional[StolenCredsTrustFeatures] = field(
        default=None, metadata=config(field_name="trust_features")
    )
    tactic_graph_detail: Optional[TacticGraphDetail] = field(
        default=None, metadata=config(field_name="tactic_graph_detail")
    )
    mitre_attack_info: Optional[MitreAttackDetails] = field(
        default=None, metadata=config(field_name="mitre_attack_info")
    )
    watchlist_matches: Optional[WatchlistMatches] = field(
        default=None, metadata=config(field_name="watchlist_matches")
    )
    kerberoasting: Optional[Kerberoasting] = field(
        default=None, metadata=config(field_name="kerberoasting")
    )
    brute_force_detail: Optional[BruteForceDetails] = field(
        default=None, metadata=config(field_name="brute_force_detail")
    )
    password_spray_detail: Optional[PasswordSprayDetail] = field(
        default=None, metadata=config(field_name="password_spray_detail")
    )
    improbable_logon_detail: Optional[ImprobableLogonDetail] = field(
        default=None, metadata=config(field_name="improbable_logon_detail")
    )
    auth_scan_detail: Optional[AuthScanDetail] = field(
        default=None, metadata=config(field_name="auth_scan_detail")
    )
    hands_on_keyboard_details: Optional[HandsOnKeyboardDetails] = field(
        default=None, metadata=config(field_name="hands_on_keyboard_details")
    )
    business_email_compromise: Optional[BusinessEmailCompromiseDetail] = field(
        default=None, metadata=config(field_name="business_email_compromise")
    )
    account_compromise_detector_detail: Optional[
        AccountCompromiseDetectorDetail
    ] = field(
        default=None, metadata=config(field_name="account_compromise_detector_detail")
    )
    file_analysis_detail: Optional[FileAnalysisDetail] = field(
        default=None, metadata=config(field_name="file_analysis_detail")
    )
    generic: Optional[GenericDetail] = field(
        default=None, metadata=config(field_name="generic")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Alert2:
    """Alert2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    group_key: Optional[List[str]] = field(
        default=None, metadata=config(field_name="group_key")
    )
    attack_technique_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attack_technique_ids")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenant_id")
    )
    parent_tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="parent_tenant_id")
    )
    suppressed: Optional[bool] = field(
        default=None, metadata=config(field_name="suppressed")
    )
    resolution_reason: Optional[str] = field(
        default=None, metadata=config(field_name="resolution_reason")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    sensor_types: Optional[List[str]] = field(
        default=None, metadata=config(field_name="sensor_types")
    )
    threat_score: Optional[float] = field(
        default=None, metadata=config(field_name="threat_score")
    )
    metadata: Optional[AlertsMetadata] = field(
        default=None, metadata=config(field_name="metadata")
    )
    visibility: Optional[Visibility] = field(
        default=None, metadata=config(field_name="visibility")
    )
    suppression_rules: Optional[List[AlertRuleReference]] = field(
        default=None, metadata=config(field_name="suppression_rules")
    )
    alerting_rules: Optional[List[AlertRuleReference]] = field(
        default=None, metadata=config(field_name="alerting_rules")
    )
    status: Optional[ResolutionStatus] = field(
        default=None, metadata=config(field_name="status")
    )
    resolution_history: Optional[List[ResolutionMetadata]] = field(
        default=None, metadata=config(field_name="resolution_history")
    )
    severity_history: Optional[List[SeverityUpdate]] = field(
        default=None, metadata=config(field_name="severity_history")
    )
    entities: Optional[EntityRelationships] = field(
        default=None, metadata=config(field_name="entities")
    )
    key_entities: Optional[List[EntityMetadata]] = field(
        default=None, metadata=config(field_name="key_entities")
    )
    event_ids: Optional[List[AuxiliaryEvent]] = field(
        default=None, metadata=config(field_name="event_ids")
    )
    observation_ids: Optional[List[Observation]] = field(
        default=None, metadata=config(field_name="observation_ids")
    )
    investigation_ids: Optional[List[Investigation]] = field(
        default=None, metadata=config(field_name="investigation_ids")
    )
    collection_ids: Optional[List[Collection]] = field(
        default=None, metadata=config(field_name="collection_ids")
    )
    enrichment_details: Optional[List[EnrichmentDetail]] = field(
        default=None, metadata=config(field_name="enrichment_details")
    )
    third_party_details: Optional[List[ThirdPartyDetail]] = field(
        default=None, metadata=config(field_name="third_party_details")
    )
    reference_details: Optional[List[ReferenceDetail]] = field(
        default=None, metadata=config(field_name="reference_details")
    )
    priority: Optional[AlertPriority] = field(
        default=None, metadata=config(field_name="priority")
    )
    events_metadata: Optional[AlertEventMetadata] = field(
        default=None, metadata=config(field_name="events_metadata")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertsList:
    """AlertsList."""

    total_results: Optional[int] = field(
        default=None, metadata=config(field_name="total_results")
    )
    next_offset: Optional[int] = field(
        default=None, metadata=config(field_name="next_offset")
    )
    previous_offset: Optional[int] = field(
        default=None, metadata=config(field_name="previous_offset")
    )
    last_offset: Optional[int] = field(
        default=None, metadata=config(field_name="last_offset")
    )
    first_offset: Optional[int] = field(
        default=None, metadata=config(field_name="first_offset")
    )
    total_parts: Optional[int] = field(
        default=None, metadata=config(field_name="total_parts")
    )
    part: Optional[int] = field(default=None, metadata=config(field_name="part"))
    list: Optional[List[Alert2]] = field(
        default=None, metadata=config(field_name="list")
    )
    group_by: Optional[List[AggregationResponse]] = field(
        default=None, metadata=config(field_name="group_by")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertsResponse:
    """AlertsResponse."""

    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    search_id: Optional[str] = field(
        default=None, metadata=config(field_name="search_id")
    )
    query_id: Optional[str] = field(default=None, metadata=config(field_name="queryId"))
    status: Optional[RPCResponseStatus] = field(
        default=None, metadata=config(field_name="status")
    )
    alerts: Optional[AlertsList] = field(
        default=None, metadata=config(field_name="alerts")
    )
