"""FileInfo Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class FileType(str, Enum):
    """FileType."""

    PE = "pe"
    ELF = "elf"
    OLE = "ole"
    PDF = "pdf"
    TEXT = "text"
    POWERSHELL = "powershell"
    SHELL = "shell"
    LNK = "lnk"
    BATCH = "batch"
    BINARY = "binary"


class FileSource(str, Enum):
    """FileSource."""

    REDCLOAK = "redcloak"
    CROWDSTRIKE = "crowdstrike"
    MICROSOFT = "microsoft"
    OTHER = "other"
    TAEGIS = "taegis"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LnkMetadata:
    """LnkMetadata."""

    show_window_value: Optional[str] = field(
        default=None, metadata=config(field_name="showWindowValue")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    relative_path: Optional[str] = field(
        default=None, metadata=config(field_name="relativePath")
    )
    icon_location: Optional[str] = field(
        default=None, metadata=config(field_name="iconLocation")
    )
    arguments: Optional[str] = field(
        default=None, metadata=config(field_name="arguments")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ShortcutFileInput:
    """ShortcutFileInput."""

    show_window_value: Optional[str] = field(
        default=None, metadata=config(field_name="showWindowValue")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    relative_path: Optional[str] = field(
        default=None, metadata=config(field_name="relativePath")
    )
    icon_location: Optional[str] = field(
        default=None, metadata=config(field_name="iconLocation")
    )
    arguments: Optional[str] = field(
        default=None, metadata=config(field_name="arguments")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DataDirectory:
    """DataDirectory."""

    section_name: Optional[str] = field(
        default=None, metadata=config(field_name="sectionName")
    )
    directory_type: Optional[str] = field(
        default=None, metadata=config(field_name="directoryType")
    )
    rva: Optional[int] = field(default=None, metadata=config(field_name="rva"))
    size: Optional[int] = field(default=None, metadata=config(field_name="size"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Strings:
    """Strings."""

    num_strings: Optional[int] = field(
        default=None, metadata=config(field_name="numStrings")
    )
    average_length: Optional[float] = field(
        default=None, metadata=config(field_name="averageLength")
    )
    printable_dist: Optional[List[float]] = field(
        default=None, metadata=config(field_name="printableDist")
    )
    number_printable: Optional[int] = field(
        default=None, metadata=config(field_name="numberPrintable")
    )
    entropy: Optional[float] = field(
        default=None, metadata=config(field_name="entropy")
    )
    paths: Optional[int] = field(default=None, metadata=config(field_name="paths"))
    urls: Optional[int] = field(default=None, metadata=config(field_name="urls"))
    registry: Optional[int] = field(
        default=None, metadata=config(field_name="registry")
    )
    mz: Optional[int] = field(default=None, metadata=config(field_name="mz"))
    histogram: Optional[List[float]] = field(
        default=None, metadata=config(field_name="histogram")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DataDirectoryInput:
    """DataDirectoryInput."""

    section_name: Optional[str] = field(
        default=None, metadata=config(field_name="sectionName")
    )
    directory_type: Optional[str] = field(
        default=None, metadata=config(field_name="directoryType")
    )
    rva: Optional[int] = field(default=None, metadata=config(field_name="rva"))
    size: Optional[int] = field(default=None, metadata=config(field_name="size"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class StringsInput:
    """StringsInput."""

    num_strings: Optional[int] = field(
        default=None, metadata=config(field_name="numStrings")
    )
    average_length: Optional[float] = field(
        default=None, metadata=config(field_name="averageLength")
    )
    printable_dist: Optional[List[float]] = field(
        default=None, metadata=config(field_name="printableDist")
    )
    number_printable: Optional[int] = field(
        default=None, metadata=config(field_name="numberPrintable")
    )
    entropy: Optional[float] = field(
        default=None, metadata=config(field_name="entropy")
    )
    paths: Optional[int] = field(default=None, metadata=config(field_name="paths"))
    urls: Optional[int] = field(default=None, metadata=config(field_name="urls"))
    registry: Optional[int] = field(
        default=None, metadata=config(field_name="registry")
    )
    mz: Optional[int] = field(default=None, metadata=config(field_name="mz"))
    histogram: Optional[List[float]] = field(
        default=None, metadata=config(field_name="histogram")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Signature:
    """Signature."""

    version: Optional[int] = field(default=None, metadata=config(field_name="version"))
    digest_algorithm: Optional[str] = field(
        default=None, metadata=config(field_name="digestAlgorithm")
    )
    signer_info_version: Optional[str] = field(
        default=None, metadata=config(field_name="signerInfoVersion")
    )
    signer_info_issuer: Optional[str] = field(
        default=None, metadata=config(field_name="signerInfoIssuer")
    )
    signer_info_digest_algorithm: Optional[str] = field(
        default=None, metadata=config(field_name="signerInfoDigestAlgorithm")
    )
    signer_info_signature_algorithm: Optional[str] = field(
        default=None, metadata=config(field_name="signerInfoSignatureAlgorithm")
    )
    signer_info_program_name: Optional[str] = field(
        default=None, metadata=config(field_name="signerInfoProgramName")
    )
    signer_info_message_digest: Optional[str] = field(
        default=None, metadata=config(field_name="signerInfoMessageDigest")
    )
    signer_info_url: Optional[str] = field(
        default=None, metadata=config(field_name="signerInfoURL")
    )
    signer_info_encrypted_digest: Optional[str] = field(
        default=None, metadata=config(field_name="signerInfoEncryptedDigest")
    )
    content_type: Optional[str] = field(
        default=None, metadata=config(field_name="contentType")
    )
    content_digest_algorithm: Optional[str] = field(
        default=None, metadata=config(field_name="contentDigestAlgorithm")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ContentInfoInput:
    """ContentInfoInput."""

    content_type: Optional[str] = field(
        default=None, metadata=config(field_name="contentType")
    )
    digest_algorithm: Optional[str] = field(
        default=None, metadata=config(field_name="digestAlgorithm")
    )
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SignerInfoInput:
    """SignerInfoInput."""

    version: Optional[str] = field(default=None, metadata=config(field_name="version"))
    issuer: Optional[str] = field(default=None, metadata=config(field_name="issuer"))
    digest_algorithm: Optional[str] = field(
        default=None, metadata=config(field_name="digestAlgorithm")
    )
    signature_algorithm: Optional[str] = field(
        default=None, metadata=config(field_name="signatureAlgorithm")
    )
    program_name: Optional[str] = field(
        default=None, metadata=config(field_name="programName")
    )
    message_digest: Optional[str] = field(
        default=None, metadata=config(field_name="messageDigest")
    )
    encrypted_digest: Optional[str] = field(
        default=None, metadata=config(field_name="encryptedDigest")
    )
    url: Optional[str] = field(default=None, metadata=config(field_name="url"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FileSignatureCertificateInput:
    """FileSignatureCertificateInput."""

    signatureid: Optional[str] = field(
        default=None, metadata=config(field_name="signatureid")
    )
    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    version: Optional[int] = field(default=None, metadata=config(field_name="version"))
    serial_number: Optional[str] = field(
        default=None, metadata=config(field_name="serialNumber")
    )
    signature_algorithm: Optional[str] = field(
        default=None, metadata=config(field_name="signatureAlgorithm")
    )
    valid_from: Optional[str] = field(
        default=None, metadata=config(field_name="validFrom")
    )
    valid_to: Optional[str] = field(default=None, metadata=config(field_name="validTo"))
    issuer: Optional[str] = field(default=None, metadata=config(field_name="issuer"))
    subject: Optional[str] = field(default=None, metadata=config(field_name="subject"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Debug:
    """Debug."""

    characteristics: Optional[str] = field(
        default=None, metadata=config(field_name="characteristics")
    )
    timestamp: Optional[str] = field(
        default=None, metadata=config(field_name="timestamp")
    )
    major_version: Optional[int] = field(
        default=None, metadata=config(field_name="majorVersion")
    )
    minor_version: Optional[int] = field(
        default=None, metadata=config(field_name="minorVersion")
    )
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    size_of_data: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfData")
    )
    address_raw_data: Optional[int] = field(
        default=None, metadata=config(field_name="addressRawData")
    )
    pointer_raw_data: Optional[int] = field(
        default=None, metadata=config(field_name="pointerRawData")
    )
    code_view_signature: Optional[str] = field(
        default=None, metadata=config(field_name="codeViewSignature")
    )
    signature: Optional[str] = field(
        default=None, metadata=config(field_name="signature")
    )
    code_view_age: Optional[int] = field(
        default=None, metadata=config(field_name="codeViewAge")
    )
    code_view_filename: Optional[str] = field(
        default=None, metadata=config(field_name="codeViewFilename")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CodeViewInput:
    """CodeViewInput."""

    code_view_signature: Optional[str] = field(
        default=None, metadata=config(field_name="codeViewSignature")
    )
    signature: Optional[str] = field(
        default=None, metadata=config(field_name="signature")
    )
    age: Optional[int] = field(default=None, metadata=config(field_name="age"))
    filename: Optional[str] = field(
        default=None, metadata=config(field_name="filename")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CoffHeader:
    """CoffHeader."""

    signature: Optional[str] = field(
        default=None, metadata=config(field_name="signature")
    )
    machine: Optional[str] = field(default=None, metadata=config(field_name="machine"))
    num_sections: Optional[int] = field(
        default=None, metadata=config(field_name="numSections")
    )
    timestamp: Optional[str] = field(
        default=None, metadata=config(field_name="timestamp")
    )
    pointer_to_symbols: Optional[int] = field(
        default=None, metadata=config(field_name="pointerToSymbols")
    )
    num_symbols: Optional[int] = field(
        default=None, metadata=config(field_name="numSymbols")
    )
    size_optional_header: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOptionalHeader")
    )
    characteristics: Optional[str] = field(
        default=None, metadata=config(field_name="characteristics")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CoffHeaderInput:
    """CoffHeaderInput."""

    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    signature: Optional[str] = field(
        default=None, metadata=config(field_name="signature")
    )
    machine: Optional[str] = field(default=None, metadata=config(field_name="machine"))
    num_sections: Optional[int] = field(
        default=None, metadata=config(field_name="numSections")
    )
    timestamp: Optional[str] = field(
        default=None, metadata=config(field_name="timestamp")
    )
    pointer_to_symbols: Optional[int] = field(
        default=None, metadata=config(field_name="pointerToSymbols")
    )
    num_symbols: Optional[int] = field(
        default=None, metadata=config(field_name="numSymbols")
    )
    size_optional_header: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOptionalHeader")
    )
    characteristics: Optional[str] = field(
        default=None, metadata=config(field_name="characteristics")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DosHeader:
    """DosHeader."""

    magic: Optional[str] = field(default=None, metadata=config(field_name="magic"))
    used_bytes_in_last_page: Optional[int] = field(
        default=None, metadata=config(field_name="usedBytesInLastPage")
    )
    file_size_in_pages: Optional[int] = field(
        default=None, metadata=config(field_name="fileSizeInPages")
    )
    number_of_relocations: Optional[int] = field(
        default=None, metadata=config(field_name="numberOfRelocations")
    )
    header_size_in_paragraphs: Optional[int] = field(
        default=None, metadata=config(field_name="headerSizeInParagraphs")
    )
    min_extra_paragraphs: Optional[int] = field(
        default=None, metadata=config(field_name="minExtraParagraphs")
    )
    max_extra_paragraphs: Optional[int] = field(
        default=None, metadata=config(field_name="maxExtraParagraphs")
    )
    initial_relative_ss: Optional[int] = field(
        default=None, metadata=config(field_name="initialRelativeSS")
    )
    initial_sp: Optional[str] = field(
        default=None, metadata=config(field_name="initialSP")
    )
    initial_ip: Optional[str] = field(
        default=None, metadata=config(field_name="initialIP")
    )
    initial_relative_cs: Optional[int] = field(
        default=None, metadata=config(field_name="initialRelativeCS")
    )
    address_relocation_table: Optional[int] = field(
        default=None, metadata=config(field_name="addressRelocationTable")
    )
    overlay_number: Optional[int] = field(
        default=None, metadata=config(field_name="overlayNumber")
    )
    oem_id: Optional[int] = field(default=None, metadata=config(field_name="oemID"))
    oem_info: Optional[str] = field(default=None, metadata=config(field_name="oemInfo"))
    address_optional_header: Optional[str] = field(
        default=None, metadata=config(field_name="addressOptionalHeader")
    )
    checksum: Optional[str] = field(
        default=None, metadata=config(field_name="checksum")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DosHeaderInput:
    """DosHeaderInput."""

    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    magic: Optional[str] = field(default=None, metadata=config(field_name="magic"))
    used_bytes_in_the_last_page: Optional[int] = field(
        default=None, metadata=config(field_name="usedBytesInTheLastPage")
    )
    file_size_in_pages: Optional[int] = field(
        default=None, metadata=config(field_name="fileSizeInPages")
    )
    number_of_relocations: Optional[int] = field(
        default=None, metadata=config(field_name="numberOfRelocations")
    )
    header_size_in_paragraphs: Optional[int] = field(
        default=None, metadata=config(field_name="headerSizeInParagraphs")
    )
    min_extra_paragraphs: Optional[int] = field(
        default=None, metadata=config(field_name="minExtraParagraphs")
    )
    max_extra_paragraphs: Optional[int] = field(
        default=None, metadata=config(field_name="maxExtraParagraphs")
    )
    initial_relative_ss: Optional[int] = field(
        default=None, metadata=config(field_name="initialRelativeSS")
    )
    initial_sp: Optional[str] = field(
        default=None, metadata=config(field_name="initialSP")
    )
    initial_ip: Optional[str] = field(
        default=None, metadata=config(field_name="initialIP")
    )
    initial_relative_cs: Optional[int] = field(
        default=None, metadata=config(field_name="initialRelativeCS")
    )
    address_relocation_table: Optional[int] = field(
        default=None, metadata=config(field_name="addressRelocationTable")
    )
    overlay_number: Optional[int] = field(
        default=None, metadata=config(field_name="overlayNumber")
    )
    oem_id: Optional[int] = field(default=None, metadata=config(field_name="oemID"))
    oem_info: Optional[str] = field(default=None, metadata=config(field_name="oemInfo"))
    address_optional_header: Optional[str] = field(
        default=None, metadata=config(field_name="addressOptionalHeader")
    )
    checksum: Optional[str] = field(
        default=None, metadata=config(field_name="checksum")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class OptionalHeader:
    """OptionalHeader."""

    magic: Optional[str] = field(default=None, metadata=config(field_name="magic"))
    major_linker_version: Optional[int] = field(
        default=None, metadata=config(field_name="majorLinkerVersion")
    )
    minor_linker_version: Optional[int] = field(
        default=None, metadata=config(field_name="minorLinkerVersion")
    )
    size_of_code: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfCode")
    )
    size_initialized_data: Optional[int] = field(
        default=None, metadata=config(field_name="sizeInitializedData")
    )
    size_uninitialized_data: Optional[int] = field(
        default=None, metadata=config(field_name="sizeUninitializedData")
    )
    entrypoint: Optional[str] = field(
        default=None, metadata=config(field_name="entrypoint")
    )
    base_of_code: Optional[str] = field(
        default=None, metadata=config(field_name="baseOfCode")
    )
    base_of_data: Optional[str] = field(
        default=None, metadata=config(field_name="baseOfData")
    )
    image_base: Optional[str] = field(
        default=None, metadata=config(field_name="imageBase")
    )
    section_alignment: Optional[str] = field(
        default=None, metadata=config(field_name="sectionAlignment")
    )
    file_alignment: Optional[str] = field(
        default=None, metadata=config(field_name="fileAlignment")
    )
    major_os_version: Optional[int] = field(
        default=None, metadata=config(field_name="majorOSVersion")
    )
    minor_os_version: Optional[int] = field(
        default=None, metadata=config(field_name="minorOSVersion")
    )
    major_image_version: Optional[int] = field(
        default=None, metadata=config(field_name="majorImageVersion")
    )
    minor_image_version: Optional[int] = field(
        default=None, metadata=config(field_name="minorImageVersion")
    )
    major_subsytem_version: Optional[int] = field(
        default=None, metadata=config(field_name="majorSubsytemVersion")
    )
    minor_subsystem_version: Optional[int] = field(
        default=None, metadata=config(field_name="minorSubsystemVersion")
    )
    win32_version_value: Optional[int] = field(
        default=None, metadata=config(field_name="win32VersionValue")
    )
    size_of_image: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfImage")
    )
    size_of_headers: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfHeaders")
    )
    checksum: Optional[str] = field(
        default=None, metadata=config(field_name="checksum")
    )
    subsystem: Optional[str] = field(
        default=None, metadata=config(field_name="subsystem")
    )
    dll_characteristics: Optional[str] = field(
        default=None, metadata=config(field_name="dllCharacteristics")
    )
    size_of_stack_reserve: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfStackReserve")
    )
    size_of_stack_commit: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfStackCommit")
    )
    size_of_heap_commit: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfHeapCommit")
    )
    size_of_heap_reserve: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfHeapReserve")
    )
    loader_flags: Optional[int] = field(
        default=None, metadata=config(field_name="loaderFlags")
    )
    number_of_rva_and_size: Optional[int] = field(
        default=None, metadata=config(field_name="numberOfRvaAndSize")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class OptionalHeaderInput:
    """OptionalHeaderInput."""

    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    magic: Optional[str] = field(default=None, metadata=config(field_name="magic"))
    major_linker_version: Optional[int] = field(
        default=None, metadata=config(field_name="majorLinkerVersion")
    )
    minor_linker_version: Optional[int] = field(
        default=None, metadata=config(field_name="minorLinkerVersion")
    )
    size_of_code: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfCode")
    )
    size_initialized_data: Optional[int] = field(
        default=None, metadata=config(field_name="sizeInitializedData")
    )
    size_uninitialized_data: Optional[int] = field(
        default=None, metadata=config(field_name="sizeUninitializedData")
    )
    entrypoint: Optional[str] = field(
        default=None, metadata=config(field_name="entrypoint")
    )
    base_of_code: Optional[str] = field(
        default=None, metadata=config(field_name="baseOfCode")
    )
    base_of_data: Optional[str] = field(
        default=None, metadata=config(field_name="baseOfData")
    )
    image_base: Optional[str] = field(
        default=None, metadata=config(field_name="imageBase")
    )
    section_alignment: Optional[str] = field(
        default=None, metadata=config(field_name="sectionAlignment")
    )
    file_alignment: Optional[str] = field(
        default=None, metadata=config(field_name="fileAlignment")
    )
    major_os_version: Optional[int] = field(
        default=None, metadata=config(field_name="majorOsVersion")
    )
    minor_os_version: Optional[int] = field(
        default=None, metadata=config(field_name="minorOsVersion")
    )
    major_image_version: Optional[int] = field(
        default=None, metadata=config(field_name="majorImageVersion")
    )
    minor_image_version: Optional[int] = field(
        default=None, metadata=config(field_name="minorImageVersion")
    )
    major_subsystem_version: Optional[int] = field(
        default=None, metadata=config(field_name="majorSubsystemVersion")
    )
    minor_subsystem_version: Optional[int] = field(
        default=None, metadata=config(field_name="minorSubsystemVersion")
    )
    win32_version_value: Optional[int] = field(
        default=None, metadata=config(field_name="win32VersionValue")
    )
    size_of_image: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfImage")
    )
    size_of_headers: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfHeaders")
    )
    checksum: Optional[str] = field(
        default=None, metadata=config(field_name="checksum")
    )
    subsystem: Optional[str] = field(
        default=None, metadata=config(field_name="subsystem")
    )
    dll_characteristics: Optional[str] = field(
        default=None, metadata=config(field_name="dllCharacteristics")
    )
    size_of_stack_reserve: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfStackReserve")
    )
    size_of_stack_commit: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfStackCommit")
    )
    size_of_heap_commit: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfHeapCommit")
    )
    size_of_heap_reserve: Optional[int] = field(
        default=None, metadata=config(field_name="sizeOfHeapReserve")
    )
    loader_flags: Optional[int] = field(
        default=None, metadata=config(field_name="loaderFlags")
    )
    number_of_rva_and_size: Optional[int] = field(
        default=None, metadata=config(field_name="numberOfRvaAndSize")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RichHeader:
    """RichHeader."""

    xor_key: Optional[int] = field(default=None, metadata=config(field_name="xorKey"))
    ssdeep: Optional[str] = field(default=None, metadata=config(field_name="ssdeep"))
    md5: Optional[str] = field(default=None, metadata=config(field_name="md5"))
    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    sha1: Optional[str] = field(default=None, metadata=config(field_name="sha1"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RichHeaderInput:
    """RichHeaderInput."""

    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    xor_key: Optional[int] = field(default=None, metadata=config(field_name="xorKey"))
    ssdeep: Optional[str] = field(default=None, metadata=config(field_name="ssdeep"))
    md5: Optional[str] = field(default=None, metadata=config(field_name="md5"))
    sha1: Optional[str] = field(default=None, metadata=config(field_name="sha1"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Appearance:
    """Appearance."""

    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    md5: Optional[str] = field(default=None, metadata=config(field_name="md5"))
    sha1: Optional[str] = field(default=None, metadata=config(field_name="sha1"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AppearanceInput:
    """AppearanceInput."""

    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    md5: Optional[str] = field(default=None, metadata=config(field_name="md5"))
    sha1: Optional[str] = field(default=None, metadata=config(field_name="sha1"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class YaraMetadata:
    """YaraMetadata."""

    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    matched_rules: Optional[List[str]] = field(
        default=None, metadata=config(field_name="matchedRules")
    )
    attack_technique_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attackTechniqueIDs")
    )
    max_severity: Optional[float] = field(
        default=None, metadata=config(field_name="maxSeverity")
    )
    max_confidence: Optional[float] = field(
        default=None, metadata=config(field_name="maxConfidence")
    )
    mss_enabled: Optional[bool] = field(
        default=None, metadata=config(field_name="mssEnabled")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class YaraMetadataInput:
    """YaraMetadataInput."""

    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    matched_rules: Optional[List[str]] = field(
        default=None, metadata=config(field_name="matchedRules")
    )
    attack_technique_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attackTechniqueIDs")
    )
    max_severity: Optional[float] = field(
        default=None, metadata=config(field_name="maxSeverity")
    )
    max_confidence: Optional[float] = field(
        default=None, metadata=config(field_name="maxConfidence")
    )
    mss_enabled: Optional[bool] = field(
        default=None, metadata=config(field_name="mssEnabled")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class HostDetails:
    """HostDetails."""

    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostID"))
    path: Optional[str] = field(default=None, metadata=config(field_name="path"))
    executed: Optional[bool] = field(
        default=None, metadata=config(field_name="executed")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FilePathMetadataInput:
    """FilePathMetadataInput."""

    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenant_id")
    )
    s3_bucket: Optional[str] = field(
        default=None, metadata=config(field_name="s3_bucket")
    )
    s3_key: Optional[str] = field(default=None, metadata=config(field_name="s3_key"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DebugInput:
    """DebugInput."""

    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    characteristics: Optional[str] = field(
        default=None, metadata=config(field_name="characteristics")
    )
    timestamp: Optional[str] = field(
        default=None, metadata=config(field_name="timestamp")
    )
    major_version: Optional[int] = field(
        default=None, metadata=config(field_name="majorVersion")
    )
    minor_version: Optional[int] = field(
        default=None, metadata=config(field_name="minorVersion")
    )
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    sizeof_data: Optional[int] = field(
        default=None, metadata=config(field_name="sizeofData")
    )
    address_raw_data: Optional[int] = field(
        default=None, metadata=config(field_name="addressRawData")
    )
    pointer_raw_data: Optional[int] = field(
        default=None, metadata=config(field_name="pointerRawData")
    )
    code_view: Optional[CodeViewInput] = field(
        default=None, metadata=config(field_name="codeView")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FileCounts:
    """FileCounts."""

    host_count: Optional[int] = field(
        default=None, metadata=config(field_name="hostCount")
    )
    tenant_count: Optional[int] = field(
        default=None, metadata=config(field_name="tenantCount")
    )
    hosts: Optional[List[HostDetails]] = field(
        default=None, metadata=config(field_name="hosts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SignatureInput:
    """SignatureInput."""

    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    version: Optional[int] = field(default=None, metadata=config(field_name="version"))
    digest_algorithm: Optional[str] = field(
        default=None, metadata=config(field_name="digestAlgorithm")
    )
    content_info: Optional[ContentInfoInput] = field(
        default=None, metadata=config(field_name="contentInfo")
    )
    signer_info: Optional[SignerInfoInput] = field(
        default=None, metadata=config(field_name="signerInfo")
    )
    certificates: Optional[List[FileSignatureCertificateInput]] = field(
        default=None, metadata=config(field_name="certificates")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PEMetadata:
    """PEMetadata."""

    pe_sha256: Optional[str] = field(
        default=None, metadata=config(field_name="peSha256")
    )
    virtual_size: Optional[int] = field(
        default=None, metadata=config(field_name="virtualSize")
    )
    is_pie: Optional[bool] = field(default=None, metadata=config(field_name="isPie"))
    has_nx: Optional[bool] = field(default=None, metadata=config(field_name="hasNX"))
    has_tls: Optional[bool] = field(default=None, metadata=config(field_name="hasTLS"))
    num_exports: Optional[int] = field(
        default=None, metadata=config(field_name="numExports")
    )
    num_imports: Optional[int] = field(
        default=None, metadata=config(field_name="numImports")
    )
    num_symbols: Optional[int] = field(
        default=None, metadata=config(field_name="numSymbols")
    )
    import_hash: Optional[str] = field(
        default=None, metadata=config(field_name="importHash")
    )
    byte_histogram: Optional[List[float]] = field(
        default=None, metadata=config(field_name="byteHistogram")
    )
    byte_entropy_histogram: Optional[List[float]] = field(
        default=None, metadata=config(field_name="byteEntropyHistogram")
    )
    imports: Optional[dict] = field(default=None, metadata=config(field_name="imports"))
    exports: Optional[dict] = field(default=None, metadata=config(field_name="exports"))
    sections: Optional[dict] = field(
        default=None, metadata=config(field_name="sections")
    )
    signature: Optional[Signature] = field(
        default=None, metadata=config(field_name="signature")
    )
    debug: Optional[Debug] = field(default=None, metadata=config(field_name="debug"))
    coff_header: Optional[CoffHeader] = field(
        default=None, metadata=config(field_name="coffHeader")
    )
    dos_header: Optional[DosHeader] = field(
        default=None, metadata=config(field_name="dosHeader")
    )
    optional_header: Optional[OptionalHeader] = field(
        default=None, metadata=config(field_name="optionalHeader")
    )
    rich_header: Optional[RichHeader] = field(
        default=None, metadata=config(field_name="richHeader")
    )
    strings: Optional[Strings] = field(
        default=None, metadata=config(field_name="strings")
    )
    data_directories: Optional[List[DataDirectory]] = field(
        default=None, metadata=config(field_name="dataDirectories")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PEMetadataInput:
    """PEMetadataInput."""

    pe_sha256: Optional[str] = field(
        default=None, metadata=config(field_name="peSha256")
    )
    virtual_size: Optional[int] = field(
        default=None, metadata=config(field_name="virtualSize")
    )
    has_nx: Optional[bool] = field(default=None, metadata=config(field_name="hasNX"))
    is_pie: Optional[bool] = field(default=None, metadata=config(field_name="isPie"))
    has_tls: Optional[bool] = field(default=None, metadata=config(field_name="hasTLS"))
    num_exports: Optional[int] = field(
        default=None, metadata=config(field_name="numExports")
    )
    num_imports: Optional[int] = field(
        default=None, metadata=config(field_name="numImports")
    )
    num_symbols: Optional[int] = field(
        default=None, metadata=config(field_name="numSymbols")
    )
    imphash: Optional[str] = field(default=None, metadata=config(field_name="imphash"))
    byte_histogram: Optional[List[float]] = field(
        default=None, metadata=config(field_name="byteHistogram")
    )
    byte_entropy_histogram: Optional[List[float]] = field(
        default=None, metadata=config(field_name="byteEntropyHistogram")
    )
    imports: Optional[dict] = field(default=None, metadata=config(field_name="imports"))
    exports: Optional[dict] = field(default=None, metadata=config(field_name="exports"))
    sections: Optional[dict] = field(
        default=None, metadata=config(field_name="sections")
    )
    signature: Optional[SignatureInput] = field(
        default=None, metadata=config(field_name="signature")
    )
    coff_header: Optional[CoffHeaderInput] = field(
        default=None, metadata=config(field_name="coffHeader")
    )
    dos_header: Optional[DosHeaderInput] = field(
        default=None, metadata=config(field_name="dosHeader")
    )
    optional_header: Optional[OptionalHeaderInput] = field(
        default=None, metadata=config(field_name="optionalHeader")
    )
    rich_header: Optional[RichHeaderInput] = field(
        default=None, metadata=config(field_name="richHeader")
    )
    debug: Optional[DebugInput] = field(
        default=None, metadata=config(field_name="debug")
    )
    strings: Optional[StringsInput] = field(
        default=None, metadata=config(field_name="strings")
    )
    datadirectories: Optional[List[DataDirectoryInput]] = field(
        default=None, metadata=config(field_name="datadirectories")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FileInput:
    """FileInput."""

    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    sha1: Optional[str] = field(default=None, metadata=config(field_name="sha1"))
    md5: Optional[str] = field(default=None, metadata=config(field_name="md5"))
    ssdeep: Optional[str] = field(default=None, metadata=config(field_name="ssdeep"))
    tlsh: Optional[str] = field(default=None, metadata=config(field_name="tlsh"))
    size: Optional[int] = field(default=None, metadata=config(field_name="size"))
    malicious: Optional[bool] = field(
        default=None, metadata=config(field_name="malicious")
    )
    file_type: Optional[FileType] = field(
        default=None, metadata=config(field_name="fileType")
    )
    file_source: Optional[FileSource] = field(
        default=None, metadata=config(field_name="fileSource")
    )
    pe_metadata: Optional[PEMetadataInput] = field(
        default=None, metadata=config(field_name="peMetadata")
    )
    lnk_metadata: Optional[ShortcutFileInput] = field(
        default=None, metadata=config(field_name="lnkMetadata")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class File:
    """File."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    size: Optional[int] = field(default=None, metadata=config(field_name="size"))
    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    sha1: Optional[str] = field(default=None, metadata=config(field_name="sha1"))
    md5: Optional[str] = field(default=None, metadata=config(field_name="md5"))
    ssdeep: Optional[str] = field(default=None, metadata=config(field_name="ssdeep"))
    tlsh: Optional[str] = field(default=None, metadata=config(field_name="tlsh"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    malicious: Optional[bool] = field(
        default=None, metadata=config(field_name="malicious")
    )
    file_type: Optional[FileType] = field(
        default=None, metadata=config(field_name="fileType")
    )
    file_source: Optional[FileSource] = field(
        default=None, metadata=config(field_name="fileSource")
    )
    pe_metadata: Optional[PEMetadata] = field(
        default=None, metadata=config(field_name="peMetadata")
    )
    lnk_metadata: Optional[LnkMetadata] = field(
        default=None, metadata=config(field_name="lnkMetadata")
    )
    yara_metadata: Optional[YaraMetadata] = field(
        default=None, metadata=config(field_name="yaraMetadata")
    )
