"""Queries Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.queries.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.queries import QueriesService

log = logging.getLogger(__name__)


class TaegisSDKQueriesQuery:
    """Taegis Queries Query operations."""

    def __init__(self, service: QueriesService):
        self.service = service

    def ql_queries(self, input_: QLQueriesInput) -> QLQueriesResults:
        """Looks up search queries by their resource names.."""
        endpoint = "qlQueries"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(QLQueriesResults),
        )
        if result.get(endpoint) is not None:
            return QLQueriesResults.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query qlQueries")

    def list_ql_queries(
        self, input_: Optional[ListQLQueriesInput] = None
    ) -> ListQLQueriesResults:
        """Searches for queries by their attributes.."""
        endpoint = "listQLQueries"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(ListQLQueriesResults),
        )
        if result.get(endpoint) is not None:
            return ListQLQueriesResults.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query listQLQueries")

    def ql_query(self, rn: str) -> QLQuery:
        """None."""
        endpoint = "qlQuery"

        log.warning(f"GraphQL Query `{endpoint}` is deprecated: 'Use qlQueries.'")

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "rn": prepare_input(rn),
            },
            output=build_output_string(QLQuery),
        )
        if result.get(endpoint) is not None:
            return QLQuery.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query qlQuery")

    def saved_ql_query(self, rn: str) -> SavedQLQuery:
        """None."""
        endpoint = "savedQLQuery"

        log.warning(f"GraphQL Query `{endpoint}` is deprecated: 'Use savedQLQueries.'")

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "rn": prepare_input(rn),
            },
            output=build_output_string(SavedQLQuery),
        )
        if result.get(endpoint) is not None:
            return SavedQLQuery.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query savedQLQuery")

    def saved_ql_queries(self, rns: List[str]) -> SavedQLQueriesResults:
        """None."""
        endpoint = "savedQLQueries"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "rns": prepare_input(rns),
            },
            output=build_output_string(SavedQLQueriesResults),
        )
        if result.get(endpoint) is not None:
            return SavedQLQueriesResults.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query savedQLQueries")

    def list_saved_ql_queries(
        self, input_: Optional[ListQLQueriesInput] = None
    ) -> ListSavedQLQueriesResults:
        """None."""
        endpoint = "listSavedQLQueries"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(ListSavedQLQueriesResults),
        )
        if result.get(endpoint) is not None:
            return ListSavedQLQueriesResults.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query listSavedQLQueries")
