"""Subjects Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class SubjectType(str, Enum):
    """SubjectType."""

    CLIENT_SUBJECT = "CLIENT_SUBJECT"
    USER_SUBJECT = "USER_SUBJECT"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SubjectRoleAssignment:
    """SubjectRoleAssignment."""

    role_id: Optional[str] = field(default=None, metadata=config(field_name="roleId"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )
    role_name: Optional[str] = field(
        default=None, metadata=config(field_name="roleName")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    deactivated: Optional[bool] = field(
        default=None, metadata=config(field_name="deactivated")
    )
    expires_at: Optional[str] = field(
        default=None, metadata=config(field_name="expiresAt")
    )
    is_scwx_role_assignment: Optional[bool] = field(
        default=None, metadata=config(field_name="isScwxRoleAssignment")
    )
    is_parent_role_assignment: Optional[bool] = field(
        default=None, metadata=config(field_name="isParentRoleAssignment")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TDRUser:
    """TDRUser."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Client:
    """Client."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SubjectRoleAssignmentData:
    """SubjectRoleAssignmentData."""

    assigned_tenant_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="assignedTenantIDs")
    )
    assigned_partner_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="assignedPartnerIDs")
    )
    can_read_all_tenants: Optional[bool] = field(
        default=None, metadata=config(field_name="canReadAllTenants")
    )
    has_support_access: Optional[bool] = field(
        default=None, metadata=config(field_name="hasSupportAccess")
    )
    has_scwx_role_assignment: Optional[bool] = field(
        default=None, metadata=config(field_name="hasScwxRoleAssignment")
    )
    role_assignments: Optional[List[SubjectRoleAssignment]] = field(
        default=None, metadata=config(field_name="roleAssignments")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Subject:
    """Subject."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    display_name: Optional[str] = field(
        default=None, metadata=config(field_name="displayName")
    )
    role_assignment_data: Optional[SubjectRoleAssignmentData] = field(
        default=None, metadata=config(field_name="roleAssignmentData")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SubjectSelector:
    """SubjectSelector."""

    with_types: Optional[List[SubjectType]] = field(
        default=None, metadata=config(field_name="withTypes")
    )


SubjectIdentity = Union[
    TDRUser,
    Client,
]
