"""Threat Mutation."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.threat.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.threat import ThreatService

log = logging.getLogger(__name__)


class TaegisSDKThreatMutation:
    """Taegis Threat Mutation operations."""

    def __init__(self, service: ThreatService):
        self.service = service

    def indicator(self, id_: str) -> ThreatIndicator:
        """None."""
        endpoint = "indicator"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(ThreatIndicator),
        )
        if result.get(endpoint) is not None:
            return ThreatIndicator.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation indicator")

    def threat_delete_document(self, id_: str) -> bool:
        """threatDeleteDocument is used to delete a document by id in the configured index."""
        endpoint = "threatDeleteDocument"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for mutation threatDeleteDocument")
