"""Trip Mutation."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.trip.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.trip import TripService

log = logging.getLogger(__name__)


class TaegisSDKTripMutation:
    """Taegis Trip Mutation operations."""

    def __init__(self, service: TripService):
        self.service = service

    def create_api_integration(
        self, product_id: int, name: str, parameters: List[ApiIntegrationParameterInput]
    ) -> ApiIntegration:
        """None."""
        endpoint = "createApiIntegration"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "productId": prepare_input(product_id),
                "name": prepare_input(name),
                "parameters": prepare_input(parameters),
            },
            output=build_output_string(ApiIntegration),
        )
        if result.get(endpoint) is not None:
            return ApiIntegration.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createApiIntegration")

    def update_api_integration_parameters(
        self, integration_id: int, parameters: List[ApiIntegrationParameterInput]
    ) -> ApiIntegration:
        """None."""
        endpoint = "updateApiIntegrationParameters"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "integrationId": prepare_input(integration_id),
                "parameters": prepare_input(parameters),
            },
            output=build_output_string(ApiIntegration),
        )
        if result.get(endpoint) is not None:
            return ApiIntegration.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for mutation updateApiIntegrationParameters"
        )

    def delete_api_integration(self, id_: int) -> List[ApiIntegrationSummary]:
        """None."""
        endpoint = "deleteApiIntegration"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(ApiIntegrationSummary),
        )
        if result.get(endpoint) is not None:
            return ApiIntegrationSummary.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for mutation deleteApiIntegration")

    def pause_api_integration(self, id_: int) -> ApiIntegrationUpdateResponse:
        """None."""
        endpoint = "pauseApiIntegration"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(ApiIntegrationUpdateResponse),
        )
        if result.get(endpoint) is not None:
            return ApiIntegrationUpdateResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation pauseApiIntegration")

    def resume_api_integration(self, id_: int) -> ApiIntegrationUpdateResponse:
        """None."""
        endpoint = "resumeApiIntegration"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(ApiIntegrationUpdateResponse),
        )
        if result.get(endpoint) is not None:
            return ApiIntegrationUpdateResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation resumeApiIntegration")
