# -*- coding: utf-8 -*-
"""
# ---------------------------------------------------------------------------------------------------------
# ProjectName:  python-qdairlines-helper
# FileName:     order_detail.py
# Description:  订单详情控制器
# Author:       ASUS
# CreateDate:   2026/01/06
# Copyright ©2011-2026. Hunan xxxxxxx Company limited. All rights reserved.
# ---------------------------------------------------------------------------------------------------------
"""
from aiohttp import CookieJar
from typing import Dict, Any, Optional, List
from qdairlines_helper.utils.log_utils import logger
from qdairlines_helper.http.flight_order import FlightOrder


async def get_order_itinerary(
        *, playwright_state: Dict[str, Any], token: Optional[str], pre_order_no: str, user_id: str,
        proxy: Dict[str, Any], domain: Optional[str] = None, protocol: Optional[str] = None,
        timeout: Optional[int] = None, retry: Optional[int] = None, enable_log: Optional[bool] = None,
        cookie_jar: Optional[CookieJar] = None, headers: Dict[str, str] = None
) -> Dict[str, Any]:
    flight_order = FlightOrder(
        playwright_state=playwright_state, token=token, domain=domain, protocol=protocol, timeout=timeout, retry=retry,
        enable_log=enable_log, cookie_jar=cookie_jar
    )
    _order_info: Dict[str, Any] = dict(pre_order_no=pre_order_no)
    try:
        order_info = await flight_order.get_order_details(
            pre_order_no=pre_order_no, user_id=user_id, is_end=True, proxy=proxy, headers=headers
        )
        if isinstance(order_info, dict) and order_info.get("result"):
            result = order_info.get("result") or dict()
            _order_info["cash_unit"] = result.get("cashUnit")
            _order_info["order_status"] = result.get("orderStatus")
            _order_info["actual_payment_amount"] = result.get("totalPrice")
            passenger_infos: List[Dict[str, Any]] = result.get("passengerInfoVoList")
            order_itineraries = list()
            for passenger_info in passenger_infos:
                id_no = passenger_info.get("idNo")
                order_itinerary = passenger_info.get("tktNo")
                passenger = passenger_info.get("passName")
                order_itineraries.append(dict(
                    passenger=passenger, id_no=id_no, order_itinerary=order_itinerary, pre_order_no=pre_order_no
                ))
            if order_itineraries:
                _order_info["order_itineraries"] = order_itineraries
        else:
            raise RuntimeError(f"订单<{pre_order_no}>，获取订单详情数据异常，返回值：{order_info}")
    except Exception as e:
        logger.error(e)
    return _order_info
