import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BotChannelFacebookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#bot_name BotChannelFacebook#bot_name}
    */
    readonly botName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#facebook_application_id BotChannelFacebook#facebook_application_id}
    */
    readonly facebookApplicationId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#facebook_application_secret BotChannelFacebook#facebook_application_secret}
    */
    readonly facebookApplicationSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#location BotChannelFacebook#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#resource_group_name BotChannelFacebook#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * page block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#page BotChannelFacebook#page}
    */
    readonly page: BotChannelFacebookPage[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#timeouts BotChannelFacebook#timeouts}
    */
    readonly timeouts?: BotChannelFacebookTimeouts;
}
export interface BotChannelFacebookPage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#access_token BotChannelFacebook#access_token}
    */
    readonly accessToken: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#id BotChannelFacebook#id}
    */
    readonly id: string;
}
export declare function botChannelFacebookPageToTerraform(struct?: BotChannelFacebookPage | cdktf.IResolvable): any;
export interface BotChannelFacebookTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#create BotChannelFacebook#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#delete BotChannelFacebook#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#read BotChannelFacebook#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook#update BotChannelFacebook#update}
    */
    readonly update?: string;
}
export declare function botChannelFacebookTimeoutsToTerraform(struct?: BotChannelFacebookTimeoutsOutputReference | BotChannelFacebookTimeouts | cdktf.IResolvable): any;
export declare class BotChannelFacebookTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BotChannelFacebookTimeouts | undefined;
    set internalValue(value: BotChannelFacebookTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook azurerm_bot_channel_facebook}
*/
export declare class BotChannelFacebook extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_bot_channel_facebook";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_facebook azurerm_bot_channel_facebook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BotChannelFacebookConfig
    */
    constructor(scope: Construct, id: string, config: BotChannelFacebookConfig);
    private _botName?;
    get botName(): string;
    set botName(value: string);
    get botNameInput(): string | undefined;
    private _facebookApplicationId?;
    get facebookApplicationId(): string;
    set facebookApplicationId(value: string);
    get facebookApplicationIdInput(): string | undefined;
    private _facebookApplicationSecret?;
    get facebookApplicationSecret(): string;
    set facebookApplicationSecret(value: string);
    get facebookApplicationSecretInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _page?;
    get page(): BotChannelFacebookPage[] | cdktf.IResolvable;
    set page(value: BotChannelFacebookPage[] | cdktf.IResolvable);
    get pageInput(): cdktf.IResolvable | BotChannelFacebookPage[] | undefined;
    private _timeouts;
    get timeouts(): BotChannelFacebookTimeoutsOutputReference;
    putTimeouts(value: BotChannelFacebookTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): BotChannelFacebookTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
