import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDatabricksWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace#name DataAzurermDatabricksWorkspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace#resource_group_name DataAzurermDatabricksWorkspace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace#tags DataAzurermDatabricksWorkspace#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace#timeouts DataAzurermDatabricksWorkspace#timeouts}
    */
    readonly timeouts?: DataAzurermDatabricksWorkspaceTimeouts;
}
export interface DataAzurermDatabricksWorkspaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace#read DataAzurermDatabricksWorkspace#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDatabricksWorkspaceTimeoutsToTerraform(struct?: DataAzurermDatabricksWorkspaceTimeoutsOutputReference | DataAzurermDatabricksWorkspaceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDatabricksWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDatabricksWorkspaceTimeouts | undefined;
    set internalValue(value: DataAzurermDatabricksWorkspaceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace azurerm_databricks_workspace}
*/
export declare class DataAzurermDatabricksWorkspace extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_databricks_workspace";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/databricks_workspace azurerm_databricks_workspace} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDatabricksWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDatabricksWorkspaceConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get workspaceId(): string;
    get workspaceUrl(): string;
    private _timeouts;
    get timeouts(): DataAzurermDatabricksWorkspaceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDatabricksWorkspaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDatabricksWorkspaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
