import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPostgresqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_server#name DataAzurermPostgresqlServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_server#resource_group_name DataAzurermPostgresqlServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_server#timeouts DataAzurermPostgresqlServer#timeouts}
    */
    readonly timeouts?: DataAzurermPostgresqlServerTimeouts;
}
export interface DataAzurermPostgresqlServerIdentity {
}
export declare function dataAzurermPostgresqlServerIdentityToTerraform(struct?: DataAzurermPostgresqlServerIdentity): any;
export declare class DataAzurermPostgresqlServerIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermPostgresqlServerIdentity | undefined;
    set internalValue(value: DataAzurermPostgresqlServerIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermPostgresqlServerIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermPostgresqlServerIdentityOutputReference;
}
export interface DataAzurermPostgresqlServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_server#read DataAzurermPostgresqlServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPostgresqlServerTimeoutsToTerraform(struct?: DataAzurermPostgresqlServerTimeoutsOutputReference | DataAzurermPostgresqlServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPostgresqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPostgresqlServerTimeouts | undefined;
    set internalValue(value: DataAzurermPostgresqlServerTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_server azurerm_postgresql_server}
*/
export declare class DataAzurermPostgresqlServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_postgresql_server";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/postgresql_server azurerm_postgresql_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPostgresqlServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPostgresqlServerConfig);
    get administratorLogin(): string;
    get fqdn(): string;
    get id(): string;
    private _identity;
    get identity(): DataAzurermPostgresqlServerIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    tags(key: string): string | cdktf.IResolvable;
    get version(): string;
    private _timeouts;
    get timeouts(): DataAzurermPostgresqlServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPostgresqlServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPostgresqlServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
