import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#customer_managed_key_id DataFactory#customer_managed_key_id}
    */
    readonly customerManagedKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#location DataFactory#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#managed_virtual_network_enabled DataFactory#managed_virtual_network_enabled}
    */
    readonly managedVirtualNetworkEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#name DataFactory#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#public_network_enabled DataFactory#public_network_enabled}
    */
    readonly publicNetworkEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#resource_group_name DataFactory#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#tags DataFactory#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * github_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#github_configuration DataFactory#github_configuration}
    */
    readonly githubConfiguration?: DataFactoryGithubConfiguration;
    /**
    * global_parameter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#global_parameter DataFactory#global_parameter}
    */
    readonly globalParameter?: DataFactoryGlobalParameter[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#identity DataFactory#identity}
    */
    readonly identity?: DataFactoryIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#timeouts DataFactory#timeouts}
    */
    readonly timeouts?: DataFactoryTimeouts;
    /**
    * vsts_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#vsts_configuration DataFactory#vsts_configuration}
    */
    readonly vstsConfiguration?: DataFactoryVstsConfiguration;
}
export interface DataFactoryGithubConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#account_name DataFactory#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#branch_name DataFactory#branch_name}
    */
    readonly branchName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#git_url DataFactory#git_url}
    */
    readonly gitUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#repository_name DataFactory#repository_name}
    */
    readonly repositoryName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#root_folder DataFactory#root_folder}
    */
    readonly rootFolder: string;
}
export declare function dataFactoryGithubConfigurationToTerraform(struct?: DataFactoryGithubConfigurationOutputReference | DataFactoryGithubConfiguration): any;
export declare class DataFactoryGithubConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryGithubConfiguration | undefined;
    set internalValue(value: DataFactoryGithubConfiguration | undefined);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _branchName?;
    get branchName(): string;
    set branchName(value: string);
    get branchNameInput(): string | undefined;
    private _gitUrl?;
    get gitUrl(): string;
    set gitUrl(value: string);
    get gitUrlInput(): string | undefined;
    private _repositoryName?;
    get repositoryName(): string;
    set repositoryName(value: string);
    get repositoryNameInput(): string | undefined;
    private _rootFolder?;
    get rootFolder(): string;
    set rootFolder(value: string);
    get rootFolderInput(): string | undefined;
}
export interface DataFactoryGlobalParameter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#name DataFactory#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#type DataFactory#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#value DataFactory#value}
    */
    readonly value: string;
}
export declare function dataFactoryGlobalParameterToTerraform(struct?: DataFactoryGlobalParameter | cdktf.IResolvable): any;
export interface DataFactoryIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#identity_ids DataFactory#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#type DataFactory#type}
    */
    readonly type: string;
}
export declare function dataFactoryIdentityToTerraform(struct?: DataFactoryIdentityOutputReference | DataFactoryIdentity): any;
export declare class DataFactoryIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryIdentity | undefined;
    set internalValue(value: DataFactoryIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DataFactoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#create DataFactory#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#delete DataFactory#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#read DataFactory#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#update DataFactory#update}
    */
    readonly update?: string;
}
export declare function dataFactoryTimeoutsToTerraform(struct?: DataFactoryTimeoutsOutputReference | DataFactoryTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryTimeouts | undefined;
    set internalValue(value: DataFactoryTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DataFactoryVstsConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#account_name DataFactory#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#branch_name DataFactory#branch_name}
    */
    readonly branchName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#project_name DataFactory#project_name}
    */
    readonly projectName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#repository_name DataFactory#repository_name}
    */
    readonly repositoryName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#root_folder DataFactory#root_folder}
    */
    readonly rootFolder: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory#tenant_id DataFactory#tenant_id}
    */
    readonly tenantId: string;
}
export declare function dataFactoryVstsConfigurationToTerraform(struct?: DataFactoryVstsConfigurationOutputReference | DataFactoryVstsConfiguration): any;
export declare class DataFactoryVstsConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryVstsConfiguration | undefined;
    set internalValue(value: DataFactoryVstsConfiguration | undefined);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _branchName?;
    get branchName(): string;
    set branchName(value: string);
    get branchNameInput(): string | undefined;
    private _projectName?;
    get projectName(): string;
    set projectName(value: string);
    get projectNameInput(): string | undefined;
    private _repositoryName?;
    get repositoryName(): string;
    set repositoryName(value: string);
    get repositoryNameInput(): string | undefined;
    private _rootFolder?;
    get rootFolder(): string;
    set rootFolder(value: string);
    get rootFolderInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory azurerm_data_factory}
*/
export declare class DataFactory extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_factory";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory azurerm_data_factory} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryConfig);
    private _customerManagedKeyId?;
    get customerManagedKeyId(): string;
    set customerManagedKeyId(value: string);
    resetCustomerManagedKeyId(): void;
    get customerManagedKeyIdInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managedVirtualNetworkEnabled?;
    get managedVirtualNetworkEnabled(): boolean | cdktf.IResolvable;
    set managedVirtualNetworkEnabled(value: boolean | cdktf.IResolvable);
    resetManagedVirtualNetworkEnabled(): void;
    get managedVirtualNetworkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkEnabled?;
    get publicNetworkEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkEnabled(): void;
    get publicNetworkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _githubConfiguration;
    get githubConfiguration(): DataFactoryGithubConfigurationOutputReference;
    putGithubConfiguration(value: DataFactoryGithubConfiguration): void;
    resetGithubConfiguration(): void;
    get githubConfigurationInput(): DataFactoryGithubConfiguration | undefined;
    private _globalParameter?;
    get globalParameter(): DataFactoryGlobalParameter[] | cdktf.IResolvable;
    set globalParameter(value: DataFactoryGlobalParameter[] | cdktf.IResolvable);
    resetGlobalParameter(): void;
    get globalParameterInput(): cdktf.IResolvable | DataFactoryGlobalParameter[] | undefined;
    private _identity;
    get identity(): DataFactoryIdentityOutputReference;
    putIdentity(value: DataFactoryIdentity): void;
    resetIdentity(): void;
    get identityInput(): DataFactoryIdentity | undefined;
    private _timeouts;
    get timeouts(): DataFactoryTimeoutsOutputReference;
    putTimeouts(value: DataFactoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataFactoryTimeouts | undefined;
    private _vstsConfiguration;
    get vstsConfiguration(): DataFactoryVstsConfigurationOutputReference;
    putVstsConfiguration(value: DataFactoryVstsConfiguration): void;
    resetVstsConfiguration(): void;
    get vstsConfigurationInput(): DataFactoryVstsConfiguration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
