import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogicAppTriggerCustomConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_custom#body LogicAppTriggerCustom#body}
    */
    readonly body: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_custom#logic_app_id LogicAppTriggerCustom#logic_app_id}
    */
    readonly logicAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_custom#name LogicAppTriggerCustom#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_custom#timeouts LogicAppTriggerCustom#timeouts}
    */
    readonly timeouts?: LogicAppTriggerCustomTimeouts;
}
export interface LogicAppTriggerCustomTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_custom#create LogicAppTriggerCustom#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_custom#delete LogicAppTriggerCustom#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_custom#read LogicAppTriggerCustom#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_custom#update LogicAppTriggerCustom#update}
    */
    readonly update?: string;
}
export declare function logicAppTriggerCustomTimeoutsToTerraform(struct?: LogicAppTriggerCustomTimeoutsOutputReference | LogicAppTriggerCustomTimeouts | cdktf.IResolvable): any;
export declare class LogicAppTriggerCustomTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppTriggerCustomTimeouts | undefined;
    set internalValue(value: LogicAppTriggerCustomTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_custom azurerm_logic_app_trigger_custom}
*/
export declare class LogicAppTriggerCustom extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logic_app_trigger_custom";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_custom azurerm_logic_app_trigger_custom} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogicAppTriggerCustomConfig
    */
    constructor(scope: Construct, id: string, config: LogicAppTriggerCustomConfig);
    private _body?;
    get body(): string;
    set body(value: string);
    get bodyInput(): string | undefined;
    get id(): string;
    private _logicAppId?;
    get logicAppId(): string;
    set logicAppId(value: string);
    get logicAppIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): LogicAppTriggerCustomTimeoutsOutputReference;
    putTimeouts(value: LogicAppTriggerCustomTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LogicAppTriggerCustomTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
