import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MariadbServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#administrator_login MariadbServer#administrator_login}
    */
    readonly administratorLogin?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#administrator_login_password MariadbServer#administrator_login_password}
    */
    readonly administratorLoginPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#auto_grow_enabled MariadbServer#auto_grow_enabled}
    */
    readonly autoGrowEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#backup_retention_days MariadbServer#backup_retention_days}
    */
    readonly backupRetentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#create_mode MariadbServer#create_mode}
    */
    readonly createMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#creation_source_server_id MariadbServer#creation_source_server_id}
    */
    readonly creationSourceServerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#geo_redundant_backup_enabled MariadbServer#geo_redundant_backup_enabled}
    */
    readonly geoRedundantBackupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#location MariadbServer#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#name MariadbServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#public_network_access_enabled MariadbServer#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#resource_group_name MariadbServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#restore_point_in_time MariadbServer#restore_point_in_time}
    */
    readonly restorePointInTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#sku_name MariadbServer#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#ssl_enforcement MariadbServer#ssl_enforcement}
    */
    readonly sslEnforcement?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#ssl_enforcement_enabled MariadbServer#ssl_enforcement_enabled}
    */
    readonly sslEnforcementEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#storage_mb MariadbServer#storage_mb}
    */
    readonly storageMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#tags MariadbServer#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#version MariadbServer#version}
    */
    readonly version: string;
    /**
    * storage_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#storage_profile MariadbServer#storage_profile}
    */
    readonly storageProfile?: MariadbServerStorageProfile;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#timeouts MariadbServer#timeouts}
    */
    readonly timeouts?: MariadbServerTimeouts;
}
export interface MariadbServerStorageProfile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#auto_grow MariadbServer#auto_grow}
    */
    readonly autoGrow?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#backup_retention_days MariadbServer#backup_retention_days}
    */
    readonly backupRetentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#geo_redundant_backup MariadbServer#geo_redundant_backup}
    */
    readonly geoRedundantBackup?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#storage_mb MariadbServer#storage_mb}
    */
    readonly storageMb?: number;
}
export declare function mariadbServerStorageProfileToTerraform(struct?: MariadbServerStorageProfileOutputReference | MariadbServerStorageProfile): any;
export declare class MariadbServerStorageProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MariadbServerStorageProfile | undefined;
    set internalValue(value: MariadbServerStorageProfile | undefined);
    private _autoGrow?;
    get autoGrow(): string;
    set autoGrow(value: string);
    resetAutoGrow(): void;
    get autoGrowInput(): string | undefined;
    private _backupRetentionDays?;
    get backupRetentionDays(): number;
    set backupRetentionDays(value: number);
    resetBackupRetentionDays(): void;
    get backupRetentionDaysInput(): number | undefined;
    private _geoRedundantBackup?;
    get geoRedundantBackup(): string;
    set geoRedundantBackup(value: string);
    resetGeoRedundantBackup(): void;
    get geoRedundantBackupInput(): string | undefined;
    private _storageMb?;
    get storageMb(): number;
    set storageMb(value: number);
    resetStorageMb(): void;
    get storageMbInput(): number | undefined;
}
export interface MariadbServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#create MariadbServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#delete MariadbServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#read MariadbServer#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server#update MariadbServer#update}
    */
    readonly update?: string;
}
export declare function mariadbServerTimeoutsToTerraform(struct?: MariadbServerTimeoutsOutputReference | MariadbServerTimeouts | cdktf.IResolvable): any;
export declare class MariadbServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MariadbServerTimeouts | undefined;
    set internalValue(value: MariadbServerTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server azurerm_mariadb_server}
*/
export declare class MariadbServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mariadb_server";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_server azurerm_mariadb_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MariadbServerConfig
    */
    constructor(scope: Construct, id: string, config: MariadbServerConfig);
    private _administratorLogin?;
    get administratorLogin(): string;
    set administratorLogin(value: string);
    resetAdministratorLogin(): void;
    get administratorLoginInput(): string | undefined;
    private _administratorLoginPassword?;
    get administratorLoginPassword(): string;
    set administratorLoginPassword(value: string);
    resetAdministratorLoginPassword(): void;
    get administratorLoginPasswordInput(): string | undefined;
    private _autoGrowEnabled?;
    get autoGrowEnabled(): boolean | cdktf.IResolvable;
    set autoGrowEnabled(value: boolean | cdktf.IResolvable);
    resetAutoGrowEnabled(): void;
    get autoGrowEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _backupRetentionDays?;
    get backupRetentionDays(): number;
    set backupRetentionDays(value: number);
    resetBackupRetentionDays(): void;
    get backupRetentionDaysInput(): number | undefined;
    private _createMode?;
    get createMode(): string;
    set createMode(value: string);
    resetCreateMode(): void;
    get createModeInput(): string | undefined;
    private _creationSourceServerId?;
    get creationSourceServerId(): string;
    set creationSourceServerId(value: string);
    resetCreationSourceServerId(): void;
    get creationSourceServerIdInput(): string | undefined;
    get fqdn(): string;
    private _geoRedundantBackupEnabled?;
    get geoRedundantBackupEnabled(): boolean | cdktf.IResolvable;
    set geoRedundantBackupEnabled(value: boolean | cdktf.IResolvable);
    resetGeoRedundantBackupEnabled(): void;
    get geoRedundantBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _restorePointInTime?;
    get restorePointInTime(): string;
    set restorePointInTime(value: string);
    resetRestorePointInTime(): void;
    get restorePointInTimeInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _sslEnforcement?;
    get sslEnforcement(): string;
    set sslEnforcement(value: string);
    resetSslEnforcement(): void;
    get sslEnforcementInput(): string | undefined;
    private _sslEnforcementEnabled?;
    get sslEnforcementEnabled(): boolean | cdktf.IResolvable;
    set sslEnforcementEnabled(value: boolean | cdktf.IResolvable);
    resetSslEnforcementEnabled(): void;
    get sslEnforcementEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageMb?;
    get storageMb(): number;
    set storageMb(value: number);
    resetStorageMb(): void;
    get storageMbInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _storageProfile;
    get storageProfile(): MariadbServerStorageProfileOutputReference;
    putStorageProfile(value: MariadbServerStorageProfile): void;
    resetStorageProfile(): void;
    get storageProfileInput(): MariadbServerStorageProfile | undefined;
    private _timeouts;
    get timeouts(): MariadbServerTimeoutsOutputReference;
    putTimeouts(value: MariadbServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MariadbServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
