import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MysqlFlexibleServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#administrator_login MysqlFlexibleServer#administrator_login}
    */
    readonly administratorLogin?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#administrator_password MysqlFlexibleServer#administrator_password}
    */
    readonly administratorPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#backup_retention_days MysqlFlexibleServer#backup_retention_days}
    */
    readonly backupRetentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#create_mode MysqlFlexibleServer#create_mode}
    */
    readonly createMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#delegated_subnet_id MysqlFlexibleServer#delegated_subnet_id}
    */
    readonly delegatedSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#geo_redundant_backup_enabled MysqlFlexibleServer#geo_redundant_backup_enabled}
    */
    readonly geoRedundantBackupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#location MysqlFlexibleServer#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#name MysqlFlexibleServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#point_in_time_restore_time_in_utc MysqlFlexibleServer#point_in_time_restore_time_in_utc}
    */
    readonly pointInTimeRestoreTimeInUtc?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#private_dns_zone_id MysqlFlexibleServer#private_dns_zone_id}
    */
    readonly privateDnsZoneId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#replication_role MysqlFlexibleServer#replication_role}
    */
    readonly replicationRole?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#resource_group_name MysqlFlexibleServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#sku_name MysqlFlexibleServer#sku_name}
    */
    readonly skuName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#source_server_id MysqlFlexibleServer#source_server_id}
    */
    readonly sourceServerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#tags MysqlFlexibleServer#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#version MysqlFlexibleServer#version}
    */
    readonly version?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#zone MysqlFlexibleServer#zone}
    */
    readonly zone?: string;
    /**
    * high_availability block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#high_availability MysqlFlexibleServer#high_availability}
    */
    readonly highAvailability?: MysqlFlexibleServerHighAvailability;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#maintenance_window MysqlFlexibleServer#maintenance_window}
    */
    readonly maintenanceWindow?: MysqlFlexibleServerMaintenanceWindow;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#storage MysqlFlexibleServer#storage}
    */
    readonly storage?: MysqlFlexibleServerStorage;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#timeouts MysqlFlexibleServer#timeouts}
    */
    readonly timeouts?: MysqlFlexibleServerTimeouts;
}
export interface MysqlFlexibleServerHighAvailability {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#mode MysqlFlexibleServer#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#standby_availability_zone MysqlFlexibleServer#standby_availability_zone}
    */
    readonly standbyAvailabilityZone?: string;
}
export declare function mysqlFlexibleServerHighAvailabilityToTerraform(struct?: MysqlFlexibleServerHighAvailabilityOutputReference | MysqlFlexibleServerHighAvailability): any;
export declare class MysqlFlexibleServerHighAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MysqlFlexibleServerHighAvailability | undefined;
    set internalValue(value: MysqlFlexibleServerHighAvailability | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _standbyAvailabilityZone?;
    get standbyAvailabilityZone(): string;
    set standbyAvailabilityZone(value: string);
    resetStandbyAvailabilityZone(): void;
    get standbyAvailabilityZoneInput(): string | undefined;
}
export interface MysqlFlexibleServerMaintenanceWindow {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#day_of_week MysqlFlexibleServer#day_of_week}
    */
    readonly dayOfWeek?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#start_hour MysqlFlexibleServer#start_hour}
    */
    readonly startHour?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#start_minute MysqlFlexibleServer#start_minute}
    */
    readonly startMinute?: number;
}
export declare function mysqlFlexibleServerMaintenanceWindowToTerraform(struct?: MysqlFlexibleServerMaintenanceWindowOutputReference | MysqlFlexibleServerMaintenanceWindow): any;
export declare class MysqlFlexibleServerMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MysqlFlexibleServerMaintenanceWindow | undefined;
    set internalValue(value: MysqlFlexibleServerMaintenanceWindow | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): number;
    set dayOfWeek(value: number);
    resetDayOfWeek(): void;
    get dayOfWeekInput(): number | undefined;
    private _startHour?;
    get startHour(): number;
    set startHour(value: number);
    resetStartHour(): void;
    get startHourInput(): number | undefined;
    private _startMinute?;
    get startMinute(): number;
    set startMinute(value: number);
    resetStartMinute(): void;
    get startMinuteInput(): number | undefined;
}
export interface MysqlFlexibleServerStorage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#auto_grow_enabled MysqlFlexibleServer#auto_grow_enabled}
    */
    readonly autoGrowEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#iops MysqlFlexibleServer#iops}
    */
    readonly iops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#size_gb MysqlFlexibleServer#size_gb}
    */
    readonly sizeGb?: number;
}
export declare function mysqlFlexibleServerStorageToTerraform(struct?: MysqlFlexibleServerStorageOutputReference | MysqlFlexibleServerStorage): any;
export declare class MysqlFlexibleServerStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MysqlFlexibleServerStorage | undefined;
    set internalValue(value: MysqlFlexibleServerStorage | undefined);
    private _autoGrowEnabled?;
    get autoGrowEnabled(): boolean | cdktf.IResolvable;
    set autoGrowEnabled(value: boolean | cdktf.IResolvable);
    resetAutoGrowEnabled(): void;
    get autoGrowEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _sizeGb?;
    get sizeGb(): number;
    set sizeGb(value: number);
    resetSizeGb(): void;
    get sizeGbInput(): number | undefined;
}
export interface MysqlFlexibleServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#create MysqlFlexibleServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#delete MysqlFlexibleServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#read MysqlFlexibleServer#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#update MysqlFlexibleServer#update}
    */
    readonly update?: string;
}
export declare function mysqlFlexibleServerTimeoutsToTerraform(struct?: MysqlFlexibleServerTimeoutsOutputReference | MysqlFlexibleServerTimeouts | cdktf.IResolvable): any;
export declare class MysqlFlexibleServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MysqlFlexibleServerTimeouts | undefined;
    set internalValue(value: MysqlFlexibleServerTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server azurerm_mysql_flexible_server}
*/
export declare class MysqlFlexibleServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mysql_flexible_server";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server azurerm_mysql_flexible_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MysqlFlexibleServerConfig
    */
    constructor(scope: Construct, id: string, config: MysqlFlexibleServerConfig);
    private _administratorLogin?;
    get administratorLogin(): string;
    set administratorLogin(value: string);
    resetAdministratorLogin(): void;
    get administratorLoginInput(): string | undefined;
    private _administratorPassword?;
    get administratorPassword(): string;
    set administratorPassword(value: string);
    resetAdministratorPassword(): void;
    get administratorPasswordInput(): string | undefined;
    private _backupRetentionDays?;
    get backupRetentionDays(): number;
    set backupRetentionDays(value: number);
    resetBackupRetentionDays(): void;
    get backupRetentionDaysInput(): number | undefined;
    private _createMode?;
    get createMode(): string;
    set createMode(value: string);
    resetCreateMode(): void;
    get createModeInput(): string | undefined;
    private _delegatedSubnetId?;
    get delegatedSubnetId(): string;
    set delegatedSubnetId(value: string);
    resetDelegatedSubnetId(): void;
    get delegatedSubnetIdInput(): string | undefined;
    get fqdn(): string;
    private _geoRedundantBackupEnabled?;
    get geoRedundantBackupEnabled(): boolean | cdktf.IResolvable;
    set geoRedundantBackupEnabled(value: boolean | cdktf.IResolvable);
    resetGeoRedundantBackupEnabled(): void;
    get geoRedundantBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pointInTimeRestoreTimeInUtc?;
    get pointInTimeRestoreTimeInUtc(): string;
    set pointInTimeRestoreTimeInUtc(value: string);
    resetPointInTimeRestoreTimeInUtc(): void;
    get pointInTimeRestoreTimeInUtcInput(): string | undefined;
    private _privateDnsZoneId?;
    get privateDnsZoneId(): string;
    set privateDnsZoneId(value: string);
    resetPrivateDnsZoneId(): void;
    get privateDnsZoneIdInput(): string | undefined;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    get replicaCapacity(): number;
    private _replicationRole?;
    get replicationRole(): string;
    set replicationRole(value: string);
    resetReplicationRole(): void;
    get replicationRoleInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    resetSkuName(): void;
    get skuNameInput(): string | undefined;
    private _sourceServerId?;
    get sourceServerId(): string;
    set sourceServerId(value: string);
    resetSourceServerId(): void;
    get sourceServerIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _highAvailability;
    get highAvailability(): MysqlFlexibleServerHighAvailabilityOutputReference;
    putHighAvailability(value: MysqlFlexibleServerHighAvailability): void;
    resetHighAvailability(): void;
    get highAvailabilityInput(): MysqlFlexibleServerHighAvailability | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): MysqlFlexibleServerMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: MysqlFlexibleServerMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): MysqlFlexibleServerMaintenanceWindow | undefined;
    private _storage;
    get storage(): MysqlFlexibleServerStorageOutputReference;
    putStorage(value: MysqlFlexibleServerStorage): void;
    resetStorage(): void;
    get storageInput(): MysqlFlexibleServerStorage | undefined;
    private _timeouts;
    get timeouts(): MysqlFlexibleServerTimeoutsOutputReference;
    putTimeouts(value: MysqlFlexibleServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MysqlFlexibleServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
