"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdgeFunction = void 0;
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const aws_ssm_1 = require("@aws-cdk/aws-ssm");
const base_edge_construct_1 = require("./base-edge-construct");
const with_configuration_1 = require("./with-configuration");
const edge_function_provider_1 = require("./edge-function-provider");
const edge_role_1 = require("./edge-role");
class EdgeFunction extends base_edge_construct_1.BaseEdgeConstruct {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const { name, parameterName = `/cloudcomponents/edge-lambda/${this.stack.node.uniqueId}/${name}`, } = props;
        this.edgeRole = (_a = props.edgeRole) !== null && _a !== void 0 ? _a : new edge_role_1.EdgeRole(this, `${name}Role`);
        this.eventType = props.eventType;
        const edgeFunction = new aws_lambda_1.Function(this.edgeStack, `${name}Function`, {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            code: props.code,
            role: this.edgeRole.role,
        });
        const parameter = new aws_ssm_1.StringParameter(this.edgeStack, `${name}StringParameter`, {
            parameterName,
            description: 'Parameter stored for cross region Lambda@Edge',
            stringValue: edgeFunction.functionArn,
        });
        const { edgeFunction: retrievedEdgeFunction } = new edge_function_provider_1.EdgeFunctionProvider(scope, `${name}Provider`, {
            parameter,
        });
        const lambdaWithConfig = new with_configuration_1.WithConfiguration(this, 'WithConfiguration', {
            function: retrievedEdgeFunction,
            configuration: props.configuration,
        });
        this.functionVersion = lambdaWithConfig.functionVersion;
        this.lambdaFunction = this.functionVersion;
    }
}
exports.EdgeFunction = EdgeFunction;
//# sourceMappingURL=data:application/json;base64,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