""" Code is generated by ucloud-model, DO NOT EDIT IT. """


from ucloud.core.typesystem import schema, fields
from ucloud.services.udisk.schemas import models

""" UDisk API Schema
"""


"""
API: AttachUDisk

将一个可用的UDisk挂载到某台主机上，当UDisk挂载成功后，还需要在主机内部进行文件系统操作
"""


class AttachUDiskRequestSchema(schema.RequestSchema):
    """AttachUDisk - 将一个可用的UDisk挂载到某台主机上，当UDisk挂载成功后，还需要在主机内部进行文件系统操作"""

    fields = {
        "HostId": fields.Str(required=False, dump_to="HostId"),
        "MultiAttach": fields.Str(required=False, dump_to="MultiAttach"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDiskId": fields.Str(required=True, dump_to="UDiskId"),
        "UHostId": fields.Str(required=False, dump_to="UHostId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class AttachUDiskResponseSchema(schema.ResponseSchema):
    """AttachUDisk - 将一个可用的UDisk挂载到某台主机上，当UDisk挂载成功后，还需要在主机内部进行文件系统操作"""

    fields = {
        "DeviceName": fields.Str(required=False, load_from="DeviceName"),
        "HostId": fields.Str(required=False, load_from="HostId"),
        "UDiskId": fields.Str(required=False, load_from="UDiskId"),
        "UHostId": fields.Str(required=False, load_from="UHostId"),
    }


"""
API: CloneUDisk

从UDisk创建UDisk克隆
"""


class CloneUDiskRequestSchema(schema.RequestSchema):
    """CloneUDisk - 从UDisk创建UDisk克隆"""

    fields = {
        "BackupMode": fields.Str(required=False, dump_to="BackupMode"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "Comment": fields.Str(required=False, dump_to="Comment"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "Day": fields.Int(required=False, dump_to="Day"),
        "HostId": fields.Str(required=False, dump_to="HostId"),
        "Hour": fields.Int(required=False, dump_to="Hour"),
        "Journal": fields.Int(required=False, dump_to="Journal"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "RdmaClusterId": fields.Str(required=False, dump_to="RdmaClusterId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=False, dump_to="Size"),
        "SnapshotService": fields.Str(
            required=False, dump_to="SnapshotService"
        ),
        "SourceId": fields.Str(required=True, dump_to="SourceId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "UDataArkMode": fields.Str(required=False, dump_to="UDataArkMode"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CloneUDiskResponseSchema(schema.ResponseSchema):
    """CloneUDisk - 从UDisk创建UDisk克隆"""

    fields = {
        "UDiskId": fields.List(
            fields.Str(), required=False, load_from="UDiskId"
        ),
    }


"""
API: CloneUDiskSnapshot

从快照创建UDisk克隆
"""


class CloneUDiskSnapshotRequestSchema(schema.RequestSchema):
    """CloneUDiskSnapshot - 从快照创建UDisk克隆"""

    fields = {
        "BackupMode": fields.Str(required=False, dump_to="BackupMode"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "Comment": fields.Str(required=False, dump_to="Comment"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "Day": fields.Int(required=False, dump_to="Day"),
        "HostId": fields.Str(required=False, dump_to="HostId"),
        "Hour": fields.Int(required=False, dump_to="Hour"),
        "Journal": fields.Int(required=False, dump_to="Journal"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "RdmaClusterId": fields.Str(required=False, dump_to="RdmaClusterId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=False, dump_to="Size"),
        "SnapshotService": fields.Str(
            required=False, dump_to="SnapshotService"
        ),
        "SourceId": fields.Str(required=True, dump_to="SourceId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "UDataArkMode": fields.Str(required=False, dump_to="UDataArkMode"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CloneUDiskSnapshotResponseSchema(schema.ResponseSchema):
    """CloneUDiskSnapshot - 从快照创建UDisk克隆"""

    fields = {
        "UDiskId": fields.List(
            fields.Str(), required=False, load_from="UDiskId"
        ),
    }


"""
API: CloneUDiskUDataArk

从数据方舟的备份创建UDisk
"""


class CloneUDiskUDataArkRequestSchema(schema.RequestSchema):
    """CloneUDiskUDataArk - 从数据方舟的备份创建UDisk"""

    fields = {
        "BackupMode": fields.Str(required=False, dump_to="BackupMode"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "Comment": fields.Str(required=False, dump_to="Comment"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "Day": fields.Int(required=False, dump_to="Day"),
        "HostId": fields.Str(required=False, dump_to="HostId"),
        "Hour": fields.Int(required=False, dump_to="Hour"),
        "Journal": fields.Int(required=False, dump_to="Journal"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "RdmaClusterId": fields.Str(required=False, dump_to="RdmaClusterId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=False, dump_to="Size"),
        "SnapshotService": fields.Str(
            required=False, dump_to="SnapshotService"
        ),
        "SnapshotTime": fields.Int(required=True, dump_to="SnapshotTime"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "UDataArkMode": fields.Str(required=False, dump_to="UDataArkMode"),
        "UDiskId": fields.Str(required=True, dump_to="UDiskId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CloneUDiskUDataArkResponseSchema(schema.ResponseSchema):
    """CloneUDiskUDataArk - 从数据方舟的备份创建UDisk"""

    fields = {
        "UDiskId": fields.List(
            fields.Str(), required=True, load_from="UDiskId"
        ),
    }


"""
API: CreateAttachUDisk

创建并挂载UDisk磁盘
"""


class CreateAttachUDiskRequestSchema(schema.RequestSchema):
    """CreateAttachUDisk - 创建并挂载UDisk磁盘"""

    fields = {
        "BackupMode": fields.Str(required=False, dump_to="BackupMode"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CmkId": fields.Str(required=False, dump_to="CmkId"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "Day": fields.Int(required=False, dump_to="Day"),
        "DiskType": fields.Str(required=False, dump_to="DiskType"),
        "HostId": fields.Str(required=False, dump_to="HostId"),
        "Hour": fields.Int(required=False, dump_to="Hour"),
        "Journal": fields.Int(required=False, dump_to="Journal"),
        "MultiAttach": fields.Str(required=False, dump_to="MultiAttach"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "SnapshotService": fields.Str(
            required=False, dump_to="SnapshotService"
        ),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "UDataArkMode": fields.Str(required=False, dump_to="UDataArkMode"),
        "UHostId": fields.Str(required=False, dump_to="UHostId"),
        "UKmsMode": fields.Str(required=False, dump_to="UKmsMode"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateAttachUDiskResponseSchema(schema.ResponseSchema):
    """CreateAttachUDisk - 创建并挂载UDisk磁盘"""

    fields = {
        "DeviceName": fields.Str(required=False, load_from="DeviceName"),
        "HostId": fields.Str(required=False, load_from="HostId"),
        "UDiskId": fields.Str(required=False, load_from="UDiskId"),
        "UHostId": fields.Str(required=False, load_from="UHostId"),
    }


"""
API: CreateUDisk

创建UDisk磁盘
"""


class CreateUDiskRequestSchema(schema.RequestSchema):
    """CreateUDisk - 创建UDisk磁盘"""

    fields = {
        "BackupMode": fields.Str(required=False, dump_to="BackupMode"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CmkId": fields.Str(required=False, dump_to="CmkId"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "Day": fields.Int(required=False, dump_to="Day"),
        "DiskType": fields.Str(required=False, dump_to="DiskType"),
        "Hour": fields.Int(required=False, dump_to="Hour"),
        "Journal": fields.Int(required=False, dump_to="Journal"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "RdmaClusterId": fields.Str(required=False, dump_to="RdmaClusterId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "SnapshotService": fields.Str(
            required=False, dump_to="SnapshotService"
        ),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "UDataArkMode": fields.Str(required=False, dump_to="UDataArkMode"),
        "UKmsMode": fields.Str(required=False, dump_to="UKmsMode"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateUDiskResponseSchema(schema.ResponseSchema):
    """CreateUDisk - 创建UDisk磁盘"""

    fields = {
        "UDiskId": fields.List(
            fields.Str(), required=False, load_from="UDiskId"
        ),
    }


"""
API: CreateUDiskSnapshot

创建snapshot快照
"""


class CreateUDiskSnapshotRequestSchema(schema.RequestSchema):
    """CreateUDiskSnapshot - 创建snapshot快照"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "Comment": fields.Str(required=False, dump_to="Comment"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDiskId": fields.Str(required=True, dump_to="UDiskId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateUDiskSnapshotResponseSchema(schema.ResponseSchema):
    """CreateUDiskSnapshot - 创建snapshot快照"""

    fields = {
        "SnapshotId": fields.List(
            fields.Str(), required=True, load_from="SnapshotId"
        ),
    }


"""
API: DeleteUDisk

删除UDisk
"""


class DeleteUDiskRequestSchema(schema.RequestSchema):
    """DeleteUDisk - 删除UDisk"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDiskId": fields.Str(required=True, dump_to="UDiskId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteUDiskResponseSchema(schema.ResponseSchema):
    """DeleteUDisk - 删除UDisk"""

    fields = {}


"""
API: DeleteUDiskSnapshot

删除Snapshot
"""


class DeleteUDiskSnapshotRequestSchema(schema.RequestSchema):
    """DeleteUDiskSnapshot - 删除Snapshot"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SnapshotId": fields.Str(required=False, dump_to="SnapshotId"),
        "UDiskId": fields.Str(required=False, dump_to="UDiskId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteUDiskSnapshotResponseSchema(schema.ResponseSchema):
    """DeleteUDiskSnapshot - 删除Snapshot"""

    fields = {}


"""
API: DescribeRecycleUDisk

拉取回收站中云硬盘列表
"""


class DescribeRecycleUDiskRequestSchema(schema.RequestSchema):
    """DescribeRecycleUDisk - 拉取回收站中云硬盘列表"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeRecycleUDiskResponseSchema(schema.ResponseSchema):
    """DescribeRecycleUDisk - 拉取回收站中云硬盘列表"""

    fields = {
        "DataSet": fields.List(
            models.RecycleUDiskSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeUDisk

获取UDisk实例
"""


class DescribeUDiskRequestSchema(schema.RequestSchema):
    """DescribeUDisk - 获取UDisk实例"""

    fields = {
        "DiskType": fields.Str(required=False, dump_to="DiskType"),
        "HostId": fields.Str(required=False, dump_to="HostId"),
        "HostIdForAttachment": fields.Str(
            required=False, dump_to="HostIdForAttachment"
        ),
        "HostProduct": fields.Str(required=False, dump_to="HostProduct"),
        "IgnoreBackupMode": fields.Str(
            required=False, dump_to="IgnoreBackupMode"
        ),
        "IgnoreUBillInfo": fields.Str(
            required=False, dump_to="IgnoreUBillInfo"
        ),
        "IsBoot": fields.Str(required=False, dump_to="IsBoot"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "ProtocolVersion": fields.Int(
            required=False, dump_to="ProtocolVersion"
        ),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Status": fields.Str(required=False, dump_to="Status"),
        "UDiskBasicInfo": fields.Str(required=False, dump_to="UDiskBasicInfo"),
        "UDiskId": fields.Str(required=False, dump_to="UDiskId"),
        "UHostIdForAttachment": fields.Str(
            required=False, dump_to="UHostIdForAttachment"
        ),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDiskResponseSchema(schema.ResponseSchema):
    """DescribeUDisk - 获取UDisk实例"""

    fields = {
        "DataSet": fields.List(
            models.UDiskDataSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUDiskPrice

获取UDisk实例价格信息
"""


class DescribeUDiskPriceRequestSchema(schema.RequestSchema):
    """DescribeUDiskPrice - 获取UDisk实例价格信息"""

    fields = {
        "BackupMode": fields.Str(required=False, dump_to="BackupMode"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "Day": fields.Int(required=False, dump_to="Day"),
        "DiskType": fields.Str(required=False, dump_to="DiskType"),
        "Hour": fields.Int(required=False, dump_to="Hour"),
        "IsTotalPrice": fields.Str(required=False, dump_to="IsTotalPrice"),
        "Journal": fields.Int(required=False, dump_to="Journal"),
        "MachineType": fields.Str(required=False, dump_to="MachineType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "SnapshotService": fields.Str(
            required=False, dump_to="SnapshotService"
        ),
        "UDataArkMode": fields.Str(required=False, dump_to="UDataArkMode"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUDiskPriceResponseSchema(schema.ResponseSchema):
    """DescribeUDiskPrice - 获取UDisk实例价格信息"""

    fields = {
        "DataSet": fields.List(
            models.UDiskPriceDataSetSchema(),
            required=False,
            load_from="DataSet",
        ),
    }


"""
API: DescribeUDiskSnapshot

获取UDisk快照
"""


class DescribeUDiskSnapshotRequestSchema(schema.RequestSchema):
    """DescribeUDiskSnapshot - 获取UDisk快照"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SnapshotId": fields.Str(required=False, dump_to="SnapshotId"),
        "UDiskId": fields.Str(required=False, dump_to="UDiskId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDiskSnapshotResponseSchema(schema.ResponseSchema):
    """DescribeUDiskSnapshot - 获取UDisk快照"""

    fields = {
        "DataSet": fields.List(
            models.UDiskSnapshotSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUDiskUpgradePrice

获取UDisk升级价格信息
"""


class DescribeUDiskUpgradePriceRequestSchema(schema.RequestSchema):
    """DescribeUDiskUpgradePrice - 获取UDisk升级价格信息"""

    fields = {
        "BackupMode": fields.Str(required=False, dump_to="BackupMode"),
        "Day": fields.Int(required=False, dump_to="Day"),
        "DiskType": fields.Str(required=False, dump_to="DiskType"),
        "Hour": fields.Int(required=False, dump_to="Hour"),
        "Journal": fields.Int(required=False, dump_to="Journal"),
        "MachineType": fields.Str(required=False, dump_to="MachineType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "SnapshotService": fields.Str(
            required=False, dump_to="SnapshotService"
        ),
        "SourceId": fields.Str(required=True, dump_to="SourceId"),
        "UDataArkMode": fields.Str(required=False, dump_to="UDataArkMode"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUDiskUpgradePriceResponseSchema(schema.ResponseSchema):
    """DescribeUDiskUpgradePrice - 获取UDisk升级价格信息"""

    fields = {
        "OriginalPrice": fields.Int(required=False, load_from="OriginalPrice"),
        "Price": fields.Int(required=False, load_from="Price"),
    }


"""
API: DetachUDisk

卸载某个已经挂载在指定UHost实例上的UDisk
"""


class DetachUDiskRequestSchema(schema.RequestSchema):
    """DetachUDisk - 卸载某个已经挂载在指定UHost实例上的UDisk"""

    fields = {
        "HostId": fields.Str(required=False, dump_to="HostId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDiskId": fields.Str(required=True, dump_to="UDiskId"),
        "UHostId": fields.Str(required=False, dump_to="UHostId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DetachUDiskResponseSchema(schema.ResponseSchema):
    """DetachUDisk - 卸载某个已经挂载在指定UHost实例上的UDisk"""

    fields = {
        "HostId": fields.Str(required=False, load_from="HostId"),
        "UDiskId": fields.Str(required=False, load_from="UDiskId"),
        "UHostId": fields.Str(required=False, load_from="UHostId"),
    }


"""
API: RecoverUDisk

从回收站中恢复云硬盘
"""


class RecoverUDiskRequestSchema(schema.RequestSchema):
    """RecoverUDisk - 从回收站中恢复云硬盘"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDiskId": fields.Str(required=True, dump_to="UDiskId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class RecoverUDiskResponseSchema(schema.ResponseSchema):
    """RecoverUDisk - 从回收站中恢复云硬盘"""

    fields = {}


"""
API: RenameUDisk

重命名UDisk
"""


class RenameUDiskRequestSchema(schema.RequestSchema):
    """RenameUDisk - 重命名UDisk"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDiskId": fields.Str(required=True, dump_to="UDiskId"),
        "UDiskName": fields.Str(required=True, dump_to="UDiskName"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class RenameUDiskResponseSchema(schema.ResponseSchema):
    """RenameUDisk - 重命名UDisk"""

    fields = {}


"""
API: ResizeUDisk

调整UDisk容量
"""


class ResizeUDiskRequestSchema(schema.RequestSchema):
    """ResizeUDisk - 调整UDisk容量"""

    fields = {
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "MachineType": fields.Str(required=False, dump_to="MachineType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "UDiskId": fields.Str(required=True, dump_to="UDiskId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ResizeUDiskResponseSchema(schema.ResponseSchema):
    """ResizeUDisk - 调整UDisk容量"""

    fields = {}


"""
API: RestoreUDisk

从备份恢复数据至UDisk
"""


class RestoreUDiskRequestSchema(schema.RequestSchema):
    """RestoreUDisk - 从备份恢复数据至UDisk"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SnapshotId": fields.Str(required=False, dump_to="SnapshotId"),
        "SnapshotTime": fields.Int(required=False, dump_to="SnapshotTime"),
        "UDiskId": fields.Str(required=True, dump_to="UDiskId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class RestoreUDiskResponseSchema(schema.ResponseSchema):
    """RestoreUDisk - 从备份恢复数据至UDisk"""

    fields = {}


"""
API: SetUDiskUDataArkMode

设置UDisk数据方舟的状态
"""


class SetUDiskUDataArkModeRequestSchema(schema.RequestSchema):
    """SetUDiskUDataArkMode - 设置UDisk数据方舟的状态"""

    fields = {
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDataArkMode": fields.Str(required=False, dump_to="UDataArkMode"),
        "UDiskId": fields.Str(required=True, dump_to="UDiskId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class SetUDiskUDataArkModeResponseSchema(schema.ResponseSchema):
    """SetUDiskUDataArkMode - 设置UDisk数据方舟的状态"""

    fields = {}
