/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.report;

import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonschema.core.report.AbstractProcessingReport;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.util.AsJson;
import io.ray.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.ray.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import io.ray.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import io.ray.shaded.com.google.common.collect.Iterators;
import io.ray.shaded.com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;

public final class ListProcessingReport
extends AbstractProcessingReport
implements AsJson {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private final List<ProcessingMessage> messages = Lists.newArrayList();

    public ListProcessingReport(LogLevel logLevel, LogLevel exceptionThreshold) {
        super(logLevel, exceptionThreshold);
    }

    public ListProcessingReport(LogLevel logLevel) {
        super(logLevel);
    }

    public ListProcessingReport() {
    }

    public ListProcessingReport(ProcessingReport other) {
        this(other.getLogLevel(), other.getExceptionThreshold());
    }

    @Override
    public void log(LogLevel level, ProcessingMessage message) {
        this.messages.add(message);
    }

    @Override
    public JsonNode asJson() {
        ArrayNode ret = FACTORY.arrayNode();
        for (ProcessingMessage message : this.messages) {
            ret.add(message.asJson());
        }
        return ret;
    }

    @Override
    public Iterator<ProcessingMessage> iterator() {
        return Iterators.unmodifiableIterator(this.messages.iterator());
    }
}

