from dataclasses import dataclass


@dataclass
class colours_data:
    rgb: tuple
    hex: str

class Colours:
    def __init__(self):
        self.black = colours_data(hex='#000000', rgb=(0, 0, 0))
        self.white = colours_data(hex='#FFFFFF', rgb=(255, 255, 255))
        self.red = colours_data(hex='#FF0000', rgb=(255, 0, 0))
        self.lime = colours_data(hex='#00FF00', rgb=(0, 255, 0))
        self.blue = colours_data(hex= '#0000FF', rgb=(0, 0, 255))
        self.yellow	= colours_data(hex='#FFFF00', rgb=(255,255,0))
        self.cyan    = colours_data(hex='#00FFFF', rgb=(0,255,255))
        self.magenta = colours_data(hex='#FF00FF', rgb=(255,0,255))
        self.silver	= colours_data(hex='#C0C0C0', rgb=(192,192,192))
        self.gray	= colours_data(hex='#808080', rgb=(128,128,128))
        self.maroon	= colours_data(hex='#800000', rgb=(128,0,0))
        self.olive	= colours_data(hex='#808000', rgb=(128,128,0))
        self.green	= colours_data(hex='#008000', rgb=(0,128,0))
        self.purple	= colours_data(hex='#800080', rgb=(128,0,128))
        self.teal	= colours_data(hex='#008080', rgb=(0,128,128))
        self.navy	= colours_data(hex='#000080', rgb=(0,0,128))
        self.dark_red	    = colours_data(hex='#8B0000', rgb= (139,0,0))
        self.brown	        = colours_data(hex='#A52A2A', rgb= (165,42,42))
        self.firebrick	    = colours_data(hex='#B22222', rgb= (178,34,34))
        self.crimson	        = colours_data(hex='#DC143C', rgb= (220,20,60))
        self.tomato	        = colours_data(hex='#FF6347', rgb= (255,99,71))
        self.coral	        = colours_data(hex='#FF7F50', rgb= (255,127,80))
        self.indian_red	    = colours_data(hex='#CD5C5C', rgb= (205,92,92))
        self.light_coral	    = colours_data(hex='#F08080', rgb= (240,128,128))
        self.dark_salmon	    = colours_data(hex='#E9967A', rgb= (233,150,122))
        self.salmon	        = colours_data(hex='#FA8072', rgb= (250,128,114))
        self.light_salmon	= colours_data(hex='#FFA07A', rgb= (255,160,122))
        self.orange_red	    = colours_data(hex='#FF4500', rgb= (255,69,0))
        self.dark_orange	    = colours_data(hex='#FF8C00', rgb= (255,140,0))
        self.orange	        = colours_data(hex='#FFA500', rgb= (255,165,0))
        self.gold	        = colours_data(hex='#FFD700', rgb= (255,215,0))
        self.dark_golden 	= colours_data(hex='#B8860B', rgb= (184,134,11))
        self.golden      	= colours_data(hex='#DAA520', rgb= (218,165,32))
        self.pale_golden_rod	= colours_data(hex='#EEE8AA', rgb= (238,232,170))
        self.dark_khaki	    = colours_data(hex='#BDB76B', rgb= (189,183,107))
        self.khaki	        = colours_data(hex='#F0E68C', rgb= (240,230,140))
        self.yellow_green	= colours_data(hex='#9ACD32', rgb= (154,205,50))
        self.olive_drab	    = colours_data(hex='#6B8E23', rgb= (107,142,35))
        self.lawn_green	    = colours_data(hex='#7CFC00', rgb= (124,252,0))
        self.chart_reuse	    = colours_data(hex='#7FFF00', rgb= (127,255,0))
        self.green_yellow	= colours_data(hex='#ADFF2F', rgb= (173,255,47))
        self.dark_green	    = colours_data(hex='#006400', rgb= (0,100,0))
        self.forest_green	= colours_data(hex='#228B22', rgb= (34,139,34))
        self.lime_green	    = colours_data(hex='#32CD32', rgb= (50,205,50))
        self.light_green	    = colours_data(hex='#90EE90', rgb= (144,238,144))
        self.pale_green	    = colours_data(hex='#98FB98', rgb= (152,251,152))
        self.dark_sea_green	= colours_data(hex='#8FBC8F', rgb= (143,188,143))
        self.spring_green	= colours_data(hex='#00FF7F', rgb= (0,255,127))
        self.sea_green	    = colours_data(hex='#2E8B57', rgb= (46,139,87))
        self.light_sea_green	= colours_data(hex='#20B2AA', rgb= (32,178,170))
        self.dark_slate_gray	= colours_data(hex='#2F4F4F', rgb= (47,79,79))
        self.dark_cyan	    = colours_data(hex='#008B8B', rgb= (0,139,139))
        self.aqua	        = colours_data(hex='#00FFFF', rgb= (0,255,255))
        self.light_cyan	    = colours_data(hex='#E0FFFF', rgb= (224,255,255))
        self.dark_turquoise	= colours_data(hex='#00CED1', rgb= (0,206,209))
        self.turquoise	    = colours_data(hex='#40E0D0', rgb= (64,224,208))
        self.dark_olive_green	= colours_data(hex='#556B2F', rgb= (85,107,47))
        self.medium_spring_green	= colours_data(hex='#00FA9A', rgb= (0,250,154))
        self.medium_aqua_marine	= colours_data(hex='#66CDAA', rgb= (102,205,170))
        self.medium_sea_green	= colours_data(hex='#3CB371', rgb= (60,179,113))
        self.medium_turquoise	= colours_data(hex='#48D1CC', rgb= (72,209,204))
        self.pale_turquoise	= colours_data(hex='#AFEEEE', rgb= (175,238,238))
        self.aqua_marine	    = colours_data(hex='#7FFFD4', rgb= (127,255,212))
        self.powder_blue	    = colours_data(hex='#B0E0E6', rgb= (176,224,230))
        self.cadet_blue	    = colours_data(hex='#5F9EA0', rgb= (95,158,160))
        self.steel_blue	    = colours_data(hex='#4682B4', rgb= (70,130,180))
        self.corn_flower_blue = colours_data(hex='#6495ED', rgb= (100,149,237))
        self.deep_sky_blue	= colours_data(hex='#00BFFF', rgb= (0,191,255))
        self.dodger_blue	    = colours_data(hex='#1E90FF', rgb= (30,144,255))
        self.light_blue	    = colours_data(hex='#ADD8E6', rgb= (173,216,230))
        self.sky_blue	    = colours_data(hex='#87CEEB', rgb= (135,206,235))
        self.light_sky_blue	= colours_data(hex='#87CEFA', rgb= (135,206,250))
        self.midnight_blue	= colours_data(hex='#191970', rgb= (25,25,112))
        self.dark_blue	    = colours_data(hex='#00008B', rgb= (0,0,139))
        self.medium_blue	    = colours_data(hex='#0000CD', rgb= (0,0,205))
        self.royal_blue	    = colours_data(hex='#4169E1', rgb= (65,105,225))
        self.blue_violet	    = colours_data(hex='#8A2BE2', rgb= (138,43,226))
        self.indigo	        = colours_data(hex='#4B0082', rgb= (75,0,130))
        self.dark_slate_blue	= colours_data(hex='#483D8B', rgb= (72,61,139))
        self.slate_blue	    = colours_data(hex='#6A5ACD', rgb= (106,90,205))
        self.medium_slate_blue = colours_data(hex='#7B68EE', rgb=	(123,104,238))
        self.medium_purple	= colours_data(hex='#9370DB', rgb= (147,112,219))
        self.dark_magenta	= colours_data(hex='#8B008B', rgb= (139,0,139))
        self.dark_violet	    = colours_data(hex='#9400D3', rgb= (148,0,211))
        self.dark_orchid	    = colours_data(hex='#9932CC', rgb= (153,50,204))
        self.medium_orchid	= colours_data(hex='#BA55D3', rgb= (186,85,211))
        self.thistle	        = colours_data(hex='#D8BFD8', rgb= (216,191,216))
        self.plum	        = colours_data(hex='#DDA0DD', rgb= (221,160,221))
        self.violet	        = colours_data(hex='#EE82EE', rgb= (238,130,238))
        self.orchid	        = colours_data(hex='#DA70D6', rgb= (218,112,214))
        self.medium_violet_red =	colours_data(hex='#C71585', rgb=(199,21,133))
        self.pale_violet_red	= colours_data(hex='#DB7093', rgb=(219,112,147))
        self.deep_pink	    = colours_data(hex='#FF1493', rgb=(255,20,147))
        self.hot_pink	    = colours_data(hex='#FF69B4', rgb=(255,105,180))
        self.light_pink	    = colours_data(hex='#FFB6C1', rgb=(255,182,193))
        self.pink	        = colours_data(hex='#FFC0CB', rgb=(255,192,203))
        self.antique_white	= colours_data(hex='#FAEBD7', rgb=(250,235,215))
        self.beige	        = colours_data(hex='#F5F5DC', rgb=(245,245,220))
        self.bisque	        = colours_data(hex='#FFE4C4', rgb=(255,228,196))
        self.blanched_almond	= colours_data(hex='#FFEBCD', rgb=(255,235,205))
        self.wheat	        = colours_data(hex='#F5DEB3', rgb=(245,222,179))
        self.corn_silk	    = colours_data(hex='#FFF8DC', rgb=(255,248,220))
        self.lemon_chiffon	= colours_data(hex='#FFFACD', rgb=(255,250,205))
        self.light_golden_yellow	= colours_data(hex= '#FAFAD2',	rgb= (250,250,210))
        self.light_yellow	= colours_data(hex='#FFFFE0', rgb=(255,255,224))
        self.saddle_brown	= colours_data(hex='#8B4513', rgb=(139,69,19))
        self.sienna	        = colours_data(hex='#A0522D', rgb=(160,82,45))
        self.chocolate	    = colours_data(hex='#D2691E', rgb=(210,105,30))
        self.peru	        = colours_data(hex='#CD853F', rgb=(205,133,63))
        self.sandy_brown	    = colours_data(hex='#F4A460', rgb=(244,164,96))
        self.burly_wood	    = colours_data(hex='#DEB887', rgb=(222,184,135))
        self.tan	            = colours_data(hex='#D2B48C', rgb=(210,180,140))
        self.rosy_brown	    = colours_data(hex='#BC8F8F', rgb=(188,143,143))
        self.moccasin	    = colours_data(hex='#FFE4B5', rgb=(255,228,181))
        self.navajo_white	= colours_data(hex='#FFDEAD', rgb=(255,222,173))
        self.peach_puff	    = colours_data(hex='#FFDAB9', rgb=(255,218,185))
        self.misty_rose	    = colours_data(hex='#FFE4E1', rgb=(255,228,225))
        self.lavender_blush	= colours_data(hex='#FFF0F5', rgb=(255,240,245))
        self.linen	        = colours_data(hex='#FAF0E6', rgb=(250,240,230))
        self.old_lace	    = colours_data(hex='#FDF5E6', rgb=(253,245,230))
        self.papaya_whip	    = colours_data(hex='#FFEFD5', rgb=(255,239,213))
        self.sea_shell	    = colours_data(hex='#FFF5EE', rgb=(255,245,238))
        self.mint_cream	    = colours_data(hex='#F5FFFA', rgb=(245,255,250))
        self.slate_gray	    = colours_data(hex='#708090', rgb=(112,128,144))
        self.light_slate_gray= colours_data(hex='#778899', rgb=(119,136,153))
        self.light_steel_blue= colours_data(hex='#B0C4DE', rgb=(176,196,222))
        self.lavender	    = colours_data(hex='#E6E6FA', rgb=(230,230,250))
        self.floral_white	= colours_data(hex='#FFFAF0', rgb=(255,250,240))
        self.alice_blue	    = colours_data(hex='#F0F8FF', rgb=(240,248,255))
        self.ghost_white	    = colours_data(hex='#F8F8FF', rgb=(248,248,255))
        self.honeydew	    = colours_data(hex='#F0FFF0', rgb=(240,255,240))
        self.ivory	        = colours_data(hex='#FFFFF0', rgb=(255,255,240))
        self.azure	        = colours_data(hex='#F0FFFF', rgb=(240,255,255))
        self.snow	        = colours_data(hex='#FFFAFA', rgb=(255,250,250))
        self.dim_gray        = colours_data(hex='#696969', rgb=(105,105,105))
        self.dark_gray       = colours_data(hex='#A9A9A9', rgb=(169,169,169))
        self.light_gray      = colours_data(hex='#D3D3D3', rgb=(211,211,211))
        self.gainsboro	    = colours_data(hex='#DCDCDC', rgb=(220,220,220))
        self.white_smoke	    = colours_data(hex='#F5F5F5', rgb=(245,245,245))