from retro_data_structures.game_check import Game

from open_prime_rando.dol_patching.all_prime_dol_patches import (
    DangerousEnergyTankAddresses,
    HealthCapacityAddresses,
    PowerupFunctionsAddresses,
    StringDisplayPatchAddresses,
)
from open_prime_rando.dol_patching.echoes.dol_patches import (
    BeamCostAddresses,
    EchoesDolVersion,
    IsDoorAddr,
    MapDoorTypeAddresses,
    SafeZoneAddresses,
    StartingBeamVisorAddresses,
)

ALL_VERSIONS = [
    EchoesDolVersion(
        game=Game.ECHOES,
        description="Gamecube NTSC",
        build_string_address=0x803AC3B0,
        build_string=b"!#$MetroidBuildInfo!#$Build v1.028 10/18/2004 10:44:32",
        sda2_base=0x804223C0,
        sda13_base=0x8041FD80,
        game_state_pointer=0x80418EB8,
        cplayer_vtable=0x803B15D0,
        cstate_manager_global=0x803DB6E0,
        string_display=StringDisplayPatchAddresses(
            update_hint_state=0x80038020,
            message_receiver_string_ref=0x803BD118,
            wstring_constructor=0x802FF3DC,
            display_hud_memo=0x8006B3C8,
            max_message_size=200,
        ),
        powerup_functions=PowerupFunctionsAddresses(
            add_power_up=0x800858F0,
            incr_pickup=0x80085760,
            decr_pickup=0x800856C4,
        ),
        health_capacity=HealthCapacityAddresses(
            base_health_capacity=0x8041ABE4,
            energy_tank_capacity=0x8041ABE0,
        ),
        dangerous_energy_tank=DangerousEnergyTankAddresses(
            small_number_float=0x8041A4A8,
            incr_pickup=0x80085760,
        ),
        beam_cost_addresses=BeamCostAddresses(
            uncharged_cost=0x803AA8C8,
            charged_cost=0x803AA8D8,
            charge_combo_ammo_cost=0x803AA8E8,
            charge_combo_missile_cost=0x803A74AC,
            get_beam_ammo_type_and_costs=0x801CCCB0,
            is_out_of_ammo_to_shoot=0x801C92E8,
            gun_get_player=0x801DD758,
            get_item_amount=0x80085514,
        ),
        game_options_constructor_address=0x80161B48,
        safe_zone=SafeZoneAddresses(
            heal_per_frame_constant=0x8041A4FC,
            increment_health_fmr=0x8000C710,
        ),
        starting_beam_visor=StartingBeamVisorAddresses(
            player_state_constructor_clean=0x80086008,
            player_state_constructor_decode=0x80085C20,
            health_info_constructor=0x801420C8,
            enter_morph_ball_state=0x80184118,
            start_transition_to_visor=0x80085314,
            reset_visor=0x80085334,
        ),
        anything_set_address=0x8010F084,
        rs_debugger_printf_loop_address=0x8028C604,
        unvisited_room_names_address=0x8008B714,
        cworldtransmanager_sfxstart=0x80158E50,
        powerup_should_persist=0x803A743C,
        map_door_types=MapDoorTypeAddresses(
            get_correct_transform=IsDoorAddr(0x800BB4D8, 0x800BB4E0, 3),
            map_obj_draw=IsDoorAddr(0x800BB960, 0x800BB96C, 7),
            is_visible_to_automapper=IsDoorAddr(0x800BB600, 0x800BB608, 3),
            map_world_draw_areas=IsDoorAddr(0x8009458C, 0x80094594, 0),
            map_area_commit_resources1=IsDoorAddr(0x8007F3B4, 0x8007F3BC, 3),
            map_area_commit_resources2=IsDoorAddr(0x8007FAB0, 0x8007FAB8, 3),
            get_door_color=0x802175B4,
            map_icon_jumptable=0x803B3638,
        ),
        double_damage_vfx=0x80017F28,
    ),
    EchoesDolVersion(
        game=Game.ECHOES,
        description="Gamecube PAL",
        build_string_address=0x803AD710,
        build_string=b"!#$MetroidBuildInfo!#$Build v1.035 10/27/2004 19:48:17",
        sda2_base=0x804236C0,
        sda13_base=0x80421060,
        game_state_pointer=0x8041A19C,
        cplayer_vtable=0x803B2950,
        cstate_manager_global=0x803DC900,
        string_display=StringDisplayPatchAddresses(
            update_hint_state=0x80038194,
            message_receiver_string_ref=0x803BE378,
            wstring_constructor=0x802FF734,
            display_hud_memo=0x8006B504,
            max_message_size=200,
        ),
        powerup_functions=PowerupFunctionsAddresses(
            add_power_up=0x80085A2C,
            incr_pickup=0x8008589C,
            decr_pickup=0x80085800,
        ),
        health_capacity=HealthCapacityAddresses(
            base_health_capacity=0x8041BEDC,
            energy_tank_capacity=0x8041BED8,
        ),
        dangerous_energy_tank=DangerousEnergyTankAddresses(
            small_number_float=0x8041B7A0,
            incr_pickup=0x8008589C,
        ),
        beam_cost_addresses=BeamCostAddresses(
            uncharged_cost=0x803ABC28,
            charged_cost=0x803ABC38,
            charge_combo_ammo_cost=0x803ABC48,
            charge_combo_missile_cost=0x803A7C04,
            get_beam_ammo_type_and_costs=0x801CCFE4,
            is_out_of_ammo_to_shoot=0x801C961C,
            gun_get_player=0x801DDA8C,
            get_item_amount=0x80085650,
        ),
        game_options_constructor_address=0x80161D9C,
        safe_zone=SafeZoneAddresses(
            heal_per_frame_constant=0x8041B7F4,
            increment_health_fmr=0x8000C754,
        ),
        starting_beam_visor=StartingBeamVisorAddresses(
            player_state_constructor_clean=0x80086144,
            player_state_constructor_decode=0x80085D5C,
            health_info_constructor=0x80142304,
            enter_morph_ball_state=0x801843F8,
            start_transition_to_visor=0x80085450,
            reset_visor=0x80085470,
        ),
        anything_set_address=0x8010F238,
        rs_debugger_printf_loop_address=0x8028CA0C,
        unvisited_room_names_address=0x8008B850,
        cworldtransmanager_sfxstart=0x801590A4,
        powerup_should_persist=0x803A7B94,
        map_door_types=MapDoorTypeAddresses(
            get_correct_transform=IsDoorAddr(0x800BB56C, 0x800BB574, 3),
            map_obj_draw=IsDoorAddr(0x800BB9F0, 0x800BB9FC, 3),
            is_visible_to_automapper=IsDoorAddr(0x800BB694, 0x800BB69C, 3),
            map_world_draw_areas=IsDoorAddr(0x80094620, 0x80094628, 0),
            map_area_commit_resources1=IsDoorAddr(0x8007F4F0, 0x8007F4F8, 3),
            map_area_commit_resources2=IsDoorAddr(0x8007FBEC, 0x8007FBF4, 3),
            get_door_color=0x802178D4,
            map_icon_jumptable=0x803B4A80,
        ),
        double_damage_vfx=0x80017FC4,
    ),
]
