import typing
import collections.abc
import typing_extensions
import mathutils

def stl(
    execution_context: int | str | None = None,
    undo: bool | None = None,
    /,
    *,
    filepath: str = "",
    check_existing: bool | None = True,
    filter_glob: str = "*.stl",
    use_selection: bool | None = False,
    global_scale: float | None = 1.0,
    use_scene_unit: bool | None = False,
    ascii: bool | None = False,
    use_mesh_modifiers: bool | None = True,
    batch_mode: typing.Literal["OFF", "OBJECT"] | None = "OFF",
    global_space: collections.abc.Sequence[collections.abc.Sequence[float]]
    | mathutils.Matrix
    | None = (
        (0.0, 0.0, 0.0, 0.0),
        (0.0, 0.0, 0.0, 0.0),
        (0.0, 0.0, 0.0, 0.0),
        (0.0, 0.0, 0.0, 0.0),
    ),
    axis_forward: typing.Literal["X", "Y", "Z", "-X", "-Y", "-Z"] | None = "Y",
    axis_up: typing.Literal["X", "Y", "Z", "-X", "-Y", "-Z"] | None = "Z",
):
    """Save STL triangle mesh data

        :type execution_context: int | str | None
        :type undo: bool | None
        :param filepath: File Path, Filepath used for exporting the file
        :type filepath: str
        :param check_existing: Check Existing, Check and warn on overwriting existing files
        :type check_existing: bool | None
        :param filter_glob: filter_glob
        :type filter_glob: str
        :param use_selection: Selection Only, Export selected objects only
        :type use_selection: bool | None
        :param global_scale: Scale
        :type global_scale: float | None
        :param use_scene_unit: Scene Unit, Apply current scene's unit (as defined by unit scale) to exported data
        :type use_scene_unit: bool | None
        :param ascii: Ascii, Save the file in ASCII file format
        :type ascii: bool | None
        :param use_mesh_modifiers: Apply Modifiers, Apply the modifiers before saving
        :type use_mesh_modifiers: bool | None
        :param batch_mode: Batch Mode

    OFF
    Off -- All data in one file.

    OBJECT
    Object -- Each object as a file.
        :type batch_mode: typing.Literal['OFF','OBJECT'] | None
        :param global_space: Global Space, Export in this reference space
        :type global_space: collections.abc.Sequence[collections.abc.Sequence[float]] | mathutils.Matrix | None
        :param axis_forward: Forward
        :type axis_forward: typing.Literal['X','Y','Z','-X','-Y','-Z'] | None
        :param axis_up: Up
        :type axis_up: typing.Literal['X','Y','Z','-X','-Y','-Z'] | None
    """
