# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DetectAnomalyJobArgs', 'DetectAnomalyJob']

@pulumi.input_type
class DetectAnomalyJobArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 input_details: pulumi.Input['DetectAnomalyJobInputDetailsArgs'],
                 model_id: pulumi.Input[builtins.str],
                 output_details: pulumi.Input['DetectAnomalyJobOutputDetailsArgs'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 sensitivity: Optional[pulumi.Input[builtins.float]] = None):
        """
        The set of arguments for constructing a DetectAnomalyJob resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that starts the job.
        :param pulumi.Input['DetectAnomalyJobInputDetailsArgs'] input_details: Detect anomaly asynchronous job details.
        :param pulumi.Input[builtins.str] model_id: The OCID of the trained model.
        :param pulumi.Input['DetectAnomalyJobOutputDetailsArgs'] output_details: Detect anomaly job output details.
        :param pulumi.Input[builtins.str] description: (Updatable) A short description of the detect anomaly job.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Detect anomaly job display name.
        :param pulumi.Input[builtins.float] sensitivity: The value that customer can adjust to control the sensitivity of anomaly detection
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "input_details", input_details)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "output_details", output_details)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if sensitivity is not None:
            pulumi.set(__self__, "sensitivity", sensitivity)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment that starts the job.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="inputDetails")
    def input_details(self) -> pulumi.Input['DetectAnomalyJobInputDetailsArgs']:
        """
        Detect anomaly asynchronous job details.
        """
        return pulumi.get(self, "input_details")

    @input_details.setter
    def input_details(self, value: pulumi.Input['DetectAnomalyJobInputDetailsArgs']):
        pulumi.set(self, "input_details", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the trained model.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter(name="outputDetails")
    def output_details(self) -> pulumi.Input['DetectAnomalyJobOutputDetailsArgs']:
        """
        Detect anomaly job output details.
        """
        return pulumi.get(self, "output_details")

    @output_details.setter
    def output_details(self, value: pulumi.Input['DetectAnomalyJobOutputDetailsArgs']):
        pulumi.set(self, "output_details", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A short description of the detect anomaly job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Detect anomaly job display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def sensitivity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The value that customer can adjust to control the sensitivity of anomaly detection


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitivity")

    @sensitivity.setter
    def sensitivity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "sensitivity", value)


@pulumi.input_type
class _DetectAnomalyJobState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 input_details: Optional[pulumi.Input['DetectAnomalyJobInputDetailsArgs']] = None,
                 lifecycle_state_details: Optional[pulumi.Input[builtins.str]] = None,
                 model_id: Optional[pulumi.Input[builtins.str]] = None,
                 output_details: Optional[pulumi.Input['DetectAnomalyJobOutputDetailsArgs']] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 sensitivity: Optional[pulumi.Input[builtins.float]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_accepted: Optional[pulumi.Input[builtins.str]] = None,
                 time_finished: Optional[pulumi.Input[builtins.str]] = None,
                 time_started: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DetectAnomalyJob resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that starts the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A short description of the detect anomaly job.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Detect anomaly job display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['DetectAnomalyJobInputDetailsArgs'] input_details: Detect anomaly asynchronous job details.
        :param pulumi.Input[builtins.str] lifecycle_state_details: The current state details of the batch document job.
        :param pulumi.Input[builtins.str] model_id: The OCID of the trained model.
        :param pulumi.Input['DetectAnomalyJobOutputDetailsArgs'] output_details: Detect anomaly job output details.
        :param pulumi.Input[builtins.str] project_id: The OCID of the project.
        :param pulumi.Input[builtins.float] sensitivity: The value that customer can adjust to control the sensitivity of anomaly detection
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the batch document job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_accepted: Job accepted time
        :param pulumi.Input[builtins.str] time_finished: Job finished time
        :param pulumi.Input[builtins.str] time_started: Job started time
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if input_details is not None:
            pulumi.set(__self__, "input_details", input_details)
        if lifecycle_state_details is not None:
            pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if output_details is not None:
            pulumi.set(__self__, "output_details", output_details)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if sensitivity is not None:
            pulumi.set(__self__, "sensitivity", sensitivity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_accepted is not None:
            pulumi.set(__self__, "time_accepted", time_accepted)
        if time_finished is not None:
            pulumi.set(__self__, "time_finished", time_finished)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment that starts the job.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A short description of the detect anomaly job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Detect anomaly job display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="inputDetails")
    def input_details(self) -> Optional[pulumi.Input['DetectAnomalyJobInputDetailsArgs']]:
        """
        Detect anomaly asynchronous job details.
        """
        return pulumi.get(self, "input_details")

    @input_details.setter
    def input_details(self, value: Optional[pulumi.Input['DetectAnomalyJobInputDetailsArgs']]):
        pulumi.set(self, "input_details", value)

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state details of the batch document job.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_state_details", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the trained model.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter(name="outputDetails")
    def output_details(self) -> Optional[pulumi.Input['DetectAnomalyJobOutputDetailsArgs']]:
        """
        Detect anomaly job output details.
        """
        return pulumi.get(self, "output_details")

    @output_details.setter
    def output_details(self, value: Optional[pulumi.Input['DetectAnomalyJobOutputDetailsArgs']]):
        pulumi.set(self, "output_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def sensitivity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The value that customer can adjust to control the sensitivity of anomaly detection


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitivity")

    @sensitivity.setter
    def sensitivity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "sensitivity", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the batch document job.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Job accepted time
        """
        return pulumi.get(self, "time_accepted")

    @time_accepted.setter
    def time_accepted(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_accepted", value)

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Job finished time
        """
        return pulumi.get(self, "time_finished")

    @time_finished.setter
    def time_finished(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_finished", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Job started time
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_started", value)


class DetectAnomalyJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 input_details: Optional[pulumi.Input[Union['DetectAnomalyJobInputDetailsArgs', 'DetectAnomalyJobInputDetailsArgsDict']]] = None,
                 model_id: Optional[pulumi.Input[builtins.str]] = None,
                 output_details: Optional[pulumi.Input[Union['DetectAnomalyJobOutputDetailsArgs', 'DetectAnomalyJobOutputDetailsArgsDict']]] = None,
                 sensitivity: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        """
        This resource provides the Detect Anomaly Job resource in Oracle Cloud Infrastructure Ai Anomaly Detection service.

        Creates a job to perform anomaly detection.

        ## Import

        DetectAnomalyJobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiAnomalyDetection/detectAnomalyJob:DetectAnomalyJob test_detect_anomaly_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that starts the job.
        :param pulumi.Input[builtins.str] description: (Updatable) A short description of the detect anomaly job.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Detect anomaly job display name.
        :param pulumi.Input[Union['DetectAnomalyJobInputDetailsArgs', 'DetectAnomalyJobInputDetailsArgsDict']] input_details: Detect anomaly asynchronous job details.
        :param pulumi.Input[builtins.str] model_id: The OCID of the trained model.
        :param pulumi.Input[Union['DetectAnomalyJobOutputDetailsArgs', 'DetectAnomalyJobOutputDetailsArgsDict']] output_details: Detect anomaly job output details.
        :param pulumi.Input[builtins.float] sensitivity: The value that customer can adjust to control the sensitivity of anomaly detection
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DetectAnomalyJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Detect Anomaly Job resource in Oracle Cloud Infrastructure Ai Anomaly Detection service.

        Creates a job to perform anomaly detection.

        ## Import

        DetectAnomalyJobs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiAnomalyDetection/detectAnomalyJob:DetectAnomalyJob test_detect_anomaly_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param DetectAnomalyJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DetectAnomalyJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 input_details: Optional[pulumi.Input[Union['DetectAnomalyJobInputDetailsArgs', 'DetectAnomalyJobInputDetailsArgsDict']]] = None,
                 model_id: Optional[pulumi.Input[builtins.str]] = None,
                 output_details: Optional[pulumi.Input[Union['DetectAnomalyJobOutputDetailsArgs', 'DetectAnomalyJobOutputDetailsArgsDict']]] = None,
                 sensitivity: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DetectAnomalyJobArgs.__new__(DetectAnomalyJobArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if input_details is None and not opts.urn:
                raise TypeError("Missing required property 'input_details'")
            __props__.__dict__["input_details"] = input_details
            if model_id is None and not opts.urn:
                raise TypeError("Missing required property 'model_id'")
            __props__.__dict__["model_id"] = model_id
            if output_details is None and not opts.urn:
                raise TypeError("Missing required property 'output_details'")
            __props__.__dict__["output_details"] = output_details
            __props__.__dict__["sensitivity"] = sensitivity
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["lifecycle_state_details"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_accepted"] = None
            __props__.__dict__["time_finished"] = None
            __props__.__dict__["time_started"] = None
        super(DetectAnomalyJob, __self__).__init__(
            'oci:AiAnomalyDetection/detectAnomalyJob:DetectAnomalyJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            input_details: Optional[pulumi.Input[Union['DetectAnomalyJobInputDetailsArgs', 'DetectAnomalyJobInputDetailsArgsDict']]] = None,
            lifecycle_state_details: Optional[pulumi.Input[builtins.str]] = None,
            model_id: Optional[pulumi.Input[builtins.str]] = None,
            output_details: Optional[pulumi.Input[Union['DetectAnomalyJobOutputDetailsArgs', 'DetectAnomalyJobOutputDetailsArgsDict']]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            sensitivity: Optional[pulumi.Input[builtins.float]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_accepted: Optional[pulumi.Input[builtins.str]] = None,
            time_finished: Optional[pulumi.Input[builtins.str]] = None,
            time_started: Optional[pulumi.Input[builtins.str]] = None) -> 'DetectAnomalyJob':
        """
        Get an existing DetectAnomalyJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that starts the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A short description of the detect anomaly job.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Detect anomaly job display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Union['DetectAnomalyJobInputDetailsArgs', 'DetectAnomalyJobInputDetailsArgsDict']] input_details: Detect anomaly asynchronous job details.
        :param pulumi.Input[builtins.str] lifecycle_state_details: The current state details of the batch document job.
        :param pulumi.Input[builtins.str] model_id: The OCID of the trained model.
        :param pulumi.Input[Union['DetectAnomalyJobOutputDetailsArgs', 'DetectAnomalyJobOutputDetailsArgsDict']] output_details: Detect anomaly job output details.
        :param pulumi.Input[builtins.str] project_id: The OCID of the project.
        :param pulumi.Input[builtins.float] sensitivity: The value that customer can adjust to control the sensitivity of anomaly detection
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the batch document job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_accepted: Job accepted time
        :param pulumi.Input[builtins.str] time_finished: Job finished time
        :param pulumi.Input[builtins.str] time_started: Job started time
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DetectAnomalyJobState.__new__(_DetectAnomalyJobState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["input_details"] = input_details
        __props__.__dict__["lifecycle_state_details"] = lifecycle_state_details
        __props__.__dict__["model_id"] = model_id
        __props__.__dict__["output_details"] = output_details
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["sensitivity"] = sensitivity
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_accepted"] = time_accepted
        __props__.__dict__["time_finished"] = time_finished
        __props__.__dict__["time_started"] = time_started
        return DetectAnomalyJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment that starts the job.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A short description of the detect anomaly job.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Detect anomaly job display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="inputDetails")
    def input_details(self) -> pulumi.Output['outputs.DetectAnomalyJobInputDetails']:
        """
        Detect anomaly asynchronous job details.
        """
        return pulumi.get(self, "input_details")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> pulumi.Output[builtins.str]:
        """
        The current state details of the batch document job.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the trained model.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="outputDetails")
    def output_details(self) -> pulumi.Output['outputs.DetectAnomalyJobOutputDetails']:
        """
        Detect anomaly job output details.
        """
        return pulumi.get(self, "output_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def sensitivity(self) -> pulumi.Output[builtins.float]:
        """
        The value that customer can adjust to control the sensitivity of anomaly detection


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitivity")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the batch document job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> pulumi.Output[builtins.str]:
        """
        Job accepted time
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> pulumi.Output[builtins.str]:
        """
        Job finished time
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[builtins.str]:
        """
        Job started time
        """
        return pulumi.get(self, "time_started")

