# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DrgAttachmentManagementArgs', 'DrgAttachmentManagement']

@pulumi.input_type
class DrgAttachmentManagementArgs:
    def __init__(__self__, *,
                 attachment_type: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 drg_id: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 drg_route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 export_drg_route_distribution_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 network_details: Optional[pulumi.Input['DrgAttachmentManagementNetworkDetailsArgs']] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 remove_export_drg_route_distribution_trigger: Optional[pulumi.Input[builtins.bool]] = None,
                 route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DrgAttachmentManagement resource.
        :param pulumi.Input[builtins.str] attachment_type: The type for the network resource attached to the DRG.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] drg_route_table_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG route table assigned to the DRG attachment.
        :param pulumi.Input[builtins.str] export_drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export route distribution used to specify how routes in the assigned DRG route table are advertised to the attachment. If this value is null, no routes are advertised through this attachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['DrgAttachmentManagementNetworkDetailsArgs'] network_details: (Updatable)
        :param pulumi.Input[builtins.str] network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource (virtual circuit, VCN, IPSec tunnel, or remote peering connection) attached to the DRG.
        :param pulumi.Input[builtins.bool] remove_export_drg_route_distribution_trigger: (Updatable) An optional property when set to true during update disables the export of route Distribution by setting export_drg_route_distribution_id to null.
        :param pulumi.Input[builtins.str] route_table_id: The OCID of the route table the DRG attachment is using.
               
               For information about why you would associate a route table with a DRG attachment, see:
               * [Transit Routing: Access to Multiple VCNs in Same Region](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitrouting.htm)
               * [Transit Routing: Private Access to Oracle Services](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitroutingoracleservices.htm) This field is deprecated. Instead, use the `networkDetails` field to view the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached resource.
        :param pulumi.Input[builtins.str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        pulumi.set(__self__, "attachment_type", attachment_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "drg_id", drg_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if drg_route_table_id is not None:
            pulumi.set(__self__, "drg_route_table_id", drg_route_table_id)
        if export_drg_route_distribution_id is not None:
            pulumi.set(__self__, "export_drg_route_distribution_id", export_drg_route_distribution_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if network_details is not None:
            pulumi.set(__self__, "network_details", network_details)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if remove_export_drg_route_distribution_trigger is not None:
            pulumi.set(__self__, "remove_export_drg_route_distribution_trigger", remove_export_drg_route_distribution_trigger)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Input[builtins.str]:
        """
        The type for the network resource attached to the DRG.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attachment_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        """
        return pulumi.get(self, "drg_id")

    @drg_id.setter
    def drg_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "drg_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="drgRouteTableId")
    def drg_route_table_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG route table assigned to the DRG attachment.
        """
        return pulumi.get(self, "drg_route_table_id")

    @drg_route_table_id.setter
    def drg_route_table_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "drg_route_table_id", value)

    @property
    @pulumi.getter(name="exportDrgRouteDistributionId")
    def export_drg_route_distribution_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export route distribution used to specify how routes in the assigned DRG route table are advertised to the attachment. If this value is null, no routes are advertised through this attachment.
        """
        return pulumi.get(self, "export_drg_route_distribution_id")

    @export_drg_route_distribution_id.setter
    def export_drg_route_distribution_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "export_drg_route_distribution_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="networkDetails")
    def network_details(self) -> Optional[pulumi.Input['DrgAttachmentManagementNetworkDetailsArgs']]:
        """
        (Updatable)
        """
        return pulumi.get(self, "network_details")

    @network_details.setter
    def network_details(self, value: Optional[pulumi.Input['DrgAttachmentManagementNetworkDetailsArgs']]):
        pulumi.set(self, "network_details", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource (virtual circuit, VCN, IPSec tunnel, or remote peering connection) attached to the DRG.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="removeExportDrgRouteDistributionTrigger")
    def remove_export_drg_route_distribution_trigger(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) An optional property when set to true during update disables the export of route Distribution by setting export_drg_route_distribution_id to null.
        """
        return pulumi.get(self, "remove_export_drg_route_distribution_trigger")

    @remove_export_drg_route_distribution_trigger.setter
    def remove_export_drg_route_distribution_trigger(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "remove_export_drg_route_distribution_trigger", value)

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the route table the DRG attachment is using.

        For information about why you would associate a route table with a DRG attachment, see:
        * [Transit Routing: Access to Multiple VCNs in Same Region](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitrouting.htm)
        * [Transit Routing: Private Access to Oracle Services](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitroutingoracleservices.htm) This field is deprecated. Instead, use the `networkDetails` field to view the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached resource.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vcn_id", value)


@pulumi.input_type
class _DrgAttachmentManagementState:
    def __init__(__self__, *,
                 attachment_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 drg_id: Optional[pulumi.Input[builtins.str]] = None,
                 drg_route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 export_drg_route_distribution_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_cross_tenancy: Optional[pulumi.Input[builtins.bool]] = None,
                 network_details: Optional[pulumi.Input['DrgAttachmentManagementNetworkDetailsArgs']] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 remove_export_drg_route_distribution_trigger: Optional[pulumi.Input[builtins.bool]] = None,
                 route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DrgAttachmentManagement resources.
        :param pulumi.Input[builtins.str] attachment_type: The type for the network resource attached to the DRG.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        :param pulumi.Input[builtins.str] drg_route_table_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG route table assigned to the DRG attachment.
        :param pulumi.Input[builtins.str] export_drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export route distribution used to specify how routes in the assigned DRG route table are advertised to the attachment. If this value is null, no routes are advertised through this attachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_cross_tenancy: Indicates whether the DRG attachment and attached network live in a different tenancy than the DRG.  Example: `false`
        :param pulumi.Input['DrgAttachmentManagementNetworkDetailsArgs'] network_details: (Updatable)
        :param pulumi.Input[builtins.str] network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource (virtual circuit, VCN, IPSec tunnel, or remote peering connection) attached to the DRG.
        :param pulumi.Input[builtins.bool] remove_export_drg_route_distribution_trigger: (Updatable) An optional property when set to true during update disables the export of route Distribution by setting export_drg_route_distribution_id to null.
        :param pulumi.Input[builtins.str] route_table_id: The OCID of the route table the DRG attachment is using.
               
               For information about why you would associate a route table with a DRG attachment, see:
               * [Transit Routing: Access to Multiple VCNs in Same Region](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitrouting.htm)
               * [Transit Routing: Private Access to Oracle Services](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitroutingoracleservices.htm) This field is deprecated. Instead, use the `networkDetails` field to view the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached resource.
        :param pulumi.Input[builtins.str] state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        :param pulumi.Input[builtins.str] time_created: The date and time the DRG attachment was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        if attachment_type is not None:
            pulumi.set(__self__, "attachment_type", attachment_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if drg_id is not None:
            pulumi.set(__self__, "drg_id", drg_id)
        if drg_route_table_id is not None:
            pulumi.set(__self__, "drg_route_table_id", drg_route_table_id)
        if export_drg_route_distribution_id is not None:
            pulumi.set(__self__, "export_drg_route_distribution_id", export_drg_route_distribution_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_cross_tenancy is not None:
            pulumi.set(__self__, "is_cross_tenancy", is_cross_tenancy)
        if network_details is not None:
            pulumi.set(__self__, "network_details", network_details)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if remove_export_drg_route_distribution_trigger is not None:
            pulumi.set(__self__, "remove_export_drg_route_distribution_trigger", remove_export_drg_route_distribution_trigger)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type for the network resource attached to the DRG.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attachment_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        """
        return pulumi.get(self, "drg_id")

    @drg_id.setter
    def drg_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "drg_id", value)

    @property
    @pulumi.getter(name="drgRouteTableId")
    def drg_route_table_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG route table assigned to the DRG attachment.
        """
        return pulumi.get(self, "drg_route_table_id")

    @drg_route_table_id.setter
    def drg_route_table_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "drg_route_table_id", value)

    @property
    @pulumi.getter(name="exportDrgRouteDistributionId")
    def export_drg_route_distribution_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export route distribution used to specify how routes in the assigned DRG route table are advertised to the attachment. If this value is null, no routes are advertised through this attachment.
        """
        return pulumi.get(self, "export_drg_route_distribution_id")

    @export_drg_route_distribution_id.setter
    def export_drg_route_distribution_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "export_drg_route_distribution_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isCrossTenancy")
    def is_cross_tenancy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the DRG attachment and attached network live in a different tenancy than the DRG.  Example: `false`
        """
        return pulumi.get(self, "is_cross_tenancy")

    @is_cross_tenancy.setter
    def is_cross_tenancy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_cross_tenancy", value)

    @property
    @pulumi.getter(name="networkDetails")
    def network_details(self) -> Optional[pulumi.Input['DrgAttachmentManagementNetworkDetailsArgs']]:
        """
        (Updatable)
        """
        return pulumi.get(self, "network_details")

    @network_details.setter
    def network_details(self, value: Optional[pulumi.Input['DrgAttachmentManagementNetworkDetailsArgs']]):
        pulumi.set(self, "network_details", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource (virtual circuit, VCN, IPSec tunnel, or remote peering connection) attached to the DRG.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="removeExportDrgRouteDistributionTrigger")
    def remove_export_drg_route_distribution_trigger(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) An optional property when set to true during update disables the export of route Distribution by setting export_drg_route_distribution_id to null.
        """
        return pulumi.get(self, "remove_export_drg_route_distribution_trigger")

    @remove_export_drg_route_distribution_trigger.setter
    def remove_export_drg_route_distribution_trigger(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "remove_export_drg_route_distribution_trigger", value)

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the route table the DRG attachment is using.

        For information about why you would associate a route table with a DRG attachment, see:
        * [Transit Routing: Access to Multiple VCNs in Same Region](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitrouting.htm)
        * [Transit Routing: Private Access to Oracle Services](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitroutingoracleservices.htm) This field is deprecated. Instead, use the `networkDetails` field to view the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached resource.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the DRG attachment was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vcn_id", value)


class DrgAttachmentManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 drg_id: Optional[pulumi.Input[builtins.str]] = None,
                 drg_route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 export_drg_route_distribution_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 network_details: Optional[pulumi.Input[Union['DrgAttachmentManagementNetworkDetailsArgs', 'DrgAttachmentManagementNetworkDetailsArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 remove_export_drg_route_distribution_trigger: Optional[pulumi.Input[builtins.bool]] = None,
                 route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Drg Attachment Management resource in Oracle Cloud Infrastructure Core service.

        This can be used to update the Drg Attachments of the following types -
        "IPSEC_TUNNEL",
        "REMOTE_PEERING_CONNECTION",
        "VIRTUAL_CIRCUIT",

        DRG Attachments for virtual circuits, IPSec tunnels, and remote peering connections are created (and deleted) automatically on your behalf when you create (or delete) the network object. Hence, this management resource is used to update these types of autogenerated DRG Attachments.
        The user cannot create DRG attachments of these types as needed.

        For the purposes of access control, the DRG attachment is automatically placed into the currently selected compartment.
        For more information about compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_drg_rpc_attachment = oci.core.DrgAttachmentManagement("test_drg_rpc_attachment",
            attachment_type="REMOTE_PEERING_CONNECTION",
            compartment_id=compartment_ocid,
            network_id=test_rpc["id"],
            drg_id=test_drg["id"],
            display_name="MyTestDrgAttachmentForRpc",
            drg_route_table_id=test_drg_route_table["id"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] attachment_type: The type for the network resource attached to the DRG.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        :param pulumi.Input[builtins.str] drg_route_table_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG route table assigned to the DRG attachment.
        :param pulumi.Input[builtins.str] export_drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export route distribution used to specify how routes in the assigned DRG route table are advertised to the attachment. If this value is null, no routes are advertised through this attachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['DrgAttachmentManagementNetworkDetailsArgs', 'DrgAttachmentManagementNetworkDetailsArgsDict']] network_details: (Updatable)
        :param pulumi.Input[builtins.str] network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource (virtual circuit, VCN, IPSec tunnel, or remote peering connection) attached to the DRG.
        :param pulumi.Input[builtins.bool] remove_export_drg_route_distribution_trigger: (Updatable) An optional property when set to true during update disables the export of route Distribution by setting export_drg_route_distribution_id to null.
        :param pulumi.Input[builtins.str] route_table_id: The OCID of the route table the DRG attachment is using.
               
               For information about why you would associate a route table with a DRG attachment, see:
               * [Transit Routing: Access to Multiple VCNs in Same Region](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitrouting.htm)
               * [Transit Routing: Private Access to Oracle Services](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitroutingoracleservices.htm) This field is deprecated. Instead, use the `networkDetails` field to view the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached resource.
        :param pulumi.Input[builtins.str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DrgAttachmentManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Drg Attachment Management resource in Oracle Cloud Infrastructure Core service.

        This can be used to update the Drg Attachments of the following types -
        "IPSEC_TUNNEL",
        "REMOTE_PEERING_CONNECTION",
        "VIRTUAL_CIRCUIT",

        DRG Attachments for virtual circuits, IPSec tunnels, and remote peering connections are created (and deleted) automatically on your behalf when you create (or delete) the network object. Hence, this management resource is used to update these types of autogenerated DRG Attachments.
        The user cannot create DRG attachments of these types as needed.

        For the purposes of access control, the DRG attachment is automatically placed into the currently selected compartment.
        For more information about compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_drg_rpc_attachment = oci.core.DrgAttachmentManagement("test_drg_rpc_attachment",
            attachment_type="REMOTE_PEERING_CONNECTION",
            compartment_id=compartment_ocid,
            network_id=test_rpc["id"],
            drg_id=test_drg["id"],
            display_name="MyTestDrgAttachmentForRpc",
            drg_route_table_id=test_drg_route_table["id"])
        ```

        :param str resource_name: The name of the resource.
        :param DrgAttachmentManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DrgAttachmentManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 drg_id: Optional[pulumi.Input[builtins.str]] = None,
                 drg_route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 export_drg_route_distribution_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 network_details: Optional[pulumi.Input[Union['DrgAttachmentManagementNetworkDetailsArgs', 'DrgAttachmentManagementNetworkDetailsArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 remove_export_drg_route_distribution_trigger: Optional[pulumi.Input[builtins.bool]] = None,
                 route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DrgAttachmentManagementArgs.__new__(DrgAttachmentManagementArgs)

            if attachment_type is None and not opts.urn:
                raise TypeError("Missing required property 'attachment_type'")
            __props__.__dict__["attachment_type"] = attachment_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if drg_id is None and not opts.urn:
                raise TypeError("Missing required property 'drg_id'")
            __props__.__dict__["drg_id"] = drg_id
            __props__.__dict__["drg_route_table_id"] = drg_route_table_id
            __props__.__dict__["export_drg_route_distribution_id"] = export_drg_route_distribution_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["network_details"] = network_details
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["remove_export_drg_route_distribution_trigger"] = remove_export_drg_route_distribution_trigger
            __props__.__dict__["route_table_id"] = route_table_id
            __props__.__dict__["vcn_id"] = vcn_id
            __props__.__dict__["is_cross_tenancy"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(DrgAttachmentManagement, __self__).__init__(
            'oci:Core/drgAttachmentManagement:DrgAttachmentManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachment_type: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            drg_id: Optional[pulumi.Input[builtins.str]] = None,
            drg_route_table_id: Optional[pulumi.Input[builtins.str]] = None,
            export_drg_route_distribution_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_cross_tenancy: Optional[pulumi.Input[builtins.bool]] = None,
            network_details: Optional[pulumi.Input[Union['DrgAttachmentManagementNetworkDetailsArgs', 'DrgAttachmentManagementNetworkDetailsArgsDict']]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            remove_export_drg_route_distribution_trigger: Optional[pulumi.Input[builtins.bool]] = None,
            route_table_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            vcn_id: Optional[pulumi.Input[builtins.str]] = None) -> 'DrgAttachmentManagement':
        """
        Get an existing DrgAttachmentManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] attachment_type: The type for the network resource attached to the DRG.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        :param pulumi.Input[builtins.str] drg_route_table_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG route table assigned to the DRG attachment.
        :param pulumi.Input[builtins.str] export_drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export route distribution used to specify how routes in the assigned DRG route table are advertised to the attachment. If this value is null, no routes are advertised through this attachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_cross_tenancy: Indicates whether the DRG attachment and attached network live in a different tenancy than the DRG.  Example: `false`
        :param pulumi.Input[Union['DrgAttachmentManagementNetworkDetailsArgs', 'DrgAttachmentManagementNetworkDetailsArgsDict']] network_details: (Updatable)
        :param pulumi.Input[builtins.str] network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource (virtual circuit, VCN, IPSec tunnel, or remote peering connection) attached to the DRG.
        :param pulumi.Input[builtins.bool] remove_export_drg_route_distribution_trigger: (Updatable) An optional property when set to true during update disables the export of route Distribution by setting export_drg_route_distribution_id to null.
        :param pulumi.Input[builtins.str] route_table_id: The OCID of the route table the DRG attachment is using.
               
               For information about why you would associate a route table with a DRG attachment, see:
               * [Transit Routing: Access to Multiple VCNs in Same Region](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitrouting.htm)
               * [Transit Routing: Private Access to Oracle Services](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitroutingoracleservices.htm) This field is deprecated. Instead, use the `networkDetails` field to view the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached resource.
        :param pulumi.Input[builtins.str] state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        :param pulumi.Input[builtins.str] time_created: The date and time the DRG attachment was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DrgAttachmentManagementState.__new__(_DrgAttachmentManagementState)

        __props__.__dict__["attachment_type"] = attachment_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["drg_id"] = drg_id
        __props__.__dict__["drg_route_table_id"] = drg_route_table_id
        __props__.__dict__["export_drg_route_distribution_id"] = export_drg_route_distribution_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_cross_tenancy"] = is_cross_tenancy
        __props__.__dict__["network_details"] = network_details
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["remove_export_drg_route_distribution_trigger"] = remove_export_drg_route_distribution_trigger
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["vcn_id"] = vcn_id
        return DrgAttachmentManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Output[builtins.str]:
        """
        The type for the network resource attached to the DRG.
        """
        return pulumi.get(self, "attachment_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        """
        return pulumi.get(self, "drg_id")

    @property
    @pulumi.getter(name="drgRouteTableId")
    def drg_route_table_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG route table assigned to the DRG attachment.
        """
        return pulumi.get(self, "drg_route_table_id")

    @property
    @pulumi.getter(name="exportDrgRouteDistributionId")
    def export_drg_route_distribution_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export route distribution used to specify how routes in the assigned DRG route table are advertised to the attachment. If this value is null, no routes are advertised through this attachment.
        """
        return pulumi.get(self, "export_drg_route_distribution_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isCrossTenancy")
    def is_cross_tenancy(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether the DRG attachment and attached network live in a different tenancy than the DRG.  Example: `false`
        """
        return pulumi.get(self, "is_cross_tenancy")

    @property
    @pulumi.getter(name="networkDetails")
    def network_details(self) -> pulumi.Output['outputs.DrgAttachmentManagementNetworkDetails']:
        """
        (Updatable)
        """
        return pulumi.get(self, "network_details")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource (virtual circuit, VCN, IPSec tunnel, or remote peering connection) attached to the DRG.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="removeExportDrgRouteDistributionTrigger")
    def remove_export_drg_route_distribution_trigger(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        (Updatable) An optional property when set to true during update disables the export of route Distribution by setting export_drg_route_distribution_id to null.
        """
        return pulumi.get(self, "remove_export_drg_route_distribution_trigger")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the route table the DRG attachment is using.

        For information about why you would associate a route table with a DRG attachment, see:
        * [Transit Routing: Access to Multiple VCNs in Same Region](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitrouting.htm)
        * [Transit Routing: Private Access to Oracle Services](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/transitroutingoracleservices.htm) This field is deprecated. Instead, use the `networkDetails` field to view the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached resource.
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the DRG attachment was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        return pulumi.get(self, "vcn_id")

