# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetComputeGpuMemoryFabricResult',
    'AwaitableGetComputeGpuMemoryFabricResult',
    'get_compute_gpu_memory_fabric',
    'get_compute_gpu_memory_fabric_output',
]

@pulumi.output_type
class GetComputeGpuMemoryFabricResult:
    """
    A collection of values returned by getComputeGpuMemoryFabric.
    """
    def __init__(__self__, additional_data=None, compartment_id=None, compute_gpu_memory_fabric_id=None, compute_hpc_island_id=None, compute_local_block_id=None, compute_network_block_id=None, defined_tags=None, display_name=None, fabric_health=None, freeform_tags=None, healthy_host_count=None, id=None, state=None, system_tags=None, time_created=None, total_host_count=None):
        if additional_data and not isinstance(additional_data, dict):
            raise TypeError("Expected argument 'additional_data' to be a dict")
        pulumi.set(__self__, "additional_data", additional_data)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_gpu_memory_fabric_id and not isinstance(compute_gpu_memory_fabric_id, str):
            raise TypeError("Expected argument 'compute_gpu_memory_fabric_id' to be a str")
        pulumi.set(__self__, "compute_gpu_memory_fabric_id", compute_gpu_memory_fabric_id)
        if compute_hpc_island_id and not isinstance(compute_hpc_island_id, str):
            raise TypeError("Expected argument 'compute_hpc_island_id' to be a str")
        pulumi.set(__self__, "compute_hpc_island_id", compute_hpc_island_id)
        if compute_local_block_id and not isinstance(compute_local_block_id, str):
            raise TypeError("Expected argument 'compute_local_block_id' to be a str")
        pulumi.set(__self__, "compute_local_block_id", compute_local_block_id)
        if compute_network_block_id and not isinstance(compute_network_block_id, str):
            raise TypeError("Expected argument 'compute_network_block_id' to be a str")
        pulumi.set(__self__, "compute_network_block_id", compute_network_block_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if fabric_health and not isinstance(fabric_health, str):
            raise TypeError("Expected argument 'fabric_health' to be a str")
        pulumi.set(__self__, "fabric_health", fabric_health)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if healthy_host_count and not isinstance(healthy_host_count, str):
            raise TypeError("Expected argument 'healthy_host_count' to be a str")
        pulumi.set(__self__, "healthy_host_count", healthy_host_count)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if total_host_count and not isinstance(total_host_count, str):
            raise TypeError("Expected argument 'total_host_count' to be a str")
        pulumi.set(__self__, "total_host_count", total_host_count)

    @property
    @pulumi.getter(name="additionalData")
    def additional_data(self) -> Mapping[str, builtins.str]:
        """
        Additional data that can be exposed to the customer. Right now it will include the switch tray ids.
        """
        return pulumi.get(self, "additional_data")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeGpuMemoryFabricId")
    def compute_gpu_memory_fabric_id(self) -> builtins.str:
        return pulumi.get(self, "compute_gpu_memory_fabric_id")

    @property
    @pulumi.getter(name="computeHpcIslandId")
    def compute_hpc_island_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique HPC Island
        """
        return pulumi.get(self, "compute_hpc_island_id")

    @property
    @pulumi.getter(name="computeLocalBlockId")
    def compute_local_block_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Local Block
        """
        return pulumi.get(self, "compute_local_block_id")

    @property
    @pulumi.getter(name="computeNetworkBlockId")
    def compute_network_block_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Network Block
        """
        return pulumi.get(self, "compute_network_block_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fabricHealth")
    def fabric_health(self) -> builtins.str:
        """
        The health state of the GPU memory fabric
        """
        return pulumi.get(self, "fabric_health")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="healthyHostCount")
    def healthy_host_count(self) -> builtins.str:
        """
        The total number of healthy bare metal hosts located in this compute GPU memory fabric.
        """
        return pulumi.get(self, "healthy_host_count")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Customer-unique GPU memory fabric
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The lifecycle state of the GPU memory fabric
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time that the compute GPU memory fabric record was created, in the format defined by [RFC3339] (https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="totalHostCount")
    def total_host_count(self) -> builtins.str:
        """
        The total number of bare metal hosts located in this compute GPU memory fabric.
        """
        return pulumi.get(self, "total_host_count")


class AwaitableGetComputeGpuMemoryFabricResult(GetComputeGpuMemoryFabricResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeGpuMemoryFabricResult(
            additional_data=self.additional_data,
            compartment_id=self.compartment_id,
            compute_gpu_memory_fabric_id=self.compute_gpu_memory_fabric_id,
            compute_hpc_island_id=self.compute_hpc_island_id,
            compute_local_block_id=self.compute_local_block_id,
            compute_network_block_id=self.compute_network_block_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            fabric_health=self.fabric_health,
            freeform_tags=self.freeform_tags,
            healthy_host_count=self.healthy_host_count,
            id=self.id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            total_host_count=self.total_host_count)


def get_compute_gpu_memory_fabric(compute_gpu_memory_fabric_id: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeGpuMemoryFabricResult:
    """
    This data source provides details about a specific Compute Gpu Memory Fabric resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified compute GPU memory fabric

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_gpu_memory_fabric = oci.Core.get_compute_gpu_memory_fabric(compute_gpu_memory_fabric_id=test_compute_gpu_memory_fabric_oci_core_compute_gpu_memory_fabric["id"])
    ```


    :param builtins.str compute_gpu_memory_fabric_id: The OCID of the compute GPU memory fabric.
    """
    __args__ = dict()
    __args__['computeGpuMemoryFabricId'] = compute_gpu_memory_fabric_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getComputeGpuMemoryFabric:getComputeGpuMemoryFabric', __args__, opts=opts, typ=GetComputeGpuMemoryFabricResult).value

    return AwaitableGetComputeGpuMemoryFabricResult(
        additional_data=pulumi.get(__ret__, 'additional_data'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_gpu_memory_fabric_id=pulumi.get(__ret__, 'compute_gpu_memory_fabric_id'),
        compute_hpc_island_id=pulumi.get(__ret__, 'compute_hpc_island_id'),
        compute_local_block_id=pulumi.get(__ret__, 'compute_local_block_id'),
        compute_network_block_id=pulumi.get(__ret__, 'compute_network_block_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        fabric_health=pulumi.get(__ret__, 'fabric_health'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        healthy_host_count=pulumi.get(__ret__, 'healthy_host_count'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        total_host_count=pulumi.get(__ret__, 'total_host_count'))
def get_compute_gpu_memory_fabric_output(compute_gpu_memory_fabric_id: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeGpuMemoryFabricResult]:
    """
    This data source provides details about a specific Compute Gpu Memory Fabric resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified compute GPU memory fabric

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_gpu_memory_fabric = oci.Core.get_compute_gpu_memory_fabric(compute_gpu_memory_fabric_id=test_compute_gpu_memory_fabric_oci_core_compute_gpu_memory_fabric["id"])
    ```


    :param builtins.str compute_gpu_memory_fabric_id: The OCID of the compute GPU memory fabric.
    """
    __args__ = dict()
    __args__['computeGpuMemoryFabricId'] = compute_gpu_memory_fabric_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getComputeGpuMemoryFabric:getComputeGpuMemoryFabric', __args__, opts=opts, typ=GetComputeGpuMemoryFabricResult)
    return __ret__.apply(lambda __response__: GetComputeGpuMemoryFabricResult(
        additional_data=pulumi.get(__response__, 'additional_data'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_gpu_memory_fabric_id=pulumi.get(__response__, 'compute_gpu_memory_fabric_id'),
        compute_hpc_island_id=pulumi.get(__response__, 'compute_hpc_island_id'),
        compute_local_block_id=pulumi.get(__response__, 'compute_local_block_id'),
        compute_network_block_id=pulumi.get(__response__, 'compute_network_block_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        fabric_health=pulumi.get(__response__, 'fabric_health'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        healthy_host_count=pulumi.get(__response__, 'healthy_host_count'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        total_host_count=pulumi.get(__response__, 'total_host_count')))
