# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetShapesResult',
    'AwaitableGetShapesResult',
    'get_shapes',
    'get_shapes_output',
]

@pulumi.output_type
class GetShapesResult:
    """
    A collection of values returned by getShapes.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, filters=None, id=None, image_id=None, shapes=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if shapes and not isinstance(shapes, list):
            raise TypeError("Expected argument 'shapes' to be a list")
        pulumi.set(__self__, "shapes", shapes)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[builtins.str]:
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetShapesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def shapes(self) -> Sequence['outputs.GetShapesShapeResult']:
        """
        The list of shapes.
        """
        return pulumi.get(self, "shapes")


class AwaitableGetShapesResult(GetShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetShapesResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            image_id=self.image_id,
            shapes=self.shapes)


def get_shapes(availability_domain: Optional[builtins.str] = None,
               compartment_id: Optional[builtins.str] = None,
               filters: Optional[Sequence[Union['GetShapesFilterArgs', 'GetShapesFilterArgsDict']]] = None,
               image_id: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetShapesResult:
    """
    This data source provides the list of Shapes in Oracle Cloud Infrastructure Core service.

    Lists the shapes that can be used to launch an instance within the specified compartment. You can
    filter the list by compatibility with a specific image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_shapes = oci.Core.get_shapes(compartment_id=compartment_id,
        availability_domain=shape_availability_domain,
        image_id=test_image["id"])
    ```


    :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str image_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of an image.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['imageId'] = image_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getShapes:getShapes', __args__, opts=opts, typ=GetShapesResult).value

    return AwaitableGetShapesResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        shapes=pulumi.get(__ret__, 'shapes'))
def get_shapes_output(availability_domain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetShapesFilterArgs', 'GetShapesFilterArgsDict']]]]] = None,
                      image_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetShapesResult]:
    """
    This data source provides the list of Shapes in Oracle Cloud Infrastructure Core service.

    Lists the shapes that can be used to launch an instance within the specified compartment. You can
    filter the list by compatibility with a specific image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_shapes = oci.Core.get_shapes(compartment_id=compartment_id,
        availability_domain=shape_availability_domain,
        image_id=test_image["id"])
    ```


    :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str image_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of an image.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['imageId'] = image_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getShapes:getShapes', __args__, opts=opts, typ=GetShapesResult)
    return __ret__.apply(lambda __response__: GetShapesResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        shapes=pulumi.get(__response__, 'shapes')))
