# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudDatabaseManagementArgs', 'CloudDatabaseManagement']

@pulumi.input_type
class CloudDatabaseManagementArgs:
    def __init__(__self__, *,
                 credentialdetails: pulumi.Input['CloudDatabaseManagementCredentialdetailsArgs'],
                 database_id: pulumi.Input[builtins.str],
                 enable_management: pulumi.Input[builtins.bool],
                 management_type: pulumi.Input[builtins.str],
                 private_end_point_id: pulumi.Input[builtins.str],
                 service_name: pulumi.Input[builtins.str],
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_secret_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CloudDatabaseManagement resource.
        :param pulumi.Input[builtins.str] database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.bool] enable_management: (Updatable) Use this flag to enable/disable database management
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] management_type: (Updatable) Specifies database management type
               enum:
               - `BASIC`
               - `ADVANCED`
        :param pulumi.Input[builtins.str] private_end_point_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        :param pulumi.Input[builtins.str] service_name: The name of the Oracle Database service that will be used to connect to the database.
        :param pulumi.Input[builtins.int] port: The port used to connect to the database.
        :param pulumi.Input[builtins.str] protocol: Protocol used by the database connection.
        :param pulumi.Input[builtins.str] role: The role of the user that will be connecting to the database.
        :param pulumi.Input[builtins.str] ssl_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        pulumi.set(__self__, "credentialdetails", credentialdetails)
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "enable_management", enable_management)
        pulumi.set(__self__, "management_type", management_type)
        pulumi.set(__self__, "private_end_point_id", private_end_point_id)
        pulumi.set(__self__, "service_name", service_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if ssl_secret_id is not None:
            pulumi.set(__self__, "ssl_secret_id", ssl_secret_id)

    @property
    @pulumi.getter
    def credentialdetails(self) -> pulumi.Input['CloudDatabaseManagementCredentialdetailsArgs']:
        return pulumi.get(self, "credentialdetails")

    @credentialdetails.setter
    def credentialdetails(self, value: pulumi.Input['CloudDatabaseManagementCredentialdetailsArgs']):
        pulumi.set(self, "credentialdetails", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[builtins.str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="enableManagement")
    def enable_management(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) Use this flag to enable/disable database management

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_management")

    @enable_management.setter
    def enable_management(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enable_management", value)

    @property
    @pulumi.getter(name="managementType")
    def management_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Specifies database management type
        enum:
        - `BASIC`
        - `ADVANCED`
        """
        return pulumi.get(self, "management_type")

    @management_type.setter
    def management_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "management_type", value)

    @property
    @pulumi.getter(name="privateEndPointId")
    def private_end_point_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        """
        return pulumi.get(self, "private_end_point_id")

    @private_end_point_id.setter
    def private_end_point_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "private_end_point_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Oracle Database service that will be used to connect to the database.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port used to connect to the database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Protocol used by the database connection.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The role of the user that will be connecting to the database.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="sslSecretId")
    def ssl_secret_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "ssl_secret_id")

    @ssl_secret_id.setter
    def ssl_secret_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_secret_id", value)


@pulumi.input_type
class _CloudDatabaseManagementState:
    def __init__(__self__, *,
                 credentialdetails: Optional[pulumi.Input['CloudDatabaseManagementCredentialdetailsArgs']] = None,
                 database_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_management: Optional[pulumi.Input[builtins.bool]] = None,
                 management_type: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 private_end_point_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_secret_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudDatabaseManagement resources.
        :param pulumi.Input[builtins.str] database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.bool] enable_management: (Updatable) Use this flag to enable/disable database management
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] management_type: (Updatable) Specifies database management type
               enum:
               - `BASIC`
               - `ADVANCED`
        :param pulumi.Input[builtins.int] port: The port used to connect to the database.
        :param pulumi.Input[builtins.str] private_end_point_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        :param pulumi.Input[builtins.str] protocol: Protocol used by the database connection.
        :param pulumi.Input[builtins.str] role: The role of the user that will be connecting to the database.
        :param pulumi.Input[builtins.str] service_name: The name of the Oracle Database service that will be used to connect to the database.
        :param pulumi.Input[builtins.str] ssl_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        if credentialdetails is not None:
            pulumi.set(__self__, "credentialdetails", credentialdetails)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if enable_management is not None:
            pulumi.set(__self__, "enable_management", enable_management)
        if management_type is not None:
            pulumi.set(__self__, "management_type", management_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_end_point_id is not None:
            pulumi.set(__self__, "private_end_point_id", private_end_point_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if ssl_secret_id is not None:
            pulumi.set(__self__, "ssl_secret_id", ssl_secret_id)

    @property
    @pulumi.getter
    def credentialdetails(self) -> Optional[pulumi.Input['CloudDatabaseManagementCredentialdetailsArgs']]:
        return pulumi.get(self, "credentialdetails")

    @credentialdetails.setter
    def credentialdetails(self, value: Optional[pulumi.Input['CloudDatabaseManagementCredentialdetailsArgs']]):
        pulumi.set(self, "credentialdetails", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="enableManagement")
    def enable_management(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Use this flag to enable/disable database management

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_management")

    @enable_management.setter
    def enable_management(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_management", value)

    @property
    @pulumi.getter(name="managementType")
    def management_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Specifies database management type
        enum:
        - `BASIC`
        - `ADVANCED`
        """
        return pulumi.get(self, "management_type")

    @management_type.setter
    def management_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "management_type", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port used to connect to the database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateEndPointId")
    def private_end_point_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        """
        return pulumi.get(self, "private_end_point_id")

    @private_end_point_id.setter
    def private_end_point_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_end_point_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Protocol used by the database connection.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The role of the user that will be connecting to the database.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Oracle Database service that will be used to connect to the database.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="sslSecretId")
    def ssl_secret_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "ssl_secret_id")

    @ssl_secret_id.setter
    def ssl_secret_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_secret_id", value)


class CloudDatabaseManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentialdetails: Optional[pulumi.Input[Union['CloudDatabaseManagementCredentialdetailsArgs', 'CloudDatabaseManagementCredentialdetailsArgsDict']]] = None,
                 database_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_management: Optional[pulumi.Input[builtins.bool]] = None,
                 management_type: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 private_end_point_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Database Management resource in Oracle Cloud Infrastructure Database service.

        Enable / Update / Disable database management for the specified Oracle Database instance.

        Database Management requires `USER_NAME`, `PASSWORD_SECRET_ID` and `PRIVATE_END_POINT_ID`.
        `database.0.database_management_config` is updated to appropriate managementType and managementStatus for the specified Oracle Database instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test = oci.database.CloudDatabaseManagement("test",
            database_id=test_database["id"],
            management_type=database_cloud_database_management_details_management_type,
            private_end_point_id=database_cloud_database_management_details_private_end_point_id,
            service_name=database_cloud_database_management_details_service_name,
            credentialdetails={
                "user_name": database_cloud_database_management_details_user_name,
                "password_secret_id": database_cloud_database_management_details_password_secret_id,
            },
            enable_management=database_cloud_database_management_details_enable_management,
            port=cloud_database_management_port,
            protocol=cloud_database_management_protocol,
            role=cloud_database_management_role,
            ssl_secret_id=test_secret["id"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.bool] enable_management: (Updatable) Use this flag to enable/disable database management
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] management_type: (Updatable) Specifies database management type
               enum:
               - `BASIC`
               - `ADVANCED`
        :param pulumi.Input[builtins.int] port: The port used to connect to the database.
        :param pulumi.Input[builtins.str] private_end_point_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        :param pulumi.Input[builtins.str] protocol: Protocol used by the database connection.
        :param pulumi.Input[builtins.str] role: The role of the user that will be connecting to the database.
        :param pulumi.Input[builtins.str] service_name: The name of the Oracle Database service that will be used to connect to the database.
        :param pulumi.Input[builtins.str] ssl_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudDatabaseManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Database Management resource in Oracle Cloud Infrastructure Database service.

        Enable / Update / Disable database management for the specified Oracle Database instance.

        Database Management requires `USER_NAME`, `PASSWORD_SECRET_ID` and `PRIVATE_END_POINT_ID`.
        `database.0.database_management_config` is updated to appropriate managementType and managementStatus for the specified Oracle Database instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test = oci.database.CloudDatabaseManagement("test",
            database_id=test_database["id"],
            management_type=database_cloud_database_management_details_management_type,
            private_end_point_id=database_cloud_database_management_details_private_end_point_id,
            service_name=database_cloud_database_management_details_service_name,
            credentialdetails={
                "user_name": database_cloud_database_management_details_user_name,
                "password_secret_id": database_cloud_database_management_details_password_secret_id,
            },
            enable_management=database_cloud_database_management_details_enable_management,
            port=cloud_database_management_port,
            protocol=cloud_database_management_protocol,
            role=cloud_database_management_role,
            ssl_secret_id=test_secret["id"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param CloudDatabaseManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudDatabaseManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentialdetails: Optional[pulumi.Input[Union['CloudDatabaseManagementCredentialdetailsArgs', 'CloudDatabaseManagementCredentialdetailsArgsDict']]] = None,
                 database_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_management: Optional[pulumi.Input[builtins.bool]] = None,
                 management_type: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 private_end_point_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudDatabaseManagementArgs.__new__(CloudDatabaseManagementArgs)

            if credentialdetails is None and not opts.urn:
                raise TypeError("Missing required property 'credentialdetails'")
            __props__.__dict__["credentialdetails"] = credentialdetails
            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            if enable_management is None and not opts.urn:
                raise TypeError("Missing required property 'enable_management'")
            __props__.__dict__["enable_management"] = enable_management
            if management_type is None and not opts.urn:
                raise TypeError("Missing required property 'management_type'")
            __props__.__dict__["management_type"] = management_type
            __props__.__dict__["port"] = port
            if private_end_point_id is None and not opts.urn:
                raise TypeError("Missing required property 'private_end_point_id'")
            __props__.__dict__["private_end_point_id"] = private_end_point_id
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["role"] = role
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["ssl_secret_id"] = ssl_secret_id
        super(CloudDatabaseManagement, __self__).__init__(
            'oci:Database/cloudDatabaseManagement:CloudDatabaseManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credentialdetails: Optional[pulumi.Input[Union['CloudDatabaseManagementCredentialdetailsArgs', 'CloudDatabaseManagementCredentialdetailsArgsDict']]] = None,
            database_id: Optional[pulumi.Input[builtins.str]] = None,
            enable_management: Optional[pulumi.Input[builtins.bool]] = None,
            management_type: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            private_end_point_id: Optional[pulumi.Input[builtins.str]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            role: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            ssl_secret_id: Optional[pulumi.Input[builtins.str]] = None) -> 'CloudDatabaseManagement':
        """
        Get an existing CloudDatabaseManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.bool] enable_management: (Updatable) Use this flag to enable/disable database management
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] management_type: (Updatable) Specifies database management type
               enum:
               - `BASIC`
               - `ADVANCED`
        :param pulumi.Input[builtins.int] port: The port used to connect to the database.
        :param pulumi.Input[builtins.str] private_end_point_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        :param pulumi.Input[builtins.str] protocol: Protocol used by the database connection.
        :param pulumi.Input[builtins.str] role: The role of the user that will be connecting to the database.
        :param pulumi.Input[builtins.str] service_name: The name of the Oracle Database service that will be used to connect to the database.
        :param pulumi.Input[builtins.str] ssl_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudDatabaseManagementState.__new__(_CloudDatabaseManagementState)

        __props__.__dict__["credentialdetails"] = credentialdetails
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["enable_management"] = enable_management
        __props__.__dict__["management_type"] = management_type
        __props__.__dict__["port"] = port
        __props__.__dict__["private_end_point_id"] = private_end_point_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["role"] = role
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["ssl_secret_id"] = ssl_secret_id
        return CloudDatabaseManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def credentialdetails(self) -> pulumi.Output['outputs.CloudDatabaseManagementCredentialdetails']:
        return pulumi.get(self, "credentialdetails")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[builtins.str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="enableManagement")
    def enable_management(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Use this flag to enable/disable database management

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_management")

    @property
    @pulumi.getter(name="managementType")
    def management_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Specifies database management type
        enum:
        - `BASIC`
        - `ADVANCED`
        """
        return pulumi.get(self, "management_type")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The port used to connect to the database.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateEndPointId")
    def private_end_point_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        """
        return pulumi.get(self, "private_end_point_id")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Protocol used by the database connection.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The role of the user that will be connecting to the database.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Oracle Database service that will be used to connect to the database.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="sslSecretId")
    def ssl_secret_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "ssl_secret_id")

