# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ExecutionWindowArgs', 'ExecutionWindow']

@pulumi.input_type
class ExecutionWindowArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 execution_resource_id: pulumi.Input[builtins.str],
                 time_scheduled: pulumi.Input[builtins.str],
                 window_duration_in_mins: pulumi.Input[builtins.int],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_enforced_duration: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ExecutionWindow resource.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] execution_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution resource the execution window belongs to.
        :param pulumi.Input[builtins.str] time_scheduled: (Updatable) The scheduled start date and time of the execution window.
        :param pulumi.Input[builtins.int] window_duration_in_mins: (Updatable) Duration window allows user to set a duration they plan to allocate for Scheduling window. The duration is in minutes. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_enforced_duration: (Updatable) Indicates if duration the user plans to allocate for scheduling window is strictly enforced. The default value is `FALSE`.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "execution_resource_id", execution_resource_id)
        pulumi.set(__self__, "time_scheduled", time_scheduled)
        pulumi.set(__self__, "window_duration_in_mins", window_duration_in_mins)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enforced_duration is not None:
            pulumi.set(__self__, "is_enforced_duration", is_enforced_duration)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="executionResourceId")
    def execution_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution resource the execution window belongs to.
        """
        return pulumi.get(self, "execution_resource_id")

    @execution_resource_id.setter
    def execution_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "execution_resource_id", value)

    @property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The scheduled start date and time of the execution window.
        """
        return pulumi.get(self, "time_scheduled")

    @time_scheduled.setter
    def time_scheduled(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "time_scheduled", value)

    @property
    @pulumi.getter(name="windowDurationInMins")
    def window_duration_in_mins(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) Duration window allows user to set a duration they plan to allocate for Scheduling window. The duration is in minutes. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "window_duration_in_mins")

    @window_duration_in_mins.setter
    def window_duration_in_mins(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "window_duration_in_mins", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnforcedDuration")
    def is_enforced_duration(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates if duration the user plans to allocate for scheduling window is strictly enforced. The default value is `FALSE`.
        """
        return pulumi.get(self, "is_enforced_duration")

    @is_enforced_duration.setter
    def is_enforced_duration(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enforced_duration", value)


@pulumi.input_type
class _ExecutionWindowState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 estimated_time_in_mins: Optional[pulumi.Input[builtins.int]] = None,
                 execution_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_enforced_duration: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_substate: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_ended: Optional[pulumi.Input[builtins.str]] = None,
                 time_scheduled: Optional[pulumi.Input[builtins.str]] = None,
                 time_started: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 total_time_taken_in_mins: Optional[pulumi.Input[builtins.int]] = None,
                 window_duration_in_mins: Optional[pulumi.Input[builtins.int]] = None,
                 window_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExecutionWindow resources.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] description: Description of the execution window.
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the execution window. The name does not need to be unique.
        :param pulumi.Input[builtins.int] estimated_time_in_mins: The estimated time of the execution window in minutes.
        :param pulumi.Input[builtins.str] execution_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution resource the execution window belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_enforced_duration: (Updatable) Indicates if duration the user plans to allocate for scheduling window is strictly enforced. The default value is `FALSE`.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[builtins.str] lifecycle_substate: The current sub-state of the execution window. Valid states are DURATION_EXCEEDED, MAINTENANCE_IN_PROGRESS and WAITING.
        :param pulumi.Input[builtins.str] state: The current state of the Schedule Policy. Valid states are CREATED, SCHEDULED, IN_PROGRESS, FAILED, CANCELED, UPDATING, DELETED, SUCCEEDED and PARTIAL_SUCCESS.
        :param pulumi.Input[builtins.str] time_created: The date and time the execution window was created.
        :param pulumi.Input[builtins.str] time_ended: The date and time that the execution window ended.
        :param pulumi.Input[builtins.str] time_scheduled: (Updatable) The scheduled start date and time of the execution window.
        :param pulumi.Input[builtins.str] time_started: The date and time that the execution window was started.
        :param pulumi.Input[builtins.str] time_updated: The last date and time that the execution window was updated.
        :param pulumi.Input[builtins.int] total_time_taken_in_mins: The total time taken by corresponding resource activity in minutes.
        :param pulumi.Input[builtins.int] window_duration_in_mins: (Updatable) Duration window allows user to set a duration they plan to allocate for Scheduling window. The duration is in minutes. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] window_type: The execution window is of PLANNED or UNPLANNED type.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if estimated_time_in_mins is not None:
            pulumi.set(__self__, "estimated_time_in_mins", estimated_time_in_mins)
        if execution_resource_id is not None:
            pulumi.set(__self__, "execution_resource_id", execution_resource_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enforced_duration is not None:
            pulumi.set(__self__, "is_enforced_duration", is_enforced_duration)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_substate is not None:
            pulumi.set(__self__, "lifecycle_substate", lifecycle_substate)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_ended is not None:
            pulumi.set(__self__, "time_ended", time_ended)
        if time_scheduled is not None:
            pulumi.set(__self__, "time_scheduled", time_scheduled)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if total_time_taken_in_mins is not None:
            pulumi.set(__self__, "total_time_taken_in_mins", total_time_taken_in_mins)
        if window_duration_in_mins is not None:
            pulumi.set(__self__, "window_duration_in_mins", window_duration_in_mins)
        if window_type is not None:
            pulumi.set(__self__, "window_type", window_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the execution window.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-friendly name for the execution window. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="estimatedTimeInMins")
    def estimated_time_in_mins(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The estimated time of the execution window in minutes.
        """
        return pulumi.get(self, "estimated_time_in_mins")

    @estimated_time_in_mins.setter
    def estimated_time_in_mins(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "estimated_time_in_mins", value)

    @property
    @pulumi.getter(name="executionResourceId")
    def execution_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution resource the execution window belongs to.
        """
        return pulumi.get(self, "execution_resource_id")

    @execution_resource_id.setter
    def execution_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_resource_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnforcedDuration")
    def is_enforced_duration(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates if duration the user plans to allocate for scheduling window is strictly enforced. The default value is `FALSE`.
        """
        return pulumi.get(self, "is_enforced_duration")

    @is_enforced_duration.setter
    def is_enforced_duration(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enforced_duration", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="lifecycleSubstate")
    def lifecycle_substate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current sub-state of the execution window. Valid states are DURATION_EXCEEDED, MAINTENANCE_IN_PROGRESS and WAITING.
        """
        return pulumi.get(self, "lifecycle_substate")

    @lifecycle_substate.setter
    def lifecycle_substate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_substate", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the Schedule Policy. Valid states are CREATED, SCHEDULED, IN_PROGRESS, FAILED, CANCELED, UPDATING, DELETED, SUCCEEDED and PARTIAL_SUCCESS.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the execution window was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time that the execution window ended.
        """
        return pulumi.get(self, "time_ended")

    @time_ended.setter
    def time_ended(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_ended", value)

    @property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The scheduled start date and time of the execution window.
        """
        return pulumi.get(self, "time_scheduled")

    @time_scheduled.setter
    def time_scheduled(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_scheduled", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time that the execution window was started.
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_started", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last date and time that the execution window was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="totalTimeTakenInMins")
    def total_time_taken_in_mins(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The total time taken by corresponding resource activity in minutes.
        """
        return pulumi.get(self, "total_time_taken_in_mins")

    @total_time_taken_in_mins.setter
    def total_time_taken_in_mins(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_time_taken_in_mins", value)

    @property
    @pulumi.getter(name="windowDurationInMins")
    def window_duration_in_mins(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Duration window allows user to set a duration they plan to allocate for Scheduling window. The duration is in minutes. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "window_duration_in_mins")

    @window_duration_in_mins.setter
    def window_duration_in_mins(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "window_duration_in_mins", value)

    @property
    @pulumi.getter(name="windowType")
    def window_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The execution window is of PLANNED or UNPLANNED type.
        """
        return pulumi.get(self, "window_type")

    @window_type.setter
    def window_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "window_type", value)


class ExecutionWindow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 execution_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_enforced_duration: Optional[pulumi.Input[builtins.bool]] = None,
                 time_scheduled: Optional[pulumi.Input[builtins.str]] = None,
                 window_duration_in_mins: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource provides the Execution Window resource in Oracle Cloud Infrastructure Database service.

        Creates an execution window resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_execution_window = oci.database.ExecutionWindow("test_execution_window",
            compartment_id=compartment_id,
            execution_resource_id=test_resource["id"],
            time_scheduled=execution_window_time_scheduled,
            window_duration_in_mins=execution_window_window_duration_in_mins,
            defined_tags=execution_window_defined_tags,
            freeform_tags={
                "Department": "Finance",
            },
            is_enforced_duration=execution_window_is_enforced_duration)
        ```

        ## Import

        ExecutionWindows can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/executionWindow:ExecutionWindow test_execution_window "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] execution_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution resource the execution window belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_enforced_duration: (Updatable) Indicates if duration the user plans to allocate for scheduling window is strictly enforced. The default value is `FALSE`.
        :param pulumi.Input[builtins.str] time_scheduled: (Updatable) The scheduled start date and time of the execution window.
        :param pulumi.Input[builtins.int] window_duration_in_mins: (Updatable) Duration window allows user to set a duration they plan to allocate for Scheduling window. The duration is in minutes. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExecutionWindowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Execution Window resource in Oracle Cloud Infrastructure Database service.

        Creates an execution window resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_execution_window = oci.database.ExecutionWindow("test_execution_window",
            compartment_id=compartment_id,
            execution_resource_id=test_resource["id"],
            time_scheduled=execution_window_time_scheduled,
            window_duration_in_mins=execution_window_window_duration_in_mins,
            defined_tags=execution_window_defined_tags,
            freeform_tags={
                "Department": "Finance",
            },
            is_enforced_duration=execution_window_is_enforced_duration)
        ```

        ## Import

        ExecutionWindows can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/executionWindow:ExecutionWindow test_execution_window "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExecutionWindowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExecutionWindowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 execution_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_enforced_duration: Optional[pulumi.Input[builtins.bool]] = None,
                 time_scheduled: Optional[pulumi.Input[builtins.str]] = None,
                 window_duration_in_mins: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExecutionWindowArgs.__new__(ExecutionWindowArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if execution_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'execution_resource_id'")
            __props__.__dict__["execution_resource_id"] = execution_resource_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_enforced_duration"] = is_enforced_duration
            if time_scheduled is None and not opts.urn:
                raise TypeError("Missing required property 'time_scheduled'")
            __props__.__dict__["time_scheduled"] = time_scheduled
            if window_duration_in_mins is None and not opts.urn:
                raise TypeError("Missing required property 'window_duration_in_mins'")
            __props__.__dict__["window_duration_in_mins"] = window_duration_in_mins
            __props__.__dict__["description"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["estimated_time_in_mins"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["lifecycle_substate"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_ended"] = None
            __props__.__dict__["time_started"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["total_time_taken_in_mins"] = None
            __props__.__dict__["window_type"] = None
        super(ExecutionWindow, __self__).__init__(
            'oci:Database/executionWindow:ExecutionWindow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            estimated_time_in_mins: Optional[pulumi.Input[builtins.int]] = None,
            execution_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_enforced_duration: Optional[pulumi.Input[builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_substate: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_ended: Optional[pulumi.Input[builtins.str]] = None,
            time_scheduled: Optional[pulumi.Input[builtins.str]] = None,
            time_started: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            total_time_taken_in_mins: Optional[pulumi.Input[builtins.int]] = None,
            window_duration_in_mins: Optional[pulumi.Input[builtins.int]] = None,
            window_type: Optional[pulumi.Input[builtins.str]] = None) -> 'ExecutionWindow':
        """
        Get an existing ExecutionWindow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] description: Description of the execution window.
        :param pulumi.Input[builtins.str] display_name: The user-friendly name for the execution window. The name does not need to be unique.
        :param pulumi.Input[builtins.int] estimated_time_in_mins: The estimated time of the execution window in minutes.
        :param pulumi.Input[builtins.str] execution_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution resource the execution window belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_enforced_duration: (Updatable) Indicates if duration the user plans to allocate for scheduling window is strictly enforced. The default value is `FALSE`.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[builtins.str] lifecycle_substate: The current sub-state of the execution window. Valid states are DURATION_EXCEEDED, MAINTENANCE_IN_PROGRESS and WAITING.
        :param pulumi.Input[builtins.str] state: The current state of the Schedule Policy. Valid states are CREATED, SCHEDULED, IN_PROGRESS, FAILED, CANCELED, UPDATING, DELETED, SUCCEEDED and PARTIAL_SUCCESS.
        :param pulumi.Input[builtins.str] time_created: The date and time the execution window was created.
        :param pulumi.Input[builtins.str] time_ended: The date and time that the execution window ended.
        :param pulumi.Input[builtins.str] time_scheduled: (Updatable) The scheduled start date and time of the execution window.
        :param pulumi.Input[builtins.str] time_started: The date and time that the execution window was started.
        :param pulumi.Input[builtins.str] time_updated: The last date and time that the execution window was updated.
        :param pulumi.Input[builtins.int] total_time_taken_in_mins: The total time taken by corresponding resource activity in minutes.
        :param pulumi.Input[builtins.int] window_duration_in_mins: (Updatable) Duration window allows user to set a duration they plan to allocate for Scheduling window. The duration is in minutes. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] window_type: The execution window is of PLANNED or UNPLANNED type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExecutionWindowState.__new__(_ExecutionWindowState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["estimated_time_in_mins"] = estimated_time_in_mins
        __props__.__dict__["execution_resource_id"] = execution_resource_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_enforced_duration"] = is_enforced_duration
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["lifecycle_substate"] = lifecycle_substate
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_ended"] = time_ended
        __props__.__dict__["time_scheduled"] = time_scheduled
        __props__.__dict__["time_started"] = time_started
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["total_time_taken_in_mins"] = total_time_taken_in_mins
        __props__.__dict__["window_duration_in_mins"] = window_duration_in_mins
        __props__.__dict__["window_type"] = window_type
        return ExecutionWindow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the execution window.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The user-friendly name for the execution window. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedTimeInMins")
    def estimated_time_in_mins(self) -> pulumi.Output[builtins.int]:
        """
        The estimated time of the execution window in minutes.
        """
        return pulumi.get(self, "estimated_time_in_mins")

    @property
    @pulumi.getter(name="executionResourceId")
    def execution_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the execution resource the execution window belongs to.
        """
        return pulumi.get(self, "execution_resource_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isEnforcedDuration")
    def is_enforced_duration(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Indicates if duration the user plans to allocate for scheduling window is strictly enforced. The default value is `FALSE`.
        """
        return pulumi.get(self, "is_enforced_duration")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubstate")
    def lifecycle_substate(self) -> pulumi.Output[builtins.str]:
        """
        The current sub-state of the execution window. Valid states are DURATION_EXCEEDED, MAINTENANCE_IN_PROGRESS and WAITING.
        """
        return pulumi.get(self, "lifecycle_substate")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the Schedule Policy. Valid states are CREATED, SCHEDULED, IN_PROGRESS, FAILED, CANCELED, UPDATING, DELETED, SUCCEEDED and PARTIAL_SUCCESS.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the execution window was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> pulumi.Output[builtins.str]:
        """
        The date and time that the execution window ended.
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The scheduled start date and time of the execution window.
        """
        return pulumi.get(self, "time_scheduled")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[builtins.str]:
        """
        The date and time that the execution window was started.
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The last date and time that the execution window was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalTimeTakenInMins")
    def total_time_taken_in_mins(self) -> pulumi.Output[builtins.int]:
        """
        The total time taken by corresponding resource activity in minutes.
        """
        return pulumi.get(self, "total_time_taken_in_mins")

    @property
    @pulumi.getter(name="windowDurationInMins")
    def window_duration_in_mins(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) Duration window allows user to set a duration they plan to allocate for Scheduling window. The duration is in minutes. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "window_duration_in_mins")

    @property
    @pulumi.getter(name="windowType")
    def window_type(self) -> pulumi.Output[builtins.str]:
        """
        The execution window is of PLANNED or UNPLANNED type.
        """
        return pulumi.get(self, "window_type")

