# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExascaleDbStorageVaultsResult',
    'AwaitableGetExascaleDbStorageVaultsResult',
    'get_exascale_db_storage_vaults',
    'get_exascale_db_storage_vaults_output',
]

@pulumi.output_type
class GetExascaleDbStorageVaultsResult:
    """
    A collection of values returned by getExascaleDbStorageVaults.
    """
    def __init__(__self__, cluster_placement_group_id=None, compartment_id=None, display_name=None, exadata_infrastructure_id=None, exascale_db_storage_vaults=None, filters=None, id=None, state=None):
        if cluster_placement_group_id and not isinstance(cluster_placement_group_id, str):
            raise TypeError("Expected argument 'cluster_placement_group_id' to be a str")
        pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id and not isinstance(exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if exascale_db_storage_vaults and not isinstance(exascale_db_storage_vaults, list):
            raise TypeError("Expected argument 'exascale_db_storage_vaults' to be a list")
        pulumi.set(__self__, "exascale_db_storage_vaults", exascale_db_storage_vaults)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="exascaleDbStorageVaults")
    def exascale_db_storage_vaults(self) -> Sequence['outputs.GetExascaleDbStorageVaultsExascaleDbStorageVaultResult']:
        """
        The list of exascale_db_storage_vaults.
        """
        return pulumi.get(self, "exascale_db_storage_vaults")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExascaleDbStorageVaultsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "state")


class AwaitableGetExascaleDbStorageVaultsResult(GetExascaleDbStorageVaultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExascaleDbStorageVaultsResult(
            cluster_placement_group_id=self.cluster_placement_group_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            exadata_infrastructure_id=self.exadata_infrastructure_id,
            exascale_db_storage_vaults=self.exascale_db_storage_vaults,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_exascale_db_storage_vaults(cluster_placement_group_id: Optional[builtins.str] = None,
                                   compartment_id: Optional[builtins.str] = None,
                                   display_name: Optional[builtins.str] = None,
                                   exadata_infrastructure_id: Optional[builtins.str] = None,
                                   filters: Optional[Sequence[Union['GetExascaleDbStorageVaultsFilterArgs', 'GetExascaleDbStorageVaultsFilterArgsDict']]] = None,
                                   state: Optional[builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExascaleDbStorageVaultsResult:
    """
    This data source provides the list of Exascale Db Storage Vaults in Oracle Cloud Infrastructure Database service.

    Gets a list of the Exadata Database Storage Vaults in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exascale_db_storage_vaults = oci.Database.get_exascale_db_storage_vaults(compartment_id=compartment_id,
        cluster_placement_group_id=test_cluster_placement_group["id"],
        display_name=exascale_db_storage_vault_display_name,
        exadata_infrastructure_id=test_exadata_infrastructure["id"],
        state=exascale_db_storage_vault_state)
    ```


    :param builtins.str cluster_placement_group_id: A filter to return only resources that match the given cluster placement group ID exactly.
    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str exadata_infrastructure_id: A filter to return only list of Vaults that are linked to the exadata infrastructure Id.
    :param builtins.str state: A filter to return only Exadata Database Storage Vaults that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['clusterPlacementGroupId'] = cluster_placement_group_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['exadataInfrastructureId'] = exadata_infrastructure_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExascaleDbStorageVaults:getExascaleDbStorageVaults', __args__, opts=opts, typ=GetExascaleDbStorageVaultsResult).value

    return AwaitableGetExascaleDbStorageVaultsResult(
        cluster_placement_group_id=pulumi.get(__ret__, 'cluster_placement_group_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__ret__, 'exadata_infrastructure_id'),
        exascale_db_storage_vaults=pulumi.get(__ret__, 'exascale_db_storage_vaults'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_exascale_db_storage_vaults_output(cluster_placement_group_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                          display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          exadata_infrastructure_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetExascaleDbStorageVaultsFilterArgs', 'GetExascaleDbStorageVaultsFilterArgsDict']]]]] = None,
                                          state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExascaleDbStorageVaultsResult]:
    """
    This data source provides the list of Exascale Db Storage Vaults in Oracle Cloud Infrastructure Database service.

    Gets a list of the Exadata Database Storage Vaults in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exascale_db_storage_vaults = oci.Database.get_exascale_db_storage_vaults(compartment_id=compartment_id,
        cluster_placement_group_id=test_cluster_placement_group["id"],
        display_name=exascale_db_storage_vault_display_name,
        exadata_infrastructure_id=test_exadata_infrastructure["id"],
        state=exascale_db_storage_vault_state)
    ```


    :param builtins.str cluster_placement_group_id: A filter to return only resources that match the given cluster placement group ID exactly.
    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str exadata_infrastructure_id: A filter to return only list of Vaults that are linked to the exadata infrastructure Id.
    :param builtins.str state: A filter to return only Exadata Database Storage Vaults that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['clusterPlacementGroupId'] = cluster_placement_group_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['exadataInfrastructureId'] = exadata_infrastructure_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getExascaleDbStorageVaults:getExascaleDbStorageVaults', __args__, opts=opts, typ=GetExascaleDbStorageVaultsResult)
    return __ret__.apply(lambda __response__: GetExascaleDbStorageVaultsResult(
        cluster_placement_group_id=pulumi.get(__response__, 'cluster_placement_group_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__response__, 'exadata_infrastructure_id'),
        exascale_db_storage_vaults=pulumi.get(__response__, 'exascale_db_storage_vaults'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
