# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFlexComponentsResult',
    'AwaitableGetFlexComponentsResult',
    'get_flex_components',
    'get_flex_components_output',
]

@pulumi.output_type
class GetFlexComponentsResult:
    """
    A collection of values returned by getFlexComponents.
    """
    def __init__(__self__, compartment_id=None, filters=None, flex_component_collections=None, id=None, name=None, shape=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if flex_component_collections and not isinstance(flex_component_collections, list):
            raise TypeError("Expected argument 'flex_component_collections' to be a list")
        pulumi.set(__self__, "flex_component_collections", flex_component_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFlexComponentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="flexComponentCollections")
    def flex_component_collections(self) -> Sequence['outputs.GetFlexComponentsFlexComponentCollectionResult']:
        """
        The list of flex_component_collection.
        """
        return pulumi.get(self, "flex_component_collections")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the Flex Component used for the DB system.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def shape(self) -> Optional[builtins.str]:
        """
        The name of the DB system shape for this Flex Component.
        """
        return pulumi.get(self, "shape")


class AwaitableGetFlexComponentsResult(GetFlexComponentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlexComponentsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            flex_component_collections=self.flex_component_collections,
            id=self.id,
            name=self.name,
            shape=self.shape)


def get_flex_components(compartment_id: Optional[builtins.str] = None,
                        filters: Optional[Sequence[Union['GetFlexComponentsFilterArgs', 'GetFlexComponentsFilterArgsDict']]] = None,
                        name: Optional[builtins.str] = None,
                        shape: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlexComponentsResult:
    """
    This data source provides the list of Flex Components in Oracle Cloud Infrastructure Database service.

    Gets a list of the flex components that can be used to launch a new DB system. The flex component determines resources to allocate to the DB system - Database Servers and Storage Servers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_flex_components = oci.Database.get_flex_components(compartment_id=compartment_id,
        name=flex_component_name,
        shape=flex_component_shape)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str name: A filter to return only resources that match the entire name given. The match is not case sensitive.
    :param builtins.str shape: A filter to return only resources that belong to the entire shape name given. The match is not case sensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['shape'] = shape
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getFlexComponents:getFlexComponents', __args__, opts=opts, typ=GetFlexComponentsResult).value

    return AwaitableGetFlexComponentsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        flex_component_collections=pulumi.get(__ret__, 'flex_component_collections'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        shape=pulumi.get(__ret__, 'shape'))
def get_flex_components_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFlexComponentsFilterArgs', 'GetFlexComponentsFilterArgsDict']]]]] = None,
                               name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               shape: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlexComponentsResult]:
    """
    This data source provides the list of Flex Components in Oracle Cloud Infrastructure Database service.

    Gets a list of the flex components that can be used to launch a new DB system. The flex component determines resources to allocate to the DB system - Database Servers and Storage Servers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_flex_components = oci.Database.get_flex_components(compartment_id=compartment_id,
        name=flex_component_name,
        shape=flex_component_shape)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str name: A filter to return only resources that match the entire name given. The match is not case sensitive.
    :param builtins.str shape: A filter to return only resources that belong to the entire shape name given. The match is not case sensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['shape'] = shape
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getFlexComponents:getFlexComponents', __args__, opts=opts, typ=GetFlexComponentsResult)
    return __ret__.apply(lambda __response__: GetFlexComponentsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        flex_component_collections=pulumi.get(__response__, 'flex_component_collections'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        shape=pulumi.get(__response__, 'shape')))
