# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVmClustersResult',
    'AwaitableGetVmClustersResult',
    'get_vm_clusters',
    'get_vm_clusters_output',
]

@pulumi.output_type
class GetVmClustersResult:
    """
    A collection of values returned by getVmClusters.
    """
    def __init__(__self__, compartment_id=None, display_name=None, exadata_infrastructure_id=None, filters=None, id=None, state=None, vm_cluster_type=None, vm_clusters=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id and not isinstance(exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vm_cluster_type and not isinstance(vm_cluster_type, str):
            raise TypeError("Expected argument 'vm_cluster_type' to be a str")
        pulumi.set(__self__, "vm_cluster_type", vm_cluster_type)
        if vm_clusters and not isinstance(vm_clusters, list):
            raise TypeError("Expected argument 'vm_clusters' to be a list")
        pulumi.set(__self__, "vm_clusters", vm_clusters)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The user-friendly name for the Exadata Cloud@Customer VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVmClustersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the VM cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vmClusterType")
    def vm_cluster_type(self) -> Optional[builtins.str]:
        """
        The vmcluster type for the VM cluster/Cloud VM cluster.
        """
        return pulumi.get(self, "vm_cluster_type")

    @property
    @pulumi.getter(name="vmClusters")
    def vm_clusters(self) -> Sequence['outputs.GetVmClustersVmClusterResult']:
        """
        The list of vm_clusters.
        """
        return pulumi.get(self, "vm_clusters")


class AwaitableGetVmClustersResult(GetVmClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVmClustersResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            exadata_infrastructure_id=self.exadata_infrastructure_id,
            filters=self.filters,
            id=self.id,
            state=self.state,
            vm_cluster_type=self.vm_cluster_type,
            vm_clusters=self.vm_clusters)


def get_vm_clusters(compartment_id: Optional[builtins.str] = None,
                    display_name: Optional[builtins.str] = None,
                    exadata_infrastructure_id: Optional[builtins.str] = None,
                    filters: Optional[Sequence[Union['GetVmClustersFilterArgs', 'GetVmClustersFilterArgsDict']]] = None,
                    state: Optional[builtins.str] = None,
                    vm_cluster_type: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVmClustersResult:
    """
    This data source provides the list of Vm Clusters in Oracle Cloud Infrastructure Database service.

    Lists the VM clusters in the specified compartment. Applies to Exadata Cloud@Customer instances only.
    To list the cloud VM clusters in an Exadata Cloud Service instance, use the [ListCloudVmClusters ](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudVmCluster/ListCloudVmClusters) operation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_clusters = oci.Database.get_vm_clusters(compartment_id=compartment_id,
        display_name=vm_cluster_display_name,
        exadata_infrastructure_id=test_exadata_infrastructure["id"],
        state=vm_cluster_state,
        vm_cluster_type=vm_cluster_vm_cluster_type)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str exadata_infrastructure_id: If provided, filters the results for the given Exadata Infrastructure.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    :param builtins.str vm_cluster_type: A filter to return only vmclusters that match the given vmcluster type exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['exadataInfrastructureId'] = exadata_infrastructure_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['vmClusterType'] = vm_cluster_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getVmClusters:getVmClusters', __args__, opts=opts, typ=GetVmClustersResult).value

    return AwaitableGetVmClustersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__ret__, 'exadata_infrastructure_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        vm_cluster_type=pulumi.get(__ret__, 'vm_cluster_type'),
        vm_clusters=pulumi.get(__ret__, 'vm_clusters'))
def get_vm_clusters_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                           display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           exadata_infrastructure_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVmClustersFilterArgs', 'GetVmClustersFilterArgsDict']]]]] = None,
                           state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           vm_cluster_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVmClustersResult]:
    """
    This data source provides the list of Vm Clusters in Oracle Cloud Infrastructure Database service.

    Lists the VM clusters in the specified compartment. Applies to Exadata Cloud@Customer instances only.
    To list the cloud VM clusters in an Exadata Cloud Service instance, use the [ListCloudVmClusters ](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudVmCluster/ListCloudVmClusters) operation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_clusters = oci.Database.get_vm_clusters(compartment_id=compartment_id,
        display_name=vm_cluster_display_name,
        exadata_infrastructure_id=test_exadata_infrastructure["id"],
        state=vm_cluster_state,
        vm_cluster_type=vm_cluster_vm_cluster_type)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param builtins.str exadata_infrastructure_id: If provided, filters the results for the given Exadata Infrastructure.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    :param builtins.str vm_cluster_type: A filter to return only vmclusters that match the given vmcluster type exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['exadataInfrastructureId'] = exadata_infrastructure_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['vmClusterType'] = vm_cluster_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getVmClusters:getVmClusters', __args__, opts=opts, typ=GetVmClustersResult)
    return __ret__.apply(lambda __response__: GetVmClustersResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__response__, 'exadata_infrastructure_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        vm_cluster_type=pulumi.get(__response__, 'vm_cluster_type'),
        vm_clusters=pulumi.get(__response__, 'vm_clusters')))
