# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbManagementPrivateEndpointAssociatedDatabaseResult',
    'AwaitableGetDbManagementPrivateEndpointAssociatedDatabaseResult',
    'get_db_management_private_endpoint_associated_database',
    'get_db_management_private_endpoint_associated_database_output',
]

@pulumi.output_type
class GetDbManagementPrivateEndpointAssociatedDatabaseResult:
    """
    A collection of values returned by getDbManagementPrivateEndpointAssociatedDatabase.
    """
    def __init__(__self__, compartment_id=None, db_management_private_endpoint_id=None, id=None, items=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_management_private_endpoint_id and not isinstance(db_management_private_endpoint_id, str):
            raise TypeError("Expected argument 'db_management_private_endpoint_id' to be a str")
        pulumi.set(__self__, "db_management_private_endpoint_id", db_management_private_endpoint_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbManagementPrivateEndpointId")
    def db_management_private_endpoint_id(self) -> builtins.str:
        return pulumi.get(self, "db_management_private_endpoint_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDbManagementPrivateEndpointAssociatedDatabaseItemResult']:
        """
        A list of databases using a Database Management private endpoint.
        """
        return pulumi.get(self, "items")


class AwaitableGetDbManagementPrivateEndpointAssociatedDatabaseResult(GetDbManagementPrivateEndpointAssociatedDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbManagementPrivateEndpointAssociatedDatabaseResult(
            compartment_id=self.compartment_id,
            db_management_private_endpoint_id=self.db_management_private_endpoint_id,
            id=self.id,
            items=self.items)


def get_db_management_private_endpoint_associated_database(compartment_id: Optional[builtins.str] = None,
                                                           db_management_private_endpoint_id: Optional[builtins.str] = None,
                                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbManagementPrivateEndpointAssociatedDatabaseResult:
    """
    This data source provides details about a specific Db Management Private Endpoint Associated Database resource in Oracle Cloud Infrastructure Database Management service.

    Gets the list of databases using a specific Database Management private endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_management_private_endpoint_associated_database = oci.DatabaseManagement.get_db_management_private_endpoint_associated_database(compartment_id=compartment_id,
        db_management_private_endpoint_id=test_db_management_private_endpoint["id"])
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str db_management_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbManagementPrivateEndpointId'] = db_management_private_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getDbManagementPrivateEndpointAssociatedDatabase:getDbManagementPrivateEndpointAssociatedDatabase', __args__, opts=opts, typ=GetDbManagementPrivateEndpointAssociatedDatabaseResult).value

    return AwaitableGetDbManagementPrivateEndpointAssociatedDatabaseResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_management_private_endpoint_id=pulumi.get(__ret__, 'db_management_private_endpoint_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))
def get_db_management_private_endpoint_associated_database_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                                  db_management_private_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbManagementPrivateEndpointAssociatedDatabaseResult]:
    """
    This data source provides details about a specific Db Management Private Endpoint Associated Database resource in Oracle Cloud Infrastructure Database Management service.

    Gets the list of databases using a specific Database Management private endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_management_private_endpoint_associated_database = oci.DatabaseManagement.get_db_management_private_endpoint_associated_database(compartment_id=compartment_id,
        db_management_private_endpoint_id=test_db_management_private_endpoint["id"])
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str db_management_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbManagementPrivateEndpointId'] = db_management_private_endpoint_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getDbManagementPrivateEndpointAssociatedDatabase:getDbManagementPrivateEndpointAssociatedDatabase', __args__, opts=opts, typ=GetDbManagementPrivateEndpointAssociatedDatabaseResult)
    return __ret__.apply(lambda __response__: GetDbManagementPrivateEndpointAssociatedDatabaseResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_management_private_endpoint_id=pulumi.get(__response__, 'db_management_private_endpoint_id'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items')))
