# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetConnectionsResult',
    'AwaitableGetConnectionsResult',
    'get_connections',
    'get_connections_output',
]

@pulumi.output_type
class GetConnectionsResult:
    """
    A collection of values returned by getConnections.
    """
    def __init__(__self__, compartment_id=None, connection_collections=None, connection_types=None, display_name=None, filters=None, id=None, source_connection_id=None, state=None, technology_types=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_collections and not isinstance(connection_collections, list):
            raise TypeError("Expected argument 'connection_collections' to be a list")
        pulumi.set(__self__, "connection_collections", connection_collections)
        if connection_types and not isinstance(connection_types, list):
            raise TypeError("Expected argument 'connection_types' to be a list")
        pulumi.set(__self__, "connection_types", connection_types)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if source_connection_id and not isinstance(source_connection_id, str):
            raise TypeError("Expected argument 'source_connection_id' to be a str")
        pulumi.set(__self__, "source_connection_id", source_connection_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if technology_types and not isinstance(technology_types, list):
            raise TypeError("Expected argument 'technology_types' to be a list")
        pulumi.set(__self__, "technology_types", technology_types)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionCollections")
    def connection_collections(self) -> Sequence['outputs.GetConnectionsConnectionCollectionResult']:
        """
        The list of connection_collection.
        """
        return pulumi.get(self, "connection_collections")

    @property
    @pulumi.getter(name="connectionTypes")
    def connection_types(self) -> Optional[Sequence[builtins.str]]:
        """
        Defines the type of connection. For example, ORACLE.
        """
        return pulumi.get(self, "connection_types")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetConnectionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sourceConnectionId")
    def source_connection_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "source_connection_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The Connection's current lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="technologyTypes")
    def technology_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The type of MySQL source or target connection. Example: OCI_MYSQL represents Oracle Cloud Infrastructure MySQL HeatWave Database Service
        """
        return pulumi.get(self, "technology_types")


class AwaitableGetConnectionsResult(GetConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionsResult(
            compartment_id=self.compartment_id,
            connection_collections=self.connection_collections,
            connection_types=self.connection_types,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            source_connection_id=self.source_connection_id,
            state=self.state,
            technology_types=self.technology_types)


def get_connections(compartment_id: Optional[builtins.str] = None,
                    connection_types: Optional[Sequence[builtins.str]] = None,
                    display_name: Optional[builtins.str] = None,
                    filters: Optional[Sequence[Union['GetConnectionsFilterArgs', 'GetConnectionsFilterArgsDict']]] = None,
                    source_connection_id: Optional[builtins.str] = None,
                    state: Optional[builtins.str] = None,
                    technology_types: Optional[Sequence[builtins.str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connections = oci.DatabaseMigration.get_connections(compartment_id=compartment_id,
        connection_types=connection_connection_type,
        display_name=connection_display_name,
        source_connection_id=test_connection["id"],
        state=connection_state,
        technology_types=connection_technology_type)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param Sequence[builtins.str] connection_types: The array of connection types.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str source_connection_id: The OCID of the source database connection.
    :param builtins.str state: The current state of the Database Migration Deployment.
    :param Sequence[builtins.str] technology_types: The array of technology types.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['connectionTypes'] = connection_types
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['sourceConnectionId'] = source_connection_id
    __args__['state'] = state
    __args__['technologyTypes'] = technology_types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseMigration/getConnections:getConnections', __args__, opts=opts, typ=GetConnectionsResult).value

    return AwaitableGetConnectionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_collections=pulumi.get(__ret__, 'connection_collections'),
        connection_types=pulumi.get(__ret__, 'connection_types'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        source_connection_id=pulumi.get(__ret__, 'source_connection_id'),
        state=pulumi.get(__ret__, 'state'),
        technology_types=pulumi.get(__ret__, 'technology_types'))
def get_connections_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                           connection_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                           display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetConnectionsFilterArgs', 'GetConnectionsFilterArgsDict']]]]] = None,
                           source_connection_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           technology_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectionsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connections = oci.DatabaseMigration.get_connections(compartment_id=compartment_id,
        connection_types=connection_connection_type,
        display_name=connection_display_name,
        source_connection_id=test_connection["id"],
        state=connection_state,
        technology_types=connection_technology_type)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param Sequence[builtins.str] connection_types: The array of connection types.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str source_connection_id: The OCID of the source database connection.
    :param builtins.str state: The current state of the Database Migration Deployment.
    :param Sequence[builtins.str] technology_types: The array of technology types.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['connectionTypes'] = connection_types
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['sourceConnectionId'] = source_connection_id
    __args__['state'] = state
    __args__['technologyTypes'] = technology_types
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseMigration/getConnections:getConnections', __args__, opts=opts, typ=GetConnectionsResult)
    return __ret__.apply(lambda __response__: GetConnectionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        connection_collections=pulumi.get(__response__, 'connection_collections'),
        connection_types=pulumi.get(__response__, 'connection_types'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        source_connection_id=pulumi.get(__response__, 'source_connection_id'),
        state=pulumi.get(__response__, 'state'),
        technology_types=pulumi.get(__response__, 'technology_types')))
