# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqlEndpointArgs', 'SqlEndpoint']

@pulumi.input_type
class SqlEndpointArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 driver_shape: pulumi.Input[builtins.str],
                 executor_shape: pulumi.Input[builtins.str],
                 max_executor_count: pulumi.Input[builtins.int],
                 metastore_id: pulumi.Input[builtins.str],
                 min_executor_count: pulumi.Input[builtins.int],
                 network_configuration: pulumi.Input['SqlEndpointNetworkConfigurationArgs'],
                 sql_endpoint_version: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape_config: Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']] = None,
                 executor_shape_config: Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 spark_advanced_configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SqlEndpoint resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The identifier of the compartment used with the SQL Endpoint.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The SQL Endpoint name, which can be changed.
        :param pulumi.Input[builtins.str] driver_shape: The shape of the SQL Endpoint driver instance.
        :param pulumi.Input[builtins.str] executor_shape: The shape of the SQL Endpoint worker instance.
        :param pulumi.Input[builtins.int] max_executor_count: (Updatable) The maximum number of executors.
        :param pulumi.Input[builtins.str] metastore_id: Metastore OCID
        :param pulumi.Input[builtins.int] min_executor_count: (Updatable) The minimum number of executors.
        :param pulumi.Input['SqlEndpointNetworkConfigurationArgs'] network_configuration: The network configuration of a SQL Endpoint.
        :param pulumi.Input[builtins.str] sql_endpoint_version: The version of the SQL Endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) The description of CreateSQLEndpointDetails.
        :param pulumi.Input['SqlEndpointDriverShapeConfigArgs'] driver_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input['SqlEndpointExecutorShapeConfigArgs'] executor_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] spark_advanced_configurations: (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the Sql Endpoint. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "driver_shape", driver_shape)
        pulumi.set(__self__, "executor_shape", executor_shape)
        pulumi.set(__self__, "max_executor_count", max_executor_count)
        pulumi.set(__self__, "metastore_id", metastore_id)
        pulumi.set(__self__, "min_executor_count", min_executor_count)
        pulumi.set(__self__, "network_configuration", network_configuration)
        pulumi.set(__self__, "sql_endpoint_version", sql_endpoint_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if driver_shape_config is not None:
            pulumi.set(__self__, "driver_shape_config", driver_shape_config)
        if executor_shape_config is not None:
            pulumi.set(__self__, "executor_shape_config", executor_shape_config)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if spark_advanced_configurations is not None:
            pulumi.set(__self__, "spark_advanced_configurations", spark_advanced_configurations)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The identifier of the compartment used with the SQL Endpoint.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The SQL Endpoint name, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> pulumi.Input[builtins.str]:
        """
        The shape of the SQL Endpoint driver instance.
        """
        return pulumi.get(self, "driver_shape")

    @driver_shape.setter
    def driver_shape(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "driver_shape", value)

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> pulumi.Input[builtins.str]:
        """
        The shape of the SQL Endpoint worker instance.
        """
        return pulumi.get(self, "executor_shape")

    @executor_shape.setter
    def executor_shape(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "executor_shape", value)

    @property
    @pulumi.getter(name="maxExecutorCount")
    def max_executor_count(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The maximum number of executors.
        """
        return pulumi.get(self, "max_executor_count")

    @max_executor_count.setter
    def max_executor_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_executor_count", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Input[builtins.str]:
        """
        Metastore OCID
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter(name="minExecutorCount")
    def min_executor_count(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The minimum number of executors.
        """
        return pulumi.get(self, "min_executor_count")

    @min_executor_count.setter
    def min_executor_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "min_executor_count", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Input['SqlEndpointNetworkConfigurationArgs']:
        """
        The network configuration of a SQL Endpoint.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: pulumi.Input['SqlEndpointNetworkConfigurationArgs']):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="sqlEndpointVersion")
    def sql_endpoint_version(self) -> pulumi.Input[builtins.str]:
        """
        The version of the SQL Endpoint.
        """
        return pulumi.get(self, "sql_endpoint_version")

    @sql_endpoint_version.setter
    def sql_endpoint_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sql_endpoint_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The description of CreateSQLEndpointDetails.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="driverShapeConfig")
    def driver_shape_config(self) -> Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']]:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_config")

    @driver_shape_config.setter
    def driver_shape_config(self, value: Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']]):
        pulumi.set(self, "driver_shape_config", value)

    @property
    @pulumi.getter(name="executorShapeConfig")
    def executor_shape_config(self) -> Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']]:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_config")

    @executor_shape_config.setter
    def executor_shape_config(self, value: Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']]):
        pulumi.set(self, "executor_shape_config", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="sparkAdvancedConfigurations")
    def spark_advanced_configurations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "spark_advanced_configurations")

    @spark_advanced_configurations.setter
    def spark_advanced_configurations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "spark_advanced_configurations", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the Sql Endpoint. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _SqlEndpointState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape_config: Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']] = None,
                 executor_shape: Optional[pulumi.Input[builtins.str]] = None,
                 executor_shape_config: Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 jdbc_endpoint_url: Optional[pulumi.Input[builtins.str]] = None,
                 lake_id: Optional[pulumi.Input[builtins.str]] = None,
                 max_executor_count: Optional[pulumi.Input[builtins.int]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 min_executor_count: Optional[pulumi.Input[builtins.int]] = None,
                 network_configuration: Optional[pulumi.Input['SqlEndpointNetworkConfigurationArgs']] = None,
                 spark_advanced_configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 sql_endpoint_version: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_message: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 warehouse_bucket_uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlEndpoint resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The identifier of the compartment used with the SQL Endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) The description of CreateSQLEndpointDetails.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The SQL Endpoint name, which can be changed.
        :param pulumi.Input[builtins.str] driver_shape: The shape of the SQL Endpoint driver instance.
        :param pulumi.Input['SqlEndpointDriverShapeConfigArgs'] driver_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[builtins.str] executor_shape: The shape of the SQL Endpoint worker instance.
        :param pulumi.Input['SqlEndpointExecutorShapeConfigArgs'] executor_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] jdbc_endpoint_url: The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        :param pulumi.Input[builtins.str] lake_id: Oracle Cloud Infrastructure lake OCID
        :param pulumi.Input[builtins.int] max_executor_count: (Updatable) The maximum number of executors.
        :param pulumi.Input[builtins.str] metastore_id: Metastore OCID
        :param pulumi.Input[builtins.int] min_executor_count: (Updatable) The minimum number of executors.
        :param pulumi.Input['SqlEndpointNetworkConfigurationArgs'] network_configuration: The network configuration of a SQL Endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] spark_advanced_configurations: (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param pulumi.Input[builtins.str] sql_endpoint_version: The version of the SQL Endpoint.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the Sql Endpoint. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state_message: A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[builtins.str] time_created: The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] warehouse_bucket_uri: The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if driver_shape is not None:
            pulumi.set(__self__, "driver_shape", driver_shape)
        if driver_shape_config is not None:
            pulumi.set(__self__, "driver_shape_config", driver_shape_config)
        if executor_shape is not None:
            pulumi.set(__self__, "executor_shape", executor_shape)
        if executor_shape_config is not None:
            pulumi.set(__self__, "executor_shape_config", executor_shape_config)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if jdbc_endpoint_url is not None:
            pulumi.set(__self__, "jdbc_endpoint_url", jdbc_endpoint_url)
        if lake_id is not None:
            pulumi.set(__self__, "lake_id", lake_id)
        if max_executor_count is not None:
            pulumi.set(__self__, "max_executor_count", max_executor_count)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if min_executor_count is not None:
            pulumi.set(__self__, "min_executor_count", min_executor_count)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if spark_advanced_configurations is not None:
            pulumi.set(__self__, "spark_advanced_configurations", spark_advanced_configurations)
        if sql_endpoint_version is not None:
            pulumi.set(__self__, "sql_endpoint_version", sql_endpoint_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_message is not None:
            pulumi.set(__self__, "state_message", state_message)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if warehouse_bucket_uri is not None:
            pulumi.set(__self__, "warehouse_bucket_uri", warehouse_bucket_uri)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The identifier of the compartment used with the SQL Endpoint.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The description of CreateSQLEndpointDetails.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The SQL Endpoint name, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The shape of the SQL Endpoint driver instance.
        """
        return pulumi.get(self, "driver_shape")

    @driver_shape.setter
    def driver_shape(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "driver_shape", value)

    @property
    @pulumi.getter(name="driverShapeConfig")
    def driver_shape_config(self) -> Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']]:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_config")

    @driver_shape_config.setter
    def driver_shape_config(self, value: Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']]):
        pulumi.set(self, "driver_shape_config", value)

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The shape of the SQL Endpoint worker instance.
        """
        return pulumi.get(self, "executor_shape")

    @executor_shape.setter
    def executor_shape(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "executor_shape", value)

    @property
    @pulumi.getter(name="executorShapeConfig")
    def executor_shape_config(self) -> Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']]:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_config")

    @executor_shape_config.setter
    def executor_shape_config(self, value: Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']]):
        pulumi.set(self, "executor_shape_config", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="jdbcEndpointUrl")
    def jdbc_endpoint_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        """
        return pulumi.get(self, "jdbc_endpoint_url")

    @jdbc_endpoint_url.setter
    def jdbc_endpoint_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "jdbc_endpoint_url", value)

    @property
    @pulumi.getter(name="lakeId")
    def lake_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Oracle Cloud Infrastructure lake OCID
        """
        return pulumi.get(self, "lake_id")

    @lake_id.setter
    def lake_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lake_id", value)

    @property
    @pulumi.getter(name="maxExecutorCount")
    def max_executor_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The maximum number of executors.
        """
        return pulumi.get(self, "max_executor_count")

    @max_executor_count.setter
    def max_executor_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_executor_count", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Metastore OCID
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter(name="minExecutorCount")
    def min_executor_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The minimum number of executors.
        """
        return pulumi.get(self, "min_executor_count")

    @min_executor_count.setter
    def min_executor_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_executor_count", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['SqlEndpointNetworkConfigurationArgs']]:
        """
        The network configuration of a SQL Endpoint.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['SqlEndpointNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="sparkAdvancedConfigurations")
    def spark_advanced_configurations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "spark_advanced_configurations")

    @spark_advanced_configurations.setter
    def spark_advanced_configurations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "spark_advanced_configurations", value)

    @property
    @pulumi.getter(name="sqlEndpointVersion")
    def sql_endpoint_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the SQL Endpoint.
        """
        return pulumi.get(self, "sql_endpoint_version")

    @sql_endpoint_version.setter
    def sql_endpoint_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sql_endpoint_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the Sql Endpoint. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "state_message")

    @state_message.setter
    def state_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_message", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
        """
        return pulumi.get(self, "warehouse_bucket_uri")

    @warehouse_bucket_uri.setter
    def warehouse_bucket_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "warehouse_bucket_uri", value)


class SqlEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape_config: Optional[pulumi.Input[Union['SqlEndpointDriverShapeConfigArgs', 'SqlEndpointDriverShapeConfigArgsDict']]] = None,
                 executor_shape: Optional[pulumi.Input[builtins.str]] = None,
                 executor_shape_config: Optional[pulumi.Input[Union['SqlEndpointExecutorShapeConfigArgs', 'SqlEndpointExecutorShapeConfigArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 max_executor_count: Optional[pulumi.Input[builtins.int]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 min_executor_count: Optional[pulumi.Input[builtins.int]] = None,
                 network_configuration: Optional[pulumi.Input[Union['SqlEndpointNetworkConfigurationArgs', 'SqlEndpointNetworkConfigurationArgsDict']]] = None,
                 spark_advanced_configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 sql_endpoint_version: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Sql Endpoint resource in Oracle Cloud Infrastructure Data Flow service.
        ## Note

        Resource Discovery is not supported for this resource.

        Create a new Sql Endpoint.

        ## Import

        SqlEndpoints can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataFlow/sqlEndpoint:SqlEndpoint test_sql_endpoint "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The identifier of the compartment used with the SQL Endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) The description of CreateSQLEndpointDetails.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The SQL Endpoint name, which can be changed.
        :param pulumi.Input[builtins.str] driver_shape: The shape of the SQL Endpoint driver instance.
        :param pulumi.Input[Union['SqlEndpointDriverShapeConfigArgs', 'SqlEndpointDriverShapeConfigArgsDict']] driver_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[builtins.str] executor_shape: The shape of the SQL Endpoint worker instance.
        :param pulumi.Input[Union['SqlEndpointExecutorShapeConfigArgs', 'SqlEndpointExecutorShapeConfigArgsDict']] executor_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.int] max_executor_count: (Updatable) The maximum number of executors.
        :param pulumi.Input[builtins.str] metastore_id: Metastore OCID
        :param pulumi.Input[builtins.int] min_executor_count: (Updatable) The minimum number of executors.
        :param pulumi.Input[Union['SqlEndpointNetworkConfigurationArgs', 'SqlEndpointNetworkConfigurationArgsDict']] network_configuration: The network configuration of a SQL Endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] spark_advanced_configurations: (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param pulumi.Input[builtins.str] sql_endpoint_version: The version of the SQL Endpoint.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the Sql Endpoint. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Sql Endpoint resource in Oracle Cloud Infrastructure Data Flow service.
        ## Note

        Resource Discovery is not supported for this resource.

        Create a new Sql Endpoint.

        ## Import

        SqlEndpoints can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataFlow/sqlEndpoint:SqlEndpoint test_sql_endpoint "id"
        ```

        :param str resource_name: The name of the resource.
        :param SqlEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape: Optional[pulumi.Input[builtins.str]] = None,
                 driver_shape_config: Optional[pulumi.Input[Union['SqlEndpointDriverShapeConfigArgs', 'SqlEndpointDriverShapeConfigArgsDict']]] = None,
                 executor_shape: Optional[pulumi.Input[builtins.str]] = None,
                 executor_shape_config: Optional[pulumi.Input[Union['SqlEndpointExecutorShapeConfigArgs', 'SqlEndpointExecutorShapeConfigArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 max_executor_count: Optional[pulumi.Input[builtins.int]] = None,
                 metastore_id: Optional[pulumi.Input[builtins.str]] = None,
                 min_executor_count: Optional[pulumi.Input[builtins.int]] = None,
                 network_configuration: Optional[pulumi.Input[Union['SqlEndpointNetworkConfigurationArgs', 'SqlEndpointNetworkConfigurationArgsDict']]] = None,
                 spark_advanced_configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 sql_endpoint_version: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlEndpointArgs.__new__(SqlEndpointArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if driver_shape is None and not opts.urn:
                raise TypeError("Missing required property 'driver_shape'")
            __props__.__dict__["driver_shape"] = driver_shape
            __props__.__dict__["driver_shape_config"] = driver_shape_config
            if executor_shape is None and not opts.urn:
                raise TypeError("Missing required property 'executor_shape'")
            __props__.__dict__["executor_shape"] = executor_shape
            __props__.__dict__["executor_shape_config"] = executor_shape_config
            __props__.__dict__["freeform_tags"] = freeform_tags
            if max_executor_count is None and not opts.urn:
                raise TypeError("Missing required property 'max_executor_count'")
            __props__.__dict__["max_executor_count"] = max_executor_count
            if metastore_id is None and not opts.urn:
                raise TypeError("Missing required property 'metastore_id'")
            __props__.__dict__["metastore_id"] = metastore_id
            if min_executor_count is None and not opts.urn:
                raise TypeError("Missing required property 'min_executor_count'")
            __props__.__dict__["min_executor_count"] = min_executor_count
            if network_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'network_configuration'")
            __props__.__dict__["network_configuration"] = network_configuration
            __props__.__dict__["spark_advanced_configurations"] = spark_advanced_configurations
            if sql_endpoint_version is None and not opts.urn:
                raise TypeError("Missing required property 'sql_endpoint_version'")
            __props__.__dict__["sql_endpoint_version"] = sql_endpoint_version
            __props__.__dict__["state"] = state
            __props__.__dict__["jdbc_endpoint_url"] = None
            __props__.__dict__["lake_id"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["warehouse_bucket_uri"] = None
        super(SqlEndpoint, __self__).__init__(
            'oci:DataFlow/sqlEndpoint:SqlEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            driver_shape: Optional[pulumi.Input[builtins.str]] = None,
            driver_shape_config: Optional[pulumi.Input[Union['SqlEndpointDriverShapeConfigArgs', 'SqlEndpointDriverShapeConfigArgsDict']]] = None,
            executor_shape: Optional[pulumi.Input[builtins.str]] = None,
            executor_shape_config: Optional[pulumi.Input[Union['SqlEndpointExecutorShapeConfigArgs', 'SqlEndpointExecutorShapeConfigArgsDict']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            jdbc_endpoint_url: Optional[pulumi.Input[builtins.str]] = None,
            lake_id: Optional[pulumi.Input[builtins.str]] = None,
            max_executor_count: Optional[pulumi.Input[builtins.int]] = None,
            metastore_id: Optional[pulumi.Input[builtins.str]] = None,
            min_executor_count: Optional[pulumi.Input[builtins.int]] = None,
            network_configuration: Optional[pulumi.Input[Union['SqlEndpointNetworkConfigurationArgs', 'SqlEndpointNetworkConfigurationArgsDict']]] = None,
            spark_advanced_configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            sql_endpoint_version: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            state_message: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            warehouse_bucket_uri: Optional[pulumi.Input[builtins.str]] = None) -> 'SqlEndpoint':
        """
        Get an existing SqlEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The identifier of the compartment used with the SQL Endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) The description of CreateSQLEndpointDetails.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The SQL Endpoint name, which can be changed.
        :param pulumi.Input[builtins.str] driver_shape: The shape of the SQL Endpoint driver instance.
        :param pulumi.Input[Union['SqlEndpointDriverShapeConfigArgs', 'SqlEndpointDriverShapeConfigArgsDict']] driver_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[builtins.str] executor_shape: The shape of the SQL Endpoint worker instance.
        :param pulumi.Input[Union['SqlEndpointExecutorShapeConfigArgs', 'SqlEndpointExecutorShapeConfigArgsDict']] executor_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] jdbc_endpoint_url: The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        :param pulumi.Input[builtins.str] lake_id: Oracle Cloud Infrastructure lake OCID
        :param pulumi.Input[builtins.int] max_executor_count: (Updatable) The maximum number of executors.
        :param pulumi.Input[builtins.str] metastore_id: Metastore OCID
        :param pulumi.Input[builtins.int] min_executor_count: (Updatable) The minimum number of executors.
        :param pulumi.Input[Union['SqlEndpointNetworkConfigurationArgs', 'SqlEndpointNetworkConfigurationArgsDict']] network_configuration: The network configuration of a SQL Endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] spark_advanced_configurations: (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param pulumi.Input[builtins.str] sql_endpoint_version: The version of the SQL Endpoint.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the Sql Endpoint. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state_message: A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[builtins.str] time_created: The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] warehouse_bucket_uri: The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlEndpointState.__new__(_SqlEndpointState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["driver_shape"] = driver_shape
        __props__.__dict__["driver_shape_config"] = driver_shape_config
        __props__.__dict__["executor_shape"] = executor_shape
        __props__.__dict__["executor_shape_config"] = executor_shape_config
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["jdbc_endpoint_url"] = jdbc_endpoint_url
        __props__.__dict__["lake_id"] = lake_id
        __props__.__dict__["max_executor_count"] = max_executor_count
        __props__.__dict__["metastore_id"] = metastore_id
        __props__.__dict__["min_executor_count"] = min_executor_count
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["spark_advanced_configurations"] = spark_advanced_configurations
        __props__.__dict__["sql_endpoint_version"] = sql_endpoint_version
        __props__.__dict__["state"] = state
        __props__.__dict__["state_message"] = state_message
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["warehouse_bucket_uri"] = warehouse_bucket_uri
        return SqlEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The identifier of the compartment used with the SQL Endpoint.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The description of CreateSQLEndpointDetails.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The SQL Endpoint name, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> pulumi.Output[builtins.str]:
        """
        The shape of the SQL Endpoint driver instance.
        """
        return pulumi.get(self, "driver_shape")

    @property
    @pulumi.getter(name="driverShapeConfig")
    def driver_shape_config(self) -> pulumi.Output['outputs.SqlEndpointDriverShapeConfig']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_config")

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> pulumi.Output[builtins.str]:
        """
        The shape of the SQL Endpoint worker instance.
        """
        return pulumi.get(self, "executor_shape")

    @property
    @pulumi.getter(name="executorShapeConfig")
    def executor_shape_config(self) -> pulumi.Output['outputs.SqlEndpointExecutorShapeConfig']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_config")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="jdbcEndpointUrl")
    def jdbc_endpoint_url(self) -> pulumi.Output[builtins.str]:
        """
        The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        """
        return pulumi.get(self, "jdbc_endpoint_url")

    @property
    @pulumi.getter(name="lakeId")
    def lake_id(self) -> pulumi.Output[builtins.str]:
        """
        Oracle Cloud Infrastructure lake OCID
        """
        return pulumi.get(self, "lake_id")

    @property
    @pulumi.getter(name="maxExecutorCount")
    def max_executor_count(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The maximum number of executors.
        """
        return pulumi.get(self, "max_executor_count")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Output[builtins.str]:
        """
        Metastore OCID
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="minExecutorCount")
    def min_executor_count(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The minimum number of executors.
        """
        return pulumi.get(self, "min_executor_count")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output['outputs.SqlEndpointNetworkConfiguration']:
        """
        The network configuration of a SQL Endpoint.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="sparkAdvancedConfigurations")
    def spark_advanced_configurations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "spark_advanced_configurations")

    @property
    @pulumi.getter(name="sqlEndpointVersion")
    def sql_endpoint_version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the SQL Endpoint.
        """
        return pulumi.get(self, "sql_endpoint_version")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The target state for the Sql Endpoint. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> pulumi.Output[builtins.str]:
        """
        The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
        """
        return pulumi.get(self, "warehouse_bucket_uri")

