# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMlApplicationInstancesResult',
    'AwaitableGetMlApplicationInstancesResult',
    'get_ml_application_instances',
    'get_ml_application_instances_output',
]

@pulumi.output_type
class GetMlApplicationInstancesResult:
    """
    A collection of values returned by getMlApplicationInstances.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, ml_application_id=None, ml_application_instance_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ml_application_id and not isinstance(ml_application_id, str):
            raise TypeError("Expected argument 'ml_application_id' to be a str")
        pulumi.set(__self__, "ml_application_id", ml_application_id)
        if ml_application_instance_collections and not isinstance(ml_application_instance_collections, list):
            raise TypeError("Expected argument 'ml_application_instance_collections' to be a list")
        pulumi.set(__self__, "ml_application_instance_collections", ml_application_instance_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment where the MlApplicationInstance is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The name of MlApplicationInstance. System will generate displayName when not provided during creation.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMlApplicationInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mlApplicationId")
    def ml_application_id(self) -> Optional[builtins.str]:
        """
        The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.
        """
        return pulumi.get(self, "ml_application_id")

    @property
    @pulumi.getter(name="mlApplicationInstanceCollections")
    def ml_application_instance_collections(self) -> Sequence['outputs.GetMlApplicationInstancesMlApplicationInstanceCollectionResult']:
        """
        The list of ml_application_instance_collection.
        """
        return pulumi.get(self, "ml_application_instance_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the MlApplicationInstance.
        """
        return pulumi.get(self, "state")


class AwaitableGetMlApplicationInstancesResult(GetMlApplicationInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMlApplicationInstancesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            ml_application_id=self.ml_application_id,
            ml_application_instance_collections=self.ml_application_instance_collections,
            state=self.state)


def get_ml_application_instances(compartment_id: Optional[builtins.str] = None,
                                 display_name: Optional[builtins.str] = None,
                                 filters: Optional[Sequence[Union['GetMlApplicationInstancesFilterArgs', 'GetMlApplicationInstancesFilterArgsDict']]] = None,
                                 ml_application_id: Optional[builtins.str] = None,
                                 state: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMlApplicationInstancesResult:
    """
    This data source provides the list of Ml Application Instances in Oracle Cloud Infrastructure Data Science service.

    Returns a list of MlApplicationsInstances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ml_application_instances = oci.DataScience.get_ml_application_instances(compartment_id=compartment_id,
        display_name=ml_application_instance_display_name,
        ml_application_id=test_ml_application["id"],
        state=ml_application_instance_state)
    ```


    :param builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str display_name: <b>Filter</b> results by its user-friendly name.
    :param builtins.str ml_application_id: unique MlApplication identifier
    :param builtins.str state: A filter to return only resources matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['mlApplicationId'] = ml_application_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getMlApplicationInstances:getMlApplicationInstances', __args__, opts=opts, typ=GetMlApplicationInstancesResult).value

    return AwaitableGetMlApplicationInstancesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ml_application_id=pulumi.get(__ret__, 'ml_application_id'),
        ml_application_instance_collections=pulumi.get(__ret__, 'ml_application_instance_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_ml_application_instances_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                        display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMlApplicationInstancesFilterArgs', 'GetMlApplicationInstancesFilterArgsDict']]]]] = None,
                                        ml_application_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMlApplicationInstancesResult]:
    """
    This data source provides the list of Ml Application Instances in Oracle Cloud Infrastructure Data Science service.

    Returns a list of MlApplicationsInstances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ml_application_instances = oci.DataScience.get_ml_application_instances(compartment_id=compartment_id,
        display_name=ml_application_instance_display_name,
        ml_application_id=test_ml_application["id"],
        state=ml_application_instance_state)
    ```


    :param builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str display_name: <b>Filter</b> results by its user-friendly name.
    :param builtins.str ml_application_id: unique MlApplication identifier
    :param builtins.str state: A filter to return only resources matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['mlApplicationId'] = ml_application_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getMlApplicationInstances:getMlApplicationInstances', __args__, opts=opts, typ=GetMlApplicationInstancesResult)
    return __ret__.apply(lambda __response__: GetMlApplicationInstancesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ml_application_id=pulumi.get(__response__, 'ml_application_id'),
        ml_application_instance_collections=pulumi.get(__response__, 'ml_application_instance_collections'),
        state=pulumi.get(__response__, 'state')))
