# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDesktopPoolDesktopsResult',
    'AwaitableGetDesktopPoolDesktopsResult',
    'get_desktop_pool_desktops',
    'get_desktop_pool_desktops_output',
]

@pulumi.output_type
class GetDesktopPoolDesktopsResult:
    """
    A collection of values returned by getDesktopPoolDesktops.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, desktop_pool_desktop_collections=None, desktop_pool_id=None, display_name=None, filters=None, id=None, state=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if desktop_pool_desktop_collections and not isinstance(desktop_pool_desktop_collections, list):
            raise TypeError("Expected argument 'desktop_pool_desktop_collections' to be a list")
        pulumi.set(__self__, "desktop_pool_desktop_collections", desktop_pool_desktop_collections)
        if desktop_pool_id and not isinstance(desktop_pool_id, str):
            raise TypeError("Expected argument 'desktop_pool_id' to be a str")
        pulumi.set(__self__, "desktop_pool_id", desktop_pool_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[builtins.str]:
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="desktopPoolDesktopCollections")
    def desktop_pool_desktop_collections(self) -> Sequence['outputs.GetDesktopPoolDesktopsDesktopPoolDesktopCollectionResult']:
        """
        The list of desktop_pool_desktop_collection.
        """
        return pulumi.get(self, "desktop_pool_desktop_collections")

    @property
    @pulumi.getter(name="desktopPoolId")
    def desktop_pool_id(self) -> builtins.str:
        return pulumi.get(self, "desktop_pool_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDesktopPoolDesktopsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state of the desktop.
        """
        return pulumi.get(self, "state")


class AwaitableGetDesktopPoolDesktopsResult(GetDesktopPoolDesktopsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDesktopPoolDesktopsResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            desktop_pool_desktop_collections=self.desktop_pool_desktop_collections,
            desktop_pool_id=self.desktop_pool_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_desktop_pool_desktops(availability_domain: Optional[builtins.str] = None,
                              compartment_id: Optional[builtins.str] = None,
                              desktop_pool_id: Optional[builtins.str] = None,
                              display_name: Optional[builtins.str] = None,
                              filters: Optional[Sequence[Union['GetDesktopPoolDesktopsFilterArgs', 'GetDesktopPoolDesktopsFilterArgsDict']]] = None,
                              id: Optional[builtins.str] = None,
                              state: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDesktopPoolDesktopsResult:
    """
    This data source provides the list of Desktop Pool Desktops in Oracle Cloud Infrastructure Desktops service.

    Returns a list of desktops within a given desktop pool. You can limit the results to an availability domain, desktop name, or desktop state. You can limit the number of results returned, sort the results by time or name, and sort in ascending or descending order.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_desktop_pool_desktops = oci.Desktops.get_desktop_pool_desktops(compartment_id=compartment_id,
        desktop_pool_id=test_desktop_pool["id"],
        availability_domain=desktop_pool_desktop_availability_domain,
        display_name=desktop_pool_desktop_display_name,
        id=desktop_pool_desktop_id,
        state=desktop_pool_desktop_state)
    ```


    :param builtins.str availability_domain: The name of the availability domain.
    :param builtins.str compartment_id: The OCID of the compartment of the desktop pool.
    :param builtins.str desktop_pool_id: The OCID of the desktop pool.
    :param builtins.str display_name: A filter to return only results with the given displayName.
    :param builtins.str id: A filter to return only results with the given OCID.
    :param builtins.str state: A filter to return only results with the given lifecycleState.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['desktopPoolId'] = desktop_pool_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Desktops/getDesktopPoolDesktops:getDesktopPoolDesktops', __args__, opts=opts, typ=GetDesktopPoolDesktopsResult).value

    return AwaitableGetDesktopPoolDesktopsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        desktop_pool_desktop_collections=pulumi.get(__ret__, 'desktop_pool_desktop_collections'),
        desktop_pool_id=pulumi.get(__ret__, 'desktop_pool_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_desktop_pool_desktops_output(availability_domain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                     desktop_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                                     display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDesktopPoolDesktopsFilterArgs', 'GetDesktopPoolDesktopsFilterArgsDict']]]]] = None,
                                     id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDesktopPoolDesktopsResult]:
    """
    This data source provides the list of Desktop Pool Desktops in Oracle Cloud Infrastructure Desktops service.

    Returns a list of desktops within a given desktop pool. You can limit the results to an availability domain, desktop name, or desktop state. You can limit the number of results returned, sort the results by time or name, and sort in ascending or descending order.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_desktop_pool_desktops = oci.Desktops.get_desktop_pool_desktops(compartment_id=compartment_id,
        desktop_pool_id=test_desktop_pool["id"],
        availability_domain=desktop_pool_desktop_availability_domain,
        display_name=desktop_pool_desktop_display_name,
        id=desktop_pool_desktop_id,
        state=desktop_pool_desktop_state)
    ```


    :param builtins.str availability_domain: The name of the availability domain.
    :param builtins.str compartment_id: The OCID of the compartment of the desktop pool.
    :param builtins.str desktop_pool_id: The OCID of the desktop pool.
    :param builtins.str display_name: A filter to return only results with the given displayName.
    :param builtins.str id: A filter to return only results with the given OCID.
    :param builtins.str state: A filter to return only results with the given lifecycleState.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['desktopPoolId'] = desktop_pool_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Desktops/getDesktopPoolDesktops:getDesktopPoolDesktops', __args__, opts=opts, typ=GetDesktopPoolDesktopsResult)
    return __ret__.apply(lambda __response__: GetDesktopPoolDesktopsResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        desktop_pool_desktop_collections=pulumi.get(__response__, 'desktop_pool_desktop_collections'),
        desktop_pool_id=pulumi.get(__response__, 'desktop_pool_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
