# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetComplianceRecordCountsResult',
    'AwaitableGetComplianceRecordCountsResult',
    'get_compliance_record_counts',
    'get_compliance_record_counts_output',
]

@pulumi.output_type
class GetComplianceRecordCountsResult:
    """
    A collection of values returned by getComplianceRecordCounts.
    """
    def __init__(__self__, compartment_id=None, compliance_record_aggregation_collections=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compliance_record_aggregation_collections and not isinstance(compliance_record_aggregation_collections, list):
            raise TypeError("Expected argument 'compliance_record_aggregation_collections' to be a list")
        pulumi.set(__self__, "compliance_record_aggregation_collections", compliance_record_aggregation_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="complianceRecordAggregationCollections")
    def compliance_record_aggregation_collections(self) -> Sequence['outputs.GetComplianceRecordCountsComplianceRecordAggregationCollectionResult']:
        """
        The list of compliance_record_aggregation_collection.
        """
        return pulumi.get(self, "compliance_record_aggregation_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetComplianceRecordCountsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetComplianceRecordCountsResult(GetComplianceRecordCountsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComplianceRecordCountsResult(
            compartment_id=self.compartment_id,
            compliance_record_aggregation_collections=self.compliance_record_aggregation_collections,
            filters=self.filters,
            id=self.id)


def get_compliance_record_counts(compartment_id: Optional[builtins.str] = None,
                                 filters: Optional[Sequence[Union['GetComplianceRecordCountsFilterArgs', 'GetComplianceRecordCountsFilterArgsDict']]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComplianceRecordCountsResult:
    """
    This data source provides the list of Compliance Record Counts in Oracle Cloud Infrastructure Fleet Apps Management service.

    Retrieve  aggregated summary information of ComplianceRecords within a Tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compliance_record_counts = oci.FleetAppsManagement.get_compliance_record_counts(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getComplianceRecordCounts:getComplianceRecordCounts', __args__, opts=opts, typ=GetComplianceRecordCountsResult).value

    return AwaitableGetComplianceRecordCountsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compliance_record_aggregation_collections=pulumi.get(__ret__, 'compliance_record_aggregation_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_compliance_record_counts_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetComplianceRecordCountsFilterArgs', 'GetComplianceRecordCountsFilterArgsDict']]]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComplianceRecordCountsResult]:
    """
    This data source provides the list of Compliance Record Counts in Oracle Cloud Infrastructure Fleet Apps Management service.

    Retrieve  aggregated summary information of ComplianceRecords within a Tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compliance_record_counts = oci.FleetAppsManagement.get_compliance_record_counts(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getComplianceRecordCounts:getComplianceRecordCounts', __args__, opts=opts, typ=GetComplianceRecordCountsResult)
    return __ret__.apply(lambda __response__: GetComplianceRecordCountsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compliance_record_aggregation_collections=pulumi.get(__response__, 'compliance_record_aggregation_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
