# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetPerformanceTuningAnalysisResultsResult',
    'AwaitableGetFleetPerformanceTuningAnalysisResultsResult',
    'get_fleet_performance_tuning_analysis_results',
    'get_fleet_performance_tuning_analysis_results_output',
]

@pulumi.output_type
class GetFleetPerformanceTuningAnalysisResultsResult:
    """
    A collection of values returned by getFleetPerformanceTuningAnalysisResults.
    """
    def __init__(__self__, application_id=None, application_name=None, filters=None, fleet_id=None, host_name=None, id=None, managed_instance_id=None, performance_tuning_analysis_result_collections=None, time_end=None, time_start=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if application_name and not isinstance(application_name, str):
            raise TypeError("Expected argument 'application_name' to be a str")
        pulumi.set(__self__, "application_name", application_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if performance_tuning_analysis_result_collections and not isinstance(performance_tuning_analysis_result_collections, list):
            raise TypeError("Expected argument 'performance_tuning_analysis_result_collections' to be a list")
        pulumi.set(__self__, "performance_tuning_analysis_result_collections", performance_tuning_analysis_result_collections)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[builtins.str]:
        """
        The OCID of the application for which the report has been generated.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[builtins.str]:
        """
        The name of the application for which the report has been generated.
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetPerformanceTuningAnalysisResultsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> builtins.str:
        """
        The fleet OCID.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[builtins.str]:
        """
        The hostname of the managed instance.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[builtins.str]:
        """
        The managed instance OCID.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="performanceTuningAnalysisResultCollections")
    def performance_tuning_analysis_result_collections(self) -> Sequence['outputs.GetFleetPerformanceTuningAnalysisResultsPerformanceTuningAnalysisResultCollectionResult']:
        """
        The list of performance_tuning_analysis_result_collection.
        """
        return pulumi.get(self, "performance_tuning_analysis_result_collections")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_start")


class AwaitableGetFleetPerformanceTuningAnalysisResultsResult(GetFleetPerformanceTuningAnalysisResultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetPerformanceTuningAnalysisResultsResult(
            application_id=self.application_id,
            application_name=self.application_name,
            filters=self.filters,
            fleet_id=self.fleet_id,
            host_name=self.host_name,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            performance_tuning_analysis_result_collections=self.performance_tuning_analysis_result_collections,
            time_end=self.time_end,
            time_start=self.time_start)


def get_fleet_performance_tuning_analysis_results(application_id: Optional[builtins.str] = None,
                                                  application_name: Optional[builtins.str] = None,
                                                  filters: Optional[Sequence[Union['GetFleetPerformanceTuningAnalysisResultsFilterArgs', 'GetFleetPerformanceTuningAnalysisResultsFilterArgsDict']]] = None,
                                                  fleet_id: Optional[builtins.str] = None,
                                                  host_name: Optional[builtins.str] = None,
                                                  managed_instance_id: Optional[builtins.str] = None,
                                                  time_end: Optional[builtins.str] = None,
                                                  time_start: Optional[builtins.str] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetPerformanceTuningAnalysisResultsResult:
    """
    This data source provides the list of Fleet Performance Tuning Analysis Results in Oracle Cloud Infrastructure Jms service.

    List Performance Tuning Analysis results.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_performance_tuning_analysis_results = oci.Jms.get_fleet_performance_tuning_analysis_results(fleet_id=test_fleet["id"],
        application_id=fleet_performance_tuning_analysis_result_application_id,
        application_name=fleet_performance_tuning_analysis_result_application_name,
        host_name=fleet_performance_tuning_analysis_result_host_name,
        managed_instance_id=fleet_performance_tuning_analysis_result_managed_instance_id,
        time_end=fleet_performance_tuning_analysis_result_time_end,
        time_start=fleet_performance_tuning_analysis_result_time_start)
    ```


    :param builtins.str application_id: The Fleet-unique identifier of the related application.
    :param builtins.str application_name: The name of the application.
    :param builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param builtins.str host_name: The host [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    :param builtins.str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param builtins.str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param builtins.str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['applicationName'] = application_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['hostName'] = host_name
    __args__['managedInstanceId'] = managed_instance_id
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetPerformanceTuningAnalysisResults:getFleetPerformanceTuningAnalysisResults', __args__, opts=opts, typ=GetFleetPerformanceTuningAnalysisResultsResult).value

    return AwaitableGetFleetPerformanceTuningAnalysisResultsResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        application_name=pulumi.get(__ret__, 'application_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        host_name=pulumi.get(__ret__, 'host_name'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        performance_tuning_analysis_result_collections=pulumi.get(__ret__, 'performance_tuning_analysis_result_collections'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))
def get_fleet_performance_tuning_analysis_results_output(application_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                         application_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetPerformanceTuningAnalysisResultsFilterArgs', 'GetFleetPerformanceTuningAnalysisResultsFilterArgsDict']]]]] = None,
                                                         fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                                                         host_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                         managed_instance_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                         time_end: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                         time_start: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetPerformanceTuningAnalysisResultsResult]:
    """
    This data source provides the list of Fleet Performance Tuning Analysis Results in Oracle Cloud Infrastructure Jms service.

    List Performance Tuning Analysis results.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_performance_tuning_analysis_results = oci.Jms.get_fleet_performance_tuning_analysis_results(fleet_id=test_fleet["id"],
        application_id=fleet_performance_tuning_analysis_result_application_id,
        application_name=fleet_performance_tuning_analysis_result_application_name,
        host_name=fleet_performance_tuning_analysis_result_host_name,
        managed_instance_id=fleet_performance_tuning_analysis_result_managed_instance_id,
        time_end=fleet_performance_tuning_analysis_result_time_end,
        time_start=fleet_performance_tuning_analysis_result_time_start)
    ```


    :param builtins.str application_id: The Fleet-unique identifier of the related application.
    :param builtins.str application_name: The name of the application.
    :param builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param builtins.str host_name: The host [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    :param builtins.str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param builtins.str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param builtins.str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['applicationName'] = application_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['hostName'] = host_name
    __args__['managedInstanceId'] = managed_instance_id
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetPerformanceTuningAnalysisResults:getFleetPerformanceTuningAnalysisResults', __args__, opts=opts, typ=GetFleetPerformanceTuningAnalysisResultsResult)
    return __ret__.apply(lambda __response__: GetFleetPerformanceTuningAnalysisResultsResult(
        application_id=pulumi.get(__response__, 'application_id'),
        application_name=pulumi.get(__response__, 'application_name'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        host_name=pulumi.get(__response__, 'host_name'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        performance_tuning_analysis_result_collections=pulumi.get(__response__, 'performance_tuning_analysis_result_collections'),
        time_end=pulumi.get(__response__, 'time_end'),
        time_start=pulumi.get(__response__, 'time_start')))
