# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetComputedUsageResult',
    'AwaitableGetComputedUsageResult',
    'get_computed_usage',
    'get_computed_usage_output',
]

@pulumi.output_type
class GetComputedUsageResult:
    """
    A collection of values returned by getComputedUsage.
    """
    def __init__(__self__, commitment_service_id=None, compartment_id=None, compute_source=None, computed_usage_id=None, cost=None, cost_rounded=None, currency_code=None, data_center=None, fields=None, id=None, is_invoiced=None, mqs_message_id=None, net_unit_price=None, original_usage_number=None, parent_products=None, parent_subscribed_service_id=None, plan_number=None, products=None, quantity=None, rate_card_id=None, rate_card_tierd_id=None, time_created=None, time_metered_on=None, time_of_arrival=None, time_updated=None, type=None, unit_of_measure=None, usage_number=None):
        if commitment_service_id and not isinstance(commitment_service_id, str):
            raise TypeError("Expected argument 'commitment_service_id' to be a str")
        pulumi.set(__self__, "commitment_service_id", commitment_service_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_source and not isinstance(compute_source, str):
            raise TypeError("Expected argument 'compute_source' to be a str")
        pulumi.set(__self__, "compute_source", compute_source)
        if computed_usage_id and not isinstance(computed_usage_id, str):
            raise TypeError("Expected argument 'computed_usage_id' to be a str")
        pulumi.set(__self__, "computed_usage_id", computed_usage_id)
        if cost and not isinstance(cost, str):
            raise TypeError("Expected argument 'cost' to be a str")
        pulumi.set(__self__, "cost", cost)
        if cost_rounded and not isinstance(cost_rounded, str):
            raise TypeError("Expected argument 'cost_rounded' to be a str")
        pulumi.set(__self__, "cost_rounded", cost_rounded)
        if currency_code and not isinstance(currency_code, str):
            raise TypeError("Expected argument 'currency_code' to be a str")
        pulumi.set(__self__, "currency_code", currency_code)
        if data_center and not isinstance(data_center, str):
            raise TypeError("Expected argument 'data_center' to be a str")
        pulumi.set(__self__, "data_center", data_center)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_invoiced and not isinstance(is_invoiced, bool):
            raise TypeError("Expected argument 'is_invoiced' to be a bool")
        pulumi.set(__self__, "is_invoiced", is_invoiced)
        if mqs_message_id and not isinstance(mqs_message_id, str):
            raise TypeError("Expected argument 'mqs_message_id' to be a str")
        pulumi.set(__self__, "mqs_message_id", mqs_message_id)
        if net_unit_price and not isinstance(net_unit_price, str):
            raise TypeError("Expected argument 'net_unit_price' to be a str")
        pulumi.set(__self__, "net_unit_price", net_unit_price)
        if original_usage_number and not isinstance(original_usage_number, str):
            raise TypeError("Expected argument 'original_usage_number' to be a str")
        pulumi.set(__self__, "original_usage_number", original_usage_number)
        if parent_products and not isinstance(parent_products, list):
            raise TypeError("Expected argument 'parent_products' to be a list")
        pulumi.set(__self__, "parent_products", parent_products)
        if parent_subscribed_service_id and not isinstance(parent_subscribed_service_id, str):
            raise TypeError("Expected argument 'parent_subscribed_service_id' to be a str")
        pulumi.set(__self__, "parent_subscribed_service_id", parent_subscribed_service_id)
        if plan_number and not isinstance(plan_number, str):
            raise TypeError("Expected argument 'plan_number' to be a str")
        pulumi.set(__self__, "plan_number", plan_number)
        if products and not isinstance(products, list):
            raise TypeError("Expected argument 'products' to be a list")
        pulumi.set(__self__, "products", products)
        if quantity and not isinstance(quantity, str):
            raise TypeError("Expected argument 'quantity' to be a str")
        pulumi.set(__self__, "quantity", quantity)
        if rate_card_id and not isinstance(rate_card_id, str):
            raise TypeError("Expected argument 'rate_card_id' to be a str")
        pulumi.set(__self__, "rate_card_id", rate_card_id)
        if rate_card_tierd_id and not isinstance(rate_card_tierd_id, str):
            raise TypeError("Expected argument 'rate_card_tierd_id' to be a str")
        pulumi.set(__self__, "rate_card_tierd_id", rate_card_tierd_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_metered_on and not isinstance(time_metered_on, str):
            raise TypeError("Expected argument 'time_metered_on' to be a str")
        pulumi.set(__self__, "time_metered_on", time_metered_on)
        if time_of_arrival and not isinstance(time_of_arrival, str):
            raise TypeError("Expected argument 'time_of_arrival' to be a str")
        pulumi.set(__self__, "time_of_arrival", time_of_arrival)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if unit_of_measure and not isinstance(unit_of_measure, str):
            raise TypeError("Expected argument 'unit_of_measure' to be a str")
        pulumi.set(__self__, "unit_of_measure", unit_of_measure)
        if usage_number and not isinstance(usage_number, str):
            raise TypeError("Expected argument 'usage_number' to be a str")
        pulumi.set(__self__, "usage_number", usage_number)

    @property
    @pulumi.getter(name="commitmentServiceId")
    def commitment_service_id(self) -> builtins.str:
        """
        Subscribed service commitmentId.
        """
        return pulumi.get(self, "commitment_service_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeSource")
    def compute_source(self) -> builtins.str:
        """
        SPM Internal compute records source .
        """
        return pulumi.get(self, "compute_source")

    @property
    @pulumi.getter(name="computedUsageId")
    def computed_usage_id(self) -> builtins.str:
        return pulumi.get(self, "computed_usage_id")

    @property
    @pulumi.getter
    def cost(self) -> builtins.str:
        """
        Computed Line Amount not rounded
        """
        return pulumi.get(self, "cost")

    @property
    @pulumi.getter(name="costRounded")
    def cost_rounded(self) -> builtins.str:
        """
        Computed Line Amount rounded.
        """
        return pulumi.get(self, "cost_rounded")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> builtins.str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> builtins.str:
        """
        Data Center Attribute as sent by MQS to SPM.
        """
        return pulumi.get(self, "data_center")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isInvoiced")
    def is_invoiced(self) -> builtins.bool:
        """
        Invoicing status for the aggregated compute usage
        """
        return pulumi.get(self, "is_invoiced")

    @property
    @pulumi.getter(name="mqsMessageId")
    def mqs_message_id(self) -> builtins.str:
        """
        MQS Identfier send to SPM , SPM does not transform this attribute and is received as is.
        """
        return pulumi.get(self, "mqs_message_id")

    @property
    @pulumi.getter(name="netUnitPrice")
    def net_unit_price(self) -> builtins.str:
        """
        Net Unit Price for the product in consideration, price actual.
        """
        return pulumi.get(self, "net_unit_price")

    @property
    @pulumi.getter(name="originalUsageNumber")
    def original_usage_number(self) -> builtins.str:
        """
        SPM Internal Original usage Line number identifier in SPM coming from Metered Services entity.
        """
        return pulumi.get(self, "original_usage_number")

    @property
    @pulumi.getter(name="parentProducts")
    def parent_products(self) -> Sequence['outputs.GetComputedUsageParentProductResult']:
        """
        Product description
        """
        return pulumi.get(self, "parent_products")

    @property
    @pulumi.getter(name="parentSubscribedServiceId")
    def parent_subscribed_service_id(self) -> builtins.str:
        """
        Subscribed service line parent id
        """
        return pulumi.get(self, "parent_subscribed_service_id")

    @property
    @pulumi.getter(name="planNumber")
    def plan_number(self) -> builtins.str:
        """
        Subscription plan number
        """
        return pulumi.get(self, "plan_number")

    @property
    @pulumi.getter
    def products(self) -> Sequence['outputs.GetComputedUsageProductResult']:
        """
        Product description
        """
        return pulumi.get(self, "products")

    @property
    @pulumi.getter
    def quantity(self) -> builtins.str:
        """
        Total Quantity that was used for computation
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter(name="rateCardId")
    def rate_card_id(self) -> builtins.str:
        """
        Ratecard Id at subscribed service level
        """
        return pulumi.get(self, "rate_card_id")

    @property
    @pulumi.getter(name="rateCardTierdId")
    def rate_card_tierd_id(self) -> builtins.str:
        """
        References the tier in the ratecard for that usage (OCI will be using the same reference to cross-reference for correctness on the usage csv report), comes from Entity OBSCNTR_IPT_PRODUCTTIER.
        """
        return pulumi.get(self, "rate_card_tierd_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        Computed Usage created time, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeMeteredOn")
    def time_metered_on(self) -> builtins.str:
        """
        Metered Service date, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_metered_on")

    @property
    @pulumi.getter(name="timeOfArrival")
    def time_of_arrival(self) -> builtins.str:
        """
        Usae computation date, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_of_arrival")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        Computed Usage updated time, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Usage compute type in SPM.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="unitOfMeasure")
    def unit_of_measure(self) -> builtins.str:
        """
        Unit of Messure
        """
        return pulumi.get(self, "unit_of_measure")

    @property
    @pulumi.getter(name="usageNumber")
    def usage_number(self) -> builtins.str:
        """
        SPM Internal usage Line number identifier in SPM coming from Metered Services entity.
        """
        return pulumi.get(self, "usage_number")


class AwaitableGetComputedUsageResult(GetComputedUsageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputedUsageResult(
            commitment_service_id=self.commitment_service_id,
            compartment_id=self.compartment_id,
            compute_source=self.compute_source,
            computed_usage_id=self.computed_usage_id,
            cost=self.cost,
            cost_rounded=self.cost_rounded,
            currency_code=self.currency_code,
            data_center=self.data_center,
            fields=self.fields,
            id=self.id,
            is_invoiced=self.is_invoiced,
            mqs_message_id=self.mqs_message_id,
            net_unit_price=self.net_unit_price,
            original_usage_number=self.original_usage_number,
            parent_products=self.parent_products,
            parent_subscribed_service_id=self.parent_subscribed_service_id,
            plan_number=self.plan_number,
            products=self.products,
            quantity=self.quantity,
            rate_card_id=self.rate_card_id,
            rate_card_tierd_id=self.rate_card_tierd_id,
            time_created=self.time_created,
            time_metered_on=self.time_metered_on,
            time_of_arrival=self.time_of_arrival,
            time_updated=self.time_updated,
            type=self.type,
            unit_of_measure=self.unit_of_measure,
            usage_number=self.usage_number)


def get_computed_usage(compartment_id: Optional[builtins.str] = None,
                       computed_usage_id: Optional[builtins.str] = None,
                       fields: Optional[Sequence[builtins.str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputedUsageResult:
    """
    This data source provides details about a specific Computed Usage resource in Oracle Cloud Infrastructure Onesubscription service.

    This is an API which returns Computed Usage corresponding to the id passed

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_computed_usage = oci.OneSubsription.get_computed_usage(compartment_id=compartment_id,
        computed_usage_id=test_computed_usage_oci_onesubscription_computed_usage["id"],
        fields=computed_usage_fields)
    ```


    :param builtins.str compartment_id: The OCID of the root compartment.
    :param builtins.str computed_usage_id: The Computed Usage Id
    :param Sequence[builtins.str] fields: Partial response refers to an optimization technique offered by the RESTful web APIs to return only the information  (fields) required by the client. This parameter is used to control what fields to return.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['computedUsageId'] = computed_usage_id
    __args__['fields'] = fields
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OneSubsription/getComputedUsage:getComputedUsage', __args__, opts=opts, typ=GetComputedUsageResult).value

    return AwaitableGetComputedUsageResult(
        commitment_service_id=pulumi.get(__ret__, 'commitment_service_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_source=pulumi.get(__ret__, 'compute_source'),
        computed_usage_id=pulumi.get(__ret__, 'computed_usage_id'),
        cost=pulumi.get(__ret__, 'cost'),
        cost_rounded=pulumi.get(__ret__, 'cost_rounded'),
        currency_code=pulumi.get(__ret__, 'currency_code'),
        data_center=pulumi.get(__ret__, 'data_center'),
        fields=pulumi.get(__ret__, 'fields'),
        id=pulumi.get(__ret__, 'id'),
        is_invoiced=pulumi.get(__ret__, 'is_invoiced'),
        mqs_message_id=pulumi.get(__ret__, 'mqs_message_id'),
        net_unit_price=pulumi.get(__ret__, 'net_unit_price'),
        original_usage_number=pulumi.get(__ret__, 'original_usage_number'),
        parent_products=pulumi.get(__ret__, 'parent_products'),
        parent_subscribed_service_id=pulumi.get(__ret__, 'parent_subscribed_service_id'),
        plan_number=pulumi.get(__ret__, 'plan_number'),
        products=pulumi.get(__ret__, 'products'),
        quantity=pulumi.get(__ret__, 'quantity'),
        rate_card_id=pulumi.get(__ret__, 'rate_card_id'),
        rate_card_tierd_id=pulumi.get(__ret__, 'rate_card_tierd_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_metered_on=pulumi.get(__ret__, 'time_metered_on'),
        time_of_arrival=pulumi.get(__ret__, 'time_of_arrival'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'),
        unit_of_measure=pulumi.get(__ret__, 'unit_of_measure'),
        usage_number=pulumi.get(__ret__, 'usage_number'))
def get_computed_usage_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                              computed_usage_id: Optional[pulumi.Input[builtins.str]] = None,
                              fields: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputedUsageResult]:
    """
    This data source provides details about a specific Computed Usage resource in Oracle Cloud Infrastructure Onesubscription service.

    This is an API which returns Computed Usage corresponding to the id passed

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_computed_usage = oci.OneSubsription.get_computed_usage(compartment_id=compartment_id,
        computed_usage_id=test_computed_usage_oci_onesubscription_computed_usage["id"],
        fields=computed_usage_fields)
    ```


    :param builtins.str compartment_id: The OCID of the root compartment.
    :param builtins.str computed_usage_id: The Computed Usage Id
    :param Sequence[builtins.str] fields: Partial response refers to an optimization technique offered by the RESTful web APIs to return only the information  (fields) required by the client. This parameter is used to control what fields to return.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['computedUsageId'] = computed_usage_id
    __args__['fields'] = fields
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OneSubsription/getComputedUsage:getComputedUsage', __args__, opts=opts, typ=GetComputedUsageResult)
    return __ret__.apply(lambda __response__: GetComputedUsageResult(
        commitment_service_id=pulumi.get(__response__, 'commitment_service_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_source=pulumi.get(__response__, 'compute_source'),
        computed_usage_id=pulumi.get(__response__, 'computed_usage_id'),
        cost=pulumi.get(__response__, 'cost'),
        cost_rounded=pulumi.get(__response__, 'cost_rounded'),
        currency_code=pulumi.get(__response__, 'currency_code'),
        data_center=pulumi.get(__response__, 'data_center'),
        fields=pulumi.get(__response__, 'fields'),
        id=pulumi.get(__response__, 'id'),
        is_invoiced=pulumi.get(__response__, 'is_invoiced'),
        mqs_message_id=pulumi.get(__response__, 'mqs_message_id'),
        net_unit_price=pulumi.get(__response__, 'net_unit_price'),
        original_usage_number=pulumi.get(__response__, 'original_usage_number'),
        parent_products=pulumi.get(__response__, 'parent_products'),
        parent_subscribed_service_id=pulumi.get(__response__, 'parent_subscribed_service_id'),
        plan_number=pulumi.get(__response__, 'plan_number'),
        products=pulumi.get(__response__, 'products'),
        quantity=pulumi.get(__response__, 'quantity'),
        rate_card_id=pulumi.get(__response__, 'rate_card_id'),
        rate_card_tierd_id=pulumi.get(__response__, 'rate_card_tierd_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_metered_on=pulumi.get(__response__, 'time_metered_on'),
        time_of_arrival=pulumi.get(__response__, 'time_of_arrival'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type'),
        unit_of_measure=pulumi.get(__response__, 'unit_of_measure'),
        usage_number=pulumi.get(__response__, 'usage_number')))
