# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAwrHubAwrSnapshotResult',
    'AwaitableGetAwrHubAwrSnapshotResult',
    'get_awr_hub_awr_snapshot',
    'get_awr_hub_awr_snapshot_output',
]

@pulumi.output_type
class GetAwrHubAwrSnapshotResult:
    """
    A collection of values returned by getAwrHubAwrSnapshot.
    """
    def __init__(__self__, awr_hub_id=None, awr_source_database_identifier=None, id=None, items=None, time_greater_than_or_equal_to=None, time_less_than_or_equal_to=None):
        if awr_hub_id and not isinstance(awr_hub_id, str):
            raise TypeError("Expected argument 'awr_hub_id' to be a str")
        pulumi.set(__self__, "awr_hub_id", awr_hub_id)
        if awr_source_database_identifier and not isinstance(awr_source_database_identifier, str):
            raise TypeError("Expected argument 'awr_source_database_identifier' to be a str")
        pulumi.set(__self__, "awr_source_database_identifier", awr_source_database_identifier)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if time_greater_than_or_equal_to and not isinstance(time_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_greater_than_or_equal_to", time_greater_than_or_equal_to)
        if time_less_than_or_equal_to and not isinstance(time_less_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_less_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_less_than_or_equal_to", time_less_than_or_equal_to)

    @property
    @pulumi.getter(name="awrHubId")
    def awr_hub_id(self) -> builtins.str:
        return pulumi.get(self, "awr_hub_id")

    @property
    @pulumi.getter(name="awrSourceDatabaseIdentifier")
    def awr_source_database_identifier(self) -> builtins.str:
        return pulumi.get(self, "awr_source_database_identifier")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAwrHubAwrSnapshotItemResult']:
        """
        A list of AWR snapshot summary data.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="timeGreaterThanOrEqualTo")
    def time_greater_than_or_equal_to(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeLessThanOrEqualTo")
    def time_less_than_or_equal_to(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_less_than_or_equal_to")


class AwaitableGetAwrHubAwrSnapshotResult(GetAwrHubAwrSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwrHubAwrSnapshotResult(
            awr_hub_id=self.awr_hub_id,
            awr_source_database_identifier=self.awr_source_database_identifier,
            id=self.id,
            items=self.items,
            time_greater_than_or_equal_to=self.time_greater_than_or_equal_to,
            time_less_than_or_equal_to=self.time_less_than_or_equal_to)


def get_awr_hub_awr_snapshot(awr_hub_id: Optional[builtins.str] = None,
                             awr_source_database_identifier: Optional[builtins.str] = None,
                             time_greater_than_or_equal_to: Optional[builtins.str] = None,
                             time_less_than_or_equal_to: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwrHubAwrSnapshotResult:
    """
    This data source provides details about a specific Awr Hub Awr Snapshot resource in Oracle Cloud Infrastructure Opsi service.

    Lists AWR snapshots for the specified source database in the AWR hub. The difference between the timeGreaterThanOrEqualTo and timeLessThanOrEqualTo should not exceed an elapsed range of 1 day.
    The timeGreaterThanOrEqualTo & timeLessThanOrEqualTo params are optional. If these params are not provided, by default last 1 day snapshots will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_awr_hub_awr_snapshot = oci.Opsi.get_awr_hub_awr_snapshot(awr_hub_id=test_awr_hub["id"],
        awr_source_database_identifier=awr_hub_awr_snapshot_awr_source_database_identifier,
        time_greater_than_or_equal_to=awr_hub_awr_snapshot_time_greater_than_or_equal_to,
        time_less_than_or_equal_to=awr_hub_awr_snapshot_time_less_than_or_equal_to)
    ```


    :param builtins.str awr_hub_id: Unique Awr Hub identifier
    :param builtins.str awr_source_database_identifier: AWR source database identifier.
    :param builtins.str time_greater_than_or_equal_to: The optional greater than or equal to query parameter to filter the timestamp. The timestamp format to be followed is: YYYY-MM-DDTHH:MM:SSZ, example 2020-12-03T19:00:53Z
    :param builtins.str time_less_than_or_equal_to: The optional less than or equal to query parameter to filter the timestamp. The timestamp format to be followed is: YYYY-MM-DDTHH:MM:SSZ, example 2020-12-03T19:00:53Z
    """
    __args__ = dict()
    __args__['awrHubId'] = awr_hub_id
    __args__['awrSourceDatabaseIdentifier'] = awr_source_database_identifier
    __args__['timeGreaterThanOrEqualTo'] = time_greater_than_or_equal_to
    __args__['timeLessThanOrEqualTo'] = time_less_than_or_equal_to
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getAwrHubAwrSnapshot:getAwrHubAwrSnapshot', __args__, opts=opts, typ=GetAwrHubAwrSnapshotResult).value

    return AwaitableGetAwrHubAwrSnapshotResult(
        awr_hub_id=pulumi.get(__ret__, 'awr_hub_id'),
        awr_source_database_identifier=pulumi.get(__ret__, 'awr_source_database_identifier'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        time_greater_than_or_equal_to=pulumi.get(__ret__, 'time_greater_than_or_equal_to'),
        time_less_than_or_equal_to=pulumi.get(__ret__, 'time_less_than_or_equal_to'))
def get_awr_hub_awr_snapshot_output(awr_hub_id: Optional[pulumi.Input[builtins.str]] = None,
                                    awr_source_database_identifier: Optional[pulumi.Input[builtins.str]] = None,
                                    time_greater_than_or_equal_to: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    time_less_than_or_equal_to: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAwrHubAwrSnapshotResult]:
    """
    This data source provides details about a specific Awr Hub Awr Snapshot resource in Oracle Cloud Infrastructure Opsi service.

    Lists AWR snapshots for the specified source database in the AWR hub. The difference between the timeGreaterThanOrEqualTo and timeLessThanOrEqualTo should not exceed an elapsed range of 1 day.
    The timeGreaterThanOrEqualTo & timeLessThanOrEqualTo params are optional. If these params are not provided, by default last 1 day snapshots will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_awr_hub_awr_snapshot = oci.Opsi.get_awr_hub_awr_snapshot(awr_hub_id=test_awr_hub["id"],
        awr_source_database_identifier=awr_hub_awr_snapshot_awr_source_database_identifier,
        time_greater_than_or_equal_to=awr_hub_awr_snapshot_time_greater_than_or_equal_to,
        time_less_than_or_equal_to=awr_hub_awr_snapshot_time_less_than_or_equal_to)
    ```


    :param builtins.str awr_hub_id: Unique Awr Hub identifier
    :param builtins.str awr_source_database_identifier: AWR source database identifier.
    :param builtins.str time_greater_than_or_equal_to: The optional greater than or equal to query parameter to filter the timestamp. The timestamp format to be followed is: YYYY-MM-DDTHH:MM:SSZ, example 2020-12-03T19:00:53Z
    :param builtins.str time_less_than_or_equal_to: The optional less than or equal to query parameter to filter the timestamp. The timestamp format to be followed is: YYYY-MM-DDTHH:MM:SSZ, example 2020-12-03T19:00:53Z
    """
    __args__ = dict()
    __args__['awrHubId'] = awr_hub_id
    __args__['awrSourceDatabaseIdentifier'] = awr_source_database_identifier
    __args__['timeGreaterThanOrEqualTo'] = time_greater_than_or_equal_to
    __args__['timeLessThanOrEqualTo'] = time_less_than_or_equal_to
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Opsi/getAwrHubAwrSnapshot:getAwrHubAwrSnapshot', __args__, opts=opts, typ=GetAwrHubAwrSnapshotResult)
    return __ret__.apply(lambda __response__: GetAwrHubAwrSnapshotResult(
        awr_hub_id=pulumi.get(__response__, 'awr_hub_id'),
        awr_source_database_identifier=pulumi.get(__response__, 'awr_source_database_identifier'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        time_greater_than_or_equal_to=pulumi.get(__response__, 'time_greater_than_or_equal_to'),
        time_less_than_or_equal_to=pulumi.get(__response__, 'time_less_than_or_equal_to')))
