# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSoftwareSourceModuleStreamsResult',
    'AwaitableGetSoftwareSourceModuleStreamsResult',
    'get_software_source_module_streams',
    'get_software_source_module_streams_output',
]

@pulumi.output_type
class GetSoftwareSourceModuleStreamsResult:
    """
    A collection of values returned by getSoftwareSourceModuleStreams.
    """
    def __init__(__self__, filters=None, id=None, is_latest=None, module_name=None, module_name_contains=None, module_stream_collections=None, name=None, software_source_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_latest and not isinstance(is_latest, bool):
            raise TypeError("Expected argument 'is_latest' to be a bool")
        pulumi.set(__self__, "is_latest", is_latest)
        if module_name and not isinstance(module_name, str):
            raise TypeError("Expected argument 'module_name' to be a str")
        pulumi.set(__self__, "module_name", module_name)
        if module_name_contains and not isinstance(module_name_contains, str):
            raise TypeError("Expected argument 'module_name_contains' to be a str")
        pulumi.set(__self__, "module_name_contains", module_name_contains)
        if module_stream_collections and not isinstance(module_stream_collections, list):
            raise TypeError("Expected argument 'module_stream_collections' to be a list")
        pulumi.set(__self__, "module_stream_collections", module_stream_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSoftwareSourceModuleStreamsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> Optional[builtins.bool]:
        """
        Indicates whether this module stream is the latest.
        """
        return pulumi.get(self, "is_latest")

    @property
    @pulumi.getter(name="moduleName")
    def module_name(self) -> Optional[builtins.str]:
        """
        The name of the module that contains the stream.
        """
        return pulumi.get(self, "module_name")

    @property
    @pulumi.getter(name="moduleNameContains")
    def module_name_contains(self) -> Optional[builtins.str]:
        return pulumi.get(self, "module_name_contains")

    @property
    @pulumi.getter(name="moduleStreamCollections")
    def module_stream_collections(self) -> Sequence['outputs.GetSoftwareSourceModuleStreamsModuleStreamCollectionResult']:
        """
        The list of module_stream_collection.
        """
        return pulumi.get(self, "module_stream_collections")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the stream.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source that provides this module stream.
        """
        return pulumi.get(self, "software_source_id")


class AwaitableGetSoftwareSourceModuleStreamsResult(GetSoftwareSourceModuleStreamsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwareSourceModuleStreamsResult(
            filters=self.filters,
            id=self.id,
            is_latest=self.is_latest,
            module_name=self.module_name,
            module_name_contains=self.module_name_contains,
            module_stream_collections=self.module_stream_collections,
            name=self.name,
            software_source_id=self.software_source_id)


def get_software_source_module_streams(filters: Optional[Sequence[Union['GetSoftwareSourceModuleStreamsFilterArgs', 'GetSoftwareSourceModuleStreamsFilterArgsDict']]] = None,
                                       is_latest: Optional[builtins.bool] = None,
                                       module_name: Optional[builtins.str] = None,
                                       module_name_contains: Optional[builtins.str] = None,
                                       name: Optional[builtins.str] = None,
                                       software_source_id: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwareSourceModuleStreamsResult:
    """
    This data source provides the list of Software Source Module Streams in Oracle Cloud Infrastructure Os Management Hub service.

    Lists module streams from the specified software source [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    Filter the list against a variety of criteria including but not limited to its module name and (stream) name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_module_streams = oci.OsManagementHub.get_software_source_module_streams(software_source_id=test_software_source["id"],
        is_latest=software_source_module_stream_is_latest,
        module_name=software_source_module_stream_module_name,
        module_name_contains=software_source_module_stream_module_name_contains,
        name=software_source_module_stream_name)
    ```


    :param builtins.bool is_latest: Indicates whether to list only the latest versions of packages, module streams, and stream profiles.
    :param builtins.str module_name: The name of a module. This parameter is required if a streamName is specified.
    :param builtins.str module_name_contains: A filter to return resources that may partially match the module name given.
    :param builtins.str name: The name of the entity to be queried.
    :param builtins.str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['isLatest'] = is_latest
    __args__['moduleName'] = module_name
    __args__['moduleNameContains'] = module_name_contains
    __args__['name'] = name
    __args__['softwareSourceId'] = software_source_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getSoftwareSourceModuleStreams:getSoftwareSourceModuleStreams', __args__, opts=opts, typ=GetSoftwareSourceModuleStreamsResult).value

    return AwaitableGetSoftwareSourceModuleStreamsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_latest=pulumi.get(__ret__, 'is_latest'),
        module_name=pulumi.get(__ret__, 'module_name'),
        module_name_contains=pulumi.get(__ret__, 'module_name_contains'),
        module_stream_collections=pulumi.get(__ret__, 'module_stream_collections'),
        name=pulumi.get(__ret__, 'name'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'))
def get_software_source_module_streams_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSoftwareSourceModuleStreamsFilterArgs', 'GetSoftwareSourceModuleStreamsFilterArgsDict']]]]] = None,
                                              is_latest: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                              module_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              module_name_contains: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              software_source_id: Optional[pulumi.Input[builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSoftwareSourceModuleStreamsResult]:
    """
    This data source provides the list of Software Source Module Streams in Oracle Cloud Infrastructure Os Management Hub service.

    Lists module streams from the specified software source [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    Filter the list against a variety of criteria including but not limited to its module name and (stream) name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_module_streams = oci.OsManagementHub.get_software_source_module_streams(software_source_id=test_software_source["id"],
        is_latest=software_source_module_stream_is_latest,
        module_name=software_source_module_stream_module_name,
        module_name_contains=software_source_module_stream_module_name_contains,
        name=software_source_module_stream_name)
    ```


    :param builtins.bool is_latest: Indicates whether to list only the latest versions of packages, module streams, and stream profiles.
    :param builtins.str module_name: The name of a module. This parameter is required if a streamName is specified.
    :param builtins.str module_name_contains: A filter to return resources that may partially match the module name given.
    :param builtins.str name: The name of the entity to be queried.
    :param builtins.str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['isLatest'] = is_latest
    __args__['moduleName'] = module_name
    __args__['moduleNameContains'] = module_name_contains
    __args__['name'] = name
    __args__['softwareSourceId'] = software_source_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getSoftwareSourceModuleStreams:getSoftwareSourceModuleStreams', __args__, opts=opts, typ=GetSoftwareSourceModuleStreamsResult)
    return __ret__.apply(lambda __response__: GetSoftwareSourceModuleStreamsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_latest=pulumi.get(__response__, 'is_latest'),
        module_name=pulumi.get(__response__, 'module_name'),
        module_name_contains=pulumi.get(__response__, 'module_name_contains'),
        module_stream_collections=pulumi.get(__response__, 'module_stream_collections'),
        name=pulumi.get(__response__, 'name'),
        software_source_id=pulumi.get(__response__, 'software_source_id')))
