# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetScheduleResult',
    'AwaitableGetScheduleResult',
    'get_schedule',
    'get_schedule_output',
]

@pulumi.output_type
class GetScheduleResult:
    """
    A collection of values returned by getSchedule.
    """
    def __init__(__self__, action=None, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, recurrence_details=None, recurrence_type=None, resource_filters=None, resources=None, schedule_id=None, state=None, system_tags=None, time_created=None, time_ends=None, time_last_run=None, time_next_run=None, time_starts=None, time_updated=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if recurrence_details and not isinstance(recurrence_details, str):
            raise TypeError("Expected argument 'recurrence_details' to be a str")
        pulumi.set(__self__, "recurrence_details", recurrence_details)
        if recurrence_type and not isinstance(recurrence_type, str):
            raise TypeError("Expected argument 'recurrence_type' to be a str")
        pulumi.set(__self__, "recurrence_type", recurrence_type)
        if resource_filters and not isinstance(resource_filters, list):
            raise TypeError("Expected argument 'resource_filters' to be a list")
        pulumi.set(__self__, "resource_filters", resource_filters)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if schedule_id and not isinstance(schedule_id, str):
            raise TypeError("Expected argument 'schedule_id' to be a str")
        pulumi.set(__self__, "schedule_id", schedule_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_ends and not isinstance(time_ends, str):
            raise TypeError("Expected argument 'time_ends' to be a str")
        pulumi.set(__self__, "time_ends", time_ends)
        if time_last_run and not isinstance(time_last_run, str):
            raise TypeError("Expected argument 'time_last_run' to be a str")
        pulumi.set(__self__, "time_last_run", time_last_run)
        if time_next_run and not isinstance(time_next_run, str):
            raise TypeError("Expected argument 'time_next_run' to be a str")
        pulumi.set(__self__, "time_next_run", time_next_run)
        if time_starts and not isinstance(time_starts, str):
            raise TypeError("Expected argument 'time_starts' to be a str")
        pulumi.set(__self__, "time_starts", time_starts)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        This is the action that will be executed by the schedule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the schedule is created
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        These are defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        This is the description of the schedule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        This is a user-friendly name for the schedule. It does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        These are free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        This is the resource OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="recurrenceDetails")
    def recurrence_details(self) -> builtins.str:
        """
        This is the frequency of recurrence of a schedule. The frequency field can either conform to RFC-5545 formatting or UNIX cron formatting for recurrences, based on the value specified by the recurrenceType field.
        """
        return pulumi.get(self, "recurrence_details")

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> builtins.str:
        """
        Type of recurrence of a schedule
        """
        return pulumi.get(self, "recurrence_type")

    @property
    @pulumi.getter(name="resourceFilters")
    def resource_filters(self) -> Sequence['outputs.GetScheduleResourceFilterResult']:
        """
        This is a list of resources filters.  The schedule will be applied to resources matching all of them.
        """
        return pulumi.get(self, "resource_filters")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetScheduleResourceResult']:
        """
        This is the list of resources to which the scheduled operation is applied.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> builtins.str:
        return pulumi.get(self, "schedule_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        This is the current state of a schedule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        These are system tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        This is the date and time the schedule was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeEnds")
    def time_ends(self) -> builtins.str:
        """
        This is the date and time the schedule ends, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339)  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_ends")

    @property
    @pulumi.getter(name="timeLastRun")
    def time_last_run(self) -> builtins.str:
        """
        This is the date and time the schedule runs last time, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_last_run")

    @property
    @pulumi.getter(name="timeNextRun")
    def time_next_run(self) -> builtins.str:
        """
        This is the date and time the schedule run the next time, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_next_run")

    @property
    @pulumi.getter(name="timeStarts")
    def time_starts(self) -> builtins.str:
        """
        This is the date and time the schedule starts, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339)  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_starts")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        This is the date and time the schedule was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetScheduleResult(GetScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduleResult(
            action=self.action,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            recurrence_details=self.recurrence_details,
            recurrence_type=self.recurrence_type,
            resource_filters=self.resource_filters,
            resources=self.resources,
            schedule_id=self.schedule_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_ends=self.time_ends,
            time_last_run=self.time_last_run,
            time_next_run=self.time_next_run,
            time_starts=self.time_starts,
            time_updated=self.time_updated)


def get_schedule(schedule_id: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduleResult:
    """
    This data source provides details about a specific Schedule resource in Oracle Cloud Infrastructure Resource Scheduler service.

    This API gets information about a schedule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_schedule = oci.ResourceScheduler.get_schedule(schedule_id=test_schedule_oci_resource_scheduler_schedule["id"])
    ```


    :param builtins.str schedule_id: This is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the schedule.
    """
    __args__ = dict()
    __args__['scheduleId'] = schedule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ResourceScheduler/getSchedule:getSchedule', __args__, opts=opts, typ=GetScheduleResult).value

    return AwaitableGetScheduleResult(
        action=pulumi.get(__ret__, 'action'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        recurrence_details=pulumi.get(__ret__, 'recurrence_details'),
        recurrence_type=pulumi.get(__ret__, 'recurrence_type'),
        resource_filters=pulumi.get(__ret__, 'resource_filters'),
        resources=pulumi.get(__ret__, 'resources'),
        schedule_id=pulumi.get(__ret__, 'schedule_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_ends=pulumi.get(__ret__, 'time_ends'),
        time_last_run=pulumi.get(__ret__, 'time_last_run'),
        time_next_run=pulumi.get(__ret__, 'time_next_run'),
        time_starts=pulumi.get(__ret__, 'time_starts'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_schedule_output(schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduleResult]:
    """
    This data source provides details about a specific Schedule resource in Oracle Cloud Infrastructure Resource Scheduler service.

    This API gets information about a schedule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_schedule = oci.ResourceScheduler.get_schedule(schedule_id=test_schedule_oci_resource_scheduler_schedule["id"])
    ```


    :param builtins.str schedule_id: This is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the schedule.
    """
    __args__ = dict()
    __args__['scheduleId'] = schedule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ResourceScheduler/getSchedule:getSchedule', __args__, opts=opts, typ=GetScheduleResult)
    return __ret__.apply(lambda __response__: GetScheduleResult(
        action=pulumi.get(__response__, 'action'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        recurrence_details=pulumi.get(__response__, 'recurrence_details'),
        recurrence_type=pulumi.get(__response__, 'recurrence_type'),
        resource_filters=pulumi.get(__response__, 'resource_filters'),
        resources=pulumi.get(__response__, 'resources'),
        schedule_id=pulumi.get(__response__, 'schedule_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_ends=pulumi.get(__response__, 'time_ends'),
        time_last_run=pulumi.get(__response__, 'time_last_run'),
        time_next_run=pulumi.get(__response__, 'time_next_run'),
        time_starts=pulumi.get(__response__, 'time_starts'),
        time_updated=pulumi.get(__response__, 'time_updated')))
