"""Tool for the Wikipedia API."""

from typing import Optional


from kolibri.utils.wrappers import WikipediaAPIWrapper


class WikipediaQueryRun():
    """Tool that adds the capability to search using the Wikipedia API."""

    name = "Wikipedia"
    description = (
        "A wrapper around Wikipedia. "
        "Useful for when you need to answer general questions about "
        "people, places, companies, facts, historical events, or other subjects. "
        "Input should be a search query."
    )
    api_wrapper: WikipediaAPIWrapper

    def _run(
        self,
        query: str,
    ) -> str:
        """Use the Wikipedia tool."""
        return self.api_wrapper.run(query)

