"""
Binance Sub Account REST API

OpenAPI Specification for the Binance Sub Account REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import CreateAVirtualSubAccountResponse
from ..models import EnableFuturesForSubAccountResponse
from ..models import EnableOptionsForSubAccountResponse
from ..models import GetFuturesPositionRiskOfSubAccountResponse
from ..models import GetFuturesPositionRiskOfSubAccountV2Response
from ..models import GetSubAccountsStatusOnMarginOrFuturesResponse
from ..models import QuerySubAccountListResponse
from ..models import QuerySubAccountTransactionStatisticsResponse


class AccountManagementApi:
    """API Client for AccountManagementApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def create_a_virtual_sub_account(
        self,
        sub_account_string: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CreateAVirtualSubAccountResponse]:
        """
                Create a Virtual Sub-account (For Master Account) (USER_DATA)
                POST /sapi/v1/sub-account/virtualSubAccount
                https://developers.binance.com/docs/sub_account/account-management/Create-a-Virtual-Sub-account

                Create a Virtual Sub-account

        * This request will generate a virtual sub account under your master account.
        * You need to enable "trade" option for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    sub_account_string (Union[str, None]): Please input a string. We will create a virtual email using that string for you to register
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[CreateAVirtualSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if sub_account_string is None:
            raise RequiredError(
                field="sub_account_string",
                error_message="Missing required parameter 'sub_account_string'",
            )

        payload = {"sub_account_string": sub_account_string, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/sub-account/virtualSubAccount",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CreateAVirtualSubAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def enable_futures_for_sub_account(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[EnableFuturesForSubAccountResponse]:
        """
                Enable Futures for Sub-account (For Master Account) (USER_DATA)
                POST /sapi/v1/sub-account/futures/enable
                https://developers.binance.com/docs/sub_account/account-management/Enable-Futures-for-Sub-account

                Enable Futures for Sub-account for Master Account

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[EnableFuturesForSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )

        payload = {"email": email, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/sub-account/futures/enable",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=EnableFuturesForSubAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def enable_options_for_sub_account(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[EnableOptionsForSubAccountResponse]:
        """
                Enable Options for Sub-account (For Master Account) (USER_DATA)
                POST /sapi/v1/sub-account/eoptions/enable
                https://developers.binance.com/docs/sub_account/account-management/Enable-Options-for-Sub-account

                Enable Options for Sub-account (For Master Account).

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[EnableOptionsForSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )

        payload = {"email": email, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/sub-account/eoptions/enable",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=EnableOptionsForSubAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_futures_position_risk_of_sub_account(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFuturesPositionRiskOfSubAccountResponse]:
        """
                Get Futures Position-Risk of Sub-account (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/futures/positionRisk
                https://developers.binance.com/docs/sub_account/account-management/Get-Futures-Position-Risk-of-Sub-account

                Get Futures Position-Risk of Sub-account

        Weight: 10

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFuturesPositionRiskOfSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )

        payload = {"email": email, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/futures/positionRisk",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFuturesPositionRiskOfSubAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_futures_position_risk_of_sub_account_v2(
        self,
        email: Union[str, None],
        futures_type: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFuturesPositionRiskOfSubAccountV2Response]:
        """
                Get Futures Position-Risk of Sub-account V2 (For Master Account) (USER_DATA)
                GET /sapi/v2/sub-account/futures/positionRisk
                https://developers.binance.com/docs/sub_account/account-management/Get-Futures-Position-Risk-of-Sub-account-V2

                Get Futures Position-Risk of Sub-account V2

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    futures_type (Union[int, None]): 1:USDT-margined Futures，2: Coin-margined Futures
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFuturesPositionRiskOfSubAccountV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if futures_type is None:
            raise RequiredError(
                field="futures_type",
                error_message="Missing required parameter 'futures_type'",
            )

        payload = {
            "email": email,
            "futures_type": futures_type,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v2/sub-account/futures/positionRisk",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetFuturesPositionRiskOfSubAccountV2Response,
            is_signed=True,
            signer=self._signer,
        )

    def get_sub_accounts_status_on_margin_or_futures(
        self,
        email: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSubAccountsStatusOnMarginOrFuturesResponse]:
        """
                Get Sub-account's Status on Margin Or Futures (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/status
                https://developers.binance.com/docs/sub_account/account-management/Get-Sub-accounts-Status-on-Margin-Or-Futures

                Get Sub-account's Status on Margin Or Futures

        * If no email sent, all sub-accounts' information will be returned.

        Weight: 10

                Args:
                    email (Optional[str] = None): Managed sub-account email
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSubAccountsStatusOnMarginOrFuturesResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"email": email, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/status",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetSubAccountsStatusOnMarginOrFuturesResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_sub_account_list(
        self,
        email: Optional[str] = None,
        is_freeze: Optional[str] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountListResponse]:
        """
                Query Sub-account List (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/list
                https://developers.binance.com/docs/sub_account/account-management/Query-Sub-account-List

                Query Sub-account List

        Weight: 1

                Args:
                    email (Optional[str] = None): Managed sub-account email
                    is_freeze (Optional[str] = None): true or false
                    page (Optional[int] = None): Default value: 1
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "email": email,
            "is_freeze": is_freeze,
            "page": page,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/list",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QuerySubAccountListResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_sub_account_transaction_statistics(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountTransactionStatisticsResponse]:
        """
                Query Sub-account Transaction Statistics (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/transaction-statistics
                https://developers.binance.com/docs/sub_account/account-management/Query-Sub-account-Transaction-Statistics

                Query Sub-account Transaction statistics (For Master Account).

        Weight: 60

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountTransactionStatisticsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )

        payload = {"email": email, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/transaction-statistics",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QuerySubAccountTransactionStatisticsResponse,
            is_signed=True,
            signer=self._signer,
        )
