"""
Binance Sub Account REST API

OpenAPI Specification for the Binance Sub Account REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import AddIpRestrictionForSubAccountApiKeyResponse
from ..models import DeleteIpListForASubAccountApiKeyResponse
from ..models import GetIpRestrictionForASubAccountApiKeyResponse


class ApiManagementApi:
    """API Client for ApiManagementApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def add_ip_restriction_for_sub_account_api_key(
        self,
        email: Union[str, None],
        sub_account_api_key: Union[str, None],
        status: Union[str, None],
        ip_address: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AddIpRestrictionForSubAccountApiKeyResponse]:
        """
                Add IP Restriction for Sub-Account API key (For Master Account) (USER_DATA)
                POST /sapi/v2/sub-account/subAccountApi/ipRestriction
                https://developers.binance.com/docs/sub_account/api-management/Add-IP-Restriction-for-Sub-Account-API-key

                Add IP Restriction for Sub-Account API key

        * You need to enable Enable Spot & Margin Trading option for the api key which requests this endpoint

        Weight: 3000

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    sub_account_api_key (Union[str, None]):
                    status (Union[str, None]): IP Restriction status. 1 = IP Unrestricted. 2 = Restrict access to trusted IPs only.
                    ip_address (Optional[str] = None): Insert static IP in batch, separated by commas.
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AddIpRestrictionForSubAccountApiKeyResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if sub_account_api_key is None:
            raise RequiredError(
                field="sub_account_api_key",
                error_message="Missing required parameter 'sub_account_api_key'",
            )
        if status is None:
            raise RequiredError(
                field="status", error_message="Missing required parameter 'status'"
            )

        payload = {
            "email": email,
            "sub_account_api_key": sub_account_api_key,
            "status": status,
            "ip_address": ip_address,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v2/sub-account/subAccountApi/ipRestriction",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=AddIpRestrictionForSubAccountApiKeyResponse,
            is_signed=True,
            signer=self._signer,
        )

    def delete_ip_list_for_a_sub_account_api_key(
        self,
        email: Union[str, None],
        sub_account_api_key: Union[str, None],
        ip_address: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[DeleteIpListForASubAccountApiKeyResponse]:
        """
                Delete IP List For a Sub-account API Key (For Master Account) (USER_DATA)
                DELETE /sapi/v1/sub-account/subAccountApi/ipRestriction/ipList
                https://developers.binance.com/docs/sub_account/api-management/Delete-IP-List-For-a-Sub-account-API-Key

                Delete IP List For a Sub-account API Key

        * You need to enable Enable Spot & Margin Trading option for the api key which requests this endpoint

        Weight: 3000

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    sub_account_api_key (Union[str, None]):
                    ip_address (Union[str, None]): IPs to be deleted. Can be added in batches, separated by commas
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[DeleteIpListForASubAccountApiKeyResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if sub_account_api_key is None:
            raise RequiredError(
                field="sub_account_api_key",
                error_message="Missing required parameter 'sub_account_api_key'",
            )
        if ip_address is None:
            raise RequiredError(
                field="ip_address",
                error_message="Missing required parameter 'ip_address'",
            )

        payload = {
            "email": email,
            "sub_account_api_key": sub_account_api_key,
            "ip_address": ip_address,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="DELETE",
            path="/sapi/v1/sub-account/subAccountApi/ipRestriction/ipList",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=DeleteIpListForASubAccountApiKeyResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_ip_restriction_for_a_sub_account_api_key(
        self,
        email: Union[str, None],
        sub_account_api_key: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetIpRestrictionForASubAccountApiKeyResponse]:
        """
                Get IP Restriction for a Sub-account API Key (For Master Account) (USER_DATA)
                GET /sapi/v1/sub-account/subAccountApi/ipRestriction
                https://developers.binance.com/docs/sub_account/api-management/Get-IP-Restriction-for-a-Sub-account-API-Key

                Get IP Restriction for a Sub-account API Key

        Weight: 3000

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    sub_account_api_key (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetIpRestrictionForASubAccountApiKeyResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if sub_account_api_key is None:
            raise RequiredError(
                field="sub_account_api_key",
                error_message="Missing required parameter 'sub_account_api_key'",
            )

        payload = {
            "email": email,
            "sub_account_api_key": sub_account_api_key,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/sub-account/subAccountApi/ipRestriction",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetIpRestrictionForASubAccountApiKeyResponse,
            is_signed=True,
            signer=self._signer,
        )
