"""
Binance Sub Account REST API

OpenAPI Specification for the Binance Sub Account REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import DepositAssetsIntoTheManagedSubAccountResponse
from ..models import GetManagedSubAccountDepositAddressResponse
from ..models import QueryManagedSubAccountAssetDetailsResponse
from ..models import QueryManagedSubAccountFuturesAssetDetailsResponse
from ..models import QueryManagedSubAccountListResponse
from ..models import QueryManagedSubAccountMarginAssetDetailsResponse
from ..models import QueryManagedSubAccountSnapshotResponse
from ..models import QueryManagedSubAccountTransferLogMasterAccountInvestorResponse
from ..models import QueryManagedSubAccountTransferLogMasterAccountTradingResponse
from ..models import QueryManagedSubAccountTransferLogSubAccountTradingResponse
from ..models import WithdrawlAssetsFromTheManagedSubAccountResponse


class ManagedSubAccountApi:
    """API Client for ManagedSubAccountApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def deposit_assets_into_the_managed_sub_account(
        self,
        to_email: Union[str, None],
        asset: Union[str, None],
        amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[DepositAssetsIntoTheManagedSubAccountResponse]:
        """
                Deposit Assets Into The Managed Sub-account (For Investor Master Account) (USER_DATA)
                POST /sapi/v1/managed-subaccount/deposit
                https://developers.binance.com/docs/sub_account/managed-sub-account/Deposit-Assets-Into-The-Managed-Sub-account

                Deposit Assets Into The Managed Sub-account

        * You need to enable `Enable Spot & Margin Trading` option for the api key which requests this endpoint

        Weight: 1

                Args:
                    to_email (Union[str, None]):
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[DepositAssetsIntoTheManagedSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if to_email is None:
            raise RequiredError(
                field="to_email", error_message="Missing required parameter 'to_email'"
            )
        if asset is None:
            raise RequiredError(
                field="asset", error_message="Missing required parameter 'asset'"
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )

        payload = {
            "to_email": to_email,
            "asset": asset,
            "amount": amount,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/managed-subaccount/deposit",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=DepositAssetsIntoTheManagedSubAccountResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_managed_sub_account_deposit_address(
        self,
        email: Union[str, None],
        coin: Union[str, None],
        network: Optional[str] = None,
        amount: Optional[float] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetManagedSubAccountDepositAddressResponse]:
        """
                Get Managed Sub-account Deposit Address (For Investor Master Account) (USER_DATA)
                GET /sapi/v1/managed-subaccount/deposit/address
                https://developers.binance.com/docs/sub_account/managed-sub-account/Get-Managed-Sub-account-Deposit-Address

                Get investor's managed sub-account deposit address.

        * If `network` is not send, return with default `network` of the `coin`.
        * * `amount` needs to be sent if using LIGHTNING network

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    coin (Union[str, None]):
                    network (Optional[str] = None): networks can be found in `GET /sapi/v1/capital/deposit/address`
                    amount (Optional[float] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetManagedSubAccountDepositAddressResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if coin is None:
            raise RequiredError(
                field="coin", error_message="Missing required parameter 'coin'"
            )

        payload = {
            "email": email,
            "coin": coin,
            "network": network,
            "amount": amount,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/managed-subaccount/deposit/address",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetManagedSubAccountDepositAddressResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_managed_sub_account_asset_details(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryManagedSubAccountAssetDetailsResponse]:
        """
                Query Managed Sub-account Asset Details (For Investor Master Account) (USER_DATA)
                GET /sapi/v1/managed-subaccount/asset
                https://developers.binance.com/docs/sub_account/managed-sub-account/Query-Managed-Sub-account-Asset-Details

                Query Managed Sub-account Asset Details

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryManagedSubAccountAssetDetailsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )

        payload = {"email": email, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/managed-subaccount/asset",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryManagedSubAccountAssetDetailsResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_managed_sub_account_futures_asset_details(
        self,
        email: Union[str, None],
        account_type: Optional[str] = None,
    ) -> ApiResponse[QueryManagedSubAccountFuturesAssetDetailsResponse]:
        """
                Query Managed Sub-account Futures Asset Details (For Investor Master Account) (USER_DATA)
                GET /sapi/v1/managed-subaccount/fetch-future-asset
                https://developers.binance.com/docs/sub_account/managed-sub-account/Query-Managed-Sub-account-Futures-Asset-Details

                Investor can use this api to query managed sub account futures asset details

        Weight: 60

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    account_type (Optional[str] = None): No input or input "MARGIN" to get Cross Margin account details. Input "ISOLATED_MARGIN" to get Isolated Margin account details.

                Returns:
                    ApiResponse[QueryManagedSubAccountFuturesAssetDetailsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )

        payload = {"email": email, "account_type": account_type}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/managed-subaccount/fetch-future-asset",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryManagedSubAccountFuturesAssetDetailsResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_managed_sub_account_list(
        self,
        email: Optional[str] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryManagedSubAccountListResponse]:
        """
                Query Managed Sub-account List (For Investor) (USER_DATA)
                GET /sapi/v1/managed-subaccount/info
                https://developers.binance.com/docs/sub_account/managed-sub-account/Query-Managed-Sub-account-List

                Get investor's managed sub-account list.

        Weight: 60

                Args:
                    email (Optional[str] = None): Managed sub-account email
                    page (Optional[int] = None): Default value: 1
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryManagedSubAccountListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "email": email,
            "page": page,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/managed-subaccount/info",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryManagedSubAccountListResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_managed_sub_account_margin_asset_details(
        self,
        email: Union[str, None],
        account_type: Optional[str] = None,
    ) -> ApiResponse[QueryManagedSubAccountMarginAssetDetailsResponse]:
        """
                Query Managed Sub-account Margin Asset Details (For Investor Master Account) (USER_DATA)
                GET /sapi/v1/managed-subaccount/marginAsset
                https://developers.binance.com/docs/sub_account/managed-sub-account/Query-Managed-Sub-account-Margin-Asset-Details

                Investor can use this api to query managed sub account margin asset details

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    account_type (Optional[str] = None): No input or input "MARGIN" to get Cross Margin account details. Input "ISOLATED_MARGIN" to get Isolated Margin account details.

                Returns:
                    ApiResponse[QueryManagedSubAccountMarginAssetDetailsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )

        payload = {"email": email, "account_type": account_type}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/managed-subaccount/marginAsset",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryManagedSubAccountMarginAssetDetailsResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_managed_sub_account_snapshot(
        self,
        email: Union[str, None],
        type: Union[str, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryManagedSubAccountSnapshotResponse]:
        """
                Query Managed Sub-account Snapshot (For Investor Master Account) (USER_DATA)
                GET /sapi/v1/managed-subaccount/accountSnapshot
                https://developers.binance.com/docs/sub_account/managed-sub-account/Query-Managed-Sub-account-Snapshot

                Query Managed Sub-account Snapshot

        * The query time period must be less then 30 days
        * Support query within the last one month only
        * If startTimeand endTime not sent, return records of the last 7 days by default

        Weight: 2400

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    type (Union[str, None]): "SPOT", "MARGIN"（cross）, "FUTURES"（UM）
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryManagedSubAccountSnapshotResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if type is None:
            raise RequiredError(
                field="type", error_message="Missing required parameter 'type'"
            )

        payload = {
            "email": email,
            "type": type,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/managed-subaccount/accountSnapshot",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryManagedSubAccountSnapshotResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_managed_sub_account_transfer_log_master_account_investor(
        self,
        email: Union[str, None],
        start_time: Union[int, None],
        end_time: Union[int, None],
        page: Union[int, None],
        limit: Union[int, None],
        transfers: Optional[str] = None,
        transfer_function_account_type: Optional[str] = None,
    ) -> ApiResponse[QueryManagedSubAccountTransferLogMasterAccountInvestorResponse]:
        """
                Query Managed Sub Account Transfer Log (For Investor Master Account) (USER_DATA)
                GET /sapi/v1/managed-subaccount/queryTransLogForInvestor
                https://developers.binance.com/docs/sub_account/managed-sub-account/Query-Managed-Sub-Account-Transfer-Log-Investor

                Investor can use this api to query managed sub account transfer log. This endpoint is available for investor of Managed Sub-Account. A Managed Sub-Account is an account type for investors who value flexibility in asset allocation and account application, while delegating trades to a professional trading team.
        Please refer to [link](https://www.binance.com/en/support/faq/how-to-get-started-with-managed-sub-account-functions-and-frequently-asked-questions-0594748722704383a7c369046e489459)

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    start_time (Union[int, None]): Start Time
                    end_time (Union[int, None]): End Time (The start time and end time interval cannot exceed half a year)
                    page (Union[int, None]): Page
                    limit (Union[int, None]): Limit (Max: 500)
                    transfers (Optional[str] = None): Transfer Direction (FROM/TO)
                    transfer_function_account_type (Optional[str] = None): Transfer function account type (SPOT/MARGIN/ISOLATED_MARGIN/USDT_FUTURE/COIN_FUTURE)

                Returns:
                    ApiResponse[QueryManagedSubAccountTransferLogMasterAccountInvestorResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if start_time is None:
            raise RequiredError(
                field="start_time",
                error_message="Missing required parameter 'start_time'",
            )
        if end_time is None:
            raise RequiredError(
                field="end_time", error_message="Missing required parameter 'end_time'"
            )
        if page is None:
            raise RequiredError(
                field="page", error_message="Missing required parameter 'page'"
            )
        if limit is None:
            raise RequiredError(
                field="limit", error_message="Missing required parameter 'limit'"
            )

        payload = {
            "email": email,
            "start_time": start_time,
            "end_time": end_time,
            "page": page,
            "limit": limit,
            "transfers": transfers,
            "transfer_function_account_type": transfer_function_account_type,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/managed-subaccount/queryTransLogForInvestor",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryManagedSubAccountTransferLogMasterAccountInvestorResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_managed_sub_account_transfer_log_master_account_trading(
        self,
        email: Union[str, None],
        start_time: Union[int, None],
        end_time: Union[int, None],
        page: Union[int, None],
        limit: Union[int, None],
        transfers: Optional[str] = None,
        transfer_function_account_type: Optional[str] = None,
    ) -> ApiResponse[QueryManagedSubAccountTransferLogMasterAccountTradingResponse]:
        """
                Query Managed Sub Account Transfer Log (For Trading Team Master Account) (USER_DATA)
                GET /sapi/v1/managed-subaccount/queryTransLogForTradeParent
                https://developers.binance.com/docs/sub_account/managed-sub-account/Query-Managed-Sub-Account-Transfer-Log-Trading-Team-Master

                Trading team can use this api to query managed sub account transfer log. This endpoint is available for trading team of Managed Sub-Account. A Managed Sub-Account is an account type for investors who value flexibility in asset allocation and account application, while delegating trades to a professional trading team.
        Please refer to [link](https://www.binance.com/en/support/faq/how-to-get-started-with-managed-sub-account-functions-and-frequently-asked-questions-0594748722704383a7c369046e489459)

        Weight: 60

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    start_time (Union[int, None]): Start Time
                    end_time (Union[int, None]): End Time (The start time and end time interval cannot exceed half a year)
                    page (Union[int, None]): Page
                    limit (Union[int, None]): Limit (Max: 500)
                    transfers (Optional[str] = None): Transfer Direction (FROM/TO)
                    transfer_function_account_type (Optional[str] = None): Transfer function account type (SPOT/MARGIN/ISOLATED_MARGIN/USDT_FUTURE/COIN_FUTURE)

                Returns:
                    ApiResponse[QueryManagedSubAccountTransferLogMasterAccountTradingResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if email is None:
            raise RequiredError(
                field="email", error_message="Missing required parameter 'email'"
            )
        if start_time is None:
            raise RequiredError(
                field="start_time",
                error_message="Missing required parameter 'start_time'",
            )
        if end_time is None:
            raise RequiredError(
                field="end_time", error_message="Missing required parameter 'end_time'"
            )
        if page is None:
            raise RequiredError(
                field="page", error_message="Missing required parameter 'page'"
            )
        if limit is None:
            raise RequiredError(
                field="limit", error_message="Missing required parameter 'limit'"
            )

        payload = {
            "email": email,
            "start_time": start_time,
            "end_time": end_time,
            "page": page,
            "limit": limit,
            "transfers": transfers,
            "transfer_function_account_type": transfer_function_account_type,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/managed-subaccount/queryTransLogForTradeParent",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryManagedSubAccountTransferLogMasterAccountTradingResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_managed_sub_account_transfer_log_sub_account_trading(
        self,
        start_time: Union[int, None],
        end_time: Union[int, None],
        page: Union[int, None],
        limit: Union[int, None],
        transfers: Optional[str] = None,
        transfer_function_account_type: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryManagedSubAccountTransferLogSubAccountTradingResponse]:
        """
                Query Managed Sub Account Transfer Log (For Trading Team Sub Account) (USER_DATA)
                GET /sapi/v1/managed-subaccount/query-trans-log
                https://developers.binance.com/docs/sub_account/managed-sub-account/Query-Managed-Sub-Account-Transfer-Log-Trading-Team-Sub

                Query Managed Sub Account Transfer Log (For Trading Team Sub Account)

        Weight: 60

                Args:
                    start_time (Union[int, None]): Start Time
                    end_time (Union[int, None]): End Time (The start time and end time interval cannot exceed half a year)
                    page (Union[int, None]): Page
                    limit (Union[int, None]): Limit (Max: 500)
                    transfers (Optional[str] = None): Transfer Direction (FROM/TO)
                    transfer_function_account_type (Optional[str] = None): Transfer function account type (SPOT/MARGIN/ISOLATED_MARGIN/USDT_FUTURE/COIN_FUTURE)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryManagedSubAccountTransferLogSubAccountTradingResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if start_time is None:
            raise RequiredError(
                field="start_time",
                error_message="Missing required parameter 'start_time'",
            )
        if end_time is None:
            raise RequiredError(
                field="end_time", error_message="Missing required parameter 'end_time'"
            )
        if page is None:
            raise RequiredError(
                field="page", error_message="Missing required parameter 'page'"
            )
        if limit is None:
            raise RequiredError(
                field="limit", error_message="Missing required parameter 'limit'"
            )

        payload = {
            "start_time": start_time,
            "end_time": end_time,
            "page": page,
            "limit": limit,
            "transfers": transfers,
            "transfer_function_account_type": transfer_function_account_type,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/sapi/v1/managed-subaccount/query-trans-log",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryManagedSubAccountTransferLogSubAccountTradingResponse,
            is_signed=True,
            signer=self._signer,
        )

    def withdrawl_assets_from_the_managed_sub_account(
        self,
        from_email: Union[str, None],
        asset: Union[str, None],
        amount: Union[float, None],
        transfer_date: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[WithdrawlAssetsFromTheManagedSubAccountResponse]:
        """
                Withdrawl Assets From The Managed Sub-account (For Investor Master Account) (USER_DATA)
                POST /sapi/v1/managed-subaccount/withdraw
                https://developers.binance.com/docs/sub_account/managed-sub-account/Withdrawl-Assets-From-The-Managed-Sub-account

                Withdrawl Assets From The Managed Sub-account

        * You need to enable `Enable Spot & Margin Trading` option for the api key which requests this endpoint

        Weight: 1

                Args:
                    from_email (Union[str, None]):
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    transfer_date (Optional[int] = None): Withdrawals is automatically occur on the transfer date(UTC0). If a date is not selected, the withdrawal occurs right now
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[WithdrawlAssetsFromTheManagedSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if from_email is None:
            raise RequiredError(
                field="from_email",
                error_message="Missing required parameter 'from_email'",
            )
        if asset is None:
            raise RequiredError(
                field="asset", error_message="Missing required parameter 'asset'"
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )

        payload = {
            "from_email": from_email,
            "asset": asset,
            "amount": amount,
            "transfer_date": transfer_date,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/sapi/v1/managed-subaccount/withdraw",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=WithdrawlAssetsFromTheManagedSubAccountResponse,
            is_signed=True,
            signer=self._signer,
        )
