# coding: utf-8

"""
Binance Sub Account REST API

OpenAPI Specification for the Binance Sub Account REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from binance_sdk_sub_account.rest_api.models.get_summary_of_sub_accounts_futures_account_v2_response_delivery_account_summary_resp import (
    GetSummaryOfSubAccountsFuturesAccountV2ResponseDeliveryAccountSummaryResp,
)
from binance_sdk_sub_account.rest_api.models.get_summary_of_sub_accounts_futures_account_v2_response_future_account_summary_resp import (
    GetSummaryOfSubAccountsFuturesAccountV2ResponseFutureAccountSummaryResp,
)
from typing import Set
from typing_extensions import Self


class GetSummaryOfSubAccountsFuturesAccountV2Response(BaseModel):
    """
    GetSummaryOfSubAccountsFuturesAccountV2Response
    """  # noqa: E501

    future_account_summary_resp: Optional[
        GetSummaryOfSubAccountsFuturesAccountV2ResponseFutureAccountSummaryResp
    ] = Field(default=None, alias="futureAccountSummaryResp")
    delivery_account_summary_resp: Optional[
        GetSummaryOfSubAccountsFuturesAccountV2ResponseDeliveryAccountSummaryResp
    ] = Field(default=None, alias="deliveryAccountSummaryResp")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "futureAccountSummaryResp",
        "deliveryAccountSummaryResp",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetSummaryOfSubAccountsFuturesAccountV2Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of future_account_summary_resp
        if self.future_account_summary_resp:
            _dict["futureAccountSummaryResp"] = (
                self.future_account_summary_resp.to_dict()
            )
        # override the default output from pydantic by calling `to_dict()` of delivery_account_summary_resp
        if self.delivery_account_summary_resp:
            _dict["deliveryAccountSummaryResp"] = (
                self.delivery_account_summary_resp.to_dict()
            )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetSummaryOfSubAccountsFuturesAccountV2Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "futureAccountSummaryResp": (
                    GetSummaryOfSubAccountsFuturesAccountV2ResponseFutureAccountSummaryResp.from_dict(
                        obj["futureAccountSummaryResp"]
                    )
                    if obj.get("futureAccountSummaryResp") is not None
                    else None
                ),
                "deliveryAccountSummaryResp": (
                    GetSummaryOfSubAccountsFuturesAccountV2ResponseDeliveryAccountSummaryResp.from_dict(
                        obj["deliveryAccountSummaryResp"]
                    )
                    if obj.get("deliveryAccountSummaryResp") is not None
                    else None
                ),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
