# coding: utf-8

"""
Binance Sub Account REST API

OpenAPI Specification for the Binance Sub Account REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from binance_sdk_sub_account.rest_api.models.query_managed_sub_account_snapshot_response_snapshot_vos_inner_data_assets_inner import (
    QueryManagedSubAccountSnapshotResponseSnapshotVosInnerDataAssetsInner,
)
from binance_sdk_sub_account.rest_api.models.query_managed_sub_account_snapshot_response_snapshot_vos_inner_data_balances_inner import (
    QueryManagedSubAccountSnapshotResponseSnapshotVosInnerDataBalancesInner,
)
from binance_sdk_sub_account.rest_api.models.query_managed_sub_account_snapshot_response_snapshot_vos_inner_data_position_inner import (
    QueryManagedSubAccountSnapshotResponseSnapshotVosInnerDataPositionInner,
)
from binance_sdk_sub_account.rest_api.models.query_managed_sub_account_snapshot_response_snapshot_vos_inner_data_user_assets_inner import (
    QueryManagedSubAccountSnapshotResponseSnapshotVosInnerDataUserAssetsInner,
)
from typing import Set
from typing_extensions import Self


class QueryManagedSubAccountSnapshotResponseSnapshotVosInnerData(BaseModel):
    """
    QueryManagedSubAccountSnapshotResponseSnapshotVosInnerData
    """  # noqa: E501

    balances: Optional[
        List[QueryManagedSubAccountSnapshotResponseSnapshotVosInnerDataBalancesInner]
    ] = None
    total_asset_of_btc: Optional[StrictStr] = Field(
        default=None, alias="totalAssetOfBtc"
    )
    margin_level: Optional[StrictStr] = Field(default=None, alias="marginLevel")
    total_liability_of_btc: Optional[StrictStr] = Field(
        default=None, alias="totalLiabilityOfBtc"
    )
    total_net_asset_of_btc: Optional[StrictStr] = Field(
        default=None, alias="totalNetAssetOfBtc"
    )
    user_assets: Optional[
        List[QueryManagedSubAccountSnapshotResponseSnapshotVosInnerDataUserAssetsInner]
    ] = Field(default=None, alias="userAssets")
    assets: Optional[
        List[QueryManagedSubAccountSnapshotResponseSnapshotVosInnerDataAssetsInner]
    ] = None
    position: Optional[
        List[QueryManagedSubAccountSnapshotResponseSnapshotVosInnerDataPositionInner]
    ] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "balances",
        "totalAssetOfBtc",
        "marginLevel",
        "totalLiabilityOfBtc",
        "totalNetAssetOfBtc",
        "userAssets",
        "assets",
        "position",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QueryManagedSubAccountSnapshotResponseSnapshotVosInnerData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in balances (list)
        _items = []
        if self.balances:
            for _item_balances in self.balances:
                if _item_balances:
                    _items.append(_item_balances.to_dict())
            _dict["balances"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in user_assets (list)
        _items = []
        if self.user_assets:
            for _item_user_assets in self.user_assets:
                if _item_user_assets:
                    _items.append(_item_user_assets.to_dict())
            _dict["userAssets"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in assets (list)
        _items = []
        if self.assets:
            for _item_assets in self.assets:
                if _item_assets:
                    _items.append(_item_assets.to_dict())
            _dict["assets"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in position (list)
        _items = []
        if self.position:
            for _item_position in self.position:
                if _item_position:
                    _items.append(_item_position.to_dict())
            _dict["position"] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QueryManagedSubAccountSnapshotResponseSnapshotVosInnerData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "balances": (
                    [
                        QueryManagedSubAccountSnapshotResponseSnapshotVosInnerDataBalancesInner.from_dict(
                            _item
                        )
                        for _item in obj["balances"]
                    ]
                    if obj.get("balances") is not None
                    else None
                ),
                "totalAssetOfBtc": obj.get("totalAssetOfBtc"),
                "marginLevel": obj.get("marginLevel"),
                "totalLiabilityOfBtc": obj.get("totalLiabilityOfBtc"),
                "totalNetAssetOfBtc": obj.get("totalNetAssetOfBtc"),
                "userAssets": (
                    [
                        QueryManagedSubAccountSnapshotResponseSnapshotVosInnerDataUserAssetsInner.from_dict(
                            _item
                        )
                        for _item in obj["userAssets"]
                    ]
                    if obj.get("userAssets") is not None
                    else None
                ),
                "assets": (
                    [
                        QueryManagedSubAccountSnapshotResponseSnapshotVosInnerDataAssetsInner.from_dict(
                            _item
                        )
                        for _item in obj["assets"]
                    ]
                    if obj.get("assets") is not None
                    else None
                ),
                "position": (
                    [
                        QueryManagedSubAccountSnapshotResponseSnapshotVosInnerDataPositionInner.from_dict(
                            _item
                        )
                        for _item in obj["position"]
                    ]
                    if obj.get("position") is not None
                    else None
                ),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
