"""
Binance Sub Account REST API

OpenAPI Specification for the Binance Sub Account REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

import requests
from typing import Optional, List, TypeVar, Union
from binance_common.configuration import ConfigurationRestAPI
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request
from .api.account_management_api import AccountManagementApi
from .api.api_management_api import ApiManagementApi
from .api.asset_management_api import AssetManagementApi
from .api.managed_sub_account_api import ManagedSubAccountApi

from .models import CreateAVirtualSubAccountResponse
from .models import EnableFuturesForSubAccountResponse
from .models import EnableOptionsForSubAccountResponse
from .models import GetFuturesPositionRiskOfSubAccountResponse
from .models import GetFuturesPositionRiskOfSubAccountV2Response
from .models import GetSubAccountsStatusOnMarginOrFuturesResponse
from .models import QuerySubAccountListResponse
from .models import QuerySubAccountTransactionStatisticsResponse
from .models import AddIpRestrictionForSubAccountApiKeyResponse
from .models import DeleteIpListForASubAccountApiKeyResponse
from .models import GetIpRestrictionForASubAccountApiKeyResponse
from .models import FuturesTransferForSubAccountResponse
from .models import GetDetailOnSubAccountsFuturesAccountResponse
from .models import GetDetailOnSubAccountsFuturesAccountV2Response
from .models import GetDetailOnSubAccountsMarginAccountResponse
from .models import GetMovePositionHistoryForSubAccountResponse
from .models import GetSubAccountDepositAddressResponse
from .models import GetSubAccountDepositHistoryResponse
from .models import GetSummaryOfSubAccountsFuturesAccountResponse
from .models import GetSummaryOfSubAccountsFuturesAccountV2Response
from .models import GetSummaryOfSubAccountsMarginAccountResponse
from .models import MarginTransferForSubAccountResponse
from .models import MovePositionForSubAccountResponse
from .models import QuerySubAccountAssetsResponse
from .models import QuerySubAccountAssetsAssetManagementResponse
from .models import QuerySubAccountFuturesAssetTransferHistoryResponse
from .models import QuerySubAccountSpotAssetTransferHistoryResponse
from .models import QuerySubAccountSpotAssetsSummaryResponse
from .models import QueryUniversalTransferHistoryResponse
from .models import SubAccountFuturesAssetTransferResponse
from .models import SubAccountTransferHistoryResponse
from .models import TransferToMasterResponse
from .models import TransferToSubAccountOfSameMasterResponse
from .models import UniversalTransferResponse
from .models import DepositAssetsIntoTheManagedSubAccountResponse
from .models import GetManagedSubAccountDepositAddressResponse
from .models import QueryManagedSubAccountAssetDetailsResponse
from .models import QueryManagedSubAccountFuturesAssetDetailsResponse
from .models import QueryManagedSubAccountListResponse
from .models import QueryManagedSubAccountMarginAssetDetailsResponse
from .models import QueryManagedSubAccountSnapshotResponse
from .models import QueryManagedSubAccountTransferLogMasterAccountInvestorResponse
from .models import QueryManagedSubAccountTransferLogMasterAccountTradingResponse
from .models import QueryManagedSubAccountTransferLogSubAccountTradingResponse
from .models import WithdrawlAssetsFromTheManagedSubAccountResponse


T = TypeVar("T")


class SubAccountRestAPI:
    def __init__(
        self,
        configuration: ConfigurationRestAPI,
    ) -> None:
        self.configuration = configuration
        self._session = requests.Session()
        self._signer = (
            Signers.get_signer(
                configuration.private_key, configuration.private_key_passphrase
            )
            if configuration.private_key is not None
            else None
        )

        self._accountManagementApi = AccountManagementApi(
            self.configuration, self._session, self._signer
        )
        self._apiManagementApi = ApiManagementApi(
            self.configuration, self._session, self._signer
        )
        self._assetManagementApi = AssetManagementApi(
            self.configuration, self._session, self._signer
        )
        self._managedSubAccountApi = ManagedSubAccountApi(
            self.configuration, self._session, self._signer
        )

    def send_request(
        self, endpoint: str, method: str, params: Optional[dict] = None
    ) -> ApiResponse[T]:
        """
        Sends an request to the Binance REST API.

        Args:
            endpoint (str): The API endpoint path to send the request to.
            method (str): The HTTP method to use for the request (e.g. "GET", "POST", "PUT", "DELETE").
            params (Optional[dict]): The request payload as a dictionary, or None if no payload is required.

        Returns:
            ApiResponse[T]: The API response, where T is the expected response type.
        """
        return send_request[T](
            self._session, self.configuration, method, endpoint, params
        )

    def send_signed_request(
        self, endpoint: str, method: str, params: Optional[dict] = None
    ) -> ApiResponse[T]:
        """
        Sends a signed request to the Binance REST API.

        Args:
            endpoint (str): The API endpoint path to send the request to.
            method (str): The HTTP method to use for the request (e.g. "GET", "POST", "PUT", "DELETE").
            params (Optional[dict]): The request payload as a dictionary, or None if no payload is required.

        Returns:
            ApiResponse[T]: The API response, where T is the expected response type.
        """
        return send_request[T](
            self._session,
            self.configuration,
            method,
            endpoint,
            params,
            is_signed=True,
            signer=self._signer,
        )

    def create_a_virtual_sub_account(
        self,
        sub_account_string: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CreateAVirtualSubAccountResponse]:
        """
                Create a Virtual Sub-account (For Master Account) (USER_DATA)

                Create a Virtual Sub-account

        * This request will generate a virtual sub account under your master account.
        * You need to enable "trade" option for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    sub_account_string (Union[str, None]): Please input a string. We will create a virtual email using that string for you to register
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[CreateAVirtualSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountManagementApi.create_a_virtual_sub_account(
            sub_account_string, recv_window
        )

    def enable_futures_for_sub_account(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[EnableFuturesForSubAccountResponse]:
        """
                Enable Futures for Sub-account (For Master Account) (USER_DATA)

                Enable Futures for Sub-account for Master Account

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[EnableFuturesForSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountManagementApi.enable_futures_for_sub_account(
            email, recv_window
        )

    def enable_options_for_sub_account(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[EnableOptionsForSubAccountResponse]:
        """
                Enable Options for Sub-account (For Master Account) (USER_DATA)

                Enable Options for Sub-account (For Master Account).

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[EnableOptionsForSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountManagementApi.enable_options_for_sub_account(
            email, recv_window
        )

    def get_futures_position_risk_of_sub_account(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFuturesPositionRiskOfSubAccountResponse]:
        """
                Get Futures Position-Risk of Sub-account (For Master Account) (USER_DATA)

                Get Futures Position-Risk of Sub-account

        Weight: 10

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFuturesPositionRiskOfSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountManagementApi.get_futures_position_risk_of_sub_account(
            email, recv_window
        )

    def get_futures_position_risk_of_sub_account_v2(
        self,
        email: Union[str, None],
        futures_type: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetFuturesPositionRiskOfSubAccountV2Response]:
        """
                Get Futures Position-Risk of Sub-account V2 (For Master Account) (USER_DATA)

                Get Futures Position-Risk of Sub-account V2

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    futures_type (Union[int, None]): 1:USDT-margined Futures，2: Coin-margined Futures
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetFuturesPositionRiskOfSubAccountV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountManagementApi.get_futures_position_risk_of_sub_account_v2(
            email, futures_type, recv_window
        )

    def get_sub_accounts_status_on_margin_or_futures(
        self,
        email: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSubAccountsStatusOnMarginOrFuturesResponse]:
        """
                Get Sub-account's Status on Margin Or Futures (For Master Account) (USER_DATA)

                Get Sub-account's Status on Margin Or Futures

        * If no email sent, all sub-accounts' information will be returned.

        Weight: 10

                Args:
                    email (Optional[str] = None): Managed sub-account email
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSubAccountsStatusOnMarginOrFuturesResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountManagementApi.get_sub_accounts_status_on_margin_or_futures(
            email, recv_window
        )

    def query_sub_account_list(
        self,
        email: Optional[str] = None,
        is_freeze: Optional[str] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountListResponse]:
        """
                Query Sub-account List (For Master Account) (USER_DATA)

                Query Sub-account List

        Weight: 1

                Args:
                    email (Optional[str] = None): Managed sub-account email
                    is_freeze (Optional[str] = None): true or false
                    page (Optional[int] = None): Default value: 1
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountManagementApi.query_sub_account_list(
            email, is_freeze, page, limit, recv_window
        )

    def query_sub_account_transaction_statistics(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountTransactionStatisticsResponse]:
        """
                Query Sub-account Transaction Statistics (For Master Account) (USER_DATA)

                Query Sub-account Transaction statistics (For Master Account).

        Weight: 60

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountTransactionStatisticsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountManagementApi.query_sub_account_transaction_statistics(
            email, recv_window
        )

    def add_ip_restriction_for_sub_account_api_key(
        self,
        email: Union[str, None],
        sub_account_api_key: Union[str, None],
        status: Union[str, None],
        ip_address: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AddIpRestrictionForSubAccountApiKeyResponse]:
        """
                Add IP Restriction for Sub-Account API key (For Master Account) (USER_DATA)

                Add IP Restriction for Sub-Account API key

        * You need to enable Enable Spot & Margin Trading option for the api key which requests this endpoint

        Weight: 3000

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    sub_account_api_key (Union[str, None]):
                    status (Union[str, None]): IP Restriction status. 1 = IP Unrestricted. 2 = Restrict access to trusted IPs only.
                    ip_address (Optional[str] = None): Insert static IP in batch, separated by commas.
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AddIpRestrictionForSubAccountApiKeyResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._apiManagementApi.add_ip_restriction_for_sub_account_api_key(
            email, sub_account_api_key, status, ip_address, recv_window
        )

    def delete_ip_list_for_a_sub_account_api_key(
        self,
        email: Union[str, None],
        sub_account_api_key: Union[str, None],
        ip_address: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[DeleteIpListForASubAccountApiKeyResponse]:
        """
                Delete IP List For a Sub-account API Key (For Master Account) (USER_DATA)

                Delete IP List For a Sub-account API Key

        * You need to enable Enable Spot & Margin Trading option for the api key which requests this endpoint

        Weight: 3000

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    sub_account_api_key (Union[str, None]):
                    ip_address (Union[str, None]): IPs to be deleted. Can be added in batches, separated by commas
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[DeleteIpListForASubAccountApiKeyResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._apiManagementApi.delete_ip_list_for_a_sub_account_api_key(
            email, sub_account_api_key, ip_address, recv_window
        )

    def get_ip_restriction_for_a_sub_account_api_key(
        self,
        email: Union[str, None],
        sub_account_api_key: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetIpRestrictionForASubAccountApiKeyResponse]:
        """
                Get IP Restriction for a Sub-account API Key (For Master Account) (USER_DATA)

                Get IP Restriction for a Sub-account API Key

        Weight: 3000

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    sub_account_api_key (Union[str, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetIpRestrictionForASubAccountApiKeyResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._apiManagementApi.get_ip_restriction_for_a_sub_account_api_key(
            email, sub_account_api_key, recv_window
        )

    def futures_transfer_for_sub_account(
        self,
        email: Union[str, None],
        asset: Union[str, None],
        amount: Union[float, None],
        type: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[FuturesTransferForSubAccountResponse]:
        """
                Futures Transfer for Sub-account (For Master Account) (USER_DATA)

                Futures Transfer for Sub-account

        * You need to open Enable Spot & Margin Trading permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    type (Union[int, None]): 1: transfer from subaccount's  spot account to margin account 2: transfer from subaccount's margin account to its spot account
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[FuturesTransferForSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.futures_transfer_for_sub_account(
            email, asset, amount, type, recv_window
        )

    def get_detail_on_sub_accounts_futures_account(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDetailOnSubAccountsFuturesAccountResponse]:
        """
                Get Detail on Sub-account's Futures Account (For Master Account) (USER_DATA)

                Get Detail on Sub-account's Futures Account

        Weight: 10

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetDetailOnSubAccountsFuturesAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.get_detail_on_sub_accounts_futures_account(
            email, recv_window
        )

    def get_detail_on_sub_accounts_futures_account_v2(
        self,
        email: Union[str, None],
        futures_type: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDetailOnSubAccountsFuturesAccountV2Response]:
        """
                Get Detail on Sub-account's Futures Account V2 (For Master Account) (USER_DATA)

                Get Detail on Sub-account's Futures Account

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    futures_type (Union[int, None]): 1:USDT-margined Futures，2: Coin-margined Futures
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetDetailOnSubAccountsFuturesAccountV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.get_detail_on_sub_accounts_futures_account_v2(
            email, futures_type, recv_window
        )

    def get_detail_on_sub_accounts_margin_account(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDetailOnSubAccountsMarginAccountResponse]:
        """
                Get Detail on Sub-account's Margin Account (For Master Account) (USER_DATA)

                Get Detail on Sub-account's Margin Account

        Weight: 10

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetDetailOnSubAccountsMarginAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.get_detail_on_sub_accounts_margin_account(
            email, recv_window
        )

    def get_move_position_history_for_sub_account(
        self,
        symbol: Union[str, None],
        page: Union[int, None],
        row: Union[int, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetMovePositionHistoryForSubAccountResponse]:
        """
                Get Move Position History for Sub-account (For Master Account) (USER_DATA)

                Query move position history

        * If `startTime` and `endTime` not sent, return records of the last 90 days by default with 1000 maximum limits
        * If `startTime` is sent and `endTime` is not sent, return records of [max(startTime, now-90d), now].
        * If `startTime` is not sent and `endTime` is sent, return records of [max(now,endTime-90d), endTime].

        Weight: 150

                Args:
                    symbol (Union[str, None]):
                    page (Union[int, None]): Page
                    row (Union[int, None]):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetMovePositionHistoryForSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.get_move_position_history_for_sub_account(
            symbol, page, row, start_time, end_time, recv_window
        )

    def get_sub_account_deposit_address(
        self,
        email: Union[str, None],
        coin: Union[str, None],
        network: Optional[str] = None,
        amount: Optional[float] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSubAccountDepositAddressResponse]:
        """
                Get Sub-account Deposit Address (For Master Account) (USER_DATA)

                Fetch sub-account deposit address

        * `amount` needs to be sent if using LIGHTNING network

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    coin (Union[str, None]):
                    network (Optional[str] = None): networks can be found in `GET /sapi/v1/capital/deposit/address`
                    amount (Optional[float] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSubAccountDepositAddressResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.get_sub_account_deposit_address(
            email, coin, network, amount, recv_window
        )

    def get_sub_account_deposit_history(
        self,
        email: Union[str, None],
        coin: Optional[str] = None,
        status: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        recv_window: Optional[int] = None,
        tx_id: Optional[str] = None,
    ) -> ApiResponse[GetSubAccountDepositHistoryResponse]:
        """
                Get Sub-account Deposit History (For Master Account) (USER_DATA)

                Fetch sub-account deposit history

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    coin (Optional[str] = None):
                    status (Optional[int] = None): 0(0:pending,6: credited but cannot withdraw,7:Wrong Deposit,8:Waiting User confirm,1:success)
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    offset (Optional[int] = None): default:0
                    recv_window (Optional[int] = None):
                    tx_id (Optional[str] = None):

                Returns:
                    ApiResponse[GetSubAccountDepositHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.get_sub_account_deposit_history(
            email, coin, status, start_time, end_time, limit, offset, recv_window, tx_id
        )

    def get_summary_of_sub_accounts_futures_account(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSummaryOfSubAccountsFuturesAccountResponse]:
        """
                Get Summary of Sub-account's Futures Account (For Master Account) (USER_DATA)

                Get Summary of Sub-account's Futures Account

        Weight: 1

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSummaryOfSubAccountsFuturesAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.get_summary_of_sub_accounts_futures_account(
            recv_window
        )

    def get_summary_of_sub_accounts_futures_account_v2(
        self,
        futures_type: Union[int, None],
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSummaryOfSubAccountsFuturesAccountV2Response]:
        """
                Get Summary of Sub-account's Futures Account V2 (For Master Account) (USER_DATA)

                Get Summary of Sub-account's Futures Account

        Weight: 10

                Args:
                    futures_type (Union[int, None]): 1:USDT-margined Futures，2: Coin-margined Futures
                    page (Optional[int] = None): Default value: 1
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSummaryOfSubAccountsFuturesAccountV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.get_summary_of_sub_accounts_futures_account_v2(
            futures_type, page, limit, recv_window
        )

    def get_summary_of_sub_accounts_margin_account(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetSummaryOfSubAccountsMarginAccountResponse]:
        """
                Get Summary of Sub-account's Margin Account (For Master Account) (USER_DATA)

                Get Summary of Sub-account's Margin Account

        Weight: 10

                Args:
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetSummaryOfSubAccountsMarginAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.get_summary_of_sub_accounts_margin_account(
            recv_window
        )

    def margin_transfer_for_sub_account(
        self,
        email: Union[str, None],
        asset: Union[str, None],
        amount: Union[float, None],
        type: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[MarginTransferForSubAccountResponse]:
        """
                Margin Transfer for Sub-account (For Master Account) (USER_DATA)

                Margin Transfer for Sub-account

        * You need to open Enable Spot & Margin Trading permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    type (Union[int, None]): 1: transfer from subaccount's  spot account to margin account 2: transfer from subaccount's margin account to its spot account
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[MarginTransferForSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.margin_transfer_for_sub_account(
            email, asset, amount, type, recv_window
        )

    def move_position_for_sub_account(
        self,
        from_user_email: Union[str, None],
        to_user_email: Union[str, None],
        product_type: Union[str, None],
        order_args: Union[List[object], None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[MovePositionForSubAccountResponse]:
        """
                Move Position for Sub-account (For Master Account) (USER_DATA)

                Move position between sub-master, master-sub, or sub-sub accounts when necessary

        * You need to Enable Trading permission for the API Key which requests this endpoint.
        * This function only support VIP level 7-9.
        * Only master account can use the function
        * Quantity should be positive number only
        * The function support normal account, PM PRO and PM PRO SPAN.
        * Only support for from account has positions
        * For all orders in the same orderArgs request, if any symbol’s total close position quantity is bigger than the symbol’s current position quantity, all batch orders in the same list will fail simultaneously.
        * Only support cross margin mode
        * The price for move position is MarkPrice only.
        * Not support for MSA.
        * Not support for the symbol under Reduce-Only.

        Weight: 150

                Args:
                    from_user_email (Union[str, None]):
                    to_user_email (Union[str, None]):
                    product_type (Union[str, None]): Only support UM
                    order_args (Union[List[object], None]): Max 10 positions supported. When input request parameter,orderArgs.symbol should be STRING, orderArgs.quantity should be BIGDECIMAL, and orderArgs.positionSide should be STRING, positionSide support BOTH,LONG and SHORT. Each entry should be like orderArgs[0].symbol=BTCUSDT,orderArgs[0].quantity=0.001,orderArgs[0].positionSide=BOTH. Example of the request parameter array: orderArgs[0].symbol=BTCUSDT orderArgs[0].quantity=0.001 orderArgs[0].positionSide=BOTH orderArgs[1].symbol=ETHUSDT orderArgs[1].quantity=0.01 orderArgs[1].positionSide=BOTH
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[MovePositionForSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.move_position_for_sub_account(
            from_user_email, to_user_email, product_type, order_args, recv_window
        )

    def query_sub_account_assets(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountAssetsResponse]:
        """
                Query Sub-account Assets (For Master Account) (USER_DATA)

                Fetch sub-account assets

        Weight: 60

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountAssetsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.query_sub_account_assets(email, recv_window)

    def query_sub_account_assets_asset_management(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountAssetsAssetManagementResponse]:
        """
                Query Sub-account Assets (For Master Account) (USER_DATA)

                Fetch sub-account assets

        Weight: 60

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountAssetsAssetManagementResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.query_sub_account_assets_asset_management(
            email, recv_window
        )

    def query_sub_account_futures_asset_transfer_history(
        self,
        email: Union[str, None],
        futures_type: Union[int, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountFuturesAssetTransferHistoryResponse]:
        """
                Query Sub-account Futures Asset Transfer History (For Master Account) (USER_DATA)

                Query Sub-account Futures Asset Transfer History

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    futures_type (Union[int, None]): 1:USDT-margined Futures，2: Coin-margined Futures
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    page (Optional[int] = None): Default value: 1
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountFuturesAssetTransferHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return (
            self._assetManagementApi.query_sub_account_futures_asset_transfer_history(
                email, futures_type, start_time, end_time, page, limit, recv_window
            )
        )

    def query_sub_account_spot_asset_transfer_history(
        self,
        from_email: Optional[str] = None,
        to_email: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountSpotAssetTransferHistoryResponse]:
        """
                Query Sub-account Spot Asset Transfer History (For Master Account) (USER_DATA)

                Query Sub-account Spot Asset Transfer History

        * fromEmail and toEmail cannot be sent at the same time.
        * Return fromEmail equal master account email by default.

        Weight: 1

                Args:
                    from_email (Optional[str] = None):
                    to_email (Optional[str] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    page (Optional[int] = None): Default value: 1
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountSpotAssetTransferHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.query_sub_account_spot_asset_transfer_history(
            from_email, to_email, start_time, end_time, page, limit, recv_window
        )

    def query_sub_account_spot_assets_summary(
        self,
        email: Optional[str] = None,
        page: Optional[int] = None,
        size: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySubAccountSpotAssetsSummaryResponse]:
        """
                Query Sub-account Spot Assets Summary (For Master Account) (USER_DATA)

                Get BTC valued asset summary of subaccounts.

        Weight: 1

                Args:
                    email (Optional[str] = None): Managed sub-account email
                    page (Optional[int] = None): Default value: 1
                    size (Optional[int] = None): default 10, max 20
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QuerySubAccountSpotAssetsSummaryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.query_sub_account_spot_assets_summary(
            email, page, size, recv_window
        )

    def query_universal_transfer_history(
        self,
        from_email: Optional[str] = None,
        to_email: Optional[str] = None,
        client_tran_id: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryUniversalTransferHistoryResponse]:
        """
                Query Universal Transfer History (For Master Account) (USER_DATA)

                Query Universal Transfer History

        * fromEmail and toEmail cannot be sent at the same time.
        * Return fromEmail equal master account email by default.
        * The query time period must be less than 7 days.
        * If startTime and endTime not sent, return records of the last 7 days by default.

        Weight: 1

                Args:
                    from_email (Optional[str] = None):
                    to_email (Optional[str] = None):
                    client_tran_id (Optional[str] = None):
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    page (Optional[int] = None): Default value: 1
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryUniversalTransferHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.query_universal_transfer_history(
            from_email,
            to_email,
            client_tran_id,
            start_time,
            end_time,
            page,
            limit,
            recv_window,
        )

    def sub_account_futures_asset_transfer(
        self,
        from_email: Union[str, None],
        to_email: Union[str, None],
        futures_type: Union[int, None],
        asset: Union[str, None],
        amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SubAccountFuturesAssetTransferResponse]:
        """
                Sub-account Futures Asset Transfer (For Master Account) (USER_DATA)

                Sub-account Futures Asset Transfer


        * Master account can transfer max 2000 times a minute
        * There must be sufficient margin balance in futures wallet to execute transferring.

        Weight: 1

                Args:
                    from_email (Union[str, None]):
                    to_email (Union[str, None]):
                    futures_type (Union[int, None]): 1:USDT-margined Futures，2: Coin-margined Futures
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SubAccountFuturesAssetTransferResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.sub_account_futures_asset_transfer(
            from_email, to_email, futures_type, asset, amount, recv_window
        )

    def sub_account_transfer_history(
        self,
        asset: Optional[str] = None,
        type: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        return_fail_history: Optional[bool] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SubAccountTransferHistoryResponse]:
        """
                Sub-account Transfer History (For Sub-account) (USER_DATA)

                Sub-account Transfer History

        * If type is not sent, the records of type 2: transfer out will be returned by default.
        * If startTime and endTime are not sent, the recent 30-day data will be returned.

        Weight: 1

                Args:
                    asset (Optional[str] = None): If not sent, result of all assets will be returned
                    type (Optional[int] = None): 1: transfer in, 2: transfer out
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    return_fail_history (Optional[bool] = None): Default `False`, return PROCESS and SUCCESS status history; If `True`,return PROCESS and SUCCESS and FAILURE status history
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SubAccountTransferHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.sub_account_transfer_history(
            asset, type, start_time, end_time, limit, return_fail_history, recv_window
        )

    def transfer_to_master(
        self,
        asset: Union[str, None],
        amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[TransferToMasterResponse]:
        """
                Transfer to Master (For Sub-account) (USER_DATA)

                Transfer to Master

        * You need to open Enable Spot & Margin Trading permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[TransferToMasterResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.transfer_to_master(asset, amount, recv_window)

    def transfer_to_sub_account_of_same_master(
        self,
        to_email: Union[str, None],
        asset: Union[str, None],
        amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[TransferToSubAccountOfSameMasterResponse]:
        """
                Transfer to Sub-account of Same Master (For Sub-account) (USER_DATA)

                Transfer to Sub-account of Same Master

        * You need to open Enable Spot & Margin Trading permission for the API Key which requests this endpoint.

        Weight: 1

                Args:
                    to_email (Union[str, None]):
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[TransferToSubAccountOfSameMasterResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.transfer_to_sub_account_of_same_master(
            to_email, asset, amount, recv_window
        )

    def universal_transfer(
        self,
        from_account_type: Union[str, None],
        to_account_type: Union[str, None],
        asset: Union[str, None],
        amount: Union[float, None],
        from_email: Optional[str] = None,
        to_email: Optional[str] = None,
        client_tran_id: Optional[str] = None,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[UniversalTransferResponse]:
        """
                Universal Transfer (For Master Account) (USER_DATA)

                Universal Transfer

        * You need to enable "internal transfer" option for the api key which requests this endpoint.
        * Transfer from master account by default if fromEmail is not sent.
        * Transfer to master account by default if toEmail is not sent.
        * At least either fromEmail or toEmail need to be sent when the fromAccountType and the toAccountType are the same.
        * Supported transfer scenarios:
        * `SPOT` transfer to `SPOT`, `USDT_FUTURE`, `COIN_FUTURE` (regardless of master or sub)
        * `SPOT`, `USDT_FUTURE`, `COIN_FUTURE` transfer to `SPOT`  (regardless of master or sub)
        * Master account `SPOT` transfer to sub-account `MARGIN(Cross)`, `ISOLATED_MARGIN`
        * Sub-account `MARGIN(Cross)`, `ISOLATED_MARGIN` transfer to master account `SPOT`
        * Sub-account `MARGIN(Cross)` transfer to Sub-account `MARGIN(Cross)`
        * `ALPHA` to `ALPHA`  (regardless of master or sub)

        Weight: 360

                Args:
                    from_account_type (Union[str, None]): "SPOT","USDT_FUTURE","COIN_FUTURE","MARGIN"(Cross),"ISOLATED_MARGIN"
                    to_account_type (Union[str, None]): "SPOT","USDT_FUTURE","COIN_FUTURE","MARGIN"(Cross),"ISOLATED_MARGIN"
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    from_email (Optional[str] = None):
                    to_email (Optional[str] = None):
                    client_tran_id (Optional[str] = None):
                    symbol (Optional[str] = None): Only supported under ISOLATED_MARGIN type
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[UniversalTransferResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._assetManagementApi.universal_transfer(
            from_account_type,
            to_account_type,
            asset,
            amount,
            from_email,
            to_email,
            client_tran_id,
            symbol,
            recv_window,
        )

    def deposit_assets_into_the_managed_sub_account(
        self,
        to_email: Union[str, None],
        asset: Union[str, None],
        amount: Union[float, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[DepositAssetsIntoTheManagedSubAccountResponse]:
        """
                Deposit Assets Into The Managed Sub-account (For Investor Master Account) (USER_DATA)

                Deposit Assets Into The Managed Sub-account

        * You need to enable `Enable Spot & Margin Trading` option for the api key which requests this endpoint

        Weight: 1

                Args:
                    to_email (Union[str, None]):
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[DepositAssetsIntoTheManagedSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._managedSubAccountApi.deposit_assets_into_the_managed_sub_account(
            to_email, asset, amount, recv_window
        )

    def get_managed_sub_account_deposit_address(
        self,
        email: Union[str, None],
        coin: Union[str, None],
        network: Optional[str] = None,
        amount: Optional[float] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetManagedSubAccountDepositAddressResponse]:
        """
                Get Managed Sub-account Deposit Address (For Investor Master Account) (USER_DATA)

                Get investor's managed sub-account deposit address.

        * If `network` is not send, return with default `network` of the `coin`.
        * * `amount` needs to be sent if using LIGHTNING network

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    coin (Union[str, None]):
                    network (Optional[str] = None): networks can be found in `GET /sapi/v1/capital/deposit/address`
                    amount (Optional[float] = None):
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetManagedSubAccountDepositAddressResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._managedSubAccountApi.get_managed_sub_account_deposit_address(
            email, coin, network, amount, recv_window
        )

    def query_managed_sub_account_asset_details(
        self,
        email: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryManagedSubAccountAssetDetailsResponse]:
        """
                Query Managed Sub-account Asset Details (For Investor Master Account) (USER_DATA)

                Query Managed Sub-account Asset Details

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryManagedSubAccountAssetDetailsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._managedSubAccountApi.query_managed_sub_account_asset_details(
            email, recv_window
        )

    def query_managed_sub_account_futures_asset_details(
        self,
        email: Union[str, None],
        account_type: Optional[str] = None,
    ) -> ApiResponse[QueryManagedSubAccountFuturesAssetDetailsResponse]:
        """
                Query Managed Sub-account Futures Asset Details (For Investor Master Account) (USER_DATA)

                Investor can use this api to query managed sub account futures asset details

        Weight: 60

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    account_type (Optional[str] = None): No input or input "MARGIN" to get Cross Margin account details. Input "ISOLATED_MARGIN" to get Isolated Margin account details.

                Returns:
                    ApiResponse[QueryManagedSubAccountFuturesAssetDetailsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return (
            self._managedSubAccountApi.query_managed_sub_account_futures_asset_details(
                email, account_type
            )
        )

    def query_managed_sub_account_list(
        self,
        email: Optional[str] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryManagedSubAccountListResponse]:
        """
                Query Managed Sub-account List (For Investor) (USER_DATA)

                Get investor's managed sub-account list.

        Weight: 60

                Args:
                    email (Optional[str] = None): Managed sub-account email
                    page (Optional[int] = None): Default value: 1
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryManagedSubAccountListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._managedSubAccountApi.query_managed_sub_account_list(
            email, page, limit, recv_window
        )

    def query_managed_sub_account_margin_asset_details(
        self,
        email: Union[str, None],
        account_type: Optional[str] = None,
    ) -> ApiResponse[QueryManagedSubAccountMarginAssetDetailsResponse]:
        """
                Query Managed Sub-account Margin Asset Details (For Investor Master Account) (USER_DATA)

                Investor can use this api to query managed sub account margin asset details

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    account_type (Optional[str] = None): No input or input "MARGIN" to get Cross Margin account details. Input "ISOLATED_MARGIN" to get Isolated Margin account details.

                Returns:
                    ApiResponse[QueryManagedSubAccountMarginAssetDetailsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return (
            self._managedSubAccountApi.query_managed_sub_account_margin_asset_details(
                email, account_type
            )
        )

    def query_managed_sub_account_snapshot(
        self,
        email: Union[str, None],
        type: Union[str, None],
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryManagedSubAccountSnapshotResponse]:
        """
                Query Managed Sub-account Snapshot (For Investor Master Account) (USER_DATA)

                Query Managed Sub-account Snapshot

        * The query time period must be less then 30 days
        * Support query within the last one month only
        * If startTimeand endTime not sent, return records of the last 7 days by default

        Weight: 2400

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    type (Union[str, None]): "SPOT", "MARGIN"（cross）, "FUTURES"（UM）
                    start_time (Optional[int] = None):
                    end_time (Optional[int] = None):
                    limit (Optional[int] = None): Default value: 1, Max value: 200
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryManagedSubAccountSnapshotResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._managedSubAccountApi.query_managed_sub_account_snapshot(
            email, type, start_time, end_time, limit, recv_window
        )

    def query_managed_sub_account_transfer_log_master_account_investor(
        self,
        email: Union[str, None],
        start_time: Union[int, None],
        end_time: Union[int, None],
        page: Union[int, None],
        limit: Union[int, None],
        transfers: Optional[str] = None,
        transfer_function_account_type: Optional[str] = None,
    ) -> ApiResponse[QueryManagedSubAccountTransferLogMasterAccountInvestorResponse]:
        """
                Query Managed Sub Account Transfer Log (For Investor Master Account) (USER_DATA)

                Investor can use this api to query managed sub account transfer log. This endpoint is available for investor of Managed Sub-Account. A Managed Sub-Account is an account type for investors who value flexibility in asset allocation and account application, while delegating trades to a professional trading team.
        Please refer to [link](https://www.binance.com/en/support/faq/how-to-get-started-with-managed-sub-account-functions-and-frequently-asked-questions-0594748722704383a7c369046e489459)

        Weight: 1

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    start_time (Union[int, None]): Start Time
                    end_time (Union[int, None]): End Time (The start time and end time interval cannot exceed half a year)
                    page (Union[int, None]): Page
                    limit (Union[int, None]): Limit (Max: 500)
                    transfers (Optional[str] = None): Transfer Direction (FROM/TO)
                    transfer_function_account_type (Optional[str] = None): Transfer function account type (SPOT/MARGIN/ISOLATED_MARGIN/USDT_FUTURE/COIN_FUTURE)

                Returns:
                    ApiResponse[QueryManagedSubAccountTransferLogMasterAccountInvestorResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._managedSubAccountApi.query_managed_sub_account_transfer_log_master_account_investor(
            email,
            start_time,
            end_time,
            page,
            limit,
            transfers,
            transfer_function_account_type,
        )

    def query_managed_sub_account_transfer_log_master_account_trading(
        self,
        email: Union[str, None],
        start_time: Union[int, None],
        end_time: Union[int, None],
        page: Union[int, None],
        limit: Union[int, None],
        transfers: Optional[str] = None,
        transfer_function_account_type: Optional[str] = None,
    ) -> ApiResponse[QueryManagedSubAccountTransferLogMasterAccountTradingResponse]:
        """
                Query Managed Sub Account Transfer Log (For Trading Team Master Account) (USER_DATA)

                Trading team can use this api to query managed sub account transfer log. This endpoint is available for trading team of Managed Sub-Account. A Managed Sub-Account is an account type for investors who value flexibility in asset allocation and account application, while delegating trades to a professional trading team.
        Please refer to [link](https://www.binance.com/en/support/faq/how-to-get-started-with-managed-sub-account-functions-and-frequently-asked-questions-0594748722704383a7c369046e489459)

        Weight: 60

                Args:
                    email (Union[str, None]): [Sub-account email](#email-address)
                    start_time (Union[int, None]): Start Time
                    end_time (Union[int, None]): End Time (The start time and end time interval cannot exceed half a year)
                    page (Union[int, None]): Page
                    limit (Union[int, None]): Limit (Max: 500)
                    transfers (Optional[str] = None): Transfer Direction (FROM/TO)
                    transfer_function_account_type (Optional[str] = None): Transfer function account type (SPOT/MARGIN/ISOLATED_MARGIN/USDT_FUTURE/COIN_FUTURE)

                Returns:
                    ApiResponse[QueryManagedSubAccountTransferLogMasterAccountTradingResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._managedSubAccountApi.query_managed_sub_account_transfer_log_master_account_trading(
            email,
            start_time,
            end_time,
            page,
            limit,
            transfers,
            transfer_function_account_type,
        )

    def query_managed_sub_account_transfer_log_sub_account_trading(
        self,
        start_time: Union[int, None],
        end_time: Union[int, None],
        page: Union[int, None],
        limit: Union[int, None],
        transfers: Optional[str] = None,
        transfer_function_account_type: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryManagedSubAccountTransferLogSubAccountTradingResponse]:
        """
                Query Managed Sub Account Transfer Log (For Trading Team Sub Account) (USER_DATA)

                Query Managed Sub Account Transfer Log (For Trading Team Sub Account)

        Weight: 60

                Args:
                    start_time (Union[int, None]): Start Time
                    end_time (Union[int, None]): End Time (The start time and end time interval cannot exceed half a year)
                    page (Union[int, None]): Page
                    limit (Union[int, None]): Limit (Max: 500)
                    transfers (Optional[str] = None): Transfer Direction (FROM/TO)
                    transfer_function_account_type (Optional[str] = None): Transfer function account type (SPOT/MARGIN/ISOLATED_MARGIN/USDT_FUTURE/COIN_FUTURE)
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[QueryManagedSubAccountTransferLogSubAccountTradingResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._managedSubAccountApi.query_managed_sub_account_transfer_log_sub_account_trading(
            start_time,
            end_time,
            page,
            limit,
            transfers,
            transfer_function_account_type,
            recv_window,
        )

    def withdrawl_assets_from_the_managed_sub_account(
        self,
        from_email: Union[str, None],
        asset: Union[str, None],
        amount: Union[float, None],
        transfer_date: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[WithdrawlAssetsFromTheManagedSubAccountResponse]:
        """
                Withdrawl Assets From The Managed Sub-account (For Investor Master Account) (USER_DATA)

                Withdrawl Assets From The Managed Sub-account

        * You need to enable `Enable Spot & Margin Trading` option for the api key which requests this endpoint

        Weight: 1

                Args:
                    from_email (Union[str, None]):
                    asset (Union[str, None]):
                    amount (Union[float, None]):
                    transfer_date (Optional[int] = None): Withdrawals is automatically occur on the transfer date(UTC0). If a date is not selected, the withdrawal occurs right now
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[WithdrawlAssetsFromTheManagedSubAccountResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._managedSubAccountApi.withdrawl_assets_from_the_managed_sub_account(
            from_email, asset, amount, transfer_date, recv_window
        )
